/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.FilePathSplittingPolicy;
import java.io.File;
import java.util.ArrayList;

public class SplitBySeparatorPolicy
extends FilePathSplittingPolicy {
    @Override
    public String getPresentableName(File file2, int length) {
        Object s;
        String absolutePath = file2.getPath();
        if (absolutePath.length() <= length) {
            return absolutePath;
        }
        String name = file2.getName();
        if (length < name.length()) {
            return "...";
        }
        if (length == name.length()) {
            return name;
        }
        ArrayList<String> components = SplitBySeparatorPolicy.getComponents(file2);
        int currentLength = 0;
        ArrayList<Object> end = new ArrayList<Object>();
        ArrayList<Object> begin = new ArrayList<Object>();
        int size = components.size();
        int mult = 1;
        int currentIndex = 0;
        for (int i = size - 1; i >= 0 && (currentLength += ((String)(s = (String)components.get(currentIndex))).length()) <= length - 3; --i) {
            if (mult > 0) {
                end.add(s);
            } else {
                begin.add(s);
            }
            currentIndex += i * mult;
            mult *= -1;
        }
        if (end.isEmpty()) {
            return name;
        }
        StringBuilder result2 = new StringBuilder();
        for (String string : begin) {
            result2.append(string);
        }
        result2.append("...");
        for (int i = end.size() - 1; i >= 0; --i) {
            result2.append((String)end.get(i));
        }
        return result2.toString();
    }

    private static ArrayList<String> getComponents(File file2) {
        ArrayList<String> result2 = new ArrayList<String>();
        File current2 = file2;
        while (current2 != null) {
            result2.add(SplitBySeparatorPolicy.getFileName(current2));
            if ((current2 = current2.getParentFile()) == null) continue;
            result2.add(File.separator);
        }
        return result2;
    }

    private static String getFileName(File current2) {
        String result2 = current2.getName();
        if (!result2.isEmpty()) {
            return result2;
        }
        String path2 = current2.getPath();
        return path2.substring(0, path2.length() - 1);
    }
}

