/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.ClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StatusText {
    public static final SimpleTextAttributes DEFAULT_ATTRIBUTES = SimpleTextAttributes.GRAYED_ATTRIBUTES;
    @Deprecated
    public static final String DEFAULT_EMPTY_TEXT = "Nothing to show";
    private static final int Y_GAP = 2;
    @Nullable
    private Component myOwner;
    private Component myMouseTarget;
    @NotNull
    private final MouseMotionListener myMouseMotionListener;
    @NotNull
    private final ClickListener myClickListener;
    private boolean myIsDefaultText;
    private String myText = "";
    @NotNull
    protected final SimpleColoredComponent myComponent = new SimpleColoredComponent();
    @NotNull
    private final SimpleColoredComponent mySecondaryComponent = new SimpleColoredComponent();
    private final List<ActionListener> myClickListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<ActionListener> mySecondaryListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myHasActiveClickListeners;
    private boolean myShowAboveCenter = true;
    private boolean myVerticalFlow = true;
    private boolean myFontSet = false;

    protected StatusText(JComponent owner) {
        this();
        this.attachTo(owner);
    }

    public StatusText() {
        this.myClickListener = new ClickListener(){

            @Override
            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                ActionListener actionListener;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getButton() == 1 && clickCount == 1 && (actionListener = StatusText.this.findActionListenerAt(e.getPoint())) != null) {
                    actionListener.actionPerformed(new ActionEvent(this, 0, ""));
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/StatusText$1", "onClick"));
            }
        };
        this.myMouseMotionListener = new MouseAdapter(){
            private Cursor myOriginalCursor;

            @Override
            public void mouseMoved(MouseEvent e) {
                if (StatusText.this.isStatusVisible()) {
                    if (StatusText.this.findActionListenerAt(e.getPoint()) != null) {
                        if (this.myOriginalCursor == null) {
                            this.myOriginalCursor = StatusText.this.myMouseTarget.getCursor();
                            StatusText.this.myMouseTarget.setCursor(Cursor.getPredefinedCursor(12));
                        }
                    } else if (this.myOriginalCursor != null) {
                        StatusText.this.myMouseTarget.setCursor(this.myOriginalCursor);
                        this.myOriginalCursor = null;
                    }
                }
            }
        };
        this.myComponent.setOpaque(false);
        this.myComponent.setFont(UIUtil.getLabelFont());
        this.setText(StatusText.getDefaultEmptyText(), DEFAULT_ATTRIBUTES);
        this.myIsDefaultText = true;
        this.mySecondaryComponent.setOpaque(false);
        this.mySecondaryComponent.setFont(UIUtil.getLabelFont());
    }

    protected boolean isFontSet() {
        return this.myFontSet;
    }

    public void setFont(@NotNull Font font) {
        if (font == null) {
            StatusText.$$$reportNull$$$0(0);
        }
        this.myComponent.setFont(font);
        this.mySecondaryComponent.setFont(font);
        this.myFontSet = true;
    }

    public void attachTo(@Nullable Component owner) {
        this.attachTo(owner, owner);
    }

    public void attachTo(@Nullable Component owner, @Nullable Component mouseTarget) {
        if (this.myMouseTarget != null) {
            this.myClickListener.uninstall(this.myMouseTarget);
            this.myMouseTarget.removeMouseMotionListener(this.myMouseMotionListener);
        }
        this.myOwner = owner;
        this.myMouseTarget = mouseTarget;
        if (this.myMouseTarget != null) {
            this.myClickListener.installOn(this.myMouseTarget);
            this.myMouseTarget.addMouseMotionListener(this.myMouseMotionListener);
        }
    }

    protected abstract boolean isStatusVisible();

    @Nullable
    private static ActionListener findListener(@NotNull SimpleColoredComponent component2, @NotNull List<? extends ActionListener> listeners, int xCoord) {
        int index;
        if (component2 == null) {
            StatusText.$$$reportNull$$$0(1);
        }
        if (listeners == null) {
            StatusText.$$$reportNull$$$0(2);
        }
        if ((index = component2.findFragmentAt(xCoord)) >= 0 && index < listeners.size()) {
            return listeners.get(index);
        }
        return null;
    }

    @Nullable
    private ActionListener findActionListenerAt(Point point) {
        if (!this.myHasActiveClickListeners || !this.isStatusVisible()) {
            return null;
        }
        point = SwingUtilities.convertPoint(this.myMouseTarget, point, this.myOwner);
        Rectangle commonBounds = this.getTextComponentBound();
        if (commonBounds.contains(point)) {
            if (this.myComponent.getPreferredSize().height >= point.y - commonBounds.y) {
                Rectangle bounds2 = this.adjustComponentBounds(this.myComponent, commonBounds);
                return StatusText.findListener(this.myComponent, this.myClickListeners, point.x - bounds2.x);
            }
            Rectangle bounds3 = this.adjustComponentBounds(this.mySecondaryComponent, commonBounds);
            return StatusText.findListener(this.mySecondaryComponent, this.mySecondaryListeners, point.x - bounds3.x);
        }
        return null;
    }

    protected Rectangle getTextComponentBound() {
        Rectangle ownerRec = this.myOwner == null ? new Rectangle(0, 0, 0, 0) : this.myOwner.getBounds();
        Dimension size = this.getPreferredSize();
        int x = (ownerRec.width - size.width) / 2;
        int y = (ownerRec.height - size.height) / (this.myShowAboveCenter ? 3 : 2);
        return new Rectangle(x, y, size.width, size.height);
    }

    public final boolean isShowAboveCenter() {
        return this.myShowAboveCenter;
    }

    public final StatusText setShowAboveCenter(boolean showAboveCenter) {
        this.myShowAboveCenter = showAboveCenter;
        return this;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            StatusText.$$$reportNull$$$0(3);
        }
        return string;
    }

    public StatusText setText(@Nls String text2) {
        return this.setText(text2, DEFAULT_ATTRIBUTES);
    }

    public StatusText setText(@Nls String text2, SimpleTextAttributes attrs) {
        return this.clear().appendText(text2, attrs);
    }

    public StatusText clear() {
        this.myText = "";
        this.myComponent.clear();
        this.myClickListeners.clear();
        this.mySecondaryComponent.clear();
        this.mySecondaryListeners.clear();
        this.myHasActiveClickListeners = false;
        this.repaintOwner();
        return this;
    }

    private void repaintOwner() {
        if (this.myOwner != null && this.isStatusVisible()) {
            this.myOwner.repaint();
        }
    }

    public StatusText appendText(@Nls(capitalization=Nls.Capitalization.Sentence) String text2) {
        return this.appendText(text2, DEFAULT_ATTRIBUTES);
    }

    public StatusText appendText(@Nls(capitalization=Nls.Capitalization.Sentence) String text2, SimpleTextAttributes attrs) {
        return this.appendText(text2, attrs, null);
    }

    public StatusText appendText(@Nls(capitalization=Nls.Capitalization.Sentence) String text2, SimpleTextAttributes attrs, ActionListener listener2) {
        if (this.myIsDefaultText) {
            this.clear();
            this.myIsDefaultText = false;
        }
        this.myText = this.myText + text2;
        this.myComponent.append(text2, attrs);
        this.myClickListeners.add(listener2);
        if (listener2 != null) {
            this.myHasActiveClickListeners = true;
        }
        this.repaintOwner();
        return this;
    }

    public void setIsVerticalFlow(boolean isVerticalFlow) {
        this.myVerticalFlow = isVerticalFlow;
    }

    @NotNull
    public StatusText appendSecondaryText(@NotNull @Nls String text2, @NotNull SimpleTextAttributes attrs, @Nullable ActionListener listener2) {
        if (text2 == null) {
            StatusText.$$$reportNull$$$0(4);
        }
        if (attrs == null) {
            StatusText.$$$reportNull$$$0(5);
        }
        this.mySecondaryComponent.append(text2, attrs);
        this.mySecondaryListeners.add(listener2);
        if (listener2 != null) {
            this.myHasActiveClickListeners = true;
        }
        this.repaintOwner();
        StatusText statusText = this;
        if (statusText == null) {
            StatusText.$$$reportNull$$$0(6);
        }
        return statusText;
    }

    public void paint(Component owner, Graphics g) {
        if (!this.isStatusVisible()) {
            return;
        }
        if (owner == this.myOwner) {
            this.doPaintStatusText(g, this.getTextComponentBound());
        } else {
            this.paintOnComponentUnderViewport(owner, g);
        }
    }

    private void paintOnComponentUnderViewport(Component component2, Graphics g) {
        JBViewport viewport = ObjectUtils.tryCast(this.myOwner, JBViewport.class);
        if (viewport == null || viewport.getView() != component2 || viewport.isPaintingNow()) {
            return;
        }
        Rectangle textBoundsInViewport = this.getTextComponentBound();
        int xInOwner = textBoundsInViewport.x - component2.getX();
        int yInOwner = textBoundsInViewport.y - component2.getY();
        Rectangle textBoundsInOwner = new Rectangle(xInOwner, yInOwner, textBoundsInViewport.width, textBoundsInViewport.height);
        this.doPaintStatusText(g, textBoundsInOwner);
        viewport.repaint(textBoundsInViewport);
    }

    private void doPaintStatusText(@NotNull Graphics g, @NotNull Rectangle bounds2) {
        if (g == null) {
            StatusText.$$$reportNull$$$0(7);
        }
        if (bounds2 == null) {
            StatusText.$$$reportNull$$$0(8);
        }
        if (!this.hasSecondaryText()) {
            StatusText.paintComponentInBounds(this.myComponent, g, bounds2);
        } else {
            Rectangle primaryBounds = this.adjustComponentBounds(this.myComponent, bounds2);
            Rectangle secondaryBounds = this.adjustComponentBounds(this.mySecondaryComponent, bounds2);
            if (this.myVerticalFlow) {
                secondaryBounds.y += primaryBounds.height + JBUIScale.scale(2);
            }
            StatusText.paintComponentInBounds(this.myComponent, g, primaryBounds);
            StatusText.paintComponentInBounds(this.mySecondaryComponent, g, secondaryBounds);
        }
    }

    @NotNull
    protected Rectangle adjustComponentBounds(@NotNull JComponent component2, @NotNull Rectangle bounds2) {
        if (component2 == null) {
            StatusText.$$$reportNull$$$0(9);
        }
        if (bounds2 == null) {
            StatusText.$$$reportNull$$$0(10);
        }
        Dimension size = component2.getPreferredSize();
        if (this.myVerticalFlow) {
            return new Rectangle(bounds2.x + (bounds2.width - size.width) / 2, bounds2.y, size.width, size.height);
        }
        return component2 == this.myComponent ? new Rectangle(bounds2.x, bounds2.y, size.width, size.height) : new Rectangle(bounds2.x + bounds2.width - size.width, bounds2.y, size.width, size.height);
    }

    private boolean hasSecondaryText() {
        return this.mySecondaryComponent.getCharSequence(false).length() > 0;
    }

    private static void paintComponentInBounds(@NotNull SimpleColoredComponent component2, @NotNull Graphics g, @NotNull Rectangle bounds2) {
        if (component2 == null) {
            StatusText.$$$reportNull$$$0(11);
        }
        if (g == null) {
            StatusText.$$$reportNull$$$0(12);
        }
        if (bounds2 == null) {
            StatusText.$$$reportNull$$$0(13);
        }
        Graphics2D g2 = (Graphics2D)g.create(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
        component2.setBounds(0, 0, bounds2.width, bounds2.height);
        component2.paint(g2);
        g2.dispose();
    }

    @NotNull
    public SimpleColoredComponent getComponent() {
        SimpleColoredComponent simpleColoredComponent = this.myComponent;
        if (simpleColoredComponent == null) {
            StatusText.$$$reportNull$$$0(14);
        }
        return simpleColoredComponent;
    }

    @NotNull
    public SimpleColoredComponent getSecondaryComponent() {
        SimpleColoredComponent simpleColoredComponent = this.mySecondaryComponent;
        if (simpleColoredComponent == null) {
            StatusText.$$$reportNull$$$0(15);
        }
        return simpleColoredComponent;
    }

    public Dimension getPreferredSize() {
        Dimension componentSize = this.myComponent.getPreferredSize();
        if (!this.hasSecondaryText()) {
            return componentSize;
        }
        Dimension secondaryComponentSize = this.mySecondaryComponent.getPreferredSize();
        if (this.myVerticalFlow) {
            return new Dimension(Math.max(componentSize.width, secondaryComponentSize.width), componentSize.height + secondaryComponentSize.height + JBUIScale.scale(2));
        }
        return new Dimension(componentSize.width + secondaryComponentSize.width, Math.max(componentSize.height, secondaryComponentSize.height));
    }

    public boolean isVerticalFlow() {
        return this.myVerticalFlow;
    }

    public static String getDefaultEmptyText() {
        return UIBundle.message("message.nothingToShow", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/StatusText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/StatusText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "appendSecondaryText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setFont";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findListener";
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 15: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendSecondaryText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doPaintStatusText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "adjustComponentBounds";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "paintComponentInBounds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

