/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.CharSequenceReader;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextTransferable
implements Transferable {
    private static final Logger LOG = Logger.getInstance(TextTransferable.class);
    private final CharSequence myHtmlContent;
    private final CharSequence myPlainContent;
    private static final NotNullLazyValue<List<DataFlavor>> FLAVORS = NotNullLazyValue.createValue(() -> {
        ArrayList<DataFlavor> result2 = new ArrayList<DataFlavor>();
        result2.add(DataFlavor.stringFlavor);
        result2.add(DataFlavor.plainTextFlavor);
        try {
            result2.add(new DataFlavor("text/html;class=java.lang.String"));
        }
        catch (ClassNotFoundException e) {
            LOG.error(e);
        }
        return result2;
    });

    public TextTransferable(@Nullable String data2) {
        this(StringUtil.notNullize(data2), StringUtil.notNullize(data2));
    }

    public TextTransferable(@NotNull CharSequence data2) {
        if (data2 == null) {
            TextTransferable.$$$reportNull$$$0(0);
        }
        this(data2, data2);
    }

    public TextTransferable(@NotNull String htmlContent, @NotNull String plainContent) {
        if (htmlContent == null) {
            TextTransferable.$$$reportNull$$$0(1);
        }
        if (plainContent == null) {
            TextTransferable.$$$reportNull$$$0(2);
        }
        this.myHtmlContent = StringUtil.notNullize(htmlContent);
        this.myPlainContent = StringUtil.notNullize(plainContent);
    }

    public TextTransferable(@NotNull CharSequence htmlContent, @NotNull CharSequence plainContent) {
        if (htmlContent == null) {
            TextTransferable.$$$reportNull$$$0(3);
        }
        if (plainContent == null) {
            TextTransferable.$$$reportNull$$$0(4);
        }
        this.myHtmlContent = htmlContent;
        this.myPlainContent = plainContent;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS.getValue().toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor f : FLAVORS.getValue()) {
            if (!flavor.equals(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(@NotNull DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor == null) {
            TextTransferable.$$$reportNull$$$0(5);
        }
        if (flavor.getMimeType().startsWith("text/html;")) {
            return this.myHtmlContent.toString();
        }
        if (flavor.equals(DataFlavor.plainTextFlavor)) {
            return new CharSequenceReader(this.myPlainContent == null ? "" : this.myPlainContent);
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.myPlainContent.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlContent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plainContent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/TextTransferable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTransferData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ColoredStringBuilder
    implements ColoredTextContainer {
        private final StringBuilder builder = new StringBuilder();

        public void appendTo(StringBuilder ... subBuilders) {
            if (subBuilders == null) {
                ColoredStringBuilder.$$$reportNull$$$0(0);
            }
            for (StringBuilder subBuilder : subBuilders) {
                subBuilder.append((CharSequence)this.builder);
            }
            this.builder.setLength(0);
        }

        public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
            if (fragment == null) {
                ColoredStringBuilder.$$$reportNull$$$0(1);
            }
            if (attributes == null) {
                ColoredStringBuilder.$$$reportNull$$$0(2);
            }
            this.builder.append(fragment);
        }

        public StringBuilder getBuilder() {
            return this.builder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subBuilders";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ui/TextTransferable$ColoredStringBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendTo";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "append";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

