/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.BundleBase;
import com.intellij.diagnostic.LoadingState;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.FontUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.AppleBoldDottedPainter;
import com.intellij.util.ui.CenteredIcon;
import com.intellij.util.ui.DetectRetinaKit;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.WavePainter;
import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.awt.print.PrinterGraphics;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import javax.swing.text.StyleContext;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.UndoManager;
import org.intellij.lang.annotations.JdkConstants;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.HeadlessToolkit;

public final class UIUtil {
    public static final String BORDER_LINE = "<hr size=1 noshade>";
    @NonNls
    public static final String BR = "<br/>";
    public static final Key<Boolean> LAF_WITH_THEME_KEY;
    public static final Key<String> PLUGGABLE_LAF_KEY;
    private static final AtomicNotNullLazyValue<Boolean> X_RENDER_ACTIVE;
    private static final String[] STANDARD_FONT_SIZES;
    public static final char MNEMONIC = '\u001b';
    @NonNls
    public static final String HTML_MIME = "text/html";
    @NonNls
    public static final String JSLIDER_ISFILLED = "JSlider.isFilled";
    @NonNls
    public static final String TABLE_FOCUS_CELL_BACKGROUND_PROPERTY = "Table.focusCellBackground";
    @NonNls
    public static final String HIDE_EDITOR_FROM_DATA_CONTEXT_PROPERTY = "AuxEditorComponent";
    @NonNls
    public static final String CENTER_TOOLTIP_DEFAULT = "ToCenterTooltip";
    @NonNls
    public static final String CENTER_TOOLTIP_STRICT = "ToCenterTooltip.default";
    private static final Pattern CLOSE_TAG_PATTERN;
    @NonNls
    private static final String FOCUS_PROXY_KEY = "isFocusProxy";
    public static final Key<Integer> KEEP_BORDER_SIDES;
    private static final Key<UndoManager> UNDO_MANAGER;
    public static final Key<Boolean> TEXT_COPY_ROOT;
    private static final AbstractAction REDO_ACTION;
    private static final AbstractAction UNDO_ACTION;
    private static final Color ACTIVE_HEADER_COLOR;
    private static final Color INACTIVE_HEADER_COLOR;
    public static final Color CONTRAST_BORDER_COLOR;
    public static final Color SIDE_PANEL_BACKGROUND;
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR;
    public static final Color TRANSPARENT_COLOR;
    public static final int DEFAULT_HGAP = 10;
    public static final int DEFAULT_VGAP = 4;
    public static final int LARGE_VGAP = 12;
    private static final int REGULAR_PANEL_TOP_BOTTOM_INSET = 8;
    private static final int REGULAR_PANEL_LEFT_RIGHT_INSET = 12;
    public static final Insets PANEL_REGULAR_INSETS;
    public static final Insets PANEL_SMALL_INSETS;
    @NonNls
    private static final String ROOT_PANE = "JRootPane.future";
    private static final Ref<Boolean> ourRetina;
    public static final int LIST_FIXED_CELL_HEIGHT = 20;
    public static final Key<Iterable<? extends Component>> NOT_IN_HIERARCHY_COMPONENTS;
    private static final JBTreeTraverser<Component> UI_TRAVERSER;
    private static final Color DECORATED_ROW_BG_COLOR;
    private static final DocumentAdapter SET_TEXT_CHECKER;
    public static final String CHECKBOX_ROLLOVER_PROPERTY = "JCheckBox.rollOver.rectangle";
    public static final String CHECKBOX_PRESSED_PROPERTY = "JCheckBox.pressed.rectangle";
    private static final Color BACKGROUND;
    private static final Color LIST_BACKGROUND;
    private static final Color TREE_BACKGROUND;
    private static final Color TABLE_BACKGROUND;
    private static final JBValue SELECTED_ITEM_ALPHA;

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(UIUtil.class);
        if (logger == null) {
            UIUtil.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public static void decorateWindowHeader(JRootPane pane2) {
        if (pane2 != null && SystemInfo.isMacOSMojave) {
            pane2.putClientProperty("jetbrains.awt.windowDarkAppearance", StartupUiUtil.isUnderDarcula());
        }
    }

    public static void setCustomTitleBar(final @NotNull Window window, final @NotNull JRootPane rootPane, java.util.function.Consumer<Runnable> onDispose) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(1);
        }
        if (rootPane == null) {
            UIUtil.$$$reportNull$$$0(2);
        }
        if (!SystemInfo.isMac || !Registry.is("ide.mac.transparentTitleBarAppearance", false)) {
            return;
        }
        final JBInsets topWindowInset = JBUI.insetsTop(24);
        rootPane.putClientProperty("jetbrains.awt.transparentTitleBarAppearance", true);
        AbstractBorder customDecorationBorder = new AbstractBorder(){

            @Override
            public Insets getBorderInsets(Component c) {
                return topWindowInset;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D graphics = (Graphics2D)g.create();
                try {
                    Rectangle headerRectangle = new Rectangle(0, 0, c.getWidth(), topWindowInset.top);
                    graphics.setColor(UIUtil.getPanelBackground());
                    graphics.fill(headerRectangle);
                    JBColor color = window.isActive() ? JBColor.black : JBColor.gray;
                    graphics.setColor(color);
                    int controlButtonsWidth = 70;
                    String windowTitle = UIUtil.getWindowTitle(window);
                    double widthToFit = controlButtonsWidth * 2 + GraphicsUtil.stringWidth(windowTitle, g.getFont()) - c.getWidth();
                    if (widthToFit <= 0.0) {
                        UIUtil.drawCenteredString(graphics, headerRectangle, windowTitle);
                    } else {
                        FontMetrics fm = graphics.getFontMetrics();
                        Rectangle2D stringBounds = fm.getStringBounds(windowTitle, graphics);
                        Rectangle bounds2 = AffineTransform.getTranslateInstance(controlButtonsWidth, (double)fm.getAscent() + ((double)headerRectangle.height - stringBounds.getHeight()) / 2.0).createTransformedShape(stringBounds).getBounds();
                        UIUtil.drawCenteredString(graphics, bounds2, windowTitle, false, true);
                    }
                }
                finally {
                    graphics.dispose();
                }
            }
        };
        rootPane.setBorder(customDecorationBorder);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                rootPane.repaint();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                rootPane.repaint();
            }
        };
        PropertyChangeListener propertyChangeListener = e -> rootPane.repaint();
        window.addPropertyChangeListener("title", propertyChangeListener);
        onDispose.accept(() -> {
            window.removeWindowListener(windowAdapter);
            window.removePropertyChangeListener("title", propertyChangeListener);
        });
    }

    private static String getWindowTitle(Window window) {
        return window instanceof JDialog ? ((JDialog)window).getTitle() : ((JFrame)window).getTitle();
    }

    public static void markAsTypeAheadAware(Window window) {
        UIUtil.putWindowClientProperty(window, "TypeAheadAwareWindow", Boolean.TRUE);
    }

    public static boolean isTypeAheadAware(Window window) {
        return UIUtil.isWindowClientPropertyTrue(window, "TypeAheadAwareWindow");
    }

    public static void markAsPossibleOwner(Dialog dialog2) {
        UIUtil.putWindowClientProperty(dialog2, "PossibleOwner", Boolean.TRUE);
    }

    public static boolean isPossibleOwner(@NotNull Dialog dialog2) {
        if (dialog2 == null) {
            UIUtil.$$$reportNull$$$0(3);
        }
        return UIUtil.isWindowClientPropertyTrue(dialog2, "PossibleOwner");
    }

    public static int getMultiClickInterval() {
        Object property = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        if (property instanceof Integer) {
            return (Integer)property;
        }
        return 500;
    }

    public static void applyStyle(@NotNull ComponentStyle componentStyle, @NotNull Component comp) {
        if (componentStyle == null) {
            UIUtil.$$$reportNull$$$0(4);
        }
        if (comp == null) {
            UIUtil.$$$reportNull$$$0(5);
        }
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent c = (JComponent)comp;
        if (UIUtil.isUnderAquaBasedLookAndFeel()) {
            c.putClientProperty("JComponent.sizeVariant", StringUtil.toLowerCase(componentStyle.name()));
        }
        FontSize fontSize = componentStyle == ComponentStyle.MINI ? FontSize.MINI : (componentStyle == ComponentStyle.SMALL ? FontSize.SMALL : FontSize.NORMAL);
        c.setFont(UIUtil.getFont(fontSize, c.getFont()));
        Container p = c.getParent();
        if (p != null) {
            SwingUtilities.updateComponentTreeUI(p);
        }
    }

    @NotNull
    public static Cursor getTextCursor(@NotNull Color backgroundColor) {
        if (backgroundColor == null) {
            UIUtil.$$$reportNull$$$0(6);
        }
        Cursor cursor = SystemInfo.isMac && ColorUtil.isDark(backgroundColor) ? MacUIUtil.getInvertedTextCursor() : Cursor.getPredefinedCursor(2);
        if (cursor == null) {
            UIUtil.$$$reportNull$$$0(7);
        }
        return cursor;
    }

    @Nullable
    public static Cursor cursorIfNotDefault(@Nullable Cursor cursorToSet) {
        return cursorToSet != null && cursorToSet.getType() != 0 ? cursorToSet : null;
    }

    @NotNull
    public static RGBImageFilter getGrayFilter() {
        GrayFilter grayFilter = GrayFilter.namedFilter("grayFilter", new GrayFilter(33, -35, 100));
        if (grayFilter == null) {
            UIUtil.$$$reportNull$$$0(8);
        }
        return grayFilter;
    }

    @NotNull
    public static RGBImageFilter getTextGrayFilter() {
        GrayFilter grayFilter = GrayFilter.namedFilter("text.grayFilter", new GrayFilter(20, 0, 100));
        if (grayFilter == null) {
            UIUtil.$$$reportNull$$$0(9);
        }
        return grayFilter;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isAppleRetina() {
        return false;
    }

    @NotNull
    public static Couple<Color> getCellColors(@NotNull JTable table, boolean isSel, int row, int column) {
        if (table == null) {
            UIUtil.$$$reportNull$$$0(10);
        }
        Couple<Color> couple = Couple.of(isSel ? table.getSelectionForeground() : table.getForeground(), isSel ? table.getSelectionBackground() : table.getBackground());
        if (couple == null) {
            UIUtil.$$$reportNull$$$0(11);
        }
        return couple;
    }

    public static void fixOSXEditorBackground(@NotNull JTable table) {
        if (table == null) {
            UIUtil.$$$reportNull$$$0(12);
        }
        if (!SystemInfo.isMac) {
            return;
        }
        if (table.isEditing()) {
            int column = table.getEditingColumn();
            int row = table.getEditingRow();
            Component renderer = column >= 0 && row >= 0 ? table.getCellRenderer(row, column).getTableCellRendererComponent(table, table.getValueAt(row, column), true, table.hasFocus(), row, column) : null;
            Component component2 = table.getEditorComponent();
            if (component2 != null && renderer != null) {
                UIUtil.changeBackGround(component2, renderer.getBackground());
            }
        }
    }

    private UIUtil() {
    }

    public static boolean isRetina(@NotNull Graphics2D graphics) {
        if (graphics == null) {
            UIUtil.$$$reportNull$$$0(13);
        }
        return SystemInfo.isMac ? DetectRetinaKit.isMacRetina(graphics) : UIUtil.isRetina();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRetina() {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        if ("true".equalsIgnoreCase(System.getProperty("is.hidpi"))) {
            return true;
        }
        if (Registry.is("new.retina.detection", false)) {
            return DetectRetinaKit.isRetina();
        }
        Ref<Boolean> ref = ourRetina;
        synchronized (ref) {
            if (ourRetina.isNull()) {
                ourRetina.set(false);
                try {
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice device = env.getDefaultScreenDevice();
                    Integer scale = ReflectionUtil.getField(device.getClass(), device, Integer.TYPE, "scale");
                    if (scale != null && scale == 2) {
                        ourRetina.set(true);
                        return true;
                    }
                }
                catch (AWTError | Exception throwable) {
                    // empty catch block
                }
                ourRetina.set(false);
            }
            return ourRetina.get();
        }
    }

    public static boolean isWindowClientPropertyTrue(Window window, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(14);
        }
        return Boolean.TRUE.equals(UIUtil.getWindowClientProperty(window, key));
    }

    public static Object getWindowClientProperty(Window window, @NotNull Object key) {
        JRootPane pane2;
        if (key == null) {
            UIUtil.$$$reportNull$$$0(15);
        }
        if (window instanceof RootPaneContainer && (pane2 = ((RootPaneContainer)((Object)window)).getRootPane()) != null) {
            return pane2.getClientProperty(key);
        }
        return null;
    }

    public static void putWindowClientProperty(Window window, @NotNull Object key, Object value2) {
        JRootPane pane2;
        if (key == null) {
            UIUtil.$$$reportNull$$$0(16);
        }
        if (window instanceof RootPaneContainer && (pane2 = ((RootPaneContainer)((Object)window)).getRootPane()) != null) {
            pane2.putClientProperty(key, value2);
        }
    }

    public static boolean isClientPropertyTrue(Object component2, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(17);
        }
        return Boolean.TRUE.equals(UIUtil.getClientProperty(component2, key));
    }

    public static Object getClientProperty(Object component2, @NotNull Object key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(18);
        }
        return component2 instanceof JComponent ? ((JComponent)component2).getClientProperty(key) : null;
    }

    public static <T> T getClientProperty(Object component2, @NotNull Class<T> type) {
        if (type == null) {
            UIUtil.$$$reportNull$$$0(19);
        }
        return ObjectUtils.tryCast(UIUtil.getClientProperty(component2, type), type);
    }

    public static <T> T getClientProperty(Object component2, @NotNull Key<T> key) {
        if (key == null) {
            UIUtil.$$$reportNull$$$0(20);
        }
        return (T)UIUtil.getClientProperty(component2, key);
    }

    public static <T> void putClientProperty(@NotNull JComponent component2, @NotNull Key<T> key, T value2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(21);
        }
        if (key == null) {
            UIUtil.$$$reportNull$$$0(22);
        }
        ComponentUtil.putClientProperty(component2, key, value2);
    }

    @NotNull
    public static String getHtmlBody(@NotNull String text2) {
        int bodyIndex;
        int htmlIndex;
        if (text2 == null) {
            UIUtil.$$$reportNull$$$0(23);
        }
        if ((htmlIndex = 6 + text2.indexOf("<html>")) < 6) {
            String string = text2.replaceAll("\n", "<br>");
            if (string == null) {
                UIUtil.$$$reportNull$$$0(24);
            }
            return string;
        }
        int htmlCloseIndex = text2.indexOf("</html>", htmlIndex);
        if (htmlCloseIndex < 0) {
            htmlCloseIndex = text2.length();
        }
        if ((bodyIndex = 6 + text2.indexOf("<body>", htmlIndex)) < 6) {
            String string = text2.substring(htmlIndex, htmlCloseIndex);
            if (string == null) {
                UIUtil.$$$reportNull$$$0(25);
            }
            return string;
        }
        int bodyCloseIndex = text2.indexOf("</body>", bodyIndex);
        if (bodyCloseIndex < 0) {
            bodyCloseIndex = text2.length();
        }
        String string = text2.substring(bodyIndex, Math.min(bodyCloseIndex, htmlCloseIndex));
        if (string == null) {
            UIUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String getHtmlBody(@NotNull Html html) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(27);
        }
        String result2 = UIUtil.getHtmlBody(html.getText());
        String string = html.isKeepFont() ? result2 : result2.replaceAll("<font(.*?)>", "").replaceAll("</font>", "");
        if (string == null) {
            UIUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    public static void drawLinePickedOut(@NotNull Graphics graphics, int x, int y, int x1, int y1) {
        if (graphics == null) {
            UIUtil.$$$reportNull$$$0(29);
        }
        if (x == x1) {
            int minY = Math.min(y, y1);
            int maxY = Math.max(y, y1);
            LinePainter2D.paint((Graphics2D)graphics, x, minY + 1, (double)x1, maxY - 1);
        } else if (y == y1) {
            int minX = Math.min(x, x1);
            int maxX = Math.max(x, x1);
            LinePainter2D.paint((Graphics2D)graphics, minX + 1, y, (double)(maxX - 1), y1);
        } else {
            LinePainter2D.paint((Graphics2D)graphics, x, y, (double)x1, y1);
        }
    }

    public static boolean isReallyTypedEvent(@NotNull KeyEvent e) {
        char c;
        if (e == null) {
            UIUtil.$$$reportNull$$$0(30);
        }
        if ((c = e.getKeyChar()) == '\uffff') {
            return false;
        }
        if (c < ' ' || c == '\u007f') {
            return false;
        }
        if (SystemInfo.isWindows && c >= '\u200c' && c <= '\u200f') {
            return true;
        }
        if (SystemInfo.isMac) {
            return !e.isMetaDown() && !e.isControlDown();
        }
        return !e.isAltDown() && !e.isControlDown();
    }

    public static int getStringY(@NotNull String string, @NotNull Rectangle bounds2, @NotNull Graphics2D g) {
        if (string == null) {
            UIUtil.$$$reportNull$$$0(31);
        }
        if (bounds2 == null) {
            UIUtil.$$$reportNull$$$0(32);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(33);
        }
        int centerY = bounds2.height / 2;
        Font font = g.getFont();
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle stringBounds = font.getStringBounds(string.isEmpty() ? " " : string, frc).getBounds();
        return (int)((double)centerY - (double)stringBounds.height / 2.0 - (double)stringBounds.y);
    }

    public static void drawLabelDottedRectangle(@NotNull JLabel label2, @NotNull Graphics g) {
        if (label2 == null) {
            UIUtil.$$$reportNull$$$0(34);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(35);
        }
        UIUtil.drawLabelDottedRectangle(label2, g, null);
    }

    public static void drawLabelDottedRectangle(@NotNull JLabel label2, @NotNull Graphics g, @Nullable Rectangle bounds2) {
        if (label2 == null) {
            UIUtil.$$$reportNull$$$0(36);
        }
        if (g == null) {
            UIUtil.$$$reportNull$$$0(37);
        }
        if (bounds2 == null) {
            bounds2 = UIUtil.getLabelTextBounds(label2);
        }
        FontMetrics fm = label2.getFontMetrics(label2.getFont());
        int baseLine = label2.getUI().getBaseline(label2, label2.getWidth(), label2.getHeight());
        int textY = baseLine - fm.getLeading() - fm.getAscent();
        int textHeight = fm.getHeight();
        UIUtil.drawDottedRectangle(g, bounds2.x, textY, bounds2.x + bounds2.width - 1, textY + textHeight - 1);
    }

    @NotNull
    public static Rectangle getLabelTextBounds(@NotNull JLabel label2) {
        if (label2 == null) {
            UIUtil.$$$reportNull$$$0(38);
        }
        Dimension size = label2.getPreferredSize();
        Icon icon2 = label2.getIcon();
        Point point = new Point(0, 0);
        Insets insets = label2.getInsets();
        if (icon2 != null) {
            if (label2.getHorizontalTextPosition() == 11) {
                point.x += label2.getIconTextGap();
                point.x += icon2.getIconWidth();
            } else if (label2.getHorizontalTextPosition() == 10) {
                size.width -= icon2.getIconWidth();
            }
        }
        point.x += insets.left;
        point.y += insets.top;
        size.width -= point.x;
        size.width -= insets.right;
        size.height -= insets.bottom;
        return new Rectangle(point, size);
    }

    public static int getHighestGlyphHeight(@NotNull String string, @NotNull Font font, @NotNull Graphics graphics) {
        if (string == null) {
            UIUtil.$$$reportNull$$$0(39);
        }
        if (font == null) {
            UIUtil.$$$reportNull$$$0(40);
        }
        if (graphics == null) {
            UIUtil.$$$reportNull$$$0(41);
        }
        FontRenderContext frc = ((Graphics2D)graphics).getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, string);
        int maxHeight = 0;
        for (int i = 0; i < string.length(); ++i) {
            maxHeight = Math.max(maxHeight, (int)gv.getGlyphMetrics(i).getBounds2D().getHeight());
        }
        return maxHeight;
    }

    public static void setEnabled(@NotNull Component component2, boolean enabled, boolean recursively) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(42);
        }
        UIUtil.setEnabled(component2, enabled, recursively, false);
    }

    public static void setEnabled(@NotNull Component component2, boolean enabled, boolean recursively, boolean visibleOnly) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(43);
        }
        JBIterable<Component> all = recursively ? ((JBTreeTraverser)UIUtil.uiTraverser(component2).expandAndFilter(visibleOnly ? Component::isVisible : Conditions.alwaysTrue())).traverse() : JBIterable.of(component2);
        Color fg = enabled ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground();
        for (Component c : all) {
            c.setEnabled(enabled);
            if (!(c instanceof JLabel)) continue;
            c.setForeground(fg);
        }
    }

    @Deprecated
    public static void drawLine(@NotNull Graphics g, int x1, int y1, int x2, int y2) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(44);
        }
        LinePainter2D.paint((Graphics2D)g, x1, y1, (double)x2, y2);
    }

    public static void drawLine(@NotNull Graphics2D g, int x1, int y1, int x2, int y2, @Nullable Color bgColor, @Nullable Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(45);
        }
        Color oldFg = g.getColor();
        Color oldBg = g.getBackground();
        if (fgColor != null) {
            g.setColor(fgColor);
        }
        if (bgColor != null) {
            g.setBackground(bgColor);
        }
        LinePainter2D.paint(g, x1, y1, (double)x2, y2);
        if (fgColor != null) {
            g.setColor(oldFg);
        }
        if (bgColor != null) {
            g.setBackground(oldBg);
        }
    }

    public static void drawWave(@NotNull Graphics2D g, @NotNull Rectangle rectangle) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(46);
        }
        if (rectangle == null) {
            UIUtil.$$$reportNull$$$0(47);
        }
        WavePainter.forColor(g.getColor()).paint(g, (int)rectangle.getMinX(), (int)rectangle.getMaxX(), (int)rectangle.getMaxY());
    }

    public static String @NotNull [] splitText(@NotNull String text2, @NotNull FontMetrics fontMetrics, int widthLimit, char separator) {
        if (text2 == null) {
            UIUtil.$$$reportNull$$$0(48);
        }
        if (fontMetrics == null) {
            UIUtil.$$$reportNull$$$0(49);
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        StringBuilder currentAtom = new StringBuilder();
        for (int i = 0; i < text2.length(); ++i) {
            String s;
            int width;
            char ch = text2.charAt(i);
            currentAtom.append(ch);
            if (ch == separator) {
                currentLine.append((CharSequence)currentAtom);
                currentAtom.setLength(0);
            }
            if ((width = fontMetrics.stringWidth(s = currentLine.toString() + currentAtom)) < widthLimit - fontMetrics.charWidth('w')) continue;
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder();
                continue;
            }
            lines.add(currentAtom.toString());
            currentAtom.setLength(0);
        }
        String s = currentLine.toString() + currentAtom;
        if (!s.isEmpty()) {
            lines.add(s);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(lines);
        if (stringArray == null) {
            UIUtil.$$$reportNull$$$0(50);
        }
        return stringArray;
    }

    public static void setActionNameAndMnemonic(@NotNull String text2, @NotNull Action action2) {
        if (text2 == null) {
            UIUtil.$$$reportNull$$$0(51);
        }
        if (action2 == null) {
            UIUtil.$$$reportNull$$$0(52);
        }
        UIUtil.assignMnemonic(text2, action2);
        text2 = text2.replaceAll("&", "");
        action2.putValue("Name", text2);
    }

    public static void assignMnemonic(@NotNull String text2, @NotNull Action action2) {
        String mnemoChar;
        int mnemoPos;
        if (text2 == null) {
            UIUtil.$$$reportNull$$$0(53);
        }
        if (action2 == null) {
            UIUtil.$$$reportNull$$$0(54);
        }
        if ((mnemoPos = text2.indexOf(38)) >= 0 && mnemoPos < text2.length() - 2 && (mnemoChar = text2.substring(mnemoPos + 1, mnemoPos + 2).trim()).length() == 1) {
            action2.putValue("MnemonicKey", mnemoChar.charAt(0));
        }
    }

    @NotNull
    public static Font getLabelFont(@NotNull FontSize size) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(55);
        }
        return UIUtil.getFont(size, null);
    }

    @NotNull
    public static Font getFont(@NotNull FontSize size, @Nullable Font base) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(56);
        }
        if (base == null) {
            base = StartupUiUtil.getLabelFont();
        }
        Font font = base.deriveFont(UIUtil.getFontSize(size));
        if (font == null) {
            UIUtil.$$$reportNull$$$0(57);
        }
        return font;
    }

    public static float getFontSize(@NotNull FontSize size) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(58);
        }
        int defSize = StartupUiUtil.getLabelFont().getSize();
        switch (size) {
            case SMALL: {
                return Math.max((float)defSize - JBUIScale.scale(2.0f), JBUIScale.scale(11.0f));
            }
            case MINI: {
                return Math.max((float)defSize - JBUIScale.scale(4.0f), JBUIScale.scale(9.0f));
            }
        }
        return defSize;
    }

    @NotNull
    public static Color getLabelFontColor(@NotNull FontColor fontColor) {
        if (fontColor == null) {
            UIUtil.$$$reportNull$$$0(59);
        }
        Color defColor = UIUtil.getLabelForeground();
        if (fontColor == FontColor.BRIGHTER) {
            return new JBColor(new Color(Math.min(defColor.getRed() + 50, 255), Math.min(defColor.getGreen() + 50, 255), Math.min(defColor.getBlue() + 50, 255)), defColor.darker());
        }
        Color color = defColor;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(60);
        }
        return color;
    }

    public static int getCheckBoxTextHorizontalOffset(@NotNull JCheckBox cb) {
        if (cb == null) {
            UIUtil.$$$reportNull$$$0(61);
        }
        ButtonUI ui = cb.getUI();
        String text2 = cb.getText();
        Icon buttonIcon = cb.getIcon();
        if (buttonIcon == null && ui != null && ui instanceof BasicRadioButtonUI) {
            buttonIcon = ((BasicRadioButtonUI)ui).getDefaultIcon();
        }
        Dimension size = new Dimension();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = cb.getInsets();
        size = cb.getSize(size);
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = size.width - (i.right + viewRect.x);
        viewRect.height = size.height - (i.bottom + viewRect.y);
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        SwingUtilities.layoutCompoundLabel(cb, cb.getFontMetrics(cb.getFont()), text2, buttonIcon, cb.getVerticalAlignment(), cb.getHorizontalAlignment(), cb.getVerticalTextPosition(), cb.getHorizontalTextPosition(), viewRect, iconRect, textRect, text2 == null ? 0 : cb.getIconTextGap());
        return textRect.x;
    }

    public static int getScrollBarWidth() {
        return UIManager.getInt("ScrollBar.width");
    }

    public static Color getLabelBackground() {
        return UIManager.getColor("Label.background");
    }

    @NotNull
    public static Color getLabelForeground() {
        JBColor jBColor = JBColor.namedColor("Label.foreground", new JBColor(Gray._0, Gray.xBB));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(62);
        }
        return jBColor;
    }

    public static Color getErrorForeground() {
        return JBColor.namedColor("Label.errorForeground", new JBColor(new Color(13050413), JBColor.RED));
    }

    @NotNull
    public static Color getLabelDisabledForeground() {
        JBColor jBColor = JBColor.namedColor("Label.disabledForeground", JBColor.GRAY);
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(63);
        }
        return jBColor;
    }

    @NotNull
    public static Color getContextHelpForeground() {
        JBColor jBColor = JBColor.namedColor("Label.infoForeground", new JBColor(Gray.x78, Gray.x8C));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(64);
        }
        return jBColor;
    }

    @NotNull
    public static String removeMnemonic(@NotNull String s) {
        if (s == null) {
            UIUtil.$$$reportNull$$$0(65);
        }
        if (s.indexOf(38) != -1) {
            s = StringUtil.replace(s, "&", "");
        }
        if (s.indexOf(95) != -1) {
            s = StringUtil.replace(s, "_", "");
        }
        if (s.indexOf(27) != -1) {
            s = StringUtil.replace(s, String.valueOf('\u001b'), "");
        }
        String string = s;
        if (string == null) {
            UIUtil.$$$reportNull$$$0(66);
        }
        return string;
    }

    public static int getDisplayMnemonicIndex(@NotNull String s) {
        int idx;
        if (s == null) {
            UIUtil.$$$reportNull$$$0(67);
        }
        if ((idx = s.indexOf(38)) >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(38)) {
            return idx;
        }
        idx = s.indexOf(27);
        if (idx >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(27)) {
            return idx;
        }
        return -1;
    }

    public static String replaceMnemonicAmpersand(String value2) {
        return BundleBase.replaceMnemonicAmpersand(value2);
    }

    @Deprecated
    @NotNull
    public static Color getTreeTextForeground() {
        return UIUtil.getTreeForeground();
    }

    @Deprecated
    @NotNull
    public static Color getTreeTextBackground() {
        return UIUtil.getTreeBackground();
    }

    public static Color getFieldForegroundColor() {
        return UIManager.getColor("field.foreground");
    }

    public static Color getActiveTextColor() {
        return UIManager.getColor("textActiveText");
    }

    @NotNull
    public static Color getInactiveTextColor() {
        JBColor jBColor = JBColor.namedColor("Component.infoForeground", new JBColor(Gray.x99, Gray.x78));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(68);
        }
        return jBColor;
    }

    @Deprecated
    public static Color getActiveTextFieldBackgroundColor() {
        return UIUtil.getTextFieldBackground();
    }

    public static Color getInactiveTextFieldBackgroundColor() {
        return UIManager.getColor("TextField.inactiveBackground");
    }

    @Deprecated
    @NotNull
    public static Color getTextInactiveTextColor() {
        return UIUtil.getInactiveTextColor();
    }

    public static Color getTreeSelectionBorderColor() {
        return UIManager.getColor("Tree.selectionBorderColor");
    }

    public static int getTreeRightChildIndent() {
        return UIManager.getInt("Tree.rightChildIndent");
    }

    public static int getTreeLeftChildIndent() {
        return UIManager.getInt("Tree.leftChildIndent");
    }

    @NotNull
    public static Color getToolTipBackground() {
        JBColor jBColor = JBColor.namedColor("ToolTip.background", new JBColor(Gray.xF2, new Color(3948353)));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(69);
        }
        return jBColor;
    }

    @NotNull
    public static Color getToolTipActionBackground() {
        JBColor jBColor = JBColor.namedColor("ToolTip.Actions.background", new JBColor(Gray.xEB, new Color(4409162)));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(70);
        }
        return jBColor;
    }

    @NotNull
    public static Color getToolTipForeground() {
        JBColor jBColor = JBColor.namedColor("ToolTip.foreground", new JBColor(Gray.x00, Gray.xBF));
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(71);
        }
        return jBColor;
    }

    public static Color getComboBoxDisabledForeground() {
        return UIManager.getColor("ComboBox.disabledForeground");
    }

    public static Color getComboBoxDisabledBackground() {
        return UIManager.getColor("ComboBox.disabledBackground");
    }

    public static Color getButtonSelectColor() {
        return UIManager.getColor("Button.select");
    }

    public static Integer getPropertyMaxGutterIconWidth(@NotNull String propertyPrefix) {
        if (propertyPrefix == null) {
            UIUtil.$$$reportNull$$$0(72);
        }
        return (Integer)UIManager.get(propertyPrefix + ".maxGutterIconWidth");
    }

    public static Color getMenuItemDisabledForeground() {
        return UIManager.getColor("MenuItem.disabledForeground");
    }

    public static Object getMenuItemDisabledForegroundObject() {
        return UIManager.get("MenuItem.disabledForeground");
    }

    public static Object getTabbedPanePaintContentBorder(@NotNull JComponent c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(73);
        }
        return c.getClientProperty("TabbedPane.paintContentBorder");
    }

    public static Color getTableGridColor() {
        return UIManager.getColor("Table.gridColor");
    }

    @NotNull
    public static Color getPanelBackground() {
        Color color = JBColor.PanelBackground;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(74);
        }
        return color;
    }

    public static Color getEditorPaneBackground() {
        return UIManager.getColor("EditorPane.background");
    }

    public static Color getTableFocusCellBackground() {
        return UIManager.getColor(TABLE_FOCUS_CELL_BACKGROUND_PROPERTY);
    }

    public static Color getTextFieldForeground() {
        return UIManager.getColor("TextField.foreground");
    }

    public static Color getTextFieldBackground() {
        return UIManager.getColor("TextField.background");
    }

    public static Font getButtonFont() {
        return UIManager.getFont("Button.font");
    }

    public static Font getToolTipFont() {
        return UIManager.getFont("ToolTip.font");
    }

    public static void setSliderIsFilled(@NotNull JSlider slider, boolean value2) {
        if (slider == null) {
            UIUtil.$$$reportNull$$$0(75);
        }
        slider.putClientProperty(JSLIDER_ISFILLED, value2);
    }

    public static Color getLabelTextForeground() {
        return UIManager.getColor("Label.textForeground");
    }

    public static Color getControlColor() {
        return UIManager.getColor("control");
    }

    public static Font getOptionPaneMessageFont() {
        return UIManager.getFont("OptionPane.messageFont");
    }

    public static Font getMenuFont() {
        return UIManager.getFont("Menu.font");
    }

    @Deprecated
    @NotNull
    public static Color getSeparatorForeground() {
        Color color = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(76);
        }
        return color;
    }

    public static Color getSeparatorShadow() {
        return UIManager.getColor("Separator.shadow");
    }

    @Deprecated
    public static Color getSeparatorHighlight() {
        return UIManager.getColor("Separator.highlight");
    }

    @Deprecated
    @NotNull
    public static Color getSeparatorColor() {
        Color color = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(77);
        }
        return color;
    }

    public static Border getTableFocusCellHighlightBorder() {
        return UIManager.getBorder("Table.focusCellHighlightBorder");
    }

    @Deprecated
    public static void setLineStyleAngled(@NotNull JTree component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(78);
        }
    }

    public static Color getTableFocusCellForeground() {
        return UIManager.getColor("Table.focusCellForeground");
    }

    public static Border getTextFieldBorder() {
        return UIManager.getBorder("TextField.border");
    }

    @NotNull
    public static Icon getErrorIcon() {
        Icon icon2 = ObjectUtils.notNull(UIManager.getIcon("OptionPane.errorIcon"), AllIcons.General.ErrorDialog);
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(79);
        }
        return icon2;
    }

    @NotNull
    public static Icon getInformationIcon() {
        Icon icon2 = ObjectUtils.notNull(UIManager.getIcon("OptionPane.informationIcon"), AllIcons.General.InformationDialog);
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(80);
        }
        return icon2;
    }

    @NotNull
    public static Icon getQuestionIcon() {
        Icon icon2 = ObjectUtils.notNull(UIManager.getIcon("OptionPane.questionIcon"), AllIcons.General.QuestionDialog);
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(81);
        }
        return icon2;
    }

    @NotNull
    public static Icon getWarningIcon() {
        Icon icon2 = ObjectUtils.notNull(UIManager.getIcon("OptionPane.warningIcon"), AllIcons.General.WarningDialog);
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(82);
        }
        return icon2;
    }

    @NotNull
    public static Icon getBalloonInformationIcon() {
        Icon icon2 = AllIcons.General.BalloonInformation;
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(83);
        }
        return icon2;
    }

    @NotNull
    public static Icon getBalloonWarningIcon() {
        Icon icon2 = AllIcons.General.BalloonWarning;
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(84);
        }
        return icon2;
    }

    @NotNull
    public static Icon getBalloonErrorIcon() {
        Icon icon2 = AllIcons.General.BalloonError;
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(85);
        }
        return icon2;
    }

    @Deprecated
    public static Icon getRadioButtonIcon() {
        return UIManager.getIcon("RadioButton.icon");
    }

    @NotNull
    public static Icon getTreeNodeIcon(boolean expanded, boolean selected2, boolean focused) {
        boolean white = selected2 && focused || StartupUiUtil.isUnderDarcula();
        Icon expandedDefault = UIUtil.getTreeExpandedIcon();
        Icon collapsedDefault = UIUtil.getTreeCollapsedIcon();
        Icon expandedSelected = UIUtil.getTreeSelectedExpandedIcon();
        Icon collapsedSelected = UIUtil.getTreeSelectedCollapsedIcon();
        int width = Math.max(Math.max(expandedDefault.getIconWidth(), collapsedDefault.getIconWidth()), Math.max(expandedSelected.getIconWidth(), collapsedSelected.getIconWidth()));
        int height = Math.max(Math.max(expandedDefault.getIconHeight(), collapsedDefault.getIconHeight()), Math.max(expandedSelected.getIconHeight(), collapsedSelected.getIconHeight()));
        return new CenteredIcon(!white ? (expanded ? expandedDefault : collapsedDefault) : (expanded ? expandedSelected : collapsedSelected), width, height, false);
    }

    @NotNull
    public static Icon getTreeCollapsedIcon() {
        Icon icon2 = UIManager.getIcon("Tree.collapsedIcon");
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(86);
        }
        return icon2;
    }

    @NotNull
    public static Icon getTreeExpandedIcon() {
        Icon icon2 = UIManager.getIcon("Tree.expandedIcon");
        if (icon2 == null) {
            UIUtil.$$$reportNull$$$0(87);
        }
        return icon2;
    }

    @Deprecated
    public static Icon getTreeIcon(boolean expanded) {
        return expanded ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon();
    }

    @NotNull
    public static Icon getTreeSelectedCollapsedIcon() {
        Icon icon2 = UIManager.getIcon("Tree.collapsedSelectedIcon");
        return icon2 != null ? icon2 : UIUtil.getTreeCollapsedIcon();
    }

    @NotNull
    public static Icon getTreeSelectedExpandedIcon() {
        Icon icon2 = UIManager.getIcon("Tree.expandedSelectedIcon");
        return icon2 != null ? icon2 : UIUtil.getTreeExpandedIcon();
    }

    @Deprecated
    public static Border getTableHeaderCellBorder() {
        return UIManager.getBorder("TableHeader.cellBorder");
    }

    public static Color getWindowColor() {
        return UIManager.getColor("window");
    }

    public static Color getTextAreaForeground() {
        return UIManager.getColor("TextArea.foreground");
    }

    public static Color getOptionPaneBackground() {
        return UIManager.getColor("OptionPane.background");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isUnderAquaLookAndFeel() {
        return SystemInfo.isMac && UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isUnderNimbusLookAndFeel() {
        return false;
    }

    public static boolean isUnderAquaBasedLookAndFeel() {
        return SystemInfo.isMac && (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF());
    }

    public static boolean isUnderDefaultMacTheme() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (SystemInfo.isMac && lookAndFeel instanceof UserDataHolder) {
            UserDataHolder dh = (UserDataHolder)((Object)lookAndFeel);
            return Boolean.TRUE != dh.getUserData(LAF_WITH_THEME_KEY) && StringUtil.equals(dh.getUserData(PLUGGABLE_LAF_KEY), "macOS Light");
        }
        return false;
    }

    public static boolean isUnderWin10LookAndFeel() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (SystemInfo.isWindows && lookAndFeel instanceof UserDataHolder) {
            UserDataHolder dh = (UserDataHolder)((Object)lookAndFeel);
            return Boolean.TRUE != dh.getUserData(LAF_WITH_THEME_KEY) && StringUtil.equals(dh.getUserData(PLUGGABLE_LAF_KEY), "Windows 10 Light");
        }
        return false;
    }

    public static boolean isUnderDarcula() {
        return StartupUiUtil.isUnderDarcula();
    }

    public static boolean isUnderIntelliJLaF() {
        return UIManager.getLookAndFeel().getName().contains("IntelliJ") || UIUtil.isUnderDefaultMacTheme() || UIUtil.isUnderWin10LookAndFeel();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isUnderGTKLookAndFeel() {
        return SystemInfo.isXWindow && UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static boolean isGraphite() {
        if (!SystemInfo.isMac) {
            return false;
        }
        try {
            return Foundation.invoke("NSColor", "currentControlTint", new Object[0]).intValue() == 6;
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public static Font getToolbarFont() {
        Font font = SystemInfo.isMac ? UIUtil.getLabelFont(FontSize.SMALL) : StartupUiUtil.getLabelFont();
        if (font == null) {
            UIUtil.$$$reportNull$$$0(88);
        }
        return font;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Color shade(@NotNull Color c, double factor, double d) {
        void alphaFactor;
        if (c == null) {
            UIUtil.$$$reportNull$$$0(89);
        }
        assert (factor >= 0.0) : factor;
        return new Color(Math.min((int)Math.round((double)c.getRed() * factor), 255), Math.min((int)Math.round((double)c.getGreen() * factor), 255), Math.min((int)Math.round((double)c.getBlue() * factor), 255), Math.min((int)Math.round((double)c.getAlpha() * alphaFactor), 255));
    }

    @NotNull
    public static Color mix(@NotNull Color c1, Color c2, double factor) {
        if (c1 == null) {
            UIUtil.$$$reportNull$$$0(90);
        }
        assert (0.0 <= factor && factor <= 1.0) : factor;
        double backFactor = 1.0 - factor;
        return new Color(Math.min((int)Math.round((double)c1.getRed() * backFactor + (double)c2.getRed() * factor), 255), Math.min((int)Math.round((double)c1.getGreen() * backFactor + (double)c2.getGreen() * factor), 255), Math.min((int)Math.round((double)c1.getBlue() * backFactor + (double)c2.getBlue() * factor), 255));
    }

    public static boolean isFullRowSelectionLAF() {
        return false;
    }

    public static boolean isUnderNativeMacLookAndFeel() {
        return StartupUiUtil.isUnderDarcula();
    }

    public static int getListCellHPadding() {
        return UIUtil.isUnderDefaultMacTheme() ? 8 : (UIUtil.isUnderWin10LookAndFeel() ? 2 : 7);
    }

    public static int getListCellVPadding() {
        return 1;
    }

    @NotNull
    public static JBInsets getRegularPanelInsets() {
        JBInsets jBInsets = JBInsets.create(8, 12);
        if (jBInsets == null) {
            UIUtil.$$$reportNull$$$0(91);
        }
        return jBInsets;
    }

    @NotNull
    public static Insets getListCellPadding() {
        JBInsets jBInsets = JBInsets.create(UIUtil.getListCellVPadding(), UIUtil.getListCellHPadding());
        if (jBInsets == null) {
            UIUtil.$$$reportNull$$$0(92);
        }
        return jBInsets;
    }

    @NotNull
    public static Insets getListViewportPadding() {
        JBInsets jBInsets = UIUtil.isUnderNativeMacLookAndFeel() ? JBInsets.create(1, 0) : JBUI.emptyInsets();
        if (jBInsets == null) {
            UIUtil.$$$reportNull$$$0(93);
        }
        return jBInsets;
    }

    public static boolean isToUseDottedCellBorder() {
        return !UIUtil.isUnderNativeMacLookAndFeel();
    }

    public static boolean isControlKeyDown(@NotNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            UIUtil.$$$reportNull$$$0(94);
        }
        return SystemInfo.isMac ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
    }

    public static String @NotNull [] getValidFontNames(boolean familyName) {
        TreeSet<String> result2 = new TreeSet<String>();
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            try {
                if (!FontUtil.isValidFont(font)) continue;
                result2.add(familyName ? font.getFamily() : font.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Font labelFont = StartupUiUtil.getLabelFont();
        if (labelFont != null && FontUtil.isValidFont(labelFont)) {
            result2.add(familyName ? labelFont.getFamily() : labelFont.getName());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result2);
        if (stringArray == null) {
            UIUtil.$$$reportNull$$$0(95);
        }
        return stringArray;
    }

    public static String @NotNull [] getStandardFontSizes() {
        if (STANDARD_FONT_SIZES == null) {
            UIUtil.$$$reportNull$$$0(96);
        }
        return STANDARD_FONT_SIZES;
    }

    public static void setupEnclosingDialogBounds(@NotNull JComponent component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(97);
        }
        component2.revalidate();
        component2.repaint();
        Window window = SwingUtilities.windowForComponent(component2);
        if (window != null && (window.getSize().height < window.getMinimumSize().height || window.getSize().width < window.getMinimumSize().width)) {
            window.pack();
        }
    }

    @NotNull
    public static String displayPropertiesToCSS(Font font, Color fg) {
        StringBuilder rule2 = new StringBuilder("body {");
        if (font != null) {
            rule2.append(" font-family: ");
            rule2.append(font.getFamily());
            rule2.append(" ; ");
            rule2.append(" font-size: ");
            rule2.append(font.getSize());
            rule2.append("pt ;");
            if (font.isBold()) {
                rule2.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule2.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule2.append(" color: #");
            UIUtil.appendColor(fg, rule2);
            rule2.append(" ; ");
        }
        rule2.append(" }");
        String string = rule2.toString();
        if (string == null) {
            UIUtil.$$$reportNull$$$0(98);
        }
        return string;
    }

    public static void appendColor(@NotNull Color color, @NotNull StringBuilder sb) {
        if (color == null) {
            UIUtil.$$$reportNull$$$0(99);
        }
        if (sb == null) {
            UIUtil.$$$reportNull$$$0(100);
        }
        if (color.getRed() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getRed()));
        if (color.getGreen() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getGreen()));
        if (color.getBlue() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getBlue()));
    }

    public static void drawDottedRectangle(@NotNull Graphics g, @NotNull Rectangle r) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(101);
        }
        if (r == null) {
            UIUtil.$$$reportNull$$$0(102);
        }
        UIUtil.drawDottedRectangle(g, r.x, r.y, r.x + r.width, r.y + r.height);
    }

    public static void drawDottedRectangle(@NotNull Graphics g, int x, int y, int x1, int y1) {
        int i1;
        if (g == null) {
            UIUtil.$$$reportNull$$$0(103);
        }
        for (i1 = x; i1 <= x1; i1 += 2) {
            LinePainter2D.paint((Graphics2D)g, i1, y, (double)i1, y);
        }
        for (i1 = y + (i1 != x1 + 1 ? 2 : 1); i1 <= y1; i1 += 2) {
            LinePainter2D.paint((Graphics2D)g, x1, i1, (double)x1, i1);
        }
        for (i1 = x1 - (i1 != y1 + 1 ? 2 : 1); i1 >= x; i1 -= 2) {
            LinePainter2D.paint((Graphics2D)g, i1, y1, (double)i1, y1);
        }
        for (i1 = y1 - (i1 != x - 1 ? 2 : 1); i1 >= y; i1 -= 2) {
            LinePainter2D.paint((Graphics2D)g, x, i1, (double)x, i1);
        }
    }

    public static void drawBoldDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(104);
        }
        if (SystemInfo.isMac && !UIUtil.isRetina() || SystemInfo.isLinux) {
            UIUtil.drawAppleDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        } else {
            UIUtil.drawBoringDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        }
    }

    public static void drawSearchMatch(@NotNull Graphics2D g, float startX, float endX, int height) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(105);
        }
        JBColor c1 = JBColor.namedColor("SearchMatch.startBackground", JBColor.namedColor("SearchMatch.startColor", 16771746));
        JBColor c2 = JBColor.namedColor("SearchMatch.endBackground", JBColor.namedColor("SearchMatch.endColor", 16764994));
        UIUtil.drawSearchMatch(g, startX, endX, height, c1, c2);
    }

    public static void drawSearchMatch(@NotNull Graphics2D g, float startXf, float endXf, int height, Color c1, Color c2) {
        boolean drawRound;
        if (g == null) {
            UIUtil.$$$reportNull$$$0(106);
        }
        GraphicsConfig config2 = new GraphicsConfig(g);
        float alpha = (float)JBUI.getInt("SearchMatch.transparency", 70) / 100.0f;
        alpha = alpha < 0.0f || alpha > 1.0f ? 0.7f : alpha;
        g.setComposite(AlphaComposite.getInstance(3, alpha));
        g.setPaint(UIUtil.getGradientPaint(startXf, 2.0f, c1, startXf, height - 5, c2));
        if (JreHiDpiUtil.isJreHiDPI(g)) {
            GraphicsConfig c = GraphicsUtil.setupRoundedBorderAntialiasing(g);
            g.fill(new RoundRectangle2D.Float(startXf, 2.0f, endXf - startXf, height - 4, 5.0f, 5.0f));
            c.restore();
            config2.restore();
            return;
        }
        int startX = (int)startXf;
        int endX = (int)endXf;
        g.fillRect(startX, 3, endX - startX, height - 5);
        boolean bl = drawRound = endXf - startXf > 4.0f;
        if (drawRound) {
            LinePainter2D.paint(g, startX - 1, 4.0, (double)(startX - 1), height - 4);
            LinePainter2D.paint(g, endX, 4.0, (double)endX, height - 4);
            g.setColor(new Color(100, 100, 100, 50));
            LinePainter2D.paint(g, startX - 1, 4.0, (double)(startX - 1), height - 4);
            LinePainter2D.paint(g, endX, 4.0, (double)endX, height - 4);
            LinePainter2D.paint(g, startX, 3.0, (double)(endX - 1), 3.0);
            LinePainter2D.paint(g, startX, height - 3, (double)(endX - 1), height - 3);
        }
        config2.restore();
    }

    private static void drawBoringDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(107);
        }
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, startX, lineY, (double)endX, lineY);
            LinePainter2D.paint(g, startX, lineY + 1, (double)endX, lineY + 1);
        }
        int step = 4;
        int startPosCorrection = startX % 4 < 3 ? 0 : 1;
        g.setColor(fgColor != null ? fgColor : oldColor);
        for (int dotXi = (startX / 4 + startPosCorrection) * 4; dotXi < endX; dotXi += 4) {
            LinePainter2D.paint(g, dotXi, lineY, (double)(dotXi + 1), lineY);
            LinePainter2D.paint(g, dotXi, lineY + 1, (double)(dotXi + 1), lineY + 1);
        }
        g.setColor(oldColor);
    }

    public static void drawGradientHToolbarBackground(@NotNull Graphics g, int width, int height) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(108);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(UIUtil.getGradientPaint(0.0f, 0.0f, Gray._215, 0.0f, height, Gray._200));
        g2d.fillRect(0, 0, width, height);
    }

    public static void drawHeader(@NotNull Graphics g, int x, int width, int height, boolean active, boolean drawTopLine) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(109);
        }
        UIUtil.drawHeader(g, x, width, height, active, false, drawTopLine, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawHeader(@NotNull Graphics g, int x, int width, int height, boolean active, boolean toolWindow, boolean drawTopLine, boolean drawBottomLine) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(110);
        }
        GraphicsConfig config2 = GraphicsUtil.disableAAPainting(g);
        try {
            g.setColor(JBUI.CurrentTheme.ToolWindow.headerBackground(active));
            g.fillRect(x, 0, width, height);
            g.setColor(JBUI.CurrentTheme.ToolWindow.headerBorderBackground());
            if (drawTopLine) {
                LinePainter2D.paint((Graphics2D)g, x, 0.0, (double)width, 0.0);
            }
            if (drawBottomLine) {
                LinePainter2D.paint((Graphics2D)g, x, height - 1, (double)width, height - 1);
            }
        }
        finally {
            config2.restore();
        }
    }

    public static void drawDoubleSpaceDottedLine(@NotNull Graphics2D g, int start2, int end, int xOrY, Color fgColor, boolean horizontal) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(111);
        }
        g.setColor(fgColor);
        for (int dot = start2; dot < end; dot += 3) {
            if (horizontal) {
                LinePainter2D.paint(g, dot, xOrY, (double)dot, xOrY);
                continue;
            }
            LinePainter2D.paint(g, xOrY, dot, (double)xOrY, dot);
        }
    }

    private static void drawAppleDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(112);
        }
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, startX, lineY, (double)endX, lineY);
            LinePainter2D.paint(g, startX, lineY + 1, (double)endX, lineY + 1);
            LinePainter2D.paint(g, startX, lineY + 2, (double)endX, lineY + 2);
        }
        AppleBoldDottedPainter painter = AppleBoldDottedPainter.forColor(ObjectUtils.notNull(fgColor, oldColor));
        painter.paint(g, startX, endX, lineY);
    }

    @Deprecated
    public static void applyRenderingHints(@NotNull Graphics g) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(113);
        }
        GraphicsUtil.applyRenderingHints((Graphics2D)g);
    }

    @Deprecated
    @NotNull
    public static BufferedImage createImage(int width, int height, int type) {
        BufferedImage bufferedImage = ImageUtil.createImage(width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(114);
        }
        return bufferedImage;
    }

    @Deprecated
    @NotNull
    public static BufferedImage createImage(@Nullable GraphicsConfiguration gc, int width, int height, int type) {
        BufferedImage bufferedImage = ImageUtil.createImage(gc, width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(115);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage createImage(GraphicsConfiguration gc, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type;
        if (roundingMode == null) {
            UIUtil.$$$reportNull$$$0(116);
        }
        if (JreHiDpiUtil.isJreHiDPI(gc)) {
            BufferedImage bufferedImage = RetinaImage.create(gc, width, height, (int)type, (PaintUtil.RoundingMode)rm);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(117);
            }
            return bufferedImage;
        }
        return new BufferedImage(rm.round(width), rm.round(height), (int)type);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage createImage(ScaleContext ctx, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type;
        if (roundingMode == null) {
            UIUtil.$$$reportNull$$$0(118);
        }
        if (StartupUiUtil.isJreHiDPI(ctx)) {
            BufferedImage bufferedImage = RetinaImage.create(ctx, width, height, (int)type, (PaintUtil.RoundingMode)rm);
            if (bufferedImage == null) {
                UIUtil.$$$reportNull$$$0(119);
            }
            return bufferedImage;
        }
        return new BufferedImage(rm.round(width), rm.round(height), (int)type);
    }

    @Deprecated
    @NotNull
    public static BufferedImage createImage(Graphics g, int width, int height, int type) {
        BufferedImage bufferedImage = ImageUtil.createImage(g, width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(120);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NotNull
    public static BufferedImage createImage(Graphics g, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type;
        if (roundingMode == null) {
            UIUtil.$$$reportNull$$$0(121);
        }
        BufferedImage bufferedImage = ImageUtil.createImage(g, width, height, (int)type, (PaintUtil.RoundingMode)rm);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(122);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage createImage(Component comp, int width, int height, int type) {
        BufferedImage bufferedImage = comp != null ? ImageUtil.createImage(comp.getGraphicsConfiguration(), width, height, type) : ImageUtil.createImage(width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(123);
        }
        return bufferedImage;
    }

    @Deprecated
    @NotNull
    public static BufferedImage createImageForGraphics(Graphics2D g, int width, int height, int type) {
        BufferedImage bufferedImage = ImageUtil.createImage(g, width, height, type);
        if (bufferedImage == null) {
            UIUtil.$$$reportNull$$$0(124);
        }
        return bufferedImage;
    }

    public static void setupComposite(@NotNull Graphics2D g) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(125);
        }
        g.setComposite(X_RENDER_ACTIVE.getValue() != false ? AlphaComposite.SrcOver : AlphaComposite.Src);
    }

    public static void dispatchAllInvocationEvents() {
        AWTEvent event;
        assert (EdtInvocationManager.getInstance().isEventDispatchThread()) : Thread.currentThread() + "; EDT: " + UIUtil.getEventQueueThread();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Method dispatchEventMethod = Objects.requireNonNull(ReflectionUtil.getDeclaredMethod(eventQueue.getClass(), "dispatchEvent", AWTEvent.class));
        int i = 1;
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                event = eventQueue.getNextEvent();
                if (event instanceof InvocationEvent) {
                    dispatchEventMethod.invoke((Object)eventQueue, event);
                }
            }
            catch (InvocationTargetException e) {
                ExceptionUtil.rethrowAllAsUnchecked(e.getCause());
            }
            catch (Exception e) {
                ExceptionUtil.rethrow(e);
            }
            if (i % 10000 == 0) {
                System.out.println("Suspiciously many (" + i + ") AWT events, last dispatched " + event);
            }
            ++i;
        }
    }

    @NotNull
    private static Thread getEventQueueThread() {
        Thread thread;
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            Method method2 = ReflectionUtil.getDeclaredMethod(EventQueue.class, "getDispatchThread", new Class[0]);
            thread = (Thread)method2.invoke((Object)eventQueue, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (thread == null) {
            UIUtil.$$$reportNull$$$0(126);
        }
        return thread;
    }

    /*
     * WARNING - void declaration
     */
    public static void addAwtListener(@NotNull AWTEventListener listener2, long mask, @NotNull Disposable disposable2) {
        void parent;
        if (listener2 == null) {
            UIUtil.$$$reportNull$$$0(127);
        }
        if (disposable2 == null) {
            UIUtil.$$$reportNull$$$0(128);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(listener2, mask);
        Disposer.register((Disposable)parent, () -> Toolkit.getDefaultToolkit().removeAWTEventListener(listener2));
    }

    public static void addParentChangeListener(@NotNull Component component2, @NotNull PropertyChangeListener listener2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(129);
        }
        if (listener2 == null) {
            UIUtil.$$$reportNull$$$0(130);
        }
        component2.addPropertyChangeListener("ancestor", listener2);
    }

    public static void removeParentChangeListener(@NotNull Component component2, @NotNull PropertyChangeListener listener2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(131);
        }
        if (listener2 == null) {
            UIUtil.$$$reportNull$$$0(132);
        }
        component2.removePropertyChangeListener("ancestor", listener2);
    }

    public static void drawVDottedLine(@NotNull Graphics2D g, int lineX, int startY, int endY, @Nullable Color bgColor, Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(133);
        }
        if (bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, lineX, startY, (double)lineX, endY);
        }
        g.setColor(fgColor);
        for (int i = startY / 2 * 2; i < endY; i += 2) {
            g.drawRect(lineX, i, 0, 0);
        }
    }

    public static void drawHDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, @Nullable Color bgColor, Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(134);
        }
        if (bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, startX, lineY, (double)endX, lineY);
        }
        g.setColor(fgColor);
        for (int i = startX / 2 * 2; i < endX; i += 2) {
            g.drawRect(i, lineY, 0, 0);
        }
    }

    public static void drawDottedLine(@NotNull Graphics2D g, int x1, int y1, int x2, int y2, @Nullable Color bgColor, Color fgColor) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(135);
        }
        if (x1 == x2) {
            UIUtil.drawVDottedLine(g, x1, y1, y2, bgColor, fgColor);
        } else if (y1 == y2) {
            UIUtil.drawHDottedLine(g, x1, x2, y1, bgColor, fgColor);
        } else {
            throw new IllegalArgumentException("Only vertical or horizontal lines are supported");
        }
    }

    public static void drawStringWithHighlighting(@NotNull Graphics g, @NotNull String s, int x, int y, Color foreground, Color highlighting) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(136);
        }
        if (s == null) {
            UIUtil.$$$reportNull$$$0(137);
        }
        g.setColor(highlighting);
        boolean isRetina = JreHiDpiUtil.isJreHiDPI((Graphics2D)g);
        float scale = 1.0f / JBUIScale.sysScale((Graphics2D)g);
        for (float i = (float)(x - 1); i <= (float)(x + 1); i += isRetina ? scale : 1.0f) {
            for (float j = (float)(y - 1); j <= (float)(y + 1); j += isRetina ? scale : 1.0f) {
                ((Graphics2D)g).drawString(s, i, j);
            }
        }
        g.setColor(foreground);
        g.drawString(s, x, y);
    }

    public static void drawCenteredString(@NotNull Graphics2D g, @NotNull Rectangle rect, @NotNull String str, boolean horzCentered, boolean vertCentered) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(138);
        }
        if (rect == null) {
            UIUtil.$$$reportNull$$$0(139);
        }
        if (str == null) {
            UIUtil.$$$reportNull$$$0(140);
        }
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int textWidth = fm.stringWidth(str) - 1;
        int x = horzCentered ? Math.max(rect.x, rect.x + (rect.width - textWidth) / 2) : rect.x;
        int y = vertCentered ? Math.max(rect.y, rect.y + rect.height / 2 + fm.getAscent() * 2 / 5) : rect.y;
        Shape oldClip = g.getClip();
        g.clip(rect);
        g.drawString(str, x, y);
        g.setClip(oldClip);
    }

    public static void drawCenteredString(@NotNull Graphics2D g, @NotNull Rectangle rect, @NotNull String str) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(141);
        }
        if (rect == null) {
            UIUtil.$$$reportNull$$$0(142);
        }
        if (str == null) {
            UIUtil.$$$reportNull$$$0(143);
        }
        UIUtil.drawCenteredString(g, rect, str, true, true);
    }

    public static boolean isFocusAncestor(@NotNull Component component2) {
        Component owner;
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(144);
        }
        if ((owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) {
            return false;
        }
        if (owner == component2) {
            return true;
        }
        return SwingUtilities.isDescendingFrom(owner, component2);
    }

    public static boolean isCloseClick(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(145);
        }
        return UIUtil.isCloseClick(e, 501);
    }

    public static boolean isCloseClick(@NotNull MouseEvent e, int effectiveType) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(146);
        }
        if (e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 2 || e.getButton() == 1 && e.isShiftDown();
    }

    public static boolean isActionClick(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(147);
        }
        return UIUtil.isActionClick(e, 501);
    }

    public static boolean isActionClick(@NotNull MouseEvent e, int effectiveType) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(148);
        }
        return UIUtil.isActionClick(e, effectiveType, false);
    }

    public static boolean isActionClick(@NotNull MouseEvent e, int effectiveType, boolean allowShift) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(149);
        }
        if (!allowShift && UIUtil.isCloseClick(e) || e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 1;
    }

    @NotNull
    public static Color getBgFillColor(@NotNull Component c) {
        Component parent;
        if (c == null) {
            UIUtil.$$$reportNull$$$0(150);
        }
        Color color = (parent = UIUtil.findNearestOpaque(c)) == null ? c.getBackground() : parent.getBackground();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(151);
        }
        return color;
    }

    @Nullable
    public static Component findNearestOpaque(Component c) {
        return ComponentUtil.findParentByCondition(c, Component::isOpaque);
    }

    @Deprecated
    public static Component findParentByCondition(@Nullable Component c, @NotNull Condition<? super Component> condition2) {
        if (condition2 == null) {
            UIUtil.$$$reportNull$$$0(152);
        }
        return ComponentUtil.findParentByCondition(c, (? super Component it) -> condition2.value((Component)it));
    }

    @Nullable
    public static Component getDeepestComponentAt(@NotNull Component parent, int x, int y) {
        Component component2;
        if (parent == null) {
            UIUtil.$$$reportNull$$$0(153);
        }
        if ((component2 = SwingUtilities.getDeepestComponentAt(parent, x, y)) != null && component2.getParent() instanceof JRootPane) {
            JRootPane rootPane = (JRootPane)component2.getParent();
            Point point = SwingUtilities.convertPoint(parent, new Point(x, y), rootPane.getLayeredPane());
            component2 = SwingUtilities.getDeepestComponentAt(rootPane.getLayeredPane(), point.x, point.y);
            if (component2 == null) {
                point = SwingUtilities.convertPoint(parent, new Point(x, y), rootPane.getContentPane());
                component2 = SwingUtilities.getDeepestComponentAt(rootPane.getContentPane(), point.x, point.y);
            }
        }
        return component2;
    }

    public static void layoutRecursively(@NotNull Component component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(154);
        }
        if (!(component2 instanceof JComponent)) {
            return;
        }
        UIUtil.forEachComponentInHierarchy(component2, c -> component2.doLayout());
    }

    @NotNull
    @Language(value="HTML")
    public static String getCssFontDeclaration(@NotNull Font font) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(155);
        }
        return UIUtil.getCssFontDeclaration(font, UIUtil.getLabelForeground(), JBUI.CurrentTheme.Link.linkColor(), null);
    }

    @NotNull
    @Language(value="HTML")
    public static String getCssFontDeclaration(@NotNull Font font, @Nullable Color fgColor, @Nullable Color linkColor, @Nullable String liImg) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(156);
        }
        StringBuilder builder2 = new StringBuilder().append("<style>\n");
        String familyAndSize = "font-family:'" + font.getFamily() + "'; font-size:" + font.getSize() + "pt;";
        builder2.append("body, div, td, p {").append(familyAndSize);
        if (fgColor != null) {
            builder2.append(" color:#").append(ColorUtil.toHex(fgColor)).append(';');
        }
        builder2.append("}\n");
        builder2.append("a {").append(familyAndSize);
        if (linkColor != null) {
            builder2.append(" color:#").append(ColorUtil.toHex(linkColor)).append(';');
        }
        builder2.append("}\n");
        builder2.append("code {font-size:").append(font.getSize()).append("pt;}\n");
        builder2.append("ul {list-style:disc; margin-left:15px;}\n");
        String string = builder2.append("</style>").toString();
        if (string == null) {
            UIUtil.$$$reportNull$$$0(157);
        }
        return string;
    }

    @NotNull
    public static Color getFocusedFillColor() {
        return UIUtil.toAlpha(UIUtil.getListSelectionBackground(true), 100);
    }

    @NotNull
    public static Color getFocusedBoundsColor() {
        return UIUtil.getBoundsColor();
    }

    @NotNull
    public static Color getBoundsColor() {
        Color color = JBColor.border();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(158);
        }
        return color;
    }

    @NotNull
    public static Color getBoundsColor(boolean focused) {
        return focused ? UIUtil.getFocusedBoundsColor() : UIUtil.getBoundsColor();
    }

    @NotNull
    public static Color toAlpha(Color color, int alpha) {
        Color actual = color != null ? color : Color.black;
        return new Color(actual.getRed(), actual.getGreen(), actual.getBlue(), alpha);
    }

    public static boolean isFocusable(@Nullable Component component2) {
        return component2 != null && component2.isFocusable() && component2.isEnabled() && component2.isShowing();
    }

    @Deprecated
    public static void requestFocus(@NotNull JComponent c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(159);
        }
        if (c.isShowing()) {
            c.requestFocus();
        } else {
            SwingUtilities.invokeLater(c::requestFocus);
        }
    }

    public static boolean canDisplayFocusedState(@NotNull Component component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(160);
        }
        return component2 instanceof JTextComponent || component2 instanceof AbstractButton || component2 instanceof JComboBox;
    }

    public static void dispose(Component c) {
        MouseWheelListener[] mouseWheelListeners;
        MouseMotionListener[] motionListeners;
        MouseListener[] mouseListeners;
        if (c == null) {
            return;
        }
        for (MouseListener each : mouseListeners = c.getMouseListeners()) {
            c.removeMouseListener(each);
        }
        for (MouseMotionListener each : motionListeners = c.getMouseMotionListeners()) {
            c.removeMouseMotionListener(each);
        }
        for (MouseWheelListener each : mouseWheelListeners = c.getMouseWheelListeners()) {
            c.removeMouseWheelListener(each);
        }
        if (c instanceof AbstractButton) {
            ActionListener[] listeners;
            for (ActionListener listener2 : listeners = ((AbstractButton)c).getActionListeners()) {
                ((AbstractButton)c).removeActionListener(listener2);
            }
        }
    }

    public static void disposeProgress(@NotNull JProgressBar progress2) {
        if (progress2 == null) {
            UIUtil.$$$reportNull$$$0(161);
        }
        if (!UIUtil.isUnderNativeMacLookAndFeel()) {
            return;
        }
        SwingUtilities.invokeLater(() -> progress2.setUI(null));
    }

    @Nullable
    public static Component findUltimateParent(@Nullable Component c) {
        return c == null ? null : ComponentUtil.findUltimateParent(c);
    }

    @NotNull
    public static Color getHeaderActiveColor() {
        Color color = ACTIVE_HEADER_COLOR;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(162);
        }
        return color;
    }

    @NotNull
    public static Color getFocusedBorderColor() {
        Color color = JBUI.CurrentTheme.Focus.focusColor();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(163);
        }
        return color;
    }

    @NotNull
    public static Color getHeaderInactiveColor() {
        Color color = INACTIVE_HEADER_COLOR;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(164);
        }
        return color;
    }

    @NotNull
    public static Font getTitledBorderFont() {
        Font font = StartupUiUtil.getLabelFont();
        if (font == null) {
            UIUtil.$$$reportNull$$$0(165);
        }
        return font;
    }

    @Deprecated
    @NotNull
    public static Color getBorderInactiveColor() {
        Color color = JBColor.border();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(166);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getBorderActiveColor() {
        Color color = JBColor.border();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(167);
        }
        return color;
    }

    @Deprecated
    @NotNull
    public static Color getBorderSeparatorColor() {
        Color color = JBColor.border();
        if (color == null) {
            UIUtil.$$$reportNull$$$0(168);
        }
        return color;
    }

    @Nullable
    public static StyleSheet loadStyleSheet(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        try {
            StyleSheet styleSheet = new StyleSheet();
            styleSheet.loadRules(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8), url);
            return styleSheet;
        }
        catch (IOException e) {
            UIUtil.getLogger().warn(url + " loading failed", e);
            return null;
        }
    }

    @NotNull
    public static HTMLEditorKit getHTMLEditorKit() {
        return UIUtil.getHTMLEditorKit(true);
    }

    @NotNull
    public static HTMLEditorKit getHTMLEditorKit(boolean noGapsBetweenParagraphs) {
        return new JBHtmlEditorKit(noGapsBetweenParagraphs);
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@NotNull Font font) {
        if (font == null) {
            UIUtil.$$$reportNull$$$0(169);
        }
        return UIUtil.getFontWithFallback(font.getFamily(), font.getStyle(), font.getSize());
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@Nullable String familyName, @JdkConstants.FontStyle int style, int size) {
        Font fontWithFallback = SystemInfo.isMac ? new Font(familyName, style, size) : new StyleContext().getFont(familyName, style, size);
        return fontWithFallback instanceof FontUIResource ? (FontUIResource)fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public static <T> T htmlInjectionGuard(T toRender) {
        if (toRender instanceof String && StringUtil.toLowerCase((String)toRender).startsWith("<html>")) {
            return (T)("<html>" + StringUtil.escapeXmlEntities((String)toRender));
        }
        return toRender;
    }

    @Deprecated
    public static void removeScrollBorder(Component c) {
        JBIterable<JScrollPane> scrollPanes = ((JBTreeTraverser)UIUtil.uiTraverser(c).expand(o -> o == c || o instanceof JPanel || o instanceof JLayeredPane)).filter(JScrollPane.class);
        for (JScrollPane scrollPane : scrollPanes) {
            Integer keepBorderSides = ComponentUtil.getClientProperty(scrollPane, KEEP_BORDER_SIDES);
            if (keepBorderSides != null) {
                if (scrollPane.getBorder() instanceof LineBorder) {
                    Color color = ((LineBorder)scrollPane.getBorder()).getLineColor();
                    scrollPane.setBorder(new SideBorder(color, keepBorderSides));
                    continue;
                }
                scrollPane.setBorder(new SideBorder(UIUtil.getBoundsColor(), keepBorderSides));
                continue;
            }
            scrollPane.setBorder(new SideBorder(UIUtil.getBoundsColor(), 0));
        }
    }

    @NotNull
    public static String toHtml(@NotNull String html) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(170);
        }
        return UIUtil.toHtml(html, 0);
    }

    @NotNull
    @NonNls
    public static String toHtml(@NotNull String html, int hPadding) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(171);
        }
        html = CLOSE_TAG_PATTERN.matcher(html).replaceAll("<$1$2></$1>");
        Font font = StartupUiUtil.getLabelFont();
        String family = font != null ? font.getFamily() : "Tahoma";
        int size = font != null ? font.getSize() : JBUIScale.scale(11);
        String string = "<html><style>body { font-family: " + family + "; font-size: " + size + ";} ul li {list-style-type:circle;}</style>" + UIUtil.addPadding(html, hPadding) + "</html>";
        if (string == null) {
            UIUtil.$$$reportNull$$$0(172);
        }
        return string;
    }

    @NotNull
    public static String addPadding(@NotNull String html, int hPadding) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(173);
        }
        String string = String.format("<p style=\"margin: 0 %dpx 0 %dpx;\">%s</p>", hPadding, hPadding, html);
        if (string == null) {
            UIUtil.$$$reportNull$$$0(174);
        }
        return string;
    }

    @NotNull
    public static String convertSpace2Nbsp(@NotNull String html) {
        if (html == null) {
            UIUtil.$$$reportNull$$$0(175);
        }
        StringBuilder result2 = new StringBuilder();
        int braces = 0;
        for (int currentPos = 0; currentPos < html.length(); ++currentPos) {
            String each = html.substring(currentPos, currentPos + 1);
            if ("<".equals(each)) {
                ++braces;
            } else if (">".equals(each)) {
                --braces;
            }
            if (" ".equals(each) && braces == 0) {
                result2.append("&nbsp;");
                continue;
            }
            result2.append(each);
        }
        String string = result2.toString();
        if (string == null) {
            UIUtil.$$$reportNull$$$0(176);
        }
        return string;
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable2) {
        EdtInvocationManager edtInvocationManager;
        if (runnable2 == null) {
            UIUtil.$$$reportNull$$$0(177);
        }
        if ((edtInvocationManager = EdtInvocationManager.getInstance()).isEventDispatchThread()) {
            runnable2.run();
        } else {
            edtInvocationManager.invokeLater(runnable2);
        }
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            UIUtil.$$$reportNull$$$0(178);
        }
        EdtInvocationManager.getInstance().invokeAndWaitIfNeeded(runnable2);
    }

    public static <T> T invokeAndWaitIfNeeded(@NotNull Computable<T> computable) {
        if (computable == null) {
            UIUtil.$$$reportNull$$$0(179);
        }
        Ref result2 = Ref.create();
        UIUtil.invokeAndWaitIfNeeded(() -> result2.set(computable.compute()));
        return result2.get();
    }

    public static void invokeAndWaitIfNeeded(@NotNull ThrowableRunnable<?> runnable2) throws Throwable {
        if (runnable2 == null) {
            UIUtil.$$$reportNull$$$0(180);
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            runnable2.run();
        } else {
            Ref ref = Ref.create();
            EdtInvocationManager.getInstance().invokeAndWait(() -> {
                try {
                    runnable2.run();
                }
                catch (Throwable throwable) {
                    ref.set(throwable);
                }
            });
            if (!ref.isNull()) {
                throw (Throwable)ref.get();
            }
        }
    }

    public static boolean isFocusProxy(@Nullable Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty(FOCUS_PROXY_KEY));
    }

    public static void maybeInstall(@NotNull InputMap map2, String action2, KeyStroke stroke) {
        if (map2 == null) {
            UIUtil.$$$reportNull$$$0(181);
        }
        if (map2.get(stroke) == null) {
            map2.put(stroke, action2);
        }
    }

    public static void changeBackGround(@NotNull Component component2, Color background) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(182);
        }
        Color oldBackGround = component2.getBackground();
        if (background == null || !background.equals(oldBackGround)) {
            component2.setBackground(background);
        }
    }

    @Nullable
    public static ComboPopup getComboBoxPopup(@NotNull JComboBox<?> comboBox2) {
        ComboBoxUI ui;
        if (comboBox2 == null) {
            UIUtil.$$$reportNull$$$0(183);
        }
        if ((ui = comboBox2.getUI()) instanceof BasicComboBoxUI) {
            return ReflectionUtil.getField(BasicComboBoxUI.class, ui, ComboPopup.class, "popup");
        }
        return null;
    }

    public static void fixFormattedField(@NotNull JFormattedTextField field) {
        if (field == null) {
            UIUtil.$$$reportNull$$$0(184);
        }
        if (SystemInfo.isMac) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit instanceof HeadlessToolkit) {
                return;
            }
            int commandKeyMask = toolkit.getMenuShortcutKeyMask();
            InputMap inputMap = field.getInputMap();
            KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, commandKeyMask);
            inputMap.put(copyKeyStroke, "copy-to-clipboard");
            KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, commandKeyMask);
            inputMap.put(pasteKeyStroke, "paste-from-clipboard");
            KeyStroke cutKeyStroke = KeyStroke.getKeyStroke(88, commandKeyMask);
            inputMap.put(cutKeyStroke, "cut-to-clipboard");
        }
    }

    public static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics || g instanceof PrinterGraphics;
    }

    public static int getSelectedButton(@NotNull ButtonGroup group) {
        if (group == null) {
            UIUtil.$$$reportNull$$$0(185);
        }
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button2 = enumeration.nextElement();
            if (group.isSelected(button2.getModel())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void setSelectedButton(@NotNull ButtonGroup group, int index) {
        if (group == null) {
            UIUtil.$$$reportNull$$$0(186);
        }
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button2 = enumeration.nextElement();
            group.setSelected(button2.getModel(), index == i);
            ++i;
        }
    }

    public static boolean isSelectionButtonDown(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(187);
        }
        return e.isShiftDown() || e.isControlDown() || e.isMetaDown();
    }

    public static boolean isToggleListSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            UIUtil.$$$reportNull$$$0(188);
        }
        return SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown()) && !e.isPopupTrigger();
    }

    public static void setComboBoxEditorBounds(int x, int y, int width, int height, @NotNull JComponent editor) {
        if (editor == null) {
            UIUtil.$$$reportNull$$$0(189);
        }
        editor.reshape(x, y, width, height);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static int fixComboBoxHeight(int height) {
        return height;
    }

    public static boolean isDescendingFrom(@Nullable Component child2, @NotNull Component parent) {
        if (parent == null) {
            UIUtil.$$$reportNull$$$0(190);
        }
        while (child2 != null && child2 != parent) {
            child2 = child2 instanceof JPopupMenu ? ((JPopupMenu)child2).getInvoker() : child2.getParent();
        }
        return child2 == parent;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getParentOfType(@NotNull Class<? extends T> type, Component component2) {
        if (type == null) {
            UIUtil.$$$reportNull$$$0(191);
        }
        return ComponentUtil.getParentOfType(type, component2);
    }

    @NotNull
    public static JBIterable<Component> uiParents(@Nullable Component c, boolean strict) {
        JBIterable<Component> jBIterable = strict ? JBIterable.generate(c, c1 -> c1.getParent()).skip(1) : JBIterable.generate(c, c1 -> c1.getParent());
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(192);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<Component> uiChildren(@Nullable Component component2) {
        if (!(component2 instanceof Container)) {
            JBIterable<Component> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                UIUtil.$$$reportNull$$$0(193);
            }
            return jBIterable;
        }
        Container container2 = (Container)component2;
        JBIterable<Component> jBIterable = JBIterable.of(container2.getComponents());
        if (jBIterable == null) {
            UIUtil.$$$reportNull$$$0(194);
        }
        return jBIterable;
    }

    @NotNull
    public static JBTreeTraverser<Component> uiTraverser(@Nullable Component component2) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)((JBTreeTraverser)UI_TRAVERSER.withRoot(component2)).expandAndFilter(o -> !(o instanceof CellRendererPane));
        if (jBTreeTraverser == null) {
            UIUtil.$$$reportNull$$$0(195);
        }
        return jBTreeTraverser;
    }

    public static void scrollListToVisibleIfNeeded(@NotNull JList<?> list2) {
        if (list2 == null) {
            UIUtil.$$$reportNull$$$0(196);
        }
        SwingUtilities.invokeLater(() -> {
            Rectangle cellBounds;
            Rectangle visibleRect;
            int selectedIndex = list2.getSelectedIndex();
            if (selectedIndex >= 0 && !(visibleRect = list2.getVisibleRect()).contains(cellBounds = list2.getCellBounds(selectedIndex, selectedIndex))) {
                list2.scrollRectToVisible(cellBounds);
            }
        });
    }

    @Nullable
    public static <T extends JComponent> T findComponentOfType(JComponent parent, Class<T> cls) {
        if (parent == null || cls.isInstance(parent)) {
            return (T)((JComponent)cls.cast(parent));
        }
        for (Component component2 : parent.getComponents()) {
            T comp;
            if (!(component2 instanceof JComponent) || (comp = UIUtil.findComponentOfType((JComponent)component2, cls)) == null) continue;
            return comp;
        }
        return null;
    }

    @NotNull
    public static <T extends JComponent> List<T> findComponentsOfType(JComponent parent, @NotNull Class<? extends T> cls) {
        if (cls == null) {
            UIUtil.$$$reportNull$$$0(197);
        }
        ArrayList result2 = new ArrayList();
        UIUtil.findComponentsOfType(parent, cls, result2);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            UIUtil.$$$reportNull$$$0(198);
        }
        return arrayList;
    }

    private static <T extends JComponent> void findComponentsOfType(JComponent parent, @NotNull Class<T> cls, @NotNull List<? super T> result2) {
        if (cls == null) {
            UIUtil.$$$reportNull$$$0(199);
        }
        if (result2 == null) {
            UIUtil.$$$reportNull$$$0(200);
        }
        if (parent == null) {
            return;
        }
        if (cls.isAssignableFrom(parent.getClass())) {
            JComponent t = parent;
            result2.add(t);
        }
        for (Component c : parent.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            UIUtil.findComponentsOfType((JComponent)c, cls, result2);
        }
    }

    @Nullable
    public static JRootPane getRootPane(Component c) {
        JRootPane root = ComponentUtil.getParentOfType(JRootPane.class, c);
        if (root != null) {
            return root;
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            WeakReference pane2;
            if (!(eachParent instanceof JComponent) || (pane2 = (WeakReference)((JComponent)eachParent).getClientProperty(ROOT_PANE)) == null) continue;
            return (JRootPane)pane2.get();
        }
        return null;
    }

    public static void setFutureRootPane(@NotNull JComponent c, @NotNull JRootPane pane2) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(201);
        }
        if (pane2 == null) {
            UIUtil.$$$reportNull$$$0(202);
        }
        c.putClientProperty(ROOT_PANE, new WeakReference<JRootPane>(pane2));
    }

    public static boolean isMeaninglessFocusOwner(@Nullable Component c) {
        if (c == null || !c.isShowing()) {
            return true;
        }
        return c instanceof JFrame || c instanceof JDialog || c instanceof JWindow || c instanceof JRootPane || UIUtil.isFocusProxy(c);
    }

    @Deprecated
    @NotNull
    public static Timer createNamedTimer(@NonNls @NotNull String name, int delay, @NotNull ActionListener listener2) {
        if (name == null) {
            UIUtil.$$$reportNull$$$0(203);
        }
        if (listener2 == null) {
            UIUtil.$$$reportNull$$$0(204);
        }
        Timer timer2 = TimerUtil.createNamedTimer(name, delay, listener2);
        if (timer2 == null) {
            UIUtil.$$$reportNull$$$0(205);
        }
        return timer2;
    }

    @Deprecated
    @NotNull
    public static Timer createNamedTimer(@NonNls @NotNull String name, int delay) {
        if (name == null) {
            UIUtil.$$$reportNull$$$0(206);
        }
        Timer timer2 = TimerUtil.createNamedTimer(name, delay);
        if (timer2 == null) {
            UIUtil.$$$reportNull$$$0(207);
        }
        return timer2;
    }

    public static boolean isDialogRootPane(JRootPane rootPane) {
        if (rootPane != null) {
            Object isDialog = rootPane.getClientProperty("DIALOG_ROOT_PANE");
            return isDialog instanceof Boolean && (Boolean)isDialog != false;
        }
        return false;
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(PanelWithAnchor ... panels) {
        if (panels == null) {
            UIUtil.$$$reportNull$$$0(208);
        }
        return UIUtil.mergeComponentsWithAnchor(Arrays.asList(panels));
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(@NotNull Collection<? extends PanelWithAnchor> panels) {
        if (panels == null) {
            UIUtil.$$$reportNull$$$0(209);
        }
        JComponent maxWidthAnchor = null;
        int maxWidth = 0;
        for (PanelWithAnchor panelWithAnchor : panels) {
            int anchorWidth;
            JComponent anchor2 = panelWithAnchor != null ? panelWithAnchor.getAnchor() : null;
            if (anchor2 == null || maxWidth >= (anchorWidth = anchor2.getPreferredSize().width)) continue;
            maxWidth = anchorWidth;
            maxWidthAnchor = anchor2;
        }
        for (PanelWithAnchor panelWithAnchor : panels) {
            if (panelWithAnchor == null) continue;
            panelWithAnchor.setAnchor(maxWidthAnchor);
        }
        return maxWidthAnchor;
    }

    public static void setNotOpaqueRecursively(@NotNull Component component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(210);
        }
        if (!(component2 instanceof JComponent)) {
            return;
        }
        UIUtil.forEachComponentInHierarchy(component2, c -> {
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(false);
            }
        });
    }

    public static void setBackgroundRecursively(@NotNull Component component2, @NotNull Color bg) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(211);
        }
        if (bg == null) {
            UIUtil.$$$reportNull$$$0(212);
        }
        UIUtil.forEachComponentInHierarchy(component2, c -> c.setBackground(bg));
    }

    private static void forEachComponentInHierarchy(@NotNull Component component2, @NotNull Consumer<Component> action2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(213);
        }
        if (action2 == null) {
            UIUtil.$$$reportNull$$$0(214);
        }
        action2.consume(component2);
        if (component2 instanceof Container) {
            for (Component c : ((Container)component2).getComponents()) {
                UIUtil.forEachComponentInHierarchy(c, action2);
            }
        }
    }

    public static void addInsets(@NotNull JComponent component2, int top, int left, int bottom, int right) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(215);
        }
        UIUtil.addBorder(component2, BorderFactory.createEmptyBorder(top, left, bottom, right));
    }

    public static void addInsets(@NotNull JComponent component2, @NotNull Insets insets) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(216);
        }
        if (insets == null) {
            UIUtil.$$$reportNull$$$0(217);
        }
        UIUtil.addInsets(component2, insets.top, insets.left, insets.bottom, insets.right);
    }

    public static void adjustWindowToMinimumSize(Window window) {
        if (window == null) {
            return;
        }
        Dimension minSize = window.getMinimumSize();
        Dimension size = window.getSize();
        Dimension newSize = new Dimension(Math.max(size.width, minSize.width), Math.max(size.height, minSize.height));
        if (!newSize.equals(size)) {
            SwingUtilities.invokeLater(() -> {
                if (window.isShowing()) {
                    window.setSize(newSize);
                }
            });
        }
    }

    public static int getLcdContrastValue() {
        int lcdContrastValue = Registry.intValue("lcd.contrast.value", 0);
        if (lcdContrastValue == 0) {
            return StartupUiUtil.doGetLcdContrastValueForSplash(StartupUiUtil.isUnderDarcula());
        }
        return StartupUiUtil.normalizeLcdContrastValue(lcdContrastValue);
    }

    public static void addBorder(JComponent component2, Border border) {
        if (component2 != null && border != null) {
            Border old = component2.getBorder();
            if (old != null) {
                border = BorderFactory.createCompoundBorder(border, old);
            }
            component2.setBorder(border);
        }
    }

    @NotNull
    public static Color getDecoratedRowColor() {
        JBColor jBColor = JBColor.namedColor("Table.stripeColor", DECORATED_ROW_BG_COLOR);
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(218);
        }
        return jBColor;
    }

    @NotNull
    public static Paint getGradientPaint(float x1, float y1, @NotNull Color c1, float x2, float y2, @NotNull Color c2) {
        if (c1 == null) {
            UIUtil.$$$reportNull$$$0(219);
        }
        if (c2 == null) {
            UIUtil.$$$reportNull$$$0(220);
        }
        return Registry.is("ui.no.bangs.and.whistles", false) ? ColorUtil.mix(c1, c2, 0.5) : new GradientPaint(x1, y1, c1, x2, y2, c2);
    }

    @Nullable
    public static Point getLocationOnScreen(@NotNull JComponent component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(221);
        }
        int dx = 0;
        int dy = 0;
        for (Container c = component2; c != null; c = c.getParent()) {
            if (c.isShowing()) {
                Point locationOnScreen = c.getLocationOnScreen();
                locationOnScreen.translate(dx, dy);
                return locationOnScreen;
            }
            Point location2 = c.getLocation();
            dx += location2.x;
            dy += location2.y;
        }
        return null;
    }

    public static void setAutoRequestFocus(@NotNull Window window, boolean value2) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(222);
        }
        if (!SystemInfo.isMac) {
            window.setAutoRequestFocus(value2);
        }
    }

    public static void runWhenWindowOpened(@NotNull Window window, final @NotNull Runnable runnable2) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(223);
        }
        if (runnable2 == null) {
            UIUtil.$$$reportNull$$$0(224);
        }
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                runnable2.run();
            }
        });
    }

    public static void runWhenWindowClosed(@NotNull Window window, final @NotNull Runnable runnable2) {
        if (window == null) {
            UIUtil.$$$reportNull$$$0(225);
        }
        if (runnable2 == null) {
            UIUtil.$$$reportNull$$$0(226);
        }
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                runnable2.run();
            }
        });
    }

    @NotNull
    public static String getDebugText(Component c) {
        StringBuilder builder2 = new StringBuilder();
        UIUtil.getAllTextsRecursivelyImpl(c, builder2);
        String string = builder2.toString();
        if (string == null) {
            UIUtil.$$$reportNull$$$0(227);
        }
        return string;
    }

    private static void getAllTextsRecursivelyImpl(Component component2, @NotNull StringBuilder builder2) {
        if (builder2 == null) {
            UIUtil.$$$reportNull$$$0(228);
        }
        String candidate = "";
        if (component2 instanceof JLabel) {
            candidate = ((JLabel)component2).getText();
        }
        if (component2 instanceof JTextComponent) {
            candidate = ((JTextComponent)component2).getText();
        }
        if (component2 instanceof AbstractButton) {
            candidate = ((AbstractButton)component2).getText();
        }
        if (StringUtil.isNotEmpty(candidate)) {
            candidate = candidate.replaceAll("<a href=\"#inspection/[^)]+\\)", "");
            if (builder2.length() > 0) {
                builder2.append(' ');
            }
            builder2.append(StringUtil.removeHtmlTags(candidate).trim());
        }
        if (component2 instanceof Container) {
            Component[] components;
            for (Component child2 : components = ((Container)component2).getComponents()) {
                UIUtil.getAllTextsRecursivelyImpl(child2, builder2);
            }
        }
    }

    public static boolean isAncestor(@NotNull Component ancestor, @Nullable Component descendant) {
        if (ancestor == null) {
            UIUtil.$$$reportNull$$$0(229);
        }
        while (descendant != null) {
            if (descendant == ancestor) {
                return true;
            }
            descendant = descendant.getParent();
        }
        return false;
    }

    public static void resetUndoRedoActions(@NotNull JTextComponent textComponent) {
        UndoManager undoManager;
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(230);
        }
        if ((undoManager = ComponentUtil.getClientProperty(textComponent, UNDO_MANAGER)) != null) {
            undoManager.discardAllEdits();
        }
    }

    public static void addUndoRedoActions(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(231);
        }
        if (textComponent.getClientProperty(UNDO_MANAGER) instanceof UndoManager) {
            return;
        }
        UndoManager undoManager = new UndoManager();
        textComponent.putClientProperty(UNDO_MANAGER, undoManager);
        textComponent.getDocument().addUndoableEditListener(undoManager);
        textComponent.getDocument().addDocumentListener(SET_TEXT_CHECKER);
        textComponent.getInputMap().put(KeyStroke.getKeyStroke(90, SystemInfo.isMac ? 4 : 2), "undoKeystroke");
        textComponent.getActionMap().put("undoKeystroke", UNDO_ACTION);
        textComponent.getInputMap().put(KeyStroke.getKeyStroke(90, (SystemInfo.isMac ? 4 : 2) | 1), "redoKeystroke");
        textComponent.getActionMap().put("redoKeystroke", REDO_ACTION);
    }

    @Nullable
    public static UndoManager getUndoManager(Component component2) {
        Object o;
        if (component2 instanceof JTextComponent && (o = ((JTextComponent)component2).getClientProperty(UNDO_MANAGER)) instanceof UndoManager) {
            return (UndoManager)o;
        }
        return null;
    }

    public static void playSoundFromResource(@NotNull String resourceName) {
        Class<?> callerClass;
        if (resourceName == null) {
            UIUtil.$$$reportNull$$$0(232);
        }
        if ((callerClass = ReflectionUtil.getGrandCallerClass()) == null) {
            return;
        }
        UIUtil.playSoundFromStream(() -> callerClass.getResourceAsStream(resourceName));
    }

    public static void playSoundFromStream(@NotNull Factory<? extends InputStream> streamProducer) {
        if (streamProducer == null) {
            UIUtil.$$$reportNull$$$0(233);
        }
        new Thread(() -> {
            try {
                Clip clip = AudioSystem.getClip();
                InputStream stream = (InputStream)streamProducer.create();
                if (!stream.markSupported()) {
                    stream = new BufferedInputStream(stream);
                }
                AudioInputStream inputStream = AudioSystem.getAudioInputStream(stream);
                clip.open(inputStream);
                clip.start();
            }
            catch (Exception e) {
                UIUtil.getLogger().info(e);
            }
        }, "play sound").start();
    }

    @NotNull
    public static String rightArrow() {
        String string = FontUtil.rightArrow(StartupUiUtil.getLabelFont());
        if (string == null) {
            UIUtil.$$$reportNull$$$0(234);
        }
        return string;
    }

    @NotNull
    public static String upArrow(@NotNull String defaultValue) {
        if (defaultValue == null) {
            UIUtil.$$$reportNull$$$0(235);
        }
        String string = FontUtil.upArrow(StartupUiUtil.getLabelFont(), defaultValue);
        if (string == null) {
            UIUtil.$$$reportNull$$$0(236);
        }
        return string;
    }

    public static void configureNumericFormattedTextField(@NotNull JFormattedTextField textField2) {
        if (textField2 == null) {
            UIUtil.$$$reportNull$$$0(237);
        }
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setParseIntegerOnly(true);
        format.setGroupingUsed(false);
        NumberFormatter numberFormatter = new NumberFormatter(format);
        numberFormatter.setMinimum(Integer.valueOf(0));
        textField2.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        textField2.setHorizontalAlignment(11);
        textField2.setColumns(4);
    }

    @Nullable
    public static Window getWindow(@Nullable Component component2) {
        return ComponentUtil.getWindow(component2);
    }

    public static void toFront(@Nullable Window window) {
        if (window instanceof Frame) {
            ((Frame)window).setState(0);
        }
        if (window != null) {
            window.toFront();
        }
    }

    public static boolean hasScrollPane(@NotNull Component component2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(238);
        }
        return UIUtil.hasComponentOfType(component2, JScrollPane.class);
    }

    public static boolean hasComponentOfType(@NotNull Component component2, Class<?> ... types) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(239);
        }
        if (types == null) {
            UIUtil.$$$reportNull$$$0(240);
        }
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(component2.getClass())) continue;
            return true;
        }
        if (component2 instanceof Container) {
            Container container2 = (Container)component2;
            for (int i = 0; i < container2.getComponentCount(); ++i) {
                if (!UIUtil.hasComponentOfType(container2.getComponent(i), types)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setColumns(JTextComponent textComponent, int columns) {
        if (textComponent instanceof JTextField) {
            ((JTextField)textComponent).setColumns(columns);
        }
        if (textComponent instanceof JTextArea) {
            ((JTextArea)textComponent).setColumns(columns);
        }
    }

    public static int getLineHeight(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(241);
        }
        return textComponent.getFontMetrics(textComponent.getFont()).getHeight();
    }

    public static JComponent getPreferredFocusedComponent(Container container2) {
        Container parent = container2;
        if (parent == null) {
            return null;
        }
        FocusTraversalPolicy policy = parent.getFocusTraversalPolicy();
        while (policy == null) {
            if ((parent = parent.getParent()) == null) {
                return null;
            }
            policy = parent.getFocusTraversalPolicy();
        }
        Component component2 = policy.getFirstComponent(container2);
        return component2 instanceof JComponent ? (JComponent)component2 : null;
    }

    @NotNull
    public static ComponentStyle getComponentStyle(Component component2) {
        if (component2 instanceof JComponent) {
            Object property = ((JComponent)component2).getClientProperty("JComponent.sizeVariant");
            if ("large".equals(property)) {
                ComponentStyle componentStyle = ComponentStyle.LARGE;
                if (componentStyle == null) {
                    UIUtil.$$$reportNull$$$0(242);
                }
                return componentStyle;
            }
            if ("small".equals(property)) {
                ComponentStyle componentStyle = ComponentStyle.SMALL;
                if (componentStyle == null) {
                    UIUtil.$$$reportNull$$$0(243);
                }
                return componentStyle;
            }
            if ("mini".equals(property)) {
                ComponentStyle componentStyle = ComponentStyle.MINI;
                if (componentStyle == null) {
                    UIUtil.$$$reportNull$$$0(244);
                }
                return componentStyle;
            }
        }
        ComponentStyle componentStyle = ComponentStyle.REGULAR;
        if (componentStyle == null) {
            UIUtil.$$$reportNull$$$0(245);
        }
        return componentStyle;
    }

    public static void repaintViewport(@NotNull JComponent c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(246);
        }
        if (!c.isDisplayable() || !c.isVisible()) {
            return;
        }
        Container p = c.getParent();
        if (p instanceof JViewport) {
            p.repaint();
        }
    }

    public static void setCursor(@NotNull Component component2, Cursor cursor) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(247);
        }
        if (component2.isCursorSet() && component2.getCursor() == cursor) {
            return;
        }
        component2.setCursor(cursor);
    }

    public static boolean haveCommonOwner(Component c1, Component c2) {
        Window owner;
        if (c1 == null || c2 == null) {
            return false;
        }
        Window c1Ancestor = UIUtil.findWindowAncestor(c1);
        Window c2Ancestor = UIUtil.findWindowAncestor(c2);
        HashSet<Window> ownerSet = new HashSet<Window>();
        for (owner = c1Ancestor; owner != null && !(owner instanceof JDialog) && !(owner instanceof JFrame); owner = owner.getOwner()) {
            ownerSet.add(owner);
        }
        for (owner = c2Ancestor; owner != null && !(owner instanceof JDialog) && !(owner instanceof JFrame); owner = owner.getOwner()) {
            if (!ownerSet.contains(owner)) continue;
            return true;
        }
        return false;
    }

    private static Window findWindowAncestor(@NotNull Component c) {
        if (c == null) {
            UIUtil.$$$reportNull$$$0(248);
        }
        return c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
    }

    public static boolean isHelpButton(Component button2) {
        return button2 instanceof JButton && "help".equals(((JComponent)button2).getClientProperty("JButton.buttonType"));
    }

    public static boolean isRetina(@NotNull GraphicsDevice device) {
        if (device == null) {
            UIUtil.$$$reportNull$$$0(249);
        }
        return DetectRetinaKit.isOracleMacRetinaDevice(device);
    }

    public static void useSafely(@NotNull Graphics originGraphics, @NotNull Consumer<? super Graphics2D> drawingConsumer) {
        if (originGraphics == null) {
            UIUtil.$$$reportNull$$$0(250);
        }
        if (drawingConsumer == null) {
            UIUtil.$$$reportNull$$$0(251);
        }
        Graphics2D graphics = (Graphics2D)originGraphics.create();
        try {
            drawingConsumer.consume(graphics);
        }
        finally {
            graphics.dispose();
        }
    }

    @NotNull
    public static Font getListFont() {
        Font font = UIManager.getFont("List.font");
        Font font2 = font != null ? font : StartupUiUtil.getLabelFont();
        if (font2 == null) {
            UIUtil.$$$reportNull$$$0(252);
        }
        return font2;
    }

    @NotNull
    public static Color getListBackground() {
        Color color = LIST_BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(253);
        }
        return color;
    }

    @NotNull
    public static Color getListSelectionBackground(boolean focused) {
        if (!focused) {
            Color color = UnfocusedSelection.LIST_BACKGROUND;
            if (color == null) {
                UIUtil.$$$reportNull$$$0(254);
            }
            return color;
        }
        Color color = UIManager.getColor("List.selectionBackground");
        double alpha = (double)SELECTED_ITEM_ALPHA.getFloat() / 100.0;
        Color color2 = UIUtil.isUnderDefaultMacTheme() && alpha >= 0.0 && alpha <= 1.0 ? ColorUtil.mix(Color.WHITE, color, alpha) : color;
        if (color2 == null) {
            UIUtil.$$$reportNull$$$0(255);
        }
        return color2;
    }

    @NotNull
    public static Dimension updateListRowHeight(@NotNull Dimension size) {
        if (size == null) {
            UIUtil.$$$reportNull$$$0(256);
        }
        size.height = Math.max(size.height, UIManager.getInt("List.rowHeight"));
        Dimension dimension = size;
        if (dimension == null) {
            UIUtil.$$$reportNull$$$0(257);
        }
        return dimension;
    }

    @NotNull
    public static Color getListBackground(boolean selected2, boolean focused) {
        return !selected2 ? UIUtil.getListBackground() : UIUtil.getListSelectionBackground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getListBackground(boolean selected2) {
        return UIUtil.getListBackground(selected2, true);
    }

    @Deprecated
    @NotNull
    public static Color getListSelectionBackground() {
        return UIUtil.getListSelectionBackground(true);
    }

    @Deprecated
    @NotNull
    public static Color getListUnfocusedSelectionBackground() {
        return UIUtil.getListSelectionBackground(false);
    }

    @NotNull
    public static Color getListForeground() {
        Color color = UIManager.getColor("List.foreground");
        if (color == null) {
            UIUtil.$$$reportNull$$$0(258);
        }
        return color;
    }

    @NotNull
    public static Color getListSelectionForeground(boolean focused) {
        Color foreground = UIManager.getColor(focused ? "List.selectionForeground" : "List.selectionInactiveForeground");
        if (focused && foreground == null) {
            foreground = UIManager.getColor("List[Selected].textForeground");
        }
        return foreground != null ? foreground : UIUtil.getListForeground();
    }

    @NotNull
    public static Color getListForeground(boolean selected2, boolean focused) {
        return !selected2 ? UIUtil.getListForeground() : UIUtil.getListSelectionForeground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getListForeground(boolean selected2) {
        return UIUtil.getListForeground(selected2, true);
    }

    @Deprecated
    @NotNull
    public static Color getListSelectionForeground() {
        return UIUtil.getListSelectionForeground(true);
    }

    @NotNull
    public static Font getTreeFont() {
        Font font = UIManager.getFont("Tree.font");
        Font font2 = font != null ? font : StartupUiUtil.getLabelFont();
        if (font2 == null) {
            UIUtil.$$$reportNull$$$0(259);
        }
        return font2;
    }

    @NotNull
    public static Color getTreeBackground() {
        Color color = TREE_BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(260);
        }
        return color;
    }

    @NotNull
    public static Color getTreeSelectionBackground(boolean focused) {
        Color color = focused ? FocusedSelection.TREE_BACKGROUND : UnfocusedSelection.TREE_BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(261);
        }
        return color;
    }

    @NotNull
    public static Color getTreeBackground(boolean selected2, boolean focused) {
        return !selected2 ? UIUtil.getTreeBackground() : UIUtil.getTreeSelectionBackground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTreeSelectionBackground() {
        return UIUtil.getTreeSelectionBackground(true);
    }

    @Deprecated
    @NotNull
    public static Color getTreeUnfocusedSelectionBackground() {
        return UIUtil.getTreeSelectionBackground(false);
    }

    @NotNull
    public static Color getTreeForeground() {
        Color color = UIManager.getColor("Tree.foreground");
        if (color == null) {
            UIUtil.$$$reportNull$$$0(262);
        }
        return color;
    }

    @NotNull
    public static Color getTreeSelectionForeground(boolean focused) {
        Color foreground = UIManager.getColor(focused ? "Tree.selectionForeground" : "Tree.selectionInactiveForeground");
        return foreground != null ? foreground : UIUtil.getTreeForeground();
    }

    @NotNull
    public static Color getTreeForeground(boolean selected2, boolean focused) {
        return !selected2 ? UIUtil.getTreeForeground() : UIUtil.getTreeSelectionForeground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTreeSelectionForeground() {
        return UIUtil.getTreeSelectionForeground(true);
    }

    @NotNull
    public static Color getTableBackground() {
        Color color = TABLE_BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(263);
        }
        return color;
    }

    @NotNull
    public static Color getTableSelectionBackground(boolean focused) {
        Color color = focused ? FocusedSelection.TABLE_BACKGROUND : UnfocusedSelection.TABLE_BACKGROUND;
        if (color == null) {
            UIUtil.$$$reportNull$$$0(264);
        }
        return color;
    }

    @NotNull
    public static Color getTableBackground(boolean selected2, boolean focused) {
        return !selected2 ? UIUtil.getTableBackground() : UIUtil.getTableSelectionBackground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTableBackground(boolean selected2) {
        return UIUtil.getTableBackground(selected2, true);
    }

    @Deprecated
    @NotNull
    public static Color getTableSelectionBackground() {
        return UIUtil.getTableSelectionBackground(true);
    }

    @Deprecated
    @NotNull
    public static Color getTableUnfocusedSelectionBackground() {
        return UIUtil.getTableSelectionBackground(false);
    }

    @NotNull
    public static Color getTableForeground() {
        Color color = UIManager.getColor("Table.foreground");
        if (color == null) {
            UIUtil.$$$reportNull$$$0(265);
        }
        return color;
    }

    @NotNull
    public static Color getTableSelectionForeground(boolean focused) {
        Color foreground = UIManager.getColor(focused ? "Table.selectionForeground" : "Table.selectionInactiveForeground");
        return foreground != null ? foreground : UIUtil.getTreeForeground();
    }

    @NotNull
    public static Color getTableForeground(boolean selected2, boolean focused) {
        return !selected2 ? UIUtil.getTableForeground() : UIUtil.getTableSelectionForeground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTableForeground(boolean selected2) {
        return UIUtil.getTableForeground(selected2, true);
    }

    @Deprecated
    @NotNull
    public static Color getTableSelectionForeground() {
        Color color = UIManager.getColor("Table.selectionForeground");
        if (color == null) {
            UIUtil.$$$reportNull$$$0(266);
        }
        return color;
    }

    @Deprecated
    public static Pair<String, Integer> getSystemFontData() {
        return JBUIScale.getSystemFontData();
    }

    @Deprecated
    public static boolean isJreHiDPIEnabled() {
        return JreHiDpiUtil.isJreHiDPIEnabled();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isJreHiDPI(@Nullable Graphics2D g) {
        return JreHiDpiUtil.isJreHiDPI(g);
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval
    public static Color getPanelBackgound() {
        return UIUtil.getPanelBackground();
    }

    public static void doNotScrollToCaret(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(267);
        }
        textComponent.setCaret(new DefaultCaret(){

            @Override
            protected void adjustVisibility(Rectangle nloc) {
            }
        });
    }

    public static void enableEagerSoftWrapping(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            UIUtil.$$$reportNull$$$0(268);
        }
        textComponent.getDocument().putProperty("multiByte", Boolean.TRUE);
    }

    @NotNull
    public static Color getTooltipSeparatorColor() {
        JBColor jBColor = JBColor.namedColor("Tooltip.separatorColor", 0xD1D1D1, 5527128);
        if (jBColor == null) {
            UIUtil.$$$reportNull$$$0(269);
        }
        return jBColor;
    }

    public static void scrollToReference(@NotNull JEditorPane editor, @NotNull String reference2) {
        Element elementById;
        Document document;
        if (editor == null) {
            UIUtil.$$$reportNull$$$0(270);
        }
        if (reference2 == null) {
            UIUtil.$$$reportNull$$$0(271);
        }
        if ((document = editor.getDocument()) instanceof HTMLDocument && (elementById = ((HTMLDocument)document).getElement(reference2)) != null) {
            try {
                int pos = elementById.getStartOffset();
                Rectangle r = editor.modelToView(pos);
                if (r != null) {
                    r.height = editor.getVisibleRect().height;
                    editor.scrollRectToVisible(r);
                    editor.setCaretPosition(pos);
                }
            }
            catch (BadLocationException e) {
                UIUtil.getLogger().error(e);
            }
            return;
        }
        editor.scrollToReference(reference2);
    }

    public static void runWhenFocused(@NotNull Component component2, final @NotNull Runnable runnable2) {
        if (component2 == null) {
            UIUtil.$$$reportNull$$$0(272);
        }
        if (runnable2 == null) {
            UIUtil.$$$reportNull$$$0(273);
        }
        assert (component2.isShowing());
        if (component2.isFocusOwner()) {
            runnable2.run();
        } else {
            final Disposable disposable2 = Disposer.newDisposable();
            FocusAdapter focusListener2 = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    Disposer.dispose(disposable2);
                    runnable2.run();
                }
            };
            HierarchyListener hierarchyListener = e -> {
                if ((e.getChangeFlags() & 4L) != 0L && !component2.isShowing()) {
                    Disposer.dispose(disposable2);
                }
            };
            component2.addFocusListener(focusListener2);
            component2.addHierarchyListener(hierarchyListener);
            Disposer.register(disposable2, () -> {
                component2.removeFocusListener(focusListener2);
                component2.removeHierarchyListener(hierarchyListener);
            });
        }
    }

    public static Font getLabelFont() {
        return StartupUiUtil.getLabelFont();
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, @Nullable ImageObserver observer) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(274);
        }
        if (image == null) {
            UIUtil.$$$reportNull$$$0(275);
        }
        StartupUiUtil.drawImage(g, image, x, y, null);
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Dimension container2, @NotNull Dimension child2) {
        if (container2 == null) {
            UIUtil.$$$reportNull$$$0(276);
        }
        if (child2 == null) {
            UIUtil.$$$reportNull$$$0(277);
        }
        Point point = StartupUiUtil.getCenterPoint(container2, child2);
        if (point == null) {
            UIUtil.$$$reportNull$$$0(278);
        }
        return point;
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Rectangle container2, @NotNull Dimension child2) {
        if (container2 == null) {
            UIUtil.$$$reportNull$$$0(279);
        }
        if (child2 == null) {
            UIUtil.$$$reportNull$$$0(280);
        }
        Point point = StartupUiUtil.getCenterPoint(container2, child2);
        if (point == null) {
            UIUtil.$$$reportNull$$$0(281);
        }
        return point;
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable ImageObserver observer) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(282);
        }
        if (image == null) {
            UIUtil.$$$reportNull$$$0(283);
        }
        StartupUiUtil.drawImage(g, image, dstBounds, srcBounds, null, observer);
    }

    public static void drawImage(@NotNull Graphics g, @NotNull BufferedImage image, @Nullable BufferedImageOp op, int x, int y) {
        if (g == null) {
            UIUtil.$$$reportNull$$$0(284);
        }
        if (image == null) {
            UIUtil.$$$reportNull$$$0(285);
        }
        StartupUiUtil.drawImage(g, image, x, y, -1, -1, op, null);
    }

    public static void pump() {
        assert (!SwingUtilities.isEventDispatchThread());
        Semaphore lock = new Semaphore(1);
        SwingUtilities.invokeLater(() -> lock.up());
        lock.waitFor();
    }

    public static boolean isJreHiDPI() {
        return StartupUiUtil.isJreHiDPI();
    }

    public static Color makeTransparent(@NotNull Color color, @NotNull Color backgroundColor, double transparency) {
        if (color == null) {
            UIUtil.$$$reportNull$$$0(286);
        }
        if (backgroundColor == null) {
            UIUtil.$$$reportNull$$$0(287);
        }
        int r = UIUtil.makeTransparent(transparency, color.getRed(), backgroundColor.getRed());
        int g = UIUtil.makeTransparent(transparency, color.getGreen(), backgroundColor.getGreen());
        int b = UIUtil.makeTransparent(transparency, color.getBlue(), backgroundColor.getBlue());
        return new Color(r, g, b);
    }

    private static int makeTransparent(double transparency, int channel, int backgroundChannel) {
        int result2 = (int)((double)backgroundChannel * (1.0 - transparency) + (double)channel * transparency);
        if (result2 < 0) {
            return 0;
        }
        return Math.min(result2, 255);
    }

    static {
        LoadingState.LAF_INITIALIZED.checkOccurred();
        LAF_WITH_THEME_KEY = Key.create("Laf.with.ui.theme");
        PLUGGABLE_LAF_KEY = Key.create("Pluggable.laf.name");
        X_RENDER_ACTIVE = new AtomicNotNullLazyValue<Boolean>(){

            @Override
            @NotNull
            protected Boolean compute() {
                Boolean bl;
                if (!SystemInfo.isXWindow) {
                    Boolean bl2 = false;
                    if (bl2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return bl2;
                }
                try {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                    Method method2 = clazz.getMethod("isXRenderAvailable", new Class[0]);
                    bl = (Boolean)method2.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    Boolean bl3 = false;
                    if (bl3 == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return bl3;
                }
                if (bl == null) {
                    3.$$$reportNull$$$0(1);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$3", "compute"));
            }
        };
        STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
        KEEP_BORDER_SIDES = Key.create("keepBorderSides");
        UNDO_MANAGER = Key.create("undoManager");
        TEXT_COPY_ROOT = Key.create("TEXT_COPY_ROOT");
        REDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                UndoManager manager;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER)) != null && manager.canRedo()) {
                    manager.redo();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/UIUtil$4", "actionPerformed"));
            }
        };
        UNDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                UndoManager manager;
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER)) != null && manager.canUndo()) {
                    manager.undo();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/UIUtil$5", "actionPerformed"));
            }
        };
        ACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.active", 10533589);
        INACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.inactive", Gray._128);
        CONTRAST_BORDER_COLOR = JBColor.namedColor("Borders.ContrastBorderColor", new JBColor(0xC9C9C9, 0x323232));
        SIDE_PANEL_BACKGROUND = JBColor.namedColor("SidePanel.background", new JBColor(15133680, 4080460));
        AQUA_SEPARATOR_BACKGROUND_COLOR = new JBColor(Gray._240, Gray.x51);
        TRANSPARENT_COLOR = Gray.TRANSPARENT;
        PANEL_REGULAR_INSETS = UIUtil.getRegularPanelInsets();
        PANEL_SMALL_INSETS = JBInsets.create(5, 8);
        ourRetina = Ref.create(SystemInfo.isMac ? null : Boolean.valueOf(false));
        NOT_IN_HIERARCHY_COMPONENTS = Key.create("NOT_IN_HIERARCHY_COMPONENTS");
        UI_TRAVERSER = JBTreeTraverser.from(c -> {
            JBIterable<Object> result2 = c instanceof JMenu ? JBIterable.of(((JMenu)c).getMenuComponents()) : UIUtil.uiChildren(c);
            if (c instanceof JComponent) {
                JPopupMenu jpm;
                JComponent jc = (JComponent)c;
                Iterable<? extends Component> orphans = ComponentUtil.getClientProperty(jc, NOT_IN_HIERARCHY_COMPONENTS);
                if (orphans != null) {
                    result2 = result2.append(orphans);
                }
                if ((jpm = jc.getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                    result2 = result2.append(Collections.singletonList(jpm));
                }
            }
            return result2;
        });
        DECORATED_ROW_BG_COLOR = new JBColor(new Color(242, 245, 249), new Color(65, 69, 71));
        SET_TEXT_CHECKER = new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                Document document;
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                if ((document = e.getDocument()) instanceof AbstractDocument) {
                    StackTraceElement[] stackTrace;
                    for (StackTraceElement element2 : stackTrace = new Throwable().getStackTrace()) {
                        UndoableEditListener[] undoableEditListeners;
                        if (!element2.getClassName().equals(JTextComponent.class.getName()) || !element2.getMethodName().equals("setText")) continue;
                        for (UndoableEditListener listener2 : undoableEditListeners = ((AbstractDocument)document).getUndoableEditListeners()) {
                            if (!(listener2 instanceof UndoManager)) continue;
                            Runnable runnable2 = ((UndoManager)listener2)::discardAllEdits;
                            SwingUtilities.invokeLater(runnable2);
                            return;
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/UIUtil$8", "textChanged"));
            }
        };
        BACKGROUND = new JBColor(0xFFFFFF, 3948353);
        LIST_BACKGROUND = JBColor.namedColor("List.background", BACKGROUND);
        TREE_BACKGROUND = JBColor.namedColor("Tree.background", BACKGROUND);
        TABLE_BACKGROUND = JBColor.namedColor("Table.background", BACKGROUND);
        SELECTED_ITEM_ALPHA = new JBValue.UIInteger("List.selectedItemAlpha", 75);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 65: 
            case 67: 
            case 72: 
            case 73: 
            case 75: 
            case 78: 
            case 89: 
            case 90: 
            case 94: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 116: 
            case 118: 
            case 121: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 159: 
            case 160: 
            case 161: 
            case 169: 
            case 170: 
            case 171: 
            case 173: 
            case 175: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 196: 
            case 197: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 206: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 256: 
            case 267: 
            case 268: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 65: 
            case 67: 
            case 72: 
            case 73: 
            case 75: 
            case 78: 
            case 89: 
            case 90: 
            case 94: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 116: 
            case 118: 
            case 121: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 159: 
            case 160: 
            case 161: 
            case 169: 
            case 170: 
            case 171: 
            case 173: 
            case 175: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 196: 
            case 197: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 206: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 256: 
            case 267: 
            case 268: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/UIUtil";
                break;
            }
            case 1: 
            case 222: 
            case 223: 
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPane";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentStyle";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 6: 
            case 287: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundColor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 13: 
            case 29: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: 
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: 
            case 42: 
            case 43: 
            case 78: 
            case 97: 
            case 129: 
            case 131: 
            case 144: 
            case 154: 
            case 160: 
            case 182: 
            case 210: 
            case 211: 
            case 213: 
            case 215: 
            case 216: 
            case 221: 
            case 238: 
            case 239: 
            case 247: 
            case 272: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 23: 
            case 48: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 27: 
            case 170: 
            case 171: 
            case 173: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 30: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 187: 
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 31: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 33: 
            case 35: 
            case 37: 
            case 44: 
            case 45: 
            case 46: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 125: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 274: 
            case 282: 
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 40: 
            case 155: 
            case 156: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 52: 
            case 54: 
            case 214: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 55: 
            case 56: 
            case 58: 
            case 256: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontColor";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cb";
                break;
            }
            case 65: 
            case 67: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyPrefix";
                break;
            }
            case 73: 
            case 89: 
            case 150: 
            case 159: 
            case 201: 
            case 246: 
            case 248: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slider";
                break;
            }
            case 90: 
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseEvent";
                break;
            }
            case 99: 
            case 286: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 116: 
            case 118: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rm";
                break;
            }
            case 127: 
            case 130: 
            case 132: 
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 128: 
            case 153: 
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 139: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 140: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 177: 
            case 178: 
            case 180: 
            case 224: 
            case 226: 
            case 273: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 185: 
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 189: 
            case 270: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 197: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 203: 
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 208: 
            case 209: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panels";
                break;
            }
            case 212: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 217: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 220: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 229: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 230: 
            case 231: 
            case 241: 
            case 267: 
            case 268: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamProducer";
                break;
            }
            case 235: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 237: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 240: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 249: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 250: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originGraphics";
                break;
            }
            case 251: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawingConsumer";
                break;
            }
            case 271: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 275: 
            case 283: 
            case 285: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 276: 
            case 279: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 277: 
            case 280: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 65: 
            case 67: 
            case 72: 
            case 73: 
            case 75: 
            case 78: 
            case 89: 
            case 90: 
            case 94: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 116: 
            case 118: 
            case 121: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 159: 
            case 160: 
            case 161: 
            case 169: 
            case 170: 
            case 171: 
            case 173: 
            case 175: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 196: 
            case 197: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 206: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 256: 
            case 267: 
            case 268: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/UIUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextCursor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrayFilter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextGrayFilter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellColors";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlBody";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "splitText";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelFontColor";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelForeground";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelDisabledForeground";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextHelpForeground";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMnemonic";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveTextColor";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipBackground";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipActionBackground";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipForeground";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanelBackground";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorForeground";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorColor";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorIcon";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationIcon";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionIcon";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningIcon";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonInformationIcon";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonWarningIcon";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonErrorIcon";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeCollapsedIcon";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeExpandedIcon";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarFont";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegularPanelInsets";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getListCellPadding";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getListViewportPadding";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidFontNames";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardFontSizes";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "displayPropertiesToCSS";
                break;
            }
            case 114: 
            case 115: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageForGraphics";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventQueueThread";
                break;
            }
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "getBgFillColor";
                break;
            }
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssFontDeclaration";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundsColor";
                break;
            }
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderActiveColor";
                break;
            }
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedBorderColor";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderInactiveColor";
                break;
            }
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitledBorderFont";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderInactiveColor";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderActiveColor";
                break;
            }
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderSeparatorColor";
                break;
            }
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtml";
                break;
            }
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "addPadding";
                break;
            }
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSpace2Nbsp";
                break;
            }
            case 192: {
                objectArray = objectArray2;
                objectArray2[1] = "uiParents";
                break;
            }
            case 193: 
            case 194: {
                objectArray = objectArray2;
                objectArray2[1] = "uiChildren";
                break;
            }
            case 195: {
                objectArray = objectArray2;
                objectArray2[1] = "uiTraverser";
                break;
            }
            case 198: {
                objectArray = objectArray2;
                objectArray2[1] = "findComponentsOfType";
                break;
            }
            case 205: 
            case 207: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedTimer";
                break;
            }
            case 218: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecoratedRowColor";
                break;
            }
            case 227: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugText";
                break;
            }
            case 234: {
                objectArray = objectArray2;
                objectArray2[1] = "rightArrow";
                break;
            }
            case 236: {
                objectArray = objectArray2;
                objectArray2[1] = "upArrow";
                break;
            }
            case 242: 
            case 243: 
            case 244: 
            case 245: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentStyle";
                break;
            }
            case 252: {
                objectArray = objectArray2;
                objectArray2[1] = "getListFont";
                break;
            }
            case 253: {
                objectArray = objectArray2;
                objectArray2[1] = "getListBackground";
                break;
            }
            case 254: 
            case 255: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionBackground";
                break;
            }
            case 257: {
                objectArray = objectArray2;
                objectArray2[1] = "updateListRowHeight";
                break;
            }
            case 258: {
                objectArray = objectArray2;
                objectArray2[1] = "getListForeground";
                break;
            }
            case 259: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeFont";
                break;
            }
            case 260: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeBackground";
                break;
            }
            case 261: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectionBackground";
                break;
            }
            case 262: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeForeground";
                break;
            }
            case 263: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableBackground";
                break;
            }
            case 264: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectionBackground";
                break;
            }
            case 265: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableForeground";
                break;
            }
            case 266: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectionForeground";
                break;
            }
            case 269: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipSeparatorColor";
                break;
            }
            case 278: 
            case 281: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterPoint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCustomTitleBar";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleOwner";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyStyle";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTextCursor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCellColors";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fixOSXEditorBackground";
                break;
            }
            case 13: 
            case 249: {
                objectArray = objectArray;
                objectArray[2] = "isRetina";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isWindowClientPropertyTrue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getWindowClientProperty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putWindowClientProperty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isClientPropertyTrue";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 23: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlBody";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "drawLinePickedOut";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isReallyTypedEvent";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getStringY";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "drawLabelDottedRectangle";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getLabelTextBounds";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getHighestGlyphHeight";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "drawLine";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "drawWave";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "splitText";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setActionNameAndMnemonic";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "assignMnemonic";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFont";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getFontSize";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getLabelFontColor";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getCheckBoxTextHorizontalOffset";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "removeMnemonic";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayMnemonicIndex";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyMaxGutterIconWidth";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getTabbedPanePaintContentBorder";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "setSliderIsFilled";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "setLineStyleAngled";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "shade";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "mix";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "isControlKeyDown";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "setupEnclosingDialogBounds";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "appendColor";
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "drawDottedRectangle";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "drawBoldDottedLine";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "drawSearchMatch";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "drawBoringDottedLine";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "drawGradientHToolbarBackground";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "drawHeader";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "drawDoubleSpaceDottedLine";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "drawAppleDottedLine";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "applyRenderingHints";
                break;
            }
            case 116: 
            case 118: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "createImage";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "setupComposite";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "addAwtListener";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "addParentChangeListener";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "removeParentChangeListener";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "drawVDottedLine";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "drawHDottedLine";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "drawDottedLine";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "drawStringWithHighlighting";
                break;
            }
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "drawCenteredString";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "isFocusAncestor";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "isCloseClick";
                break;
            }
            case 147: 
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "isActionClick";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "getBgFillColor";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "findParentByCondition";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestComponentAt";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "layoutRecursively";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getCssFontDeclaration";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "canDisplayFocusedState";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "disposeProgress";
                break;
            }
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithFallback";
                break;
            }
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "addPadding";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "convertSpace2Nbsp";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 178: 
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "maybeInstall";
                break;
            }
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "changeBackGround";
                break;
            }
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "getComboBoxPopup";
                break;
            }
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "fixFormattedField";
                break;
            }
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedButton";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedButton";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionButtonDown";
                break;
            }
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "isToggleListSelectionEvent";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "setComboBoxEditorBounds";
                break;
            }
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "isDescendingFrom";
                break;
            }
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "scrollListToVisibleIfNeeded";
                break;
            }
            case 197: 
            case 199: 
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "findComponentsOfType";
                break;
            }
            case 201: 
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "setFutureRootPane";
                break;
            }
            case 203: 
            case 204: 
            case 206: {
                objectArray = objectArray;
                objectArray[2] = "createNamedTimer";
                break;
            }
            case 208: 
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "mergeComponentsWithAnchor";
                break;
            }
            case 210: {
                objectArray = objectArray;
                objectArray[2] = "setNotOpaqueRecursively";
                break;
            }
            case 211: 
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "setBackgroundRecursively";
                break;
            }
            case 213: 
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "forEachComponentInHierarchy";
                break;
            }
            case 215: 
            case 216: 
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "addInsets";
                break;
            }
            case 219: 
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "getGradientPaint";
                break;
            }
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "getLocationOnScreen";
                break;
            }
            case 222: {
                objectArray = objectArray;
                objectArray[2] = "setAutoRequestFocus";
                break;
            }
            case 223: 
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "runWhenWindowOpened";
                break;
            }
            case 225: 
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "runWhenWindowClosed";
                break;
            }
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "getAllTextsRecursivelyImpl";
                break;
            }
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 230: {
                objectArray = objectArray;
                objectArray[2] = "resetUndoRedoActions";
                break;
            }
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "addUndoRedoActions";
                break;
            }
            case 232: {
                objectArray = objectArray;
                objectArray[2] = "playSoundFromResource";
                break;
            }
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "playSoundFromStream";
                break;
            }
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "upArrow";
                break;
            }
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "configureNumericFormattedTextField";
                break;
            }
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "hasScrollPane";
                break;
            }
            case 239: 
            case 240: {
                objectArray = objectArray;
                objectArray[2] = "hasComponentOfType";
                break;
            }
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "getLineHeight";
                break;
            }
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "repaintViewport";
                break;
            }
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "setCursor";
                break;
            }
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "findWindowAncestor";
                break;
            }
            case 250: 
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "useSafely";
                break;
            }
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "updateListRowHeight";
                break;
            }
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "doNotScrollToCaret";
                break;
            }
            case 268: {
                objectArray = objectArray;
                objectArray[2] = "enableEagerSoftWrapping";
                break;
            }
            case 270: 
            case 271: {
                objectArray = objectArray;
                objectArray[2] = "scrollToReference";
                break;
            }
            case 272: 
            case 273: {
                objectArray = objectArray;
                objectArray[2] = "runWhenFocused";
                break;
            }
            case 274: 
            case 275: 
            case 282: 
            case 283: 
            case 284: 
            case 285: {
                objectArray = objectArray;
                objectArray[2] = "drawImage";
                break;
            }
            case 276: 
            case 277: 
            case 279: 
            case 280: {
                objectArray = objectArray;
                objectArray[2] = "getCenterPoint";
                break;
            }
            case 286: 
            case 287: {
                objectArray = objectArray;
                objectArray[2] = "makeTransparent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 65: 
            case 67: 
            case 72: 
            case 73: 
            case 75: 
            case 78: 
            case 89: 
            case 90: 
            case 94: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 116: 
            case 118: 
            case 121: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 159: 
            case 160: 
            case 161: 
            case 169: 
            case 170: 
            case 171: 
            case 173: 
            case 175: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 196: 
            case 197: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 206: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 256: 
            case 267: 
            case 268: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UnfocusedSelection {
        private static final Color BACKGROUND = new JBColor(0xD4D4D4, 862526);
        private static final Color LIST_BACKGROUND = JBColor.namedColor("List.selectionInactiveBackground", BACKGROUND);
        private static final Color TREE_BACKGROUND = JBColor.namedColor("Tree.selectionInactiveBackground", BACKGROUND);
        private static final Color TABLE_BACKGROUND = JBColor.namedColor("Table.selectionInactiveBackground", BACKGROUND);

        private UnfocusedSelection() {
        }
    }

    private static final class FocusedSelection {
        private static final Color BACKGROUND = new JBColor(3700182, 3106250);
        private static final Color LIST_BACKGROUND = JBColor.namedColor("List.selectionBackground", BACKGROUND);
        private static final Color TREE_BACKGROUND = JBColor.namedColor("Tree.selectionBackground", BACKGROUND);
        private static final Color TABLE_BACKGROUND = JBColor.namedColor("Table.selectionBackground", BACKGROUND);

        private FocusedSelection() {
        }
    }

    public static class TextPainter {
        private final List<String> myLines = new ArrayList<String>();
        private boolean myDrawShadow = StartupUiUtil.isUnderDarcula();
        private Color myShadowColor = StartupUiUtil.isUnderDarcula() ? Gray._0.withAlpha(100) : Gray._220;
        private float myLineSpacing = 1.0f;
        private Font myFont;
        private Color myColor;

        @NotNull
        public TextPainter withShadow(boolean drawShadow, Color shadowColor) {
            this.myDrawShadow = drawShadow;
            this.myShadowColor = shadowColor;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(0);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter withLineSpacing(float lineSpacing) {
            this.myLineSpacing = lineSpacing;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(1);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter withColor(Color color) {
            this.myColor = color;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(2);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter withFont(Font font) {
            this.myFont = font;
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(3);
            }
            return textPainter;
        }

        @NotNull
        public TextPainter appendLine(String text2) {
            if (text2 == null || text2.isEmpty()) {
                TextPainter textPainter = this;
                if (textPainter == null) {
                    TextPainter.$$$reportNull$$$0(4);
                }
                return textPainter;
            }
            this.myLines.add(text2);
            TextPainter textPainter = this;
            if (textPainter == null) {
                TextPainter.$$$reportNull$$$0(5);
            }
            return textPainter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(@NotNull Graphics g, @NotNull PairFunction<? super Integer, ? super Integer, ? extends Couple<Integer>> _position) {
            if (g == null) {
                TextPainter.$$$reportNull$$$0(6);
            }
            if (_position == null) {
                TextPainter.$$$reportNull$$$0(7);
            }
            Font oldFont = null;
            if (this.myFont != null) {
                oldFont = g.getFont();
                g.setFont(this.myFont);
            }
            Color oldColor = null;
            if (this.myColor != null) {
                oldColor = g.getColor();
                g.setColor(this.myColor);
            }
            try {
                int[] maxWidth = new int[]{0};
                int[] height = new int[]{0};
                ContainerUtil.process(this.myLines, text2 -> {
                    FontMetrics fm = g.getFontMetrics();
                    maxWidth[0] = Math.max(fm.stringWidth(text2.replace("<shortcut>", "").replace("</shortcut>", "")), maxWidth[0]);
                    height[0] = (int)((float)height[0] + (float)(fm.getHeight() + fm.getLeading()) * this.myLineSpacing);
                    return true;
                });
                Couple<Integer> position = _position.fun((Integer)(maxWidth[0] + 20), (Integer)height[0]);
                assert (position != null);
                int[] yOffset = new int[]{(Integer)position.getSecond()};
                ContainerUtil.process(this.myLines, text2 -> {
                    String shortcut = "";
                    if (text2.contains("<shortcut>")) {
                        shortcut = text2.substring(text2.indexOf("<shortcut>") + "<shortcut>".length(), text2.indexOf("</shortcut>"));
                        text2 = text2.substring(0, text2.indexOf("<shortcut>"));
                    }
                    int x = (Integer)position.getFirst() + 10;
                    FontMetrics fm = g.getFontMetrics();
                    if (this.myDrawShadow) {
                        int xOff = StartupUiUtil.isUnderDarcula() ? 1 : 0;
                        Color oldColor1 = g.getColor();
                        g.setColor(this.myShadowColor);
                        int yOff = 1;
                        g.drawString((String)text2, x + xOff, yOffset[0] + yOff);
                        g.setColor(oldColor1);
                    }
                    g.drawString((String)text2, x, yOffset[0]);
                    if (!StringUtil.isEmpty(shortcut)) {
                        Color oldColor1 = g.getColor();
                        g.setColor(JBColor.namedColor("Editor.shortcutForeground", new JBColor(new Color(82, 99, 155), new Color(88, 157, 246))));
                        g.drawString(shortcut, x + fm.stringWidth(text2 + (StartupUiUtil.isUnderDarcula() ? " " : "")), yOffset[0]);
                        g.setColor(oldColor1);
                    }
                    yOffset[0] = (int)((float)yOffset[0] + (float)(fm.getHeight() + fm.getLeading()) * this.myLineSpacing);
                    return true;
                });
            }
            finally {
                if (oldFont != null) {
                    g.setFont(oldFont);
                }
                if (oldColor != null) {
                    g.setColor(oldColor);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/UIUtil$TextPainter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_position";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withShadow";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withLineSpacing";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withColor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withFont";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendLine";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/UIUtil$TextPainter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "draw";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class JBWordWrapHtmlEditorKit
    extends JBHtmlEditorKit {
        private final HTMLEditorKit.HTMLFactory myFactory = new HTMLEditorKit.HTMLFactory(){

            @Override
            public View create(Element e) {
                View view = super.create(e);
                if (view instanceof ParagraphView) {
                    return new ParagraphView(e){

                        @Override
                        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
                            if (r == null) {
                                r = new SizeRequirements();
                            }
                            r.minimum = (int)this.layoutPool.getMinimumSpan(axis);
                            r.preferred = Math.max(r.minimum, (int)this.layoutPool.getPreferredSpan(axis));
                            r.maximum = Integer.MAX_VALUE;
                            r.alignment = 0.5f;
                            return r;
                        }
                    };
                }
                return view;
            }
        };

        @Override
        public ViewFactory getViewFactory() {
            return this.myFactory;
        }
    }

    public static enum FontColor {
        NORMAL,
        BRIGHTER;

    }

    public static enum ComponentStyle {
        LARGE,
        REGULAR,
        SMALL,
        MINI;

    }

    public static enum FontSize {
        NORMAL,
        SMALL,
        MINI;

    }

    @ApiStatus.Experimental
    public static class GrayFilter
    extends RGBImageFilter {
        private float brightness;
        private float contrast;
        private int alpha;
        private int origContrast;
        private int origBrightness;

        public GrayFilter(int brightness, int contrast, int alpha) {
            this.setBrightness(brightness);
            this.setContrast(contrast);
            this.setAlpha(alpha);
        }

        public GrayFilter() {
            this(0, 0, 100);
        }

        private void setBrightness(int brightness) {
            this.origBrightness = Math.max(-100, Math.min(100, brightness));
            this.brightness = (float)(Math.pow(this.origBrightness, 3.0) / 10000.0);
        }

        public int getBrightness() {
            return this.origBrightness;
        }

        private void setContrast(int contrast) {
            this.origContrast = Math.max(-100, Math.min(100, contrast));
            this.contrast = (float)this.origContrast / 100.0f;
        }

        public int getContrast() {
            return this.origContrast;
        }

        private void setAlpha(int alpha) {
            this.alpha = Math.max(0, Math.min(100, alpha));
        }

        public int getAlpha() {
            return this.alpha;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int gray = (int)(0.3 * (double)(rgb >> 16 & 0xFF) + 0.59 * (double)(rgb >> 8 & 0xFF) + 0.11 * (double)(rgb & 0xFF));
            gray = this.brightness >= 0.0f ? (int)(((float)gray + this.brightness * 255.0f) / (1.0f + this.brightness)) : (int)((float)gray / (1.0f - this.brightness));
            gray = this.contrast >= 0.0f ? (gray >= 127 ? (int)((float)gray + (float)(255 - gray) * this.contrast) : (int)((float)gray - (float)gray * this.contrast)) : (int)(127.0f + (float)(gray - 127) * (this.contrast + 1.0f));
            int a = (rgb >> 24 & 0xFF) * this.alpha / 100;
            return a << 24 | gray << 16 | gray << 8 | gray;
        }

        @NotNull
        public GrayFilterUIResource asUIResource() {
            return new GrayFilterUIResource(this);
        }

        @NotNull
        public static GrayFilter namedFilter(@NotNull String resourceName, @NotNull GrayFilter defaultFilter) {
            if (resourceName == null) {
                GrayFilter.$$$reportNull$$$0(0);
            }
            if (defaultFilter == null) {
                GrayFilter.$$$reportNull$$$0(1);
            }
            GrayFilter grayFilter = ObjectUtils.notNull((GrayFilter)UIManager.get(resourceName), defaultFilter);
            if (grayFilter == null) {
                GrayFilter.$$$reportNull$$$0(2);
            }
            return grayFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/UIUtil$GrayFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/UIUtil$GrayFilter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "namedFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "namedFilter";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static class GrayFilterUIResource
        extends GrayFilter
        implements UIResource {
            public GrayFilterUIResource(@NotNull GrayFilter filter2) {
                if (filter2 == null) {
                    GrayFilterUIResource.$$$reportNull$$$0(0);
                }
                super(filter2.origBrightness, filter2.origContrast, filter2.alpha);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/ui/UIUtil$GrayFilter$GrayFilterUIResource", "<init>"));
            }
        }
    }
}

