/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ChangesTrackingTableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ValidatingTableEditor<Item>
implements ComponentWithEmptyText {
    private static final Icon WARNING_ICON = UIUtil.getBalloonWarningIcon();
    private static final Icon EMPTY_ICON = EmptyIcon.create(WARNING_ICON);
    @NonNls
    private static final String REMOVE_KEY = "REMOVE_SELECTED";
    private JPanel myContentPane;
    private TableView<Item> myTable;
    private final AnActionButton myRemoveButton;
    private JLabel myMessageLabel;
    private HoverHyperlinkLabel myFixLink;
    private JPanel myTablePanel;
    private final List<String> myWarnings;
    private Fix myFixRunnable;

    protected abstract Item cloneOf(Item var1);

    @Nullable
    protected Pair<String, Fix> validate(List<? extends Item> current2, List<? super String> warnings) {
        String error = null;
        for (int i = 0; i < current2.size(); ++i) {
            Item item = current2.get(i);
            String s = this.validate(item);
            warnings.set(i, s);
            if (error != null) continue;
            error = s;
        }
        return error != null ? Pair.create(error, null) : null;
    }

    @Nullable
    protected String validate(Item item) {
        return null;
    }

    @Nullable
    protected abstract Item createItem();

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myTable.getEmptyText();
        if (statusText == null) {
            ValidatingTableEditor.$$$reportNull$$$0(0);
        }
        return statusText;
    }

    private void createUIComponents() {
        this.myTable = new ChangesTrackingTableView<Item>(){

            @Override
            protected void onCellValueChanged(int row, int column, Object value2) {
                Object original = this.getItems().get(row);
                Object override = ValidatingTableEditor.this.cloneOf(original);
                ColumnInfo columnInfo = ValidatingTableEditor.this.getTableModel().getColumnInfos()[column];
                columnInfo.setValue(override, value2);
                ValidatingTableEditor.this.updateMessage(row, override);
            }

            @Override
            protected void onEditingStopped() {
                ValidatingTableEditor.this.updateMessage(-1, null);
            }
        };
        this.myFixLink = new HoverHyperlinkLabel(null);
    }

    protected ValidatingTableEditor(AnActionButton ... extraButtons) {
        this.$$$setupUI$$$();
        this.myWarnings = new ArrayList<String>();
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myTable).disableRemoveAction().disableUpAction().disableDownAction();
        decorator.setAddAction(new AnActionButtonRunnable(){

            @Override
            public void run(AnActionButton anActionButton) {
                ValidatingTableEditor.this.addItem();
            }
        });
        this.myRemoveButton = new AnActionButton(ApplicationBundle.message("button.remove", new Object[0]), IconUtil.getRemoveIcon()){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ValidatingTableEditor.this.removeSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/ValidatingTableEditor$3", "actionPerformed"));
            }
        };
        this.myRemoveButton.setShortcut(CustomShortcutSet.fromString("alt DELETE"));
        decorator.addExtraAction(this.myRemoveButton);
        if (extraButtons != null && extraButtons.length != 0) {
            for (AnActionButton extraButton : extraButtons) {
                decorator.addExtraAction(extraButton);
            }
        }
        this.myTablePanel.add((Component)decorator.createPanel(), "Center");
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ValidatingTableEditor.this.updateButtons();
            }
        });
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), REMOVE_KEY);
        this.myTable.getActionMap().put(REMOVE_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidatingTableEditor.this.removeSelected();
            }
        });
        this.myFixLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && ValidatingTableEditor.this.myFixRunnable != null) {
                    ValidatingTableEditor.this.myFixRunnable.run();
                }
            }
        });
    }

    protected ValidatingTableEditor() {
        this(null);
    }

    @Nullable
    public List<Item> getSelectedItems() {
        return this.myTable.getSelectedObjects();
    }

    private void removeSelected() {
        this.myTable.stopEditing();
        ArrayList<Item> items = new ArrayList<Item>(this.doGetItems());
        int[] rows = this.myTable.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            items.remove(rows[i]);
        }
        this.setItems(items);
        this.updateMessage(-1, null);
        if (!items.isEmpty()) {
            int index = Math.min(rows[0], items.size() - 1);
            this.myTable.getSelectionModel().addSelectionInterval(index, index);
        }
    }

    protected void addItem() {
        Item newItem = this.createItem();
        if (newItem == null) {
            return;
        }
        ArrayList<Item> items = new ArrayList<Item>(this.doGetItems());
        items.add(newItem);
        this.setItems(items);
        int row = items.size() - 1;
        this.myTable.getSelectionModel().setSelectionInterval(row, row);
        this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
        if (this.getTableModel().getColumnInfos()[1].isCellEditable(items.get(row))) {
            this.myTable.editCellAt(row, 1);
            IdeFocusManager.findInstanceByComponent(this.myContentPane).requestFocus(this.myTable.getEditorComponent(), true);
        }
        this.updateMessage(-1, null);
    }

    private ListTableModel<Item> getTableModel() {
        return (ListTableModel)this.myTable.getModel();
    }

    public void setModel(ColumnInfo<Item, Object>[] valueColumns, List<? extends Item> items) {
        ColumnInfo[] columns = new ColumnInfo[valueColumns.length + 1];
        IconColumn iconColumn = new IconColumn();
        int maxHeight = iconColumn.getRowHeight();
        columns[0] = iconColumn;
        for (int i = 0; i < valueColumns.length; ++i) {
            columns[i + 1] = new ColumnInfoWrapper(valueColumns[i]);
            if (!(valueColumns[i] instanceof RowHeightProvider)) continue;
            maxHeight = Math.max(maxHeight, ((RowHeightProvider)((Object)valueColumns[i])).getRowHeight());
        }
        this.myTable.stopEditing();
        this.myTable.setModelAndUpdateColumns(new ListTableModel(columns));
        if (maxHeight > 0) {
            this.myTable.setRowHeight(maxHeight);
        }
        this.setItems(items);
        this.updateMessage(-1, null);
    }

    public List<Item> getItems() {
        return Collections.unmodifiableList(this.doGetItems());
    }

    private List<Item> doGetItems() {
        ArrayList<Item> items = new ArrayList<Item>(this.getTableModel().getItems());
        if (this.myTable.isEditing()) {
            Object value2 = ChangesTrackingTableView.getValue(this.myTable.getEditorComponent());
            ColumnInfo column = ((ListTableModel)this.myTable.getModel()).getColumnInfos()[this.myTable.getEditingColumn()];
            ((ColumnInfoWrapper)column).myDelegate.setValue(items.get(this.myTable.getEditingRow()), value2);
        }
        return items;
    }

    private void setItems(List<? extends Item> items) {
        if (items.isEmpty()) {
            this.getTableModel().setItems(Collections.emptyList());
            this.myWarnings.clear();
        } else {
            this.myWarnings.clear();
            for (Item item : items) {
                this.myWarnings.add(null);
            }
            this.getTableModel().setItems(new ArrayList<Item>(items));
        }
        this.updateButtons();
    }

    public void setTableHeader(JTableHeader header) {
        this.myTable.setTableHeader(header);
    }

    private void updateButtons() {
        this.myRemoveButton.setEnabled(this.myTable.getSelectedRow() != -1);
    }

    public void updateMessage(int index, @Nullable Item override) {
        ArrayList<Item> current2 = new ArrayList<Item>(this.doGetItems());
        if (override != null) {
            current2.set(index, override);
        }
        this.displayMessageAndFix(this.validate(current2, this.myWarnings));
        this.myTable.repaint();
    }

    protected void displayMessageAndFix(@Nullable Pair<String, Fix> messageAndFix) {
        if (messageAndFix != null) {
            this.myMessageLabel.setText((String)messageAndFix.first);
            this.myMessageLabel.setIcon(WARNING_ICON);
            this.myMessageLabel.setVisible(true);
            this.myFixRunnable = (Fix)messageAndFix.second;
            this.myFixLink.setVisible(this.myFixRunnable != null);
            this.myFixLink.setText(this.myFixRunnable != null ? this.myFixRunnable.getTitle() : null);
        } else {
            this.myMessageLabel.setText(" ");
            this.myMessageLabel.setIcon(EMPTY_ICON);
            this.myFixLink.setVisible(false);
            this.myFixRunnable = null;
        }
    }

    public void hideMessageLabel() {
        this.myMessageLabel.setVisible(false);
        this.myFixLink.setVisible(false);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    public Component getContentPane() {
        return this.myContentPane;
    }

    public void setColumnReorderingAllowed(boolean value2) {
        JTableHeader header = this.myTable.getTableHeader();
        if (header != null) {
            header.setReorderingAllowed(value2);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myFixLink;
        ((JLabel)hoverHyperlinkLabel).setText("Fix");
        jPanel3.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ValidatingTableEditor", "getEmptyText"));
    }

    private static class WarningIconCellRenderer
    extends DefaultTableCellRenderer {
        private final NullableComputable<String> myWarningProvider;

        WarningIconCellRenderer(NullableComputable<String> warningProvider) {
            this.myWarningProvider = warningProvider;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label2 = (JLabel)super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            String message = this.myWarningProvider.compute();
            label2.setIcon(message != null ? WARNING_ICON : null);
            label2.setToolTipText(message);
            label2.setHorizontalAlignment(0);
            label2.setVerticalAlignment(0);
            return label2;
        }
    }

    private class IconColumn
    extends ColumnInfo<Item, Object>
    implements RowHeightProvider {
        IconColumn() {
            super(" ");
        }

        @Override
        public String valueOf(Item item) {
            return null;
        }

        @Override
        public int getWidth(JTable table) {
            return WARNING_ICON.getIconWidth() + 2;
        }

        @Override
        public int getRowHeight() {
            return WARNING_ICON.getIconHeight();
        }

        @Override
        public TableCellRenderer getRenderer(Item item) {
            return new WarningIconCellRenderer(() -> (String)ValidatingTableEditor.this.myWarnings.get(ValidatingTableEditor.this.doGetItems().indexOf(item)));
        }
    }

    private class ColumnInfoWrapper
    extends ColumnInfo<Item, Object> {
        private final ColumnInfo<Item, Object> myDelegate;

        ColumnInfoWrapper(ColumnInfo<Item, Object> delegate) {
            super(delegate.getName());
            this.myDelegate = delegate;
        }

        @Override
        public Object valueOf(Item item) {
            return this.myDelegate.valueOf(item);
        }

        @Override
        public boolean isCellEditable(Item item) {
            return this.myDelegate.isCellEditable(item);
        }

        @Override
        public void setValue(Item item, Object value2) {
            this.myDelegate.setValue(item, value2);
            ValidatingTableEditor.this.updateMessage(-1, null);
        }

        @Override
        public TableCellEditor getEditor(Item item) {
            return this.myDelegate.getEditor(item);
        }

        @Override
        public int getWidth(JTable table) {
            return this.myDelegate.getWidth(table);
        }

        @Override
        public Class getColumnClass() {
            return this.myDelegate.getColumnClass();
        }

        @Override
        public TableCellRenderer getRenderer(Item item) {
            return this.myDelegate.getRenderer(item);
        }
    }

    public static interface Fix
    extends Runnable {
        public String getTitle();
    }

    public static interface RowHeightProvider {
        public int getRowHeight();
    }
}

