/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class VcsBackgroundTask<T>
extends Task.ConditionalModal {
    private final Collection<? extends T> myItems;
    private final List<VcsException> myExceptions;

    public VcsBackgroundTask(Project project2, @NotNull String title, @NotNull PerformInBackgroundOption backgroundOption, Collection<? extends T> itemsToProcess, boolean canBeCanceled) {
        if (title == null) {
            VcsBackgroundTask.$$$reportNull$$$0(0);
        }
        if (backgroundOption == null) {
            VcsBackgroundTask.$$$reportNull$$$0(1);
        }
        super(project2, title, canBeCanceled, backgroundOption);
        this.myExceptions = new ArrayList<VcsException>();
        this.myItems = itemsToProcess;
    }

    public VcsBackgroundTask(Project project2, @NotNull String title, @NotNull PerformInBackgroundOption backgroundOption, Collection<? extends T> itemsToProcess) {
        if (title == null) {
            VcsBackgroundTask.$$$reportNull$$$0(2);
        }
        if (backgroundOption == null) {
            VcsBackgroundTask.$$$reportNull$$$0(3);
        }
        this(project2, title, backgroundOption, itemsToProcess, false);
    }

    @Override
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            VcsBackgroundTask.$$$reportNull$$$0(4);
        }
        for (T item : this.myItems) {
            try {
                this.process(item);
            }
            catch (VcsException ex) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new RuntimeException(ex);
                }
                this.myExceptions.add(ex);
            }
        }
    }

    protected boolean executedOk() {
        return this.myExceptions.isEmpty();
    }

    @Override
    public void onSuccess() {
        if (!this.myExceptions.isEmpty()) {
            AbstractVcsHelper.getInstance(this.myProject).showErrors(this.myExceptions, this.myTitle);
        }
    }

    protected abstract void process(T var1) throws VcsException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundOption";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/VcsBackgroundTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

