/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.accessibility;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class ScreenReader {
    public static final String ATK_WRAPPER = "org.GNOME.Accessibility.AtkWrapper";
    public static final String ACCESS_BRIDGE = "com.sun.java.accessibility.AccessBridge";
    private static final PropertyChangeSupport PCS = new PropertyChangeSupport(new ScreenReader());
    public static final String SCREEN_READER_ACTIVE_PROPERTY = "ScreenReader.active";
    private static boolean myActive = false;

    public static boolean isActive() {
        return myActive;
    }

    public static void setActive(boolean active) {
        boolean oldValue = myActive;
        myActive = active;
        PCS.firePropertyChange(SCREEN_READER_ACTIVE_PROPERTY, oldValue, active);
    }

    public static boolean isEnabled(String a11yClassName) {
        String[] paths = new String[]{System.getProperty("user.home") + File.separator + ".accessibility.properties", System.getProperty("java.home") + File.separator + "lib" + File.separator + "accessibility.properties"};
        Properties properties = new Properties();
        for (String path2 : paths) {
            try (InputStream in = Files.newInputStream(Paths.get(path2, new String[0]), new OpenOption[0]);){
                properties.load(in);
            }
            catch (Exception ignore) {
                continue;
            }
            if (!properties.isEmpty()) break;
        }
        if (!properties.isEmpty()) {
            String classNames = System.getProperty("javax.accessibility.assistive_technologies");
            if (classNames == null) {
                classNames = properties.getProperty("assistive_technologies", null);
            }
            if (classNames != null && classNames.contains(a11yClassName)) {
                return true;
            }
        }
        return false;
    }

    public static void addPropertyChangeListener(final @NotNull String propertyName, @NotNull Disposable parent, final @NotNull PropertyChangeListener listener2) {
        if (propertyName == null) {
            ScreenReader.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            ScreenReader.$$$reportNull$$$0(1);
        }
        if (listener2 == null) {
            ScreenReader.$$$reportNull$$$0(2);
        }
        PCS.addPropertyChangeListener(propertyName, listener2);
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                PCS.removePropertyChangeListener(propertyName, listener2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "propertyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/ui/accessibility/ScreenReader";
        objectArray[2] = "addPropertyChangeListener";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

