/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.openapi.util.Iconable;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ListWithSelection;
import java.awt.Component;
import java.util.Collections;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;

public class ComboBoxTableCellEditor
extends DefaultCellEditor {
    public static final ComboBoxTableCellEditor INSTANCE = new ComboBoxTableCellEditor();
    private final JComboBox comboBox = (JComboBox)this.getComponent();

    public ComboBoxTableCellEditor() {
        super(new JComboBox(new CollectionComboBoxModel(Collections.emptyList())));
        this.comboBox.addPopupMenuListener(new PopupMenuListenerAdapter(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ComboBoxTableCellEditor.this.cancelCellEditing();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                ComboBoxTableCellEditor.this.cancelCellEditing();
            }
        });
        this.comboBox.setRenderer(SimpleListCellRenderer.create((label2, value2, index) -> {
            label2.setIcon(value2 instanceof Iconable ? ((Iconable)value2).getIcon(1) : null);
            label2.setText(value2 == null ? "" : value2.toString());
        }));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
        if (value2 instanceof ListWithSelection) {
            ListWithSelection options = (ListWithSelection)value2;
            this.comboBox.setModel(new CollectionComboBoxModel(options));
            if (options.getSelection() == null) {
                options.selectFirst();
            }
            this.comboBox.setSelectedItem(options.getSelection());
        } else {
            Enum enumValue = (Enum)value2;
            Class enumClass = enumValue.getDeclaringClass();
            ComboBoxModel model = this.comboBox.getModel();
            if (!(model instanceof EnumComboBoxModel) || model.getSize() <= 0 || ((Enum)model.getElementAt(0)).getDeclaringClass() != enumClass) {
                this.comboBox.setModel(new EnumComboBoxModel(enumClass));
            }
            this.comboBox.setSelectedItem(value2);
        }
        return this.comboBox;
    }
}

