/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.actions;

import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.actions.generate.DomTemplateRunner;
import com.intellij.util.xml.ui.actions.generate.CreateDomElementAction;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;

public abstract class CreateClassMappingAction<T extends DomElement>
extends CreateDomElementAction<T> {
    @Nullable
    private final String myBaseClass;
    private final String myTemplate;

    public CreateClassMappingAction(Class<T> contextClass, @Nullable String baseClass, String template) {
        super(contextClass);
        this.myBaseClass = baseClass;
        this.myTemplate = template;
    }

    protected DomElement createElement(T context, Editor editor, PsiFile file2, Project project2) {
        PsiClass selectedClass;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            PsiClass baseClass = this.getBaseClass(context, project2, this.myBaseClass);
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance(project2).createInheritanceClassChooser(this.getChooserTitle(), GlobalSearchScope.allScope(project2), baseClass, null, new ClassFilter(){

                @Override
                public boolean isAccepted(PsiClass aClass) {
                    return !aClass.isInterface() && !aClass.hasModifierProperty("abstract");
                }
            });
            chooser.showDialog();
            selectedClass = chooser.getSelected();
        } else {
            selectedClass = this.getBaseClass(context, project2, this.myBaseClass == null ? "java.lang.Object" : this.myBaseClass);
        }
        if (selectedClass == null) {
            return null;
        }
        return this.createElement(context, editor, file2, project2, selectedClass);
    }

    @Nullable
    protected DomElement createElement(T context, Editor editor, PsiFile file2, Project project2, PsiClass selectedClass) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("CLASS_NAME", selectedClass.getQualifiedName());
        WriteCommandAction.writeCommandAction(project2, file2).run(() -> DomTemplateRunner.getInstance((Project)project2).runTemplate(this.createElement(context), this.myTemplate, editor, map2));
        return null;
    }

    protected String getChooserTitle() {
        String text2 = this.getTemplatePresentation().getText();
        if (text2.endsWith("...")) {
            text2 = StringUtil.trimEnd(text2, "...");
        }
        return "Choose " + text2 + " Class";
    }

    protected abstract DomElement createElement(T var1);

    @Nullable
    protected PsiClass getBaseClass(T context, Project project2, String baseClass) {
        return baseClass == null ? null : JavaPsiFacade.getInstance(project2).findClass(baseClass, GlobalSearchScope.allScope(project2));
    }

    public boolean startInWriteAction() {
        return false;
    }
}

