/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters.values;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassValueConverter
extends Converter<PsiClass>
implements CustomReferenceConverter {
    public static ClassValueConverter getClassValueConverter() {
        return ServiceManager.getService(ClassValueConverter.class);
    }

    public PsiClass fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        Module module2 = context.getModule();
        XmlFile psiFile = context.getFile();
        Project project2 = psiFile.getProject();
        return DomJavaUtil.findClass(s, context.getFile(), context.getModule(), ClassValueConverter.getScope(project2, module2, psiFile));
    }

    public String toString(@Nullable PsiClass psiClass, ConvertContext context) {
        return psiClass == null ? null : psiClass.getQualifiedName();
    }

    public abstract PsiReference @NotNull [] createReferences(GenericDomValue var1, PsiElement var2, ConvertContext var3);

    public static GlobalSearchScope getScope(Project project2, @Nullable Module module2, @Nullable PsiFile psiFile) {
        if (module2 == null || psiFile == null) {
            return ProjectScope.getAllScope(project2);
        }
        VirtualFile file2 = psiFile.getOriginalFile().getVirtualFile();
        if (file2 == null) {
            return ProjectScope.getAllScope(project2);
        }
        boolean inTests = TestSourcesFilter.isTestSources(file2, project2);
        return module2.getModuleRuntimeScope(inTests);
    }
}

