/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters.values;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.BooleanValueConverter;
import com.intellij.util.xml.converters.values.CharacterValueConverter;
import com.intellij.util.xml.converters.values.ClassArrayConverter;
import com.intellij.util.xml.converters.values.ClassValueConverter;
import com.intellij.util.xml.converters.values.NumberValueConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDomValueConvertersRegistry {
    private final Map<Condition<Pair<PsiType, GenericDomValue>>, Converter<?>> myConditionConverters = new LinkedHashMap();

    public void registerFromExtensions(ExtensionPointName<Provider> extensionPointName) {
        for (Provider provider : extensionPointName.getExtensionList()) {
            this.registerConverter(provider.getConverter(), provider.getCondition());
        }
    }

    public void registerDefaultConverters() {
        this.registerBooleanConverters();
        this.registerCharacterConverter();
        this.registerNumberValueConverters();
        this.registerClassValueConverters();
    }

    private void registerBooleanConverters() {
        this.registerConverter((Converter<?>)new BooleanValueConverter(false), PsiType.BOOLEAN);
        this.registerConverter((Converter<?>)new BooleanValueConverter(true), Boolean.class);
    }

    public void registerClassValueConverters() {
        this.registerConverter(ClassValueConverter.getClassValueConverter(), (Pair<PsiType, GenericDomValue> pair) -> {
            PsiClass resolve2;
            PsiType psiType = (PsiType)pair.getFirst();
            if (psiType instanceof PsiClassType && (resolve2 = ((PsiClassType)psiType).resolve()) != null) {
                return "java.lang.Class".equals(resolve2.getQualifiedName());
            }
            return false;
        });
        this.registerConverter(ClassArrayConverter.getClassArrayConverter(), Class[].class);
    }

    public void registerCharacterConverter() {
        this.registerConverter((Converter<?>)new CharacterValueConverter(false), PsiType.CHAR);
        this.registerConverter((Converter<?>)new CharacterValueConverter(true), Character.class);
    }

    public void registerNumberValueConverters() {
        this.registerConverter((Converter<?>)new NumberValueConverter(Byte.TYPE, false), PsiType.BYTE);
        this.registerConverter((Converter<?>)new NumberValueConverter(Byte.class, true), Byte.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(Short.TYPE, false), PsiType.SHORT);
        this.registerConverter((Converter<?>)new NumberValueConverter(Short.class, true), Short.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(Integer.TYPE, false), PsiType.INT);
        this.registerConverter((Converter<?>)new NumberValueConverter(Integer.class, true), Integer.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(Long.TYPE, false), PsiType.LONG);
        this.registerConverter((Converter<?>)new NumberValueConverter(Long.class, true), Long.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(Float.TYPE, false), PsiType.FLOAT);
        this.registerConverter((Converter<?>)new NumberValueConverter(Float.class, true), Float.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(Double.TYPE, false), PsiType.DOUBLE);
        this.registerConverter((Converter<?>)new NumberValueConverter(Double.class, true), Double.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(BigDecimal.class, true), BigDecimal.class);
        this.registerConverter((Converter<?>)new NumberValueConverter(BigInteger.class, true), BigInteger.class);
    }

    public void registerConverter(@NotNull Converter<?> provider, @NotNull PsiType type) {
        if (provider == null) {
            GenericDomValueConvertersRegistry.$$$reportNull$$$0(0);
        }
        if (type == null) {
            GenericDomValueConvertersRegistry.$$$reportNull$$$0(1);
        }
        this.registerConverter(provider, (Pair<PsiType, GenericDomValue> pair) -> Comparing.equal(pair.getFirst(), type));
    }

    public void registerConverter(@NotNull Converter<?> provider, @NotNull Condition<Pair<PsiType, GenericDomValue>> condition2) {
        if (provider == null) {
            GenericDomValueConvertersRegistry.$$$reportNull$$$0(2);
        }
        if (condition2 == null) {
            GenericDomValueConvertersRegistry.$$$reportNull$$$0(3);
        }
        this.myConditionConverters.put(condition2, provider);
    }

    @Nullable
    public Converter<?> getConverter(@NotNull GenericDomValue domValue, @Nullable PsiType type) {
        if (domValue == null) {
            GenericDomValueConvertersRegistry.$$$reportNull$$$0(4);
        }
        Pair<PsiType, GenericDomValue> pair = Pair.create(type, domValue);
        for (Condition<Pair<PsiType, GenericDomValue>> condition2 : this.myConditionConverters.keySet()) {
            if (!condition2.value(pair)) continue;
            return this.myConditionConverters.get(condition2);
        }
        return null;
    }

    public void registerConverter(@NotNull Converter<?> provider, @NotNull Class type) {
        if (provider == null) {
            GenericDomValueConvertersRegistry.$$$reportNull$$$0(5);
        }
        if (type == null) {
            GenericDomValueConvertersRegistry.$$$reportNull$$$0(6);
        }
        String name = type.getCanonicalName();
        this.registerConverter(provider, (Pair<PsiType, GenericDomValue> pair) -> pair.first != null && Comparing.equal(name, ((PsiType)pair.first).getCanonicalText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domValue";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/xml/converters/values/GenericDomValueConvertersRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerConverter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getConverter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Provider {
        public Converter getConverter();

        public Condition<Pair<PsiType, GenericDomValue>> getCondition();
    }
}

