/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.annotations.Property;
import java.awt.Rectangle;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AccessorBindingWrapper
implements MultiNodeBinding,
NestedBinding {
    private final Binding myBinding;
    private final MutableAccessor myAccessor;
    private final boolean myFlat;
    private final Property.Style beanStyle;

    AccessorBindingWrapper(@NotNull MutableAccessor accessor, @NotNull Binding binding, boolean flat, Property.Style beanStyle) {
        if (accessor == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(0);
        }
        if (binding == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(1);
        }
        this.myAccessor = accessor;
        this.myBinding = binding;
        this.myFlat = flat;
        this.beanStyle = beanStyle;
    }

    @Override
    @NotNull
    public MutableAccessor getAccessor() {
        MutableAccessor mutableAccessor = this.myAccessor;
        if (mutableAccessor == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(2);
        }
        return mutableAccessor;
    }

    public boolean isFlat() {
        return this.myFlat;
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter2) {
        Object value2;
        if (o == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(3);
        }
        if ((value2 = this.myAccessor.read(o)) == null) {
            return null;
        }
        if (this.myFlat) {
            Element element2 = (Element)context;
            if (this.beanStyle == Property.Style.ATTRIBUTE && value2 instanceof Rectangle) {
                Rectangle bounds2 = (Rectangle)value2;
                LOG.assertTrue(element2 != null);
                element2.setAttribute("x", Integer.toString(bounds2.x));
                element2.setAttribute("y", Integer.toString(bounds2.y));
                element2.setAttribute("width", Integer.toString(bounds2.width));
                element2.setAttribute("height", Integer.toString(bounds2.height));
            } else {
                ((BeanBinding)this.myBinding).serializeInto(value2, element2, filter2);
            }
            return null;
        }
        return this.myBinding.serialize(value2, context, filter2);
    }

    @Override
    public Object deserializeUnsafe(Object context, @NotNull Element element2) {
        if (element2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(4);
        }
        return this.deserialize(context, element2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull Element element2) {
        if (context == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(5);
        }
        if (element2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(6);
        }
        Object currentValue = this.myAccessor.read(context);
        if (this.myBinding instanceof BeanBinding && !this.myAccessor.isWritable()) {
            ((BeanBinding)this.myBinding).deserializeInto(currentValue, element2);
        } else {
            Object deserializedValue;
            block10: {
                if (this.beanStyle == Property.Style.ATTRIBUTE && this.myBinding instanceof BeanBinding && ((BeanBinding)this.myBinding).myBeanClass == Rectangle.class) {
                    String xA = element2.getAttributeValue("x");
                    String yA = element2.getAttributeValue("y");
                    String wA = element2.getAttributeValue("width");
                    String hA = element2.getAttributeValue("height");
                    if (xA != null && yA != null && wA != null && hA != null) {
                        int x = StringUtilRt.parseInt(xA, 0);
                        int y = StringUtilRt.parseInt(yA, 0);
                        int h = StringUtilRt.parseInt(hA, 0);
                        int w = StringUtilRt.parseInt(wA, 0);
                        deserializedValue = new Rectangle(x, y, w, h);
                        break block10;
                    } else {
                        Object object = context;
                        if (object == null) {
                            AccessorBindingWrapper.$$$reportNull$$$0(7);
                        }
                        return object;
                    }
                }
                deserializedValue = this.myBinding.deserializeUnsafe(currentValue, element2);
            }
            if (currentValue != deserializedValue) {
                this.myAccessor.set(context, deserializedValue);
            }
        }
        Object object = context;
        if (object == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(8);
        }
        return object;
    }

    @Override
    @NotNull
    public Object deserializeList(@NotNull Object context, @NotNull List<? extends Element> elements2) {
        if (context == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(9);
        }
        if (elements2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(10);
        }
        Object currentValue = this.myAccessor.read(context);
        if (this.myBinding instanceof BeanBinding && !this.myAccessor.isWritable()) {
            ((BeanBinding)this.myBinding).deserializeInto(currentValue, elements2.get(0));
        } else {
            Object deserializedValue = Binding.deserializeList(this.myBinding, currentValue, elements2);
            if (currentValue != deserializedValue) {
                this.myAccessor.set(context, deserializedValue);
            }
        }
        Object object = context;
        if (object == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(11);
        }
        return object;
    }

    @Override
    public boolean isMulti() {
        return this.myBinding instanceof MultiNodeBinding && ((MultiNodeBinding)this.myBinding).isMulti();
    }

    @Override
    public boolean isBoundTo(@NotNull Element element2) {
        if (element2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(12);
        }
        if (this.myBinding instanceof MapBinding) {
            return ((MapBinding)this.myBinding).isBoundToWithoutProperty(element2);
        }
        return this.myBinding.isBoundTo(element2);
    }

    public String toString() {
        return this.myBinding.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/AccessorBindingWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/AccessorBindingWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deserializeUnsafe";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

