/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.XMap;
import gnu.trove.THashMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MapBinding
implements MultiNodeBinding,
NestedBinding {
    private static final Comparator<Object> KEY_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            return c1.compareTo(c2);
        }
        return 0;
    };
    private final MapAnnotation oldAnnotation;
    private final XMap annotation;
    @NotNull
    private final Class<? extends Map> mapClass;
    private Class<?> keyClass;
    private Class<?> valueClass;
    private Binding keyBinding;
    private Binding valueBinding;
    private final MutableAccessor myAccessor;

    MapBinding(@Nullable MutableAccessor accessor, @NotNull Class<? extends Map> mapClass) {
        if (mapClass == null) {
            MapBinding.$$$reportNull$$$0(0);
        }
        this.myAccessor = accessor;
        this.oldAnnotation = accessor == null ? null : accessor.getAnnotation(MapAnnotation.class);
        this.annotation = accessor == null ? null : accessor.getAnnotation(XMap.class);
        this.mapClass = mapClass;
    }

    @Override
    @NotNull
    public MutableAccessor getAccessor() {
        MutableAccessor mutableAccessor = this.myAccessor;
        if (mutableAccessor == null) {
            MapBinding.$$$reportNull$$$0(1);
        }
        return mutableAccessor;
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        if (originalType == null) {
            MapBinding.$$$reportNull$$$0(2);
        }
        if (serializer == null) {
            MapBinding.$$$reportNull$$$0(3);
        }
        ParameterizedType type = (ParameterizedType)originalType;
        Type[] typeArguments = type.getActualTypeArguments();
        this.keyClass = ClassUtil.typeToClass(typeArguments[0]);
        this.valueClass = ClassUtil.typeToClass(typeArguments[1]);
        this.keyBinding = serializer.getBinding(this.keyClass, typeArguments[0]);
        this.valueBinding = serializer.getBinding(this.valueClass, typeArguments[1]);
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    private boolean isSortMap(Map<?, ?> map2) {
        if (map2 instanceof TreeMap || this.annotation != null && map2 instanceof LinkedHashMap) {
            return false;
        }
        return this.oldAnnotation == null || this.oldAnnotation.sortBeforeSave();
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter2) {
        Element serialized;
        if (o == null) {
            MapBinding.$$$reportNull$$$0(4);
        }
        Element element2 = serialized = this.isSurroundWithTag() ? new Element("map") : (Element)context;
        assert (serialized != null);
        Map map2 = (Map)o;
        Object[] keys2 = ArrayUtil.toObjectArray(map2.keySet());
        if (this.isSortMap(map2)) {
            Arrays.sort(keys2, KEY_COMPARATOR);
        }
        for (Object k : keys2) {
            Element entry = new Element(this.getEntryElementName());
            serialized.addContent(entry);
            this.serializeKeyOrValue(entry, this.getKeyAttributeName(), k, this.keyBinding, filter2);
            this.serializeKeyOrValue(entry, this.getValueAttributeName(), map2.get(k), this.valueBinding, filter2);
        }
        return serialized == context ? null : serialized;
    }

    protected boolean isSurroundWithTag() {
        if (this.annotation != null) {
            return false;
        }
        return this.oldAnnotation == null || this.oldAnnotation.surroundWithTag();
    }

    @NotNull
    String getEntryElementName() {
        if (this.annotation != null) {
            String string = this.annotation.entryTagName();
            if (string == null) {
                MapBinding.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.oldAnnotation == null ? "entry" : this.oldAnnotation.entryTagName();
        if (string == null) {
            MapBinding.$$$reportNull$$$0(6);
        }
        return string;
    }

    private String getKeyAttributeName() {
        if (this.annotation != null) {
            return this.annotation.keyAttributeName();
        }
        return this.oldAnnotation == null ? "key" : this.oldAnnotation.keyAttributeName();
    }

    private String getValueAttributeName() {
        if (this.annotation != null) {
            return this.annotation.valueAttributeName();
        }
        return this.oldAnnotation == null ? "value" : this.oldAnnotation.valueAttributeName();
    }

    @Override
    @Nullable
    public Object deserializeList(@Nullable Object context, @NotNull List<? extends Element> elements2) {
        List<? extends Element> childNodes;
        if (elements2 == null) {
            MapBinding.$$$reportNull$$$0(7);
        }
        if (this.isSurroundWithTag()) {
            assert (elements2.size() == 1);
            childNodes = elements2.get(0).getChildren();
        } else {
            childNodes = elements2;
        }
        return this.deserialize(context, childNodes);
    }

    @Override
    public Object deserializeUnsafe(Object context, @NotNull Element element2) {
        if (element2 == null) {
            MapBinding.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Nullable
    public Object deserialize(@Nullable Object context, @NotNull Element element2) {
        if (element2 == null) {
            MapBinding.$$$reportNull$$$0(9);
        }
        if (this.isSurroundWithTag()) {
            return this.deserialize(context, element2.getChildren());
        }
        return this.deserialize(context, Collections.singletonList(element2));
    }

    @Nullable
    private Map deserialize(@Nullable Object context, @NotNull List<? extends Element> childNodes) {
        Map<Object, Object> map2;
        if (childNodes == null) {
            MapBinding.$$$reportNull$$$0(10);
        }
        THashMap<Object, Object> tHashMap = map2 = this.myAccessor == null ? null : (THashMap<Object, Object>)context;
        if (map2 != null) {
            if (ClassUtil.isMutableMap(map2)) {
                map2.clear();
            } else {
                map2 = null;
            }
        }
        for (Element element2 : childNodes) {
            if (!element2.getName().equals(this.getEntryElementName())) {
                LOG.warn("unexpected entry for serialized Map will be skipped: " + element2);
                continue;
            }
            if (map2 == null) {
                if (this.mapClass == Map.class) {
                    map2 = new THashMap<Object, Object>();
                } else {
                    try {
                        map2 = ReflectionUtil.newInstance(this.mapClass);
                    }
                    catch (Exception e) {
                        LOG.warn(e);
                        map2 = new THashMap();
                    }
                }
            }
            map2.put(this.deserializeKeyOrValue(element2, this.getKeyAttributeName(), context, this.keyBinding, this.keyClass), this.deserializeKeyOrValue(element2, this.getValueAttributeName(), context, this.valueBinding, this.valueClass));
        }
        return map2;
    }

    private void serializeKeyOrValue(@NotNull Element entry, @NotNull String attributeName, @Nullable Object value2, @Nullable Binding binding, @Nullable SerializationFilter filter2) {
        if (entry == null) {
            MapBinding.$$$reportNull$$$0(11);
        }
        if (attributeName == null) {
            MapBinding.$$$reportNull$$$0(12);
        }
        if (value2 == null) {
            return;
        }
        if (binding == null) {
            entry.setAttribute(attributeName, JDOMUtil.removeControlChars(XmlSerializerImpl.convertToString(value2)));
        } else {
            Object serialized = binding.serialize(value2, entry, filter2);
            if (serialized != null) {
                if (this.isSurroundKey()) {
                    Element container2 = new Element(attributeName);
                    container2.addContent((Content)serialized);
                    entry.addContent(container2);
                } else {
                    entry.addContent((Content)serialized);
                }
            }
        }
    }

    private Object deserializeKeyOrValue(@NotNull Element entry, @NotNull String attributeName, Object context, @Nullable Binding binding, @NotNull Class<?> valueClass) {
        Attribute attribute;
        if (entry == null) {
            MapBinding.$$$reportNull$$$0(13);
        }
        if (attributeName == null) {
            MapBinding.$$$reportNull$$$0(14);
        }
        if (valueClass == null) {
            MapBinding.$$$reportNull$$$0(15);
        }
        if ((attribute = entry.getAttribute(attributeName)) != null) {
            return XmlSerializerImpl.convert(attribute.getValue(), valueClass);
        }
        if (!this.isSurroundKey()) {
            assert (binding != null);
            for (Element element2 : entry.getChildren()) {
                if (!binding.isBoundTo(element2)) continue;
                return binding.deserializeUnsafe(context, element2);
            }
        } else {
            List<Object> children2;
            Element entryChild = entry.getChild(attributeName);
            List<Object> list2 = children2 = entryChild == null ? Collections.emptyList() : entryChild.getChildren();
            if (children2.isEmpty()) {
                return null;
            }
            assert (binding != null);
            return Binding.deserializeList(binding, null, children2);
        }
        return null;
    }

    private boolean isSurroundKey() {
        if (this.annotation != null) {
            return false;
        }
        return this.oldAnnotation == null || this.oldAnnotation.surroundKeyWithTag();
    }

    boolean isBoundToWithoutProperty(@NotNull Element element2) {
        if (element2 == null) {
            MapBinding.$$$reportNull$$$0(16);
        }
        String elementName = element2.getName();
        if (this.annotation != null) {
            return elementName.equals(this.annotation.entryTagName());
        }
        if (this.oldAnnotation != null && !this.oldAnnotation.surroundWithTag()) {
            return elementName.equals(this.oldAnnotation.entryTagName());
        }
        return elementName.equals("map");
    }

    @Override
    public boolean isBoundTo(@NotNull Element element2) {
        if (element2 == null) {
            MapBinding.$$$reportNull$$$0(17);
        }
        if (this.oldAnnotation != null && !this.oldAnnotation.surroundWithTag()) {
            return this.oldAnnotation.entryTagName().equals(element2.getName());
        }
        if (this.annotation != null) {
            return this.annotation.propertyElementName().equals(element2.getName());
        }
        return element2.getName().equals("map");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapClass";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/MapBinding";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNodes";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/MapBinding";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserializeUnsafe";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "serializeKeyOrValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deserializeKeyOrValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isBoundToWithoutProperty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

