/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsLogProvider {
    public static final ExtensionPointName<VcsLogProvider> LOG_PROVIDER_EP = ExtensionPointName.create("com.intellij.logProvider");

    @NotNull
    public DetailedLogData readFirstBlock(@NotNull VirtualFile var1, @NotNull Requirements var2) throws VcsException;

    @NotNull
    public LogData readAllHashes(@NotNull VirtualFile var1, @NotNull Consumer<? super TimedVcsCommit> var2) throws VcsException;

    public List<? extends VcsCommitMetadata> readMetadata(@NotNull VirtualFile var1, @NotNull List<String> var2) throws VcsException;

    default public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<? super VcsFullCommitDetails> commitConsumer) throws VcsException {
        if (root == null) {
            VcsLogProvider.$$$reportNull$$$0(0);
        }
        if (hashes == null) {
            VcsLogProvider.$$$reportNull$$$0(1);
        }
        if (commitConsumer == null) {
            VcsLogProvider.$$$reportNull$$$0(2);
        }
        this.readFullDetails(root, hashes, commitConsumer, false);
    }

    @NotNull
    public VcsKey getSupportedVcs();

    @NotNull
    public VcsLogRefManager getReferenceManager();

    @NotNull
    public Disposable subscribeToRootRefreshEvents(@NotNull Collection<? extends VirtualFile> var1, @NotNull VcsLogRefresher var2);

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile var1, @NotNull VcsLogFilterCollection var2, int var3) throws VcsException;

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile var1) throws VcsException;

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile var1, @NotNull Hash var2) throws VcsException;

    @Nullable
    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> var1);

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile var1);

    @Nullable
    default public VcsLogDiffHandler getDiffHandler() {
        return null;
    }

    @Nullable
    default public VcsLogFileHistoryHandler getFileHistoryHandler() {
        return null;
    }

    @Nullable
    default public Hash resolveReference(@NotNull String ref, @NotNull VirtualFile root) {
        if (ref == null) {
            VcsLogProvider.$$$reportNull$$$0(3);
        }
        if (root == null) {
            VcsLogProvider.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Nullable
    default public VirtualFile getVcsRoot(@NotNull Project project2, @NotNull VirtualFile detectedRoot, @NotNull FilePath filePath2) {
        if (project2 == null) {
            VcsLogProvider.$$$reportNull$$$0(5);
        }
        if (detectedRoot == null) {
            VcsLogProvider.$$$reportNull$$$0(6);
        }
        if (filePath2 == null) {
            VcsLogProvider.$$$reportNull$$$0(7);
        }
        return detectedRoot;
    }

    @Deprecated
    @NotNull
    default public List<? extends VcsShortCommitDetails> readShortDetails(@NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            VcsLogProvider.$$$reportNull$$$0(8);
        }
        if (hashes == null) {
            VcsLogProvider.$$$reportNull$$$0(9);
        }
        List<? extends VcsCommitMetadata> list2 = this.readMetadata(root, hashes);
        if (list2 == null) {
            VcsLogProvider.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Deprecated
    default public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<? super VcsFullCommitDetails> commitConsumer, boolean isForIndexing) throws VcsException {
        if (root == null) {
            VcsLogProvider.$$$reportNull$$$0(11);
        }
        if (hashes == null) {
            VcsLogProvider.$$$reportNull$$$0(12);
        }
        if (commitConsumer == null) {
            VcsLogProvider.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException(this.getClass().getName() + ".readFullDetails is deprecated");
    }

    @Deprecated
    @NotNull
    default public List<? extends VcsFullCommitDetails> readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            VcsLogProvider.$$$reportNull$$$0(14);
        }
        if (hashes == null) {
            VcsLogProvider.$$$reportNull$$$0(15);
        }
        ArrayList result2 = new ArrayList();
        this.readFullDetails(root, hashes, result2::add);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsLogProvider.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedRoot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/VcsLogProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/VcsLogProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readShortDetails";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "readFullDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetails";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRoot";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readShortDetails";
                break;
            }
            case 10: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DetailedLogData {
        @NotNull
        public List<VcsCommitMetadata> getCommits();

        @NotNull
        public Set<VcsRef> getRefs();
    }

    public static interface LogData {
        @NotNull
        public Set<VcsRef> getRefs();

        @NotNull
        public Set<VcsUser> getUsers();
    }

    public static interface Requirements {
        public int getCommitCount();
    }
}

