/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public abstract class ActionWithTempFile {
    private File myTempFile;
    private final File mySourceFile;
    @NonNls
    private static final String TMP_PREFIX = "vcs";
    @NonNls
    private static final String TMP_SUFFIX = "tmp";

    public ActionWithTempFile(File sourceFile) {
        this.mySourceFile = sourceFile;
    }

    public void execute() throws VcsException {
        try {
            try {
                this.init();
                this.executeInternal();
            }
            finally {
                this.rollbackChanges();
            }
        }
        catch (IOException e) {
            throw new VcsException(e);
        }
    }

    private void init() throws IOException {
        this.myTempFile = FileUtil.createTempFile(TMP_PREFIX, TMP_SUFFIX);
        FileUtil.delete(this.myTempFile);
        FileUtil.rename(this.mySourceFile, this.myTempFile);
    }

    protected abstract void executeInternal() throws VcsException;

    private void rollbackChanges() throws IOException {
        try {
            FileUtil.delete(this.mySourceFile);
        }
        finally {
            try {
                FileUtil.rename(this.myTempFile, this.mySourceFile);
            }
            finally {
                FileUtil.delete(this.myTempFile);
            }
        }
    }
}

