/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.util.Function;
import com.intellij.util.ThrowableConvertor;
import com.intellij.vcsUtil.VcsRunnable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsUtil {
    protected static final char[] ourCharsToBeChopped = new char[]{'/', '\\'};
    private static final Logger LOG = Logger.getInstance(VcsUtil.class);
    public static final String MAX_VCS_LOADED_SIZE_KB = "idea.max.vcs.loaded.size.kb";
    private static final int ourMaxLoadedFileSize = VcsUtil.computeLoadedFileSize();
    private static final int MAX_COMMIT_MESSAGE_LENGTH = 50000;
    private static final int MAX_COMMIT_MESSAGE_LINES = 3000;
    private static final String ANNO_ASPECT = "show.vcs.annotation.aspect.";

    public static int getMaxVcsLoadedFileSize() {
        return ourMaxLoadedFileSize;
    }

    private static int computeLoadedFileSize() {
        int result2 = (int)PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD;
        String userLimitKb = System.getProperty(MAX_VCS_LOADED_SIZE_KB);
        try {
            return userLimitKb != null ? Integer.parseInt(userLimitKb) * 1024 : result2;
        }
        catch (NumberFormatException ignored) {
            return result2;
        }
    }

    @Deprecated
    public static void markFileAsDirty(Project project2, VirtualFile file2) {
        VcsDirtyScopeManager.getInstance(project2).fileDirty(file2);
    }

    @Deprecated
    public static void markFileAsDirty(Project project2, FilePath path2) {
        VcsDirtyScopeManager.getInstance(project2).fileDirty(path2);
    }

    public static void markFileAsDirty(Project project2, String path2) {
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOn(new File(path2));
        VcsDirtyScopeManager.getInstance(project2).fileDirty(filePath2);
    }

    @Deprecated
    public static void refreshFiles(Project project2, HashSet<? extends FilePath> paths) {
        for (FilePath filePath2 : paths) {
            VirtualFile vFile = filePath2.getVirtualFile();
            if (vFile == null) continue;
            if (vFile.isDirectory()) {
                VcsUtil.markFileAsDirty(project2, vFile);
                continue;
            }
            vFile.refresh(true, vFile.isDirectory());
        }
    }

    public static boolean isFileUnderVcs(Project project2, String file2) {
        return VcsUtil.getVcsFor(project2, VcsUtil.getFilePath(file2)) != null;
    }

    public static boolean isFileUnderVcs(Project project2, FilePath file2) {
        return VcsUtil.getVcsFor(project2, file2) != null;
    }

    public static boolean isFileForVcs(@NotNull VirtualFile file2, Project project2, AbstractVcs host) {
        if (file2 == null) {
            VcsUtil.$$$reportNull$$$0(0);
        }
        return VcsUtil.getVcsFor(project2, file2) == host;
    }

    public static boolean isFileForVcs(FilePath path2, Project project2, AbstractVcs host) {
        return VcsUtil.getVcsFor(project2, path2) == host;
    }

    public static boolean isFileForVcs(String path2, Project project2, AbstractVcs host) {
        return VcsUtil.getVcsFor(project2, VcsUtil.getFilePath(path2)) == host;
    }

    @Nullable
    public static AbstractVcs getVcsFor(@NotNull Project project2, FilePath filePath2) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(1);
        }
        return VcsUtil.computeValue(project2, manager -> manager.getVcsFor(filePath2));
    }

    @Nullable
    public static AbstractVcs getVcsFor(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            VcsUtil.$$$reportNull$$$0(3);
        }
        return VcsUtil.computeValue(project2, manager -> manager.getVcsFor(file2));
    }

    @Nullable
    public static AbstractVcs findVcsByKey(@NotNull Project project2, @NotNull VcsKey key) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(4);
        }
        if (key == null) {
            VcsUtil.$$$reportNull$$$0(5);
        }
        return ProjectLevelVcsManager.getInstance(project2).findVcsByName(key.getName());
    }

    @Nullable
    public static AbstractVcs findVcs(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            VcsUtil.$$$reportNull$$$0(6);
        }
        if ((project2 = e.getProject()) == null) {
            return null;
        }
        VcsKey key = e.getData(VcsDataKeys.VCS);
        if (key == null) {
            return null;
        }
        return VcsUtil.findVcsByKey(project2, key);
    }

    @Nullable
    public static VirtualFile getVcsRootFor(@NotNull Project project2, FilePath filePath2) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(7);
        }
        return VcsUtil.computeValue(project2, manager -> manager.getVcsRootFor(filePath2));
    }

    @Nullable
    public static VirtualFile getVcsRootFor(@NotNull Project project2, @Nullable VirtualFile file2) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(8);
        }
        return VcsUtil.computeValue(project2, manager -> manager.getVcsRootFor(file2));
    }

    @Nullable
    private static <T> T computeValue(@NotNull Project project2, @NotNull Function<? super ProjectLevelVcsManager, ? extends T> provider) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(9);
        }
        if (provider == null) {
            VcsUtil.$$$reportNull$$$0(10);
        }
        return (T)ReadAction.compute(() -> {
            Object result2 = null;
            if (!project2.isDisposed()) {
                ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance(project2);
                result2 = manager != null ? provider.fun(manager) : null;
            }
            return result2;
        });
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull String path2) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(11);
        }
        return ReadAction.compute(() -> LocalFileSystem.getInstance().findFileByPath(path2.replace(File.separatorChar, '/')));
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull File file2) {
        if (file2 == null) {
            VcsUtil.$$$reportNull$$$0(12);
        }
        return ReadAction.compute(() -> LocalFileSystem.getInstance().findFileByIoFile(file2));
    }

    @Nullable
    public static VirtualFile getVirtualFileWithRefresh(File file2) {
        if (file2 == null) {
            return null;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile result2 = lfs.findFileByIoFile(file2);
        if (result2 == null) {
            result2 = lfs.refreshAndFindFileByIoFile(file2);
        }
        return result2;
    }

    public static String getFileContent(@NotNull String path2) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(13);
        }
        return ReadAction.compute(() -> {
            VirtualFile vFile = VcsUtil.getVirtualFile(path2);
            assert (vFile != null);
            return FileDocumentManager.getInstance().getDocument(vFile).getText();
        });
    }

    public static byte @Nullable [] getFileByteContent(@NotNull File file2) {
        if (file2 == null) {
            VcsUtil.$$$reportNull$$$0(14);
        }
        try {
            return FileUtil.loadFileBytes(file2);
        }
        catch (IOException e) {
            LOG.info(e);
            return null;
        }
    }

    @NotNull
    public static FilePath getFilePath(@NotNull String path2) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(15);
        }
        return VcsUtil.getFilePath(new File(path2));
    }

    @NotNull
    public static FilePath getFilePath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VcsUtil.$$$reportNull$$$0(16);
        }
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file2);
        if (filePath2 == null) {
            VcsUtil.$$$reportNull$$$0(17);
        }
        return filePath2;
    }

    @NotNull
    public static FilePath getFilePath(@NotNull File file2) {
        if (file2 == null) {
            VcsUtil.$$$reportNull$$$0(18);
        }
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file2);
        if (filePath2 == null) {
            VcsUtil.$$$reportNull$$$0(19);
        }
        return filePath2;
    }

    @NotNull
    public static FilePath getFilePath(@NotNull String path2, boolean isDirectory) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(20);
        }
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePath(path2, isDirectory);
        if (filePath2 == null) {
            VcsUtil.$$$reportNull$$$0(21);
        }
        return filePath2;
    }

    @NotNull
    public static FilePath getFilePathOnNonLocal(@NotNull String path2, boolean isDirectory) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(22);
        }
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOnNonLocal(path2, isDirectory);
        if (filePath2 == null) {
            VcsUtil.$$$reportNull$$$0(23);
        }
        return filePath2;
    }

    @NotNull
    public static FilePath getFilePath(@NotNull File file2, boolean isDirectory) {
        if (file2 == null) {
            VcsUtil.$$$reportNull$$$0(24);
        }
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file2, isDirectory);
        if (filePath2 == null) {
            VcsUtil.$$$reportNull$$$0(25);
        }
        return filePath2;
    }

    @Deprecated
    @NotNull
    public static FilePath getFilePathForDeletedFile(@NotNull String path2, boolean isDirectory) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(26);
        }
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOn(new File(path2), isDirectory);
        if (filePath2 == null) {
            VcsUtil.$$$reportNull$$$0(27);
        }
        return filePath2;
    }

    @NotNull
    public static FilePath getFilePath(@NotNull VirtualFile parent, @NotNull String name) {
        if (parent == null) {
            VcsUtil.$$$reportNull$$$0(28);
        }
        if (name == null) {
            VcsUtil.$$$reportNull$$$0(29);
        }
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOn(parent, name);
        if (filePath2 == null) {
            VcsUtil.$$$reportNull$$$0(30);
        }
        return filePath2;
    }

    @NotNull
    public static FilePath getFilePath(@NotNull VirtualFile parent, @NotNull String fileName, boolean isDirectory) {
        if (parent == null) {
            VcsUtil.$$$reportNull$$$0(31);
        }
        if (fileName == null) {
            VcsUtil.$$$reportNull$$$0(32);
        }
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePath(parent, fileName, isDirectory);
        if (filePath2 == null) {
            VcsUtil.$$$reportNull$$$0(33);
        }
        return filePath2;
    }

    @Deprecated
    public static void showStatusMessage(@NotNull Project project2, @Nullable String message) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(34);
        }
        SwingUtilities.invokeLater(() -> {
            if (project2.isOpen()) {
                StatusBar.Info.set(message, project2);
            }
        });
    }

    public static boolean isRenameChange(Change change) {
        boolean isRenamed = false;
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after2 = change.getAfterRevision();
        if (before != null && after2 != null) {
            String newFile;
            String prevFile = VcsUtil.getCanonicalLocalPath(before.getFile().getPath());
            isRenamed = !prevFile.equals(newFile = VcsUtil.getCanonicalLocalPath(after2.getFile().getPath()));
        }
        return isRenamed;
    }

    public static boolean isChangeForNew(Change change) {
        return change.getBeforeRevision() == null && change.getAfterRevision() != null;
    }

    public static boolean isChangeForDeleted(Change change) {
        return change.getBeforeRevision() != null && change.getAfterRevision() == null;
    }

    public static boolean isChangeForFolder(Change change) {
        ContentRevision revB = change.getBeforeRevision();
        ContentRevision revA = change.getAfterRevision();
        return revA != null && revA.getFile().isDirectory() || revB != null && revB.getFile().isDirectory();
    }

    public static FilePath[] sortPathsFromOutermost(FilePath[] files2) {
        return VcsUtil.sortPaths(files2, 1);
    }

    private static FilePath[] sortPaths(FilePath[] files2, int sign) {
        Arrays.sort(files2, (file1, file2) -> sign * file1.getPath().compareTo(file2.getPath()));
        return files2;
    }

    @Nullable
    public static VirtualFile getOneVirtualFile(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (e == null) {
            VcsUtil.$$$reportNull$$$0(35);
        }
        return (files2 = VcsUtil.getVirtualFiles(e)).length != 1 ? null : files2[0];
    }

    public static VirtualFile @NotNull [] getVirtualFiles(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (e == null) {
            VcsUtil.$$$reportNull$$$0(36);
        }
        VirtualFile[] virtualFileArray = (files2 = e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null ? VirtualFile.EMPTY_ARRAY : files2;
        if (virtualFileArray == null) {
            VcsUtil.$$$reportNull$$$0(37);
        }
        return virtualFileArray;
    }

    @Deprecated
    public static boolean runVcsProcessWithProgress(@NotNull VcsRunnable runnable2, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project2) throws VcsException {
        if (runnable2 == null) {
            VcsUtil.$$$reportNull$$$0(38);
        }
        if (progressTitle == null) {
            VcsUtil.$$$reportNull$$$0(39);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Ref ex = new Ref();
            boolean result2 = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                try {
                    runnable2.run();
                }
                catch (VcsException e) {
                    ex.set(e);
                }
            }, progressTitle, canBeCanceled, project2);
            if (!ex.isNull()) {
                throw (VcsException)ex.get();
            }
            return result2;
        }
        runnable2.run();
        return true;
    }

    public static <T> T computeWithModalProgress(@Nullable Project project2, @NotNull @Nls String title, boolean canBeCancelled, final @NotNull ThrowableConvertor<? super ProgressIndicator, T, ? extends VcsException> computable) throws VcsException {
        if (title == null) {
            VcsUtil.$$$reportNull$$$0(40);
        }
        if (computable == null) {
            VcsUtil.$$$reportNull$$$0(41);
        }
        return ProgressManager.getInstance().run(new Task.WithResult<T, VcsException>(project2, title, canBeCancelled){

            @Override
            protected T compute(@NotNull ProgressIndicator indicator) throws VcsException {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return computable.convert(indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcsUtil/VcsUtil$1", "compute"));
            }
        });
    }

    @Deprecated
    @Nullable
    public static VirtualFile waitForTheFile(@NotNull String path2) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(42);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(path2);
    }

    public static String getCanonicalLocalPath(String localPath) {
        if ((localPath = VcsUtil.chopTrailingChars(localPath.trim().replace('\\', '/'), ourCharsToBeChopped)).length() == 2 && localPath.charAt(1) == ':') {
            localPath = localPath + '/';
        }
        return localPath;
    }

    public static String getCanonicalPath(String path2) {
        String canonPath;
        try {
            canonPath = new File(path2).getCanonicalPath();
        }
        catch (IOException e) {
            canonPath = path2;
        }
        return canonPath;
    }

    public static String getCanonicalPath(File file2) {
        String canonPath;
        try {
            canonPath = file2.getCanonicalPath();
        }
        catch (IOException e) {
            canonPath = file2.getAbsolutePath();
        }
        return canonPath;
    }

    public static String chopTrailingChars(String source, char[] chars) {
        boolean atLeastOneCharWasChopped;
        StringBuilder sb = new StringBuilder(source);
        do {
            atLeastOneCharWasChopped = false;
            for (int i = 0; i < chars.length && sb.length() > 0; ++i) {
                if (sb.charAt(sb.length() - 1) != chars[i]) continue;
                sb.deleteCharAt(sb.length() - 1);
                atLeastOneCharWasChopped = true;
            }
        } while (atLeastOneCharWasChopped);
        return sb.toString();
    }

    public static String getShortRevisionString(@NotNull VcsRevisionNumber revision) {
        if (revision == null) {
            VcsUtil.$$$reportNull$$$0(43);
        }
        return revision instanceof ShortVcsRevisionNumber ? ((ShortVcsRevisionNumber)revision).toShortString() : revision.asString();
    }

    public static VirtualFile[] paths2VFiles(String[] paths) {
        VirtualFile[] files2 = new VirtualFile[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files2[i] = VcsUtil.getVirtualFile(paths[i]);
        }
        return files2;
    }

    public static boolean isAspectAvailableByDefault(String id2) {
        return VcsUtil.isAspectAvailableByDefault(id2, true);
    }

    public static boolean isAspectAvailableByDefault(@Nullable String id2, boolean defaultValue) {
        if (id2 == null) {
            return false;
        }
        return PropertiesComponent.getInstance().getBoolean(ANNO_ASPECT + id2, defaultValue);
    }

    public static void setAspectAvailability(String aspectID, boolean showByDefault) {
        PropertiesComponent.getInstance().setValue(ANNO_ASPECT + aspectID, String.valueOf(showByDefault));
    }

    public static boolean isPathRemote(String path2) {
        int idx = path2.indexOf("://");
        if (idx == -1) {
            int idx2 = path2.indexOf(":\\\\");
            if (idx2 == -1) {
                return false;
            }
            return idx2 > 0;
        }
        return idx > 0;
    }

    public static String getPathForProgressPresentation(@NotNull File file2) {
        if (file2 == null) {
            VcsUtil.$$$reportNull$$$0(44);
        }
        return file2.getName() + " (" + FileUtil.getLocationRelativeToUserHome(file2.getParent()) + ")";
    }

    @NotNull
    public static <T> Map<VcsRoot, List<T>> groupByRoots(@NotNull Project project2, @NotNull Collection<? extends T> items, @NotNull Function<? super T, ? extends FilePath> filePathMapper) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(45);
        }
        if (items == null) {
            VcsUtil.$$$reportNull$$$0(46);
        }
        if (filePathMapper == null) {
            VcsUtil.$$$reportNull$$$0(47);
        }
        return VcsUtil.groupByRoots(project2, items, false, filePathMapper);
    }

    @NotNull
    public static <T> Map<VcsRoot, List<T>> groupByRoots(@NotNull Project project2, @NotNull Collection<? extends T> items, boolean putNonVcs, @NotNull Function<? super T, ? extends FilePath> filePathMapper) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(48);
        }
        if (items == null) {
            VcsUtil.$$$reportNull$$$0(49);
        }
        if (filePathMapper == null) {
            VcsUtil.$$$reportNull$$$0(50);
        }
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance(project2);
        HashMap<VcsRoot, List<T>> map2 = new HashMap<VcsRoot, List<T>>();
        for (T item : items) {
            VcsRoot vcsRoot = manager.getVcsRootObjectFor(filePathMapper.fun(item));
            if (vcsRoot == null && !putNonVcs) continue;
            List list2 = map2.computeIfAbsent(vcsRoot, key -> new ArrayList());
            list2.add(item);
        }
        HashMap<VcsRoot, List<T>> hashMap = map2;
        if (hashMap == null) {
            VcsUtil.$$$reportNull$$$0(51);
        }
        return hashMap;
    }

    @NotNull
    public static List<VcsDirectoryMapping> addMapping(@NotNull List<? extends VcsDirectoryMapping> existingMappings, @NotNull String path2, @NotNull String vcs) {
        if (existingMappings == null) {
            VcsUtil.$$$reportNull$$$0(52);
        }
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(53);
        }
        if (vcs == null) {
            VcsUtil.$$$reportNull$$$0(54);
        }
        ArrayList<VcsDirectoryMapping> mappings = new ArrayList<VcsDirectoryMapping>(existingMappings);
        Iterator iterator2 = mappings.iterator();
        while (iterator2.hasNext()) {
            VcsDirectoryMapping mapping2 = (VcsDirectoryMapping)iterator2.next();
            if (mapping2.isDefaultMapping() && StringUtil.isEmptyOrSpaces(mapping2.getVcs())) {
                LOG.debug("Removing <Project> -> <None> mapping");
                iterator2.remove();
                continue;
            }
            if (!FileUtil.pathsEqual(mapping2.getDirectory(), path2)) continue;
            if (!StringUtil.isEmptyOrSpaces(mapping2.getVcs())) {
                LOG.warn("Substituting existing mapping [" + path2 + "] -> [" + mapping2.getVcs() + "] with [" + vcs + "]");
            } else {
                LOG.debug("Removing [" + path2 + "] -> <None> mapping");
            }
            iterator2.remove();
        }
        mappings.add(new VcsDirectoryMapping(path2, vcs));
        ArrayList<VcsDirectoryMapping> arrayList = mappings;
        if (arrayList == null) {
            VcsUtil.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    @NotNull
    public static FilePath getLastCommitPath(@NotNull Project project2, @NotNull FilePath path2) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(56);
        }
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(57);
        }
        if (project2.isDefault()) {
            FilePath filePath2 = path2;
            if (filePath2 == null) {
                VcsUtil.$$$reportNull$$$0(58);
            }
            return filePath2;
        }
        Change change = ChangeListManager.getInstance(project2).getChange(path2);
        if (change == null || change.getType() != Change.Type.MOVED || change.getBeforeRevision() == null) {
            FilePath filePath3 = path2;
            if (filePath3 == null) {
                VcsUtil.$$$reportNull$$$0(59);
            }
            return filePath3;
        }
        FilePath filePath4 = change.getBeforeRevision().getFile();
        if (filePath4 == null) {
            VcsUtil.$$$reportNull$$$0(60);
        }
        return filePath4;
    }

    @NotNull
    public static Set<String> getVcsIgnoreFileNames(@NotNull Project project2) {
        if (project2 == null) {
            VcsUtil.$$$reportNull$$$0(61);
        }
        Set<String> set = IgnoredFileContentProvider.IGNORE_FILE_CONTENT_PROVIDER.extensions(project2).map(IgnoredFileContentProvider::getFileName).collect(Collectors.toSet());
        if (set == null) {
            VcsUtil.$$$reportNull$$$0(62);
        }
        return set;
    }

    @NotNull
    public static String trimCommitMessageToSaneSize(@NotNull String message) {
        int nthLine;
        if (message == null) {
            VcsUtil.$$$reportNull$$$0(63);
        }
        if ((nthLine = VcsUtil.nthIndexOf(message, '\n', 3000)) != -1 && nthLine < 50000) {
            String string = VcsUtil.trimCommitMessageAt(message, nthLine);
            if (string == null) {
                VcsUtil.$$$reportNull$$$0(64);
            }
            return string;
        }
        if (message.length() > 50050) {
            String string = VcsUtil.trimCommitMessageAt(message, 50000);
            if (string == null) {
                VcsUtil.$$$reportNull$$$0(65);
            }
            return string;
        }
        String string = message;
        if (string == null) {
            VcsUtil.$$$reportNull$$$0(66);
        }
        return string;
    }

    private static String trimCommitMessageAt(@NotNull String message, int index) {
        if (message == null) {
            VcsUtil.$$$reportNull$$$0(67);
        }
        return String.format("%s\n\n... Commit message is too long and was truncated by %s ...", message.substring(0, index), ApplicationNamesInfo.getInstance().getProductName());
    }

    private static int nthIndexOf(@NotNull String text2, char c, int n) {
        if (text2 == null) {
            VcsUtil.$$$reportNull$$$0(68);
        }
        assert (n > 0);
        int length = text2.length();
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (text2.charAt(i) != c || ++count != n) continue;
            return i;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 51: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 66: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 51: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 66: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 34: 
            case 45: 
            case 48: 
            case 56: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 26: 
            case 42: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 51: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcsUtil/VcsUtil";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePathMapper";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingMappings";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcsUtil/VcsUtil";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 30: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathOnNonLocal";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathForDeletedFile";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByRoots";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "addMapping";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommitPath";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsIgnoreFileNames";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "trimCommitMessageToSaneSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileForVcs";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findVcsByKey";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findVcs";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootFor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeValue";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileContent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileByteContent";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 51: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 66: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFilePathOnNonLocal";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFilePathForDeletedFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "showStatusMessage";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getOneVirtualFile";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFiles";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "runVcsProcessWithProgress";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "computeWithModalProgress";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "waitForTheFile";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getShortRevisionString";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getPathForProgressPresentation";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "groupByRoots";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addMapping";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommitPath";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getVcsIgnoreFileNames";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "trimCommitMessageToSaneSize";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "trimCommitMessageAt";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "nthIndexOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 51: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 66: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

