/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.ui.JBUI;
import com.intellij.webcore.packaging.PackageManagementService;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ManageRepoDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private final JBList<String> myList;
    private boolean myEnabled;
    private static final Logger LOG = Logger.getInstance(ManageRepoDialog.class);

    public ManageRepoDialog(Project project2, PackageManagementService controller) {
        super(project2, false);
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(IdeBundle.message("manage.repositories.dialog.title", new Object[0]));
        this.myList = new JBList();
        this.myList.setPaintBusy(true);
        final DefaultListModel repoModel = new DefaultListModel();
        controller.fetchAllRepositories((CatchingConsumer<? super List<String>, ? super Exception>)new CatchingConsumer<List<String>, Exception>(){

            @Override
            public void consume(List<String> repoUrls) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (ManageRepoDialog.this.isDisposed()) {
                        return;
                    }
                    ManageRepoDialog.this.myList.setPaintBusy(false);
                    for (String repoUrl : repoUrls) {
                        repoModel.addElement(repoUrl);
                    }
                }, ModalityState.any());
            }

            @Override
            public void consume(Exception e) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (ManageRepoDialog.this.isDisposed()) {
                        return;
                    }
                    ManageRepoDialog.this.myList.setPaintBusy(false);
                    LOG.warn(e);
                });
            }
        });
        this.myList.setModel(repoModel);
        this.myList.setSelectionMode(0);
        this.myList.addListSelectionListener(event -> {
            String selected2 = (String)this.myList.getSelectedValue();
            this.myEnabled = controller.canModifyRepository(selected2);
        });
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).disableUpDownActions();
        decorator.setAddActionName(IdeBundle.message("action.add.repository", new Object[0]));
        decorator.setRemoveActionName(IdeBundle.message("action.remove.repository.from.list", new Object[0]));
        decorator.setEditActionName(IdeBundle.message("action.edit.repository.url", new Object[0]));
        decorator.setAddAction(button2 -> {
            String url = Messages.showInputDialog(IdeBundle.message("please.input.repository.url", new Object[0]), IdeBundle.message("repository.url.title", new Object[0]), null);
            if (!StringUtil.isEmptyOrSpaces(url) && !repoModel.contains(url)) {
                repoModel.addElement(url);
                controller.addRepository(url);
            }
        });
        decorator.setEditAction(button2 -> {
            String oldValue = (String)this.myList.getSelectedValue();
            String url = Messages.showInputDialog(IdeBundle.message("please.edit.repository.url", new Object[0]), IdeBundle.message("repository.url.title", new Object[0]), null, oldValue, new InputValidator(){

                @Override
                public boolean checkInput(String inputString) {
                    return !repoModel.contains(inputString);
                }

                @Override
                public boolean canClose(String inputString) {
                    return true;
                }
            });
            if (!StringUtil.isEmptyOrSpaces(url) && !oldValue.equals(url)) {
                repoModel.addElement(url);
                repoModel.removeElement(oldValue);
                controller.removeRepository(oldValue);
                controller.addRepository(url);
            }
        });
        decorator.setRemoveAction(button2 -> {
            String selected2 = (String)this.myList.getSelectedValue();
            controller.removeRepository(selected2);
            repoModel.removeElement(selected2);
            button2.setEnabled(false);
        });
        decorator.setRemoveActionUpdater(e -> this.myEnabled);
        decorator.setEditActionUpdater(e -> this.myEnabled);
        JPanel panel2 = decorator.createPanel();
        panel2.setPreferredSize(JBUI.size(800, 600));
        this.myMainPanel.add(panel2);
    }

    @Override
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

