/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.webcore.packaging.PackageManagementService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageManagementUsageCollector {
    private PackageManagementUsageCollector() {
    }

    public static void triggerBrowseAvailablePackagesPerformed(@NotNull Project project2, @Nullable PackageManagementService service) {
        if (project2 == null) {
            PackageManagementUsageCollector.$$$reportNull$$$0(0);
        }
        PackageManagementUsageCollector.trigger(project2, service, "browseAvailablePackages");
    }

    public static void triggerInstallPerformed(@NotNull Project project2, @Nullable PackageManagementService service) {
        if (project2 == null) {
            PackageManagementUsageCollector.$$$reportNull$$$0(1);
        }
        PackageManagementUsageCollector.trigger(project2, service, "install");
    }

    public static void triggerUpgradePerformed(@NotNull Project project2, @Nullable PackageManagementService service) {
        if (project2 == null) {
            PackageManagementUsageCollector.$$$reportNull$$$0(2);
        }
        PackageManagementUsageCollector.trigger(project2, service, "upgrade");
    }

    public static void triggerUninstallPerformed(@NotNull Project project2, @Nullable PackageManagementService service) {
        if (project2 == null) {
            PackageManagementUsageCollector.$$$reportNull$$$0(3);
        }
        PackageManagementUsageCollector.trigger(project2, service, "uninstall");
    }

    private static void trigger(@NotNull Project project2, @Nullable PackageManagementService service, @NotNull String actionName) {
        String serviceName;
        if (project2 == null) {
            PackageManagementUsageCollector.$$$reportNull$$$0(4);
        }
        if (actionName == null) {
            PackageManagementUsageCollector.$$$reportNull$$$0(5);
        }
        if ((serviceName = PackageManagementUsageCollector.toKnownServiceName(service)) != null) {
            FeatureUsageData data2 = new FeatureUsageData().addData("service", serviceName);
            FUCounterUsageLogger.getInstance().logEvent(project2, "package.management.ui", actionName, data2);
        }
    }

    @Nullable
    private static String toKnownServiceName(@Nullable PackageManagementService service) {
        if (service == null) {
            return null;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(service.getClass());
        return info.isSafeToReport() ? service.getID() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/packaging/PackageManagementUsageCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerBrowseAvailablePackagesPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerInstallPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerUpgradePerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerUninstallPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "trigger";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

