/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.api;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.workspace.api.CachedValue;
import com.intellij.workspace.api.TypedEntityStore;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u000fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0011\u0010\u000b\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/intellij/workspace/api/DisposableCachedValue;", "R", "Lcom/intellij/openapi/Disposable;", "entityStore", "Lkotlin/Function0;", "Lcom/intellij/workspace/api/TypedEntityStore;", "cachedValue", "Lcom/intellij/workspace/api/CachedValue;", "(Lkotlin/jvm/functions/Function0;Lcom/intellij/workspace/api/CachedValue;)V", "latestValue", "Lcom/intellij/openapi/Disposable;", "value", "getValue", "()Lcom/intellij/openapi/Disposable;", "dispose", "", "dropCache", "intellij.platform.workspaceModel.core"})
public final class DisposableCachedValue<R extends Disposable>
implements Disposable {
    private R latestValue;
    private final Function0<TypedEntityStore> entityStore;
    private final CachedValue<R> cachedValue;

    @NotNull
    public final synchronized R getValue() {
        R oldValue = this.latestValue;
        Disposable currentValue = (Disposable)((TypedEntityStore)this.entityStore.invoke()).cachedValue(this.cachedValue);
        if (oldValue != currentValue && oldValue != null) {
            Disposer.dispose(oldValue);
        }
        this.latestValue = currentValue;
        return (R)currentValue;
    }

    @Override
    public void dispose() {
        this.dropCache();
    }

    public final synchronized void dropCache() {
        R oldValue = this.latestValue;
        if (oldValue != null) {
            ((TypedEntityStore)this.entityStore.invoke()).clearCachedValue(this.cachedValue);
            Disposer.dispose(oldValue);
            this.latestValue = null;
        }
    }

    public DisposableCachedValue(@NotNull Function0<? extends TypedEntityStore> entityStore2, @NotNull CachedValue<R> cachedValue) {
        Intrinsics.checkParameterIsNotNull(entityStore2, (String)"entityStore");
        Intrinsics.checkParameterIsNotNull(cachedValue, (String)"cachedValue");
        this.entityStore = entityStore2;
        this.cachedValue = cachedValue;
    }
}

