/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.ide;

import com.google.common.base.Stopwatch;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SingleAlarmKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspace.UtilsKt;
import com.intellij.workspace.api.EntityStorageSerializer;
import com.intellij.workspace.api.EntityStoreChanged;
import com.intellij.workspace.api.EntityTypesResolver;
import com.intellij.workspace.api.KryoEntityStorageSerializer;
import com.intellij.workspace.api.TypedEntityStorage;
import com.intellij.workspace.api.TypedEntityStorageBuilder;
import com.intellij.workspace.ide.WorkspaceModel;
import com.intellij.workspace.ide.WorkspaceModelCacheImpl;
import com.intellij.workspace.ide.WorkspaceModelChangeListener;
import com.intellij.workspace.ide.WorkspaceModelTopics;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013H\u0002R\u0015\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/workspace/ide/WorkspaceModelCacheImpl;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LOG$1", "cacheFile", "Ljava/io/File;", "saveAlarm", "Lcom/intellij/util/SingleAlarm;", "serializer", "Lcom/intellij/workspace/api/EntityStorageSerializer;", "dispose", "", "loadCache", "Lcom/intellij/workspace/api/TypedEntityStorage;", "saveCache", "storage", "Companion", "PluginAwareEntityTypesResolver", "intellij.platform.workspaceModel.ide"})
@ApiStatus.Internal
public final class WorkspaceModelCacheImpl
implements Disposable {
    private final Logger LOG$1;
    private final File cacheFile;
    private final EntityStorageSerializer serializer;
    private final SingleAlarm saveAlarm;
    private final Project project;
    private static final Logger LOG;
    private static final File cacheDir;
    private static final AtomicBoolean cachesInvalidated;
    private static final File invalidateCachesMarkerFile;
    public static final Companion Companion;

    @Override
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final TypedEntityStorage loadCache() {
        try {
            TypedEntityStorageBuilder typedEntityStorageBuilder;
            if (!this.cacheFile.exists()) {
                return null;
            }
            if (invalidateCachesMarkerFile.exists() && this.cacheFile.lastModified() < invalidateCachesMarkerFile.lastModified()) {
                this.LOG$1.info("Skipping project model cache since '" + invalidateCachesMarkerFile + "' is present and newer than cache file '" + this.cacheFile + '\'');
                FileUtil.delete(this.cacheFile);
                return null;
            }
            this.LOG$1.info("Loading project model cache from " + this.cacheFile);
            Stopwatch stopWatch = Stopwatch.createStarted();
            Object object = this.cacheFile;
            boolean bl = false;
            object = new FileInputStream((File)object);
            bl = false;
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)object;
                boolean bl2 = false;
                typedEntityStorageBuilder = this.serializer.deserializeCache(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            TypedEntityStorageBuilder builder2 = typedEntityStorageBuilder;
            this.LOG$1.info("Loaded project model cache from " + this.cacheFile + " in " + stopWatch.stop());
            return builder2;
        }
        catch (Throwable t) {
            this.LOG$1.warn("Could not deserialize project model cache from " + this.cacheFile, t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveCache(TypedEntityStorage storage) {
        File file2 = FileUtil.createTempFile(this.cacheFile.getParentFile(), "cache", ".tmp");
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtil.createTempFile(\u2026entFile, \"cache\", \".tmp\")");
        File tmpFile = file2;
        try {
            Object object = tmpFile;
            boolean bl = false;
            object = new FileOutputStream((File)object);
            bl = false;
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)object;
                boolean bl2 = false;
                this.serializer.serializeCache(it, storage);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            try {
                Files.move(tmpFile.toPath(), this.cacheFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AtomicMoveNotSupportedException e) {
                this.LOG$1.warn(e);
                Files.move(tmpFile.toPath(), this.cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        finally {
            tmpFile.delete();
        }
    }

    public WorkspaceModelCacheImpl(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        String it;
        int n;
        int n2;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.project = project2;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(javaClass)");
        this.LOG$1 = logger;
        this.serializer = new KryoEntityStorageSerializer(PluginAwareEntityTypesResolver.INSTANCE);
        Disposer.register(parentDisposable, this);
        Hasher hasher = Hashing.sha256().newHasher();
        String string2 = this.project.getBasePath();
        if (string2 != null) {
            string = string2;
            n2 = 0;
            n = 0;
            it = string;
            boolean bl = false;
            hasher.putString((CharSequence)it, Charsets.UTF_8);
        }
        String string3 = this.project.getProjectFilePath();
        if (string3 != null) {
            string = string3;
            n2 = 0;
            n = 0;
            it = string;
            boolean bl = false;
            hasher.putString((CharSequence)it, Charsets.UTF_8);
        }
        hasher.putString((CharSequence)this.project.getLocationHash(), Charsets.UTF_8);
        hasher.putString((CharSequence)this.serializer.getClass().getName(), Charsets.UTF_8);
        hasher.putString((CharSequence)this.serializer.getSerializerDataFormatVersion(), Charsets.UTF_8);
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = hasher.hash().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"hasher.hash().toString()");
        string = string4;
        n2 = 0;
        n = 20;
        StringBuilder stringBuilder2 = stringBuilder;
        File file2 = cacheDir;
        WorkspaceModelCacheImpl workspaceModelCacheImpl = this;
        boolean bl = false;
        String string5 = string;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n2, n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string7 = string6;
        String string8 = stringBuilder2.append(string7).append(".data").toString();
        File file3 = file2;
        workspaceModelCacheImpl.cacheFile = new File(file3, string8);
        this.LOG$1.info("Project Model Cache at " + this.cacheFile);
        WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(this.project);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(this);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        workspaceModelTopics.subscribeImmediately(messageBusConnection, new WorkspaceModelChangeListener(){

            @Override
            public void changed(@NotNull EntityStoreChanged event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                UtilsKt.bracket(LOG$1, this.getClass().getSimpleName() + ".EntityStoreChange", (Function0)new Function0<Unit>(this){
                    final /* synthetic */ 3 this$0;

                    public final void invoke() {
                        SingleAlarm.request$default(WorkspaceModelCacheImpl.access$getSaveAlarm$p(this.this$0.this), false, 0, 3, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }

            @Override
            public void beforeChanged(@NotNull EntityStoreChanged event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                WorkspaceModelChangeListener.DefaultImpls.beforeChanged(this, event);
            }
        });
        this.saveAlarm = SingleAlarmKt.pooledThreadSingleAlarm(1000, this, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WorkspaceModelCacheImpl this$0;

            public final void invoke() {
                TypedEntityStorage storage = WorkspaceModel.Companion.getInstance(WorkspaceModelCacheImpl.access$getProject$p(this.this$0)).getEntityStore().getCurrent();
                if (!WorkspaceModelCacheImpl.access$getCachesInvalidated$cp().get()) {
                    WorkspaceModelCacheImpl.access$getLOG$p(this.this$0).info("Saving project model cache to " + WorkspaceModelCacheImpl.access$getCacheFile$p(this.this$0));
                    WorkspaceModelCacheImpl.access$saveCache(this.this$0, storage);
                }
                if (WorkspaceModelCacheImpl.access$getCachesInvalidated$cp().get()) {
                    FileUtil.delete(WorkspaceModelCacheImpl.access$getCacheFile$p(this.this$0));
                }
            }
            {
                this.this$0 = workspaceModelCacheImpl;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceModelCacheImpl.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        cacheDir = PathManagerEx.getAppSystemDir().resolve("projectModelCache").toFile();
        cachesInvalidated = new AtomicBoolean(false);
        invalidateCachesMarkerFile = new File(cacheDir, ".invalidate");
    }

    public static final /* synthetic */ SingleAlarm access$getSaveAlarm$p(WorkspaceModelCacheImpl $this) {
        return $this.saveAlarm;
    }

    public static final /* synthetic */ Project access$getProject$p(WorkspaceModelCacheImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ File access$getCacheFile$p(WorkspaceModelCacheImpl $this) {
        return $this.cacheFile;
    }

    public static final /* synthetic */ void access$saveCache(WorkspaceModelCacheImpl $this, TypedEntityStorage storage) {
        $this.saveCache(storage);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u001e\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/workspace/ide/WorkspaceModelCacheImpl$PluginAwareEntityTypesResolver;", "Lcom/intellij/workspace/api/EntityTypesResolver;", "()V", "getPluginId", "", "clazz", "Ljava/lang/Class;", "resolveClass", "name", "pluginId", "intellij.platform.workspaceModel.ide"})
    private static final class PluginAwareEntityTypesResolver
    implements EntityTypesResolver {
        public static final PluginAwareEntityTypesResolver INSTANCE;

        @Override
        @Nullable
        public String getPluginId(@NotNull Class<?> clazz) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            PluginId pluginId = PluginManager.getInstance().getPluginOrPlatformByClassName(clazz.getName());
            return pluginId != null ? pluginId.getIdString() : null;
        }

        @Override
        @NotNull
        public Class<?> resolveClass(@NotNull String name, @Nullable String pluginId) {
            ClassLoader classLoader;
            PluginId id2;
            PluginId pluginId2;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            String string = pluginId;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                pluginId2 = PluginId.getId(it);
            } else {
                pluginId2 = id2 = null;
            }
            if (id2 == null) {
                classLoader = ApplicationManager.class.getClassLoader();
            } else {
                IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin(id2);
                if (ideaPluginDescriptor == null) {
                    String string3 = "Could not resolve plugin by id '" + pluginId + "' for type: " + name;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptor, (String)"PluginManagerCore.getPlu\u2026uginId' for type: $name\")");
                IdeaPluginDescriptor plugin = ideaPluginDescriptor;
                classLoader = plugin.getPluginClassLoader();
                if (classLoader == null) {
                    classLoader = ApplicationManager.class.getClassLoader();
                }
            }
            ClassLoader classloader = classLoader;
            Class<?> clazz = classloader.loadClass(name);
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"classloader.loadClass(name)");
            return clazz;
        }

        private PluginAwareEntityTypesResolver() {
        }

        static {
            PluginAwareEntityTypesResolver pluginAwareEntityTypesResolver;
            INSTANCE = pluginAwareEntityTypesResolver = new PluginAwareEntityTypesResolver();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/workspace/ide/WorkspaceModelCacheImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "cacheDir", "Ljava/io/File;", "kotlin.jvm.PlatformType", "cachesInvalidated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "invalidateCachesMarkerFile", "invalidateCaches", "", "intellij.platform.workspaceModel.ide"})
    public static final class Companion {
        public final void invalidateCaches() {
            LOG.info("Invalidating project model caches by creating " + invalidateCachesMarkerFile);
            cachesInvalidated.set(true);
            try {
                FileUtil.createDirectory(cacheDir);
                FileUtil.writeToFile(invalidateCachesMarkerFile, String.valueOf(System.currentTimeMillis()));
            }
            catch (Throwable t) {
                LOG.warn("Cannot update the invalidation marker file", t);
            }
            ApplicationManager.getApplication().executeOnPooledThread(invalidateCaches.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

