/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.ide;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBus;
import com.intellij.workspace.api.EntityChange;
import com.intellij.workspace.api.EntityStoreChanged;
import com.intellij.workspace.api.EntityStoreImpl;
import com.intellij.workspace.api.TypedEntity;
import com.intellij.workspace.api.TypedEntityStorage;
import com.intellij.workspace.api.TypedEntityStorageBuilder;
import com.intellij.workspace.api.TypedEntityStore;
import com.intellij.workspace.ide.WorkspaceModel;
import com.intellij.workspace.ide.WorkspaceModelCacheImpl;
import com.intellij.workspace.ide.WorkspaceModelInitialTestContent;
import com.intellij.workspace.ide.WorkspaceModelTopics;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J/\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u00130\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0017J'\u0010\u0018\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u00130\u0015H\u0016\u00a2\u0006\u0002\u0010\u0019J'\u0010\u001a\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u00130\u0015H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/workspace/ide/WorkspaceModelImpl;", "Lcom/intellij/workspace/ide/WorkspaceModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/intellij/workspace/ide/WorkspaceModelCacheImpl;", "cacheEnabled", "", "entityStore", "Lcom/intellij/workspace/api/EntityStoreImpl;", "getEntityStore", "()Lcom/intellij/workspace/api/EntityStoreImpl;", "projectEntities", "Lcom/intellij/workspace/api/TypedEntityStorageBuilder;", "dispose", "", "doUpdateProject", "R", "updater", "Lkotlin/Function1;", "notify", "(Lkotlin/jvm/functions/Function1;Z)Ljava/lang/Object;", "updateProjectModel", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "updateProjectModelSilent", "EntityStoreChangedImpl", "ProjectModelEntityStore", "intellij.platform.workspaceModel.ide"})
public final class WorkspaceModelImpl
implements WorkspaceModel,
Disposable {
    private final TypedEntityStorageBuilder projectEntities;
    private final boolean cacheEnabled;
    private final WorkspaceModelCacheImpl cache;
    @NotNull
    private final EntityStoreImpl entityStore;

    @Override
    @NotNull
    public EntityStoreImpl getEntityStore() {
        return this.entityStore;
    }

    @Override
    public <R> R updateProjectModel(@NotNull Function1<? super TypedEntityStorageBuilder, ? extends R> updater2) {
        Intrinsics.checkParameterIsNotNull(updater2, (String)"updater");
        return this.doUpdateProject(updater2, true);
    }

    @Override
    public <R> R updateProjectModelSilent(@NotNull Function1<? super TypedEntityStorageBuilder, ? extends R> updater2) {
        Intrinsics.checkParameterIsNotNull(updater2, (String)"updater");
        return this.doUpdateProject(updater2, false);
    }

    private final <R> R doUpdateProject(Function1<? super TypedEntityStorageBuilder, ? extends R> updater2, boolean notify) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        TypedEntityStorage before = this.projectEntities.toStorage();
        Object result2 = updater2.invoke((Object)this.projectEntities);
        Map<Class<?>, List<EntityChange<?>>> changes = this.projectEntities.collectChanges(before);
        this.projectEntities.resetChanges();
        if (notify) {
            this.getEntityStore().replace(this.projectEntities.toStorage(), changes);
        } else {
            EntityStoreImpl entityStoreImpl = this.getEntityStore();
            if (entityStoreImpl == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspace.ide.WorkspaceModelImpl.ProjectModelEntityStore");
            }
            ((ProjectModelEntityStore)entityStoreImpl).replaceSilent(this.projectEntities.toStorage(), changes);
        }
        return (R)result2;
    }

    @Override
    public void dispose() {
    }

    public WorkspaceModelImpl(@NotNull Project project2) {
        TypedEntityStorage previousStorage;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        this.cacheEnabled = !application.isUnitTestMode();
        this.cache = this.cacheEnabled ? new WorkspaceModelCacheImpl(project2, this) : null;
        TypedEntityStorage initialContent = WorkspaceModelInitialTestContent.INSTANCE.pop$intellij_platform_workspaceModel_ide();
        this.projectEntities = initialContent != null ? TypedEntityStorageBuilder.Companion.from(initialContent) : (this.cache != null ? ((previousStorage = this.cache.loadCache()) != null ? TypedEntityStorageBuilder.Companion.from(previousStorage) : TypedEntityStorageBuilder.Companion.create()) : TypedEntityStorageBuilder.Companion.create());
        this.entityStore = new ProjectModelEntityStore(project2, this.projectEntities.toStorage());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J:\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052 \u0010\r\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00100\u000eH\u0014J:\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052 \u0010\r\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00100\u000eH\u0014J0\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00052 \u0010\r\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00100\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/workspace/ide/WorkspaceModelImpl$ProjectModelEntityStore;", "Lcom/intellij/workspace/api/EntityStoreImpl;", "project", "Lcom/intellij/openapi/project/Project;", "initialStorage", "Lcom/intellij/workspace/api/TypedEntityStorage;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/workspace/api/TypedEntityStorage;)V", "notificationsEnabled", "", "onBeforeChanged", "", "before", "after", "changes", "", "Ljava/lang/Class;", "", "Lcom/intellij/workspace/api/EntityChange;", "onChanged", "replaceSilent", "newStorage", "intellij.platform.workspaceModel.ide"})
    private static final class ProjectModelEntityStore
    extends EntityStoreImpl {
        private boolean notificationsEnabled;
        private final Project project;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void replaceSilent(@NotNull TypedEntityStorage newStorage, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
            Intrinsics.checkParameterIsNotNull((Object)newStorage, (String)"newStorage");
            Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
            this.notificationsEnabled = false;
            try {
                this.replace(newStorage, changes);
            }
            finally {
                this.notificationsEnabled = true;
            }
        }

        @Override
        protected void onBeforeChanged(@NotNull TypedEntityStorage before, @NotNull TypedEntityStorage after2, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
            Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
            Intrinsics.checkParameterIsNotNull((Object)after2, (String)"after");
            Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
            if (this.project.isDisposed() || Disposer.isDisposing(this.project) || !this.notificationsEnabled) {
                return;
            }
            WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(this.project);
            MessageBus messageBus = this.project.getMessageBus();
            Intrinsics.checkExpressionValueIsNotNull((Object)messageBus, (String)"project.messageBus");
            workspaceModelTopics.syncPublisher(messageBus).beforeChanged(new EntityStoreChangedImpl(this, before, after2, changes));
        }

        @Override
        protected void onChanged(@NotNull TypedEntityStorage before, @NotNull TypedEntityStorage after2, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
            Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
            Intrinsics.checkParameterIsNotNull((Object)after2, (String)"after");
            Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
            if (this.project.isDisposed() || Disposer.isDisposing(this.project) || !this.notificationsEnabled) {
                return;
            }
            WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(this.project);
            MessageBus messageBus = this.project.getMessageBus();
            Intrinsics.checkExpressionValueIsNotNull((Object)messageBus, (String)"project.messageBus");
            workspaceModelTopics.syncPublisher(messageBus).changed(new EntityStoreChangedImpl(this, before, after2, changes));
        }

        public ProjectModelEntityStore(@NotNull Project project2, @NotNull TypedEntityStorage initialStorage) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)initialStorage, (String)"initialStorage");
            super(initialStorage);
            this.project = project2;
            this.notificationsEnabled = true;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012 \u0010\u0007\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n0\b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0011H\u0016J,\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u000b0\n\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\tH\u0016R(\u0010\u0007\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/workspace/ide/WorkspaceModelImpl$EntityStoreChangedImpl;", "Lcom/intellij/workspace/api/EntityStoreChanged;", "entityStore", "Lcom/intellij/workspace/api/TypedEntityStore;", "storageBefore", "Lcom/intellij/workspace/api/TypedEntityStorage;", "storageAfter", "changes", "", "Ljava/lang/Class;", "", "Lcom/intellij/workspace/api/EntityChange;", "(Lcom/intellij/workspace/api/TypedEntityStore;Lcom/intellij/workspace/api/TypedEntityStorage;Lcom/intellij/workspace/api/TypedEntityStorage;Ljava/util/Map;)V", "getStorageAfter", "()Lcom/intellij/workspace/api/TypedEntityStorage;", "getStorageBefore", "getAllChanges", "Lkotlin/sequences/Sequence;", "getChanges", "T", "Lcom/intellij/workspace/api/TypedEntity;", "entityClass", "intellij.platform.workspaceModel.ide"})
    private static final class EntityStoreChangedImpl
    extends EntityStoreChanged {
        @NotNull
        private final TypedEntityStorage storageBefore;
        @NotNull
        private final TypedEntityStorage storageAfter;
        private final Map<Class<?>, List<EntityChange<?>>> changes;

        @Override
        @NotNull
        public <T extends TypedEntity> List<EntityChange<T>> getChanges(@NotNull Class<T> entityClass) {
            List list2;
            Intrinsics.checkParameterIsNotNull(entityClass, (String)"entityClass");
            List list3 = this.changes.get(entityClass);
            if (!(list3 instanceof List)) {
                list3 = list2 = null;
            }
            if (list3 == null) {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        @Override
        @NotNull
        public Sequence<EntityChange<?>> getAllChanges() {
            return SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.changes.values()));
        }

        @Override
        @NotNull
        public TypedEntityStorage getStorageBefore() {
            return this.storageBefore;
        }

        @Override
        @NotNull
        public TypedEntityStorage getStorageAfter() {
            return this.storageAfter;
        }

        public EntityStoreChangedImpl(@NotNull TypedEntityStore entityStore2, @NotNull TypedEntityStorage storageBefore, @NotNull TypedEntityStorage storageAfter, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
            Intrinsics.checkParameterIsNotNull((Object)entityStore2, (String)"entityStore");
            Intrinsics.checkParameterIsNotNull((Object)storageBefore, (String)"storageBefore");
            Intrinsics.checkParameterIsNotNull((Object)storageAfter, (String)"storageAfter");
            Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
            super(entityStore2);
            this.storageBefore = storageBefore;
            this.storageAfter = storageAfter;
            this.changes = changes;
        }
    }
}

