/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.jps;

import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.workspace.jps.FakeDirectoryBasedStateSplitter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0007"}, d2={"getProjectStateStorage", "Lcom/intellij/configurationStore/StateStorageBase;", "Lcom/intellij/configurationStore/StateMap;", "filePath", "", "store", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "intellij.platform.workspaceModel.ide"})
public final class JpsProjectModelSynchronizerKt {
    @NotNull
    public static final StateStorageBase<StateMap> getProjectStateStorage(@NotNull String filePath2, @NotNull IProjectStore store) {
        Intrinsics.checkParameterIsNotNull((Object)filePath2, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        String collapsedPath = null;
        Class<StateSplitterEx> splitterClass = null;
        if (FileUtil.extensionEquals(filePath2, "ipr")) {
            collapsedPath = "$PROJECT_FILE$";
            splitterClass = StateSplitterEx.class;
        } else {
            String string = PathUtil.getFileName(filePath2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtil.getFileName(filePath)");
            String fileName = string;
            String string2 = PathUtil.getParentPath(filePath2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtil.getParentPath(filePath)");
            String parentPath = string2;
            if (Intrinsics.areEqual((Object)PathUtil.getFileName(parentPath), (Object)".idea")) {
                collapsedPath = fileName;
                splitterClass = StateSplitterEx.class;
            } else {
                String string3 = PathUtil.getParentPath(parentPath);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"PathUtil.getParentPath(parentPath)");
                String grandParentPath = string3;
                if (Intrinsics.areEqual((Object)PathUtil.getFileName(grandParentPath), (Object)".idea") ^ true) {
                    String string4 = filePath2 + " is not under .idea directory";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string4.toString());
                }
                String string5 = PathUtil.getFileName(parentPath);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"PathUtil.getFileName(parentPath)");
                collapsedPath = string5;
                splitterClass = FakeDirectoryBasedStateSplitter.class;
            }
        }
        FileStorageAnnotation storageSpec = new FileStorageAnnotation(collapsedPath, false, splitterClass);
        StateStorage stateStorage = store.getStorageManager().getStateStorage((Storage)storageSpec);
        if (stateStorage == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageBase<com.intellij.configurationStore.StateMap>");
        }
        return (StateStorageBase)stateStorage;
    }
}

