/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.legacyBridge.libraries.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspace.UtilsKt;
import com.intellij.workspace.api.ContentRootEntity;
import com.intellij.workspace.api.EntityStoreChanged;
import com.intellij.workspace.api.JavaModuleSettingsEntity;
import com.intellij.workspace.api.LibraryEntity;
import com.intellij.workspace.api.LibraryRoot;
import com.intellij.workspace.api.SdkEntity;
import com.intellij.workspace.api.SourceRootEntity;
import com.intellij.workspace.api.TypedEntity;
import com.intellij.workspace.api.TypedEntityStorage;
import com.intellij.workspace.api.VirtualFileUrl;
import com.intellij.workspace.api.VirtualFileUrlManager;
import com.intellij.workspace.ide.WorkspaceModelChangeListener;
import com.intellij.workspace.ide.WorkspaceModelTopics;
import com.intellij.workspace.legacyBridge.libraries.libraries.LegacyBridgeRootsWatcher$WhenMappings;
import com.intellij.workspace.legacyBridge.libraries.libraries.LegacyModelRootsFilePointers;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0019H\u0016J2\u0010\u001b\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u001dH\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/workspace/legacyBridge/libraries/libraries/LegacyBridgeRootsWatcher;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "currentJarDirectories", "", "Lcom/intellij/workspace/api/VirtualFileUrl;", "currentRecursiveJarDirectories", "currentRoots", "getProject", "()Lcom/intellij/openapi/project/Project;", "rootFilePointers", "Lcom/intellij/workspace/legacyBridge/libraries/libraries/LegacyModelRootsFilePointers;", "rootsValidityChangedListener", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerListener;", "getRootsValidityChangedListener", "()Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerListener;", "virtualFilePointerManager", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerManager;", "kotlin.jvm.PlatformType", "clear", "", "dispose", "syncNewRootsToContainer", "newRoots", "", "newJarDirectories", "newRecursiveJarDirectories", "Companion", "intellij.platform.workspaceModel.ide"})
@ApiStatus.Internal
public final class LegacyBridgeRootsWatcher
implements Disposable {
    private final Logger LOG;
    private final VirtualFilePointerManager virtualFilePointerManager;
    private final LegacyModelRootsFilePointers rootFilePointers;
    private final Map<VirtualFileUrl, Disposable> currentRoots;
    private final Map<VirtualFileUrl, Disposable> currentJarDirectories;
    private final Map<VirtualFileUrl, Disposable> currentRecursiveJarDirectories;
    @NotNull
    private final Project project;
    public static final Companion Companion = new Companion(null);

    private final VirtualFilePointerListener getRootsValidityChangedListener() {
        ProjectRootManagerImpl projectRootManagerImpl = ProjectRootManagerImpl.getInstanceImpl(this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManagerImpl, (String)"ProjectRootManagerImpl.getInstanceImpl(project)");
        VirtualFilePointerListener virtualFilePointerListener = projectRootManagerImpl.getRootsValidityChangedListener();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFilePointerListener, (String)"ProjectRootManagerImpl.g\u2026tsValidityChangedListener");
        return virtualFilePointerListener;
    }

    private final void syncNewRootsToContainer(Set<VirtualFileUrl> newRoots, Set<VirtualFileUrl> newJarDirectories, Set<VirtualFileUrl> newRecursiveJarDirectories) {
        boolean $i$f$debug;
        Logger $this$debug$iv;
        Disposable dispose2;
        String string;
        Logger logger;
        boolean $i$f$debug2;
        Exception e$iv;
        Logger $this$debug$iv2;
        if (Intrinsics.areEqual(this.currentRoots.keySet(), newRoots) && Intrinsics.areEqual(this.currentJarDirectories.keySet(), newJarDirectories) && Intrinsics.areEqual(this.currentRecursiveJarDirectories.keySet(), newRecursiveJarDirectories)) {
            return;
        }
        for (VirtualFileUrl removed : SetsKt.minus(this.currentRoots.keySet(), (Iterable)newRoots)) {
            $this$debug$iv2 = this.LOG;
            e$iv = null;
            $i$f$debug2 = false;
            if ($this$debug$iv2.isDebugEnabled()) {
                logger = $this$debug$iv2;
                boolean bl = false;
                string = "Removed root " + removed;
                logger.debug(string, e$iv);
            }
            Disposer.dispose((Disposable)MapsKt.getValue(this.currentRoots, (Object)removed));
            this.currentRoots.remove(removed);
        }
        for (VirtualFileUrl removedJarDirectory : SetsKt.minus(this.currentJarDirectories.keySet(), (Iterable)newJarDirectories)) {
            $this$debug$iv2 = this.LOG;
            e$iv = null;
            $i$f$debug2 = false;
            if ($this$debug$iv2.isDebugEnabled()) {
                logger = $this$debug$iv2;
                boolean bl = false;
                string = "Removed jar directory root " + removedJarDirectory;
                logger.debug(string, e$iv);
            }
            Disposer.dispose((Disposable)MapsKt.getValue(this.currentJarDirectories, (Object)removedJarDirectory));
            this.currentJarDirectories.remove(removedJarDirectory);
        }
        for (VirtualFileUrl removedRecursiveJarDirectory : SetsKt.minus(this.currentRecursiveJarDirectories.keySet(), (Iterable)newRecursiveJarDirectories)) {
            $this$debug$iv2 = this.LOG;
            e$iv = null;
            $i$f$debug2 = false;
            if ($this$debug$iv2.isDebugEnabled()) {
                logger = $this$debug$iv2;
                boolean bl = false;
                string = "Removed recursive jar directory root " + removedRecursiveJarDirectory;
                logger.debug(string, e$iv);
            }
            Disposer.dispose((Disposable)MapsKt.getValue(this.currentRecursiveJarDirectories, (Object)removedRecursiveJarDirectory));
            this.currentRecursiveJarDirectories.remove(removedRecursiveJarDirectory);
        }
        for (VirtualFileUrl added : SetsKt.minus(newRoots, (Iterable)this.currentRoots.keySet())) {
            Intrinsics.checkExpressionValueIsNotNull((Object)Disposer.newDisposable(), (String)"Disposer.newDisposable()");
            this.currentRoots.put(added, dispose2);
            this.virtualFilePointerManager.create(added.getUrl(), dispose2, this.getRootsValidityChangedListener());
            $this$debug$iv = this.LOG;
            Exception e$iv2 = null;
            $i$f$debug = false;
            if (!$this$debug$iv.isDebugEnabled()) continue;
            logger = $this$debug$iv;
            boolean bl = false;
            string = "Added root " + added;
            logger.debug(string, e$iv2);
        }
        for (VirtualFileUrl addedJarDirectory : SetsKt.minus(newJarDirectories, (Iterable)this.currentJarDirectories.keySet())) {
            Intrinsics.checkExpressionValueIsNotNull((Object)Disposer.newDisposable(), (String)"Disposer.newDisposable()");
            this.currentRoots.put(addedJarDirectory, dispose2);
            this.virtualFilePointerManager.createDirectoryPointer(addedJarDirectory.getUrl(), false, dispose2, this.getRootsValidityChangedListener());
            $this$debug$iv = this.LOG;
            Exception e$iv3 = null;
            $i$f$debug = false;
            if (!$this$debug$iv.isDebugEnabled()) continue;
            logger = $this$debug$iv;
            boolean bl = false;
            string = "Added jar directory " + addedJarDirectory;
            logger.debug(string, e$iv3);
        }
        for (VirtualFileUrl addedRecursiveJarDirectory : SetsKt.minus(newRecursiveJarDirectories, (Iterable)this.currentRecursiveJarDirectories.keySet())) {
            Intrinsics.checkExpressionValueIsNotNull((Object)Disposer.newDisposable(), (String)"Disposer.newDisposable()");
            this.currentRoots.put(addedRecursiveJarDirectory, dispose2);
            this.virtualFilePointerManager.createDirectoryPointer(addedRecursiveJarDirectory.getUrl(), true, dispose2, this.getRootsValidityChangedListener());
            $this$debug$iv = this.LOG;
            Exception e$iv4 = null;
            $i$f$debug = false;
            if (!$this$debug$iv.isDebugEnabled()) continue;
            logger = $this$debug$iv;
            boolean bl = false;
            string = "Added recursive jar directory " + addedRecursiveJarDirectory;
            logger.debug(string, e$iv4);
        }
    }

    public final void clear() {
        Disposable it;
        Iterable $this$forEach$iv = this.currentRoots.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose(it);
        }
        $this$forEach$iv = this.currentJarDirectories.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose(it);
        }
        $this$forEach$iv = this.currentRecursiveJarDirectories.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose(it);
        }
        this.currentRoots.clear();
        this.currentJarDirectories.clear();
        this.currentRecursiveJarDirectories.clear();
        this.rootFilePointers.clear();
    }

    @Override
    public void dispose() {
        this.clear();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public LegacyBridgeRootsWatcher(@NotNull Project project2) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(javaClass)");
        this.LOG = logger;
        this.virtualFilePointerManager = VirtualFilePointerManager.getInstance();
        this.rootFilePointers = new LegacyModelRootsFilePointers(this.project);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"project.messageBus.connect()");
        MessageBusConnection messageBusConnection2 = messageBusConnection;
        WorkspaceModelTopics.Companion.getInstance(this.project).subscribeImmediately(messageBusConnection2, new WorkspaceModelChangeListener(){

            @Override
            public void changed(@NotNull EntityStoreChanged event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                UtilsKt.bracket(LOG, "LibraryRootsWatcher.EntityStoreChange", (Function0)new Function0<Unit>(this, event){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ EntityStoreChanged $event;

                    public final void invoke() {
                        JavaModuleSettingsEntity javaSettings2;
                        boolean bl;
                        Iterator<LibraryRoot> iterator2;
                        TypedEntity it;
                        boolean bl2 = false;
                        Set roots = new LinkedHashSet<E>();
                        boolean bl3 = false;
                        Set jarDirectories = new LinkedHashSet<E>();
                        boolean bl4 = false;
                        Set recursiveJarDirectories = new LinkedHashSet<E>();
                        TypedEntityStorage s = this.$event.getStorageAfter();
                        Object $this$forEach$iv = s.entities(SourceRootEntity.class);
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            it = (SourceRootEntity)element$iv;
                            boolean bl5 = false;
                            roots.add(it.getUrl());
                        }
                        $this$forEach$iv = s.entities(ContentRootEntity.class);
                        $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            it = (ContentRootEntity)element$iv;
                            boolean bl6 = false;
                            roots.add(it.getUrl());
                            roots.addAll((Collection)it.getExcludedUrls());
                        }
                        $this$forEach$iv = s.entities(LibraryEntity.class);
                        $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            it = (LibraryEntity)element$iv;
                            boolean bl7 = false;
                            roots.addAll((Collection)it.getExcludedRoots());
                            iterator2 = it.getRoots().iterator();
                            while (iterator2.hasNext()) {
                                boolean bl8;
                                LibraryRoot root = iterator2.next();
                                switch (LegacyBridgeRootsWatcher$WhenMappings.$EnumSwitchMapping$0[root.getInclusionOptions().ordinal()]) {
                                    case 1: {
                                        bl8 = roots.add(root.getUrl());
                                        break;
                                    }
                                    case 2: {
                                        bl8 = jarDirectories.add(root.getUrl());
                                        break;
                                    }
                                    case 3: {
                                        bl8 = recursiveJarDirectories.add(root.getUrl());
                                        break;
                                    }
                                    default: {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                                bl = bl8;
                                boolean bl9 = false;
                                boolean bl10 = false;
                                boolean it2 = bl;
                                boolean bl11 = false;
                            }
                        }
                        $this$forEach$iv = s.entities(SdkEntity.class);
                        $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            it = (SdkEntity)element$iv;
                            boolean bl12 = false;
                            roots.add(it.getHomeUrl());
                        }
                        $this$forEach$iv = s.entities(JavaModuleSettingsEntity.class);
                        $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            javaSettings2 = (JavaModuleSettingsEntity)element$iv;
                            boolean bl13 = false;
                            if (javaSettings2.getCompilerOutput() == null) continue;
                            boolean bl14 = false;
                            bl = false;
                            Object it3 = iterator2;
                            boolean bl15 = false;
                            roots.add(it3);
                        }
                        $this$forEach$iv = s.entities(JavaModuleSettingsEntity.class);
                        $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            javaSettings2 = (JavaModuleSettingsEntity)element$iv;
                            boolean bl16 = false;
                            if (javaSettings2.getCompilerOutputForTests() == null) continue;
                            boolean bl17 = false;
                            bl = false;
                            Object it4 = iterator2;
                            boolean bl18 = false;
                            roots.add(it4);
                        }
                        LegacyBridgeRootsWatcher.access$getRootFilePointers$p(this.this$0.this).onModelChange(s);
                        LegacyBridgeRootsWatcher.access$syncNewRootsToContainer(this.this$0.this, roots, jarDirectories, recursiveJarDirectories);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$event = entityStoreChanged;
                        super(0);
                    }
                });
            }

            @Override
            public void beforeChanged(@NotNull EntityStoreChanged event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                WorkspaceModelChangeListener.DefaultImpls.beforeChanged(this, event);
            }
        });
        messageBusConnection2.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void before(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                Iterable $this$forEach$iv = events;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void oldUrl;
                    Pair<String, String> pair;
                    VFileEvent event = (VFileEvent)element$iv;
                    boolean bl = false;
                    if (this.getUrls(event) == null) {
                        continue;
                    }
                    String string = (String)pair.component1();
                    String newUrl = (String)pair.component2();
                    rootFilePointers.onVfsChange((String)oldUrl, newUrl);
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                Iterable $this$forEach$iv = events;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void oldUrl;
                    Pair<String, String> pair;
                    VFileEvent event = (VFileEvent)element$iv;
                    boolean bl = false;
                    if (this.getUrls(event) == null) {
                        continue;
                    }
                    String string = (String)pair.component1();
                    String newUrl = (String)pair.component2();
                    this.updateRoots(currentRoots, (String)oldUrl, newUrl);
                    this.updateRoots(currentJarDirectories, (String)oldUrl, newUrl);
                    this.updateRoots(currentRecursiveJarDirectories, (String)oldUrl, newUrl);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void updateRoots(Map<VirtualFileUrl, Disposable> map2, String oldUrl, String newUrl) {
                void $this$filterTo$iv$iv;
                Map $this$filter$iv = map2;
                boolean $i$f$filter = false;
                Map map3 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                void var9_11 = $this$filterTo$iv$iv;
                boolean bl = false;
                Iterator iterator2 = var9_11.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((VirtualFileUrl)it.getKey()).getUrl(), (Object)oldUrl)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map $this$forEach$iv = destination$iv$iv;
                boolean $i$f$forEach = false;
                map3 = $this$forEach$iv;
                boolean bl3 = false;
                Iterator iterator3 = map3.entrySet().iterator();
                while (iterator3.hasNext()) {
                    void url;
                    Map.Entry element$iv;
                    Map.Entry $dstr$url$disposable = element$iv = iterator3.next();
                    boolean bl4 = false;
                    Map.Entry entry = $dstr$url$disposable;
                    boolean bl5 = false;
                    VirtualFileUrl bl2 = (VirtualFileUrl)entry.getKey();
                    entry = $dstr$url$disposable;
                    bl5 = false;
                    Disposable disposable2 = (Disposable)entry.getValue();
                    map2.remove(url);
                    map2.put(VirtualFileUrlManager.INSTANCE.fromUrl(newUrl), disposable2);
                }
            }

            private final Pair<String, String> getUrls(VFileEvent event) {
                String oldUrl = null;
                String newUrl = null;
                VFileEvent vFileEvent = event;
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    String string = VfsUtilCore.pathToUrl(((VFilePropertyChangeEvent)event).getOldPath());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VfsUtilCore.pathToUrl(event.oldPath)");
                    oldUrl = string;
                    String string2 = VfsUtilCore.pathToUrl(((VFilePropertyChangeEvent)event).getNewPath());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"VfsUtilCore.pathToUrl(event.newPath)");
                    newUrl = string2;
                } else if (vFileEvent instanceof VFileMoveEvent) {
                    String string = VfsUtilCore.pathToUrl(((VFileMoveEvent)event).getOldPath());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VfsUtilCore.pathToUrl(event.oldPath)");
                    oldUrl = string;
                    String string3 = VfsUtilCore.pathToUrl(((VFileMoveEvent)event).getNewPath());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"VfsUtilCore.pathToUrl(event.newPath)");
                    newUrl = string3;
                } else {
                    return null;
                }
                return TuplesKt.to((Object)oldUrl, (Object)newUrl);
            }
        });
        LegacyBridgeRootsWatcher legacyBridgeRootsWatcher = this;
        boolean bl = false;
        legacyBridgeRootsWatcher.currentRoots = map2 = (Map)new LinkedHashMap();
        legacyBridgeRootsWatcher = this;
        bl = false;
        legacyBridgeRootsWatcher.currentJarDirectories = map2 = (Map)new LinkedHashMap();
        legacyBridgeRootsWatcher = this;
        bl = false;
        legacyBridgeRootsWatcher.currentRecursiveJarDirectories = map2 = (Map)new LinkedHashMap();
    }

    public static final /* synthetic */ void access$syncNewRootsToContainer(LegacyBridgeRootsWatcher $this, Set newRoots, Set newJarDirectories, Set newRecursiveJarDirectories) {
        $this.syncNewRootsToContainer(newRoots, newJarDirectories, newRecursiveJarDirectories);
    }

    @JvmStatic
    @NotNull
    public static final LegacyBridgeRootsWatcher getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/workspace/legacyBridge/libraries/libraries/LegacyBridgeRootsWatcher$Companion;", "", "()V", "getInstance", "Lcom/intellij/workspace/legacyBridge/libraries/libraries/LegacyBridgeRootsWatcher;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.workspaceModel.ide"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final LegacyBridgeRootsWatcher getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            LegacyBridgeRootsWatcher legacyBridgeRootsWatcher = project2.getComponent(LegacyBridgeRootsWatcher.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)legacyBridgeRootsWatcher, (String)"project.getComponent(Leg\u2026RootsWatcher::class.java)");
            return legacyBridgeRootsWatcher;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

