/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class XDebuggerSmartStepIntoHandler
extends XDebuggerSuspendedActionHandler {
    private static final Ref<Boolean> SHOW_AD = new Ref<Boolean>(true);
    private static final Logger LOG = Logger.getInstance(XDebuggerSmartStepIntoHandler.class);
    private static final String COUNTER_PROPERTY = "debugger.smart.chooser.counter";
    static final Key<SmartStepData> SMART_STEP_INPLACE_DATA = Key.create("SMART_STEP_INPLACE_DATA");

    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            XDebuggerSmartStepIntoHandler.$$$reportNull$$$0(0);
        }
        return super.isEnabled(session2, dataContext) && session2.getDebugProcess().getSmartStepIntoHandler() != null;
    }

    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        FileEditor editor;
        if (session2 == null) {
            XDebuggerSmartStepIntoHandler.$$$reportNull$$$0(1);
        }
        XSmartStepIntoHandler<?> handler2 = session2.getDebugProcess().getSmartStepIntoHandler();
        XSourcePosition position = session2.getTopFramePosition();
        if (position != null && handler2 != null && (editor = FileEditorManager.getInstance(session2.getProject()).getSelectedEditor(position.getFile())) instanceof TextEditor) {
            this.doSmartStepInto(handler2, position, session2, ((TextEditor)editor).getEditor());
            return;
        }
        session2.stepInto();
    }

    private <V extends XSmartStepIntoVariant> void doSmartStepInto(XSmartStepIntoHandler<V> handler2, XSourcePosition position, XDebugSession session2, Editor editor) {
        SmartStepData stepData = editor.getUserData(SMART_STEP_INPLACE_DATA);
        if (stepData != null) {
            stepData.stepInto(stepData.myCurrentVariant);
        } else {
            this.computeVariants(handler2, position).onSuccess(variants -> UIUtil.invokeLaterIfNeeded(() -> {
                if (!this.handleSimpleCases(handler2, (List)variants, session2)) {
                    XDebuggerSmartStepIntoHandler.choose(handler2, variants, position, session2, editor);
                }
            })).onError(throwable -> session2.stepInto());
        }
    }

    protected <V extends XSmartStepIntoVariant> Promise<List<V>> computeVariants(XSmartStepIntoHandler<V> handler2, XSourcePosition position) {
        return handler2.computeSmartStepVariantsAsync(position);
    }

    protected <V extends XSmartStepIntoVariant> boolean handleSimpleCases(XSmartStepIntoHandler<V> handler2, List<? extends V> variants, XDebugSession session2) {
        if (variants.isEmpty()) {
            handler2.stepIntoEmpty(session2);
            return true;
        }
        if (variants.size() == 1) {
            session2.smartStepInto(handler2, (XSmartStepIntoVariant)variants.get(0));
            return true;
        }
        return false;
    }

    private static <V extends XSmartStepIntoVariant> void choose(XSmartStepIntoHandler<V> handler2, List<? extends V> variants, XSourcePosition position, XDebugSession session2, Editor editor) {
        block3: {
            if (Registry.is("debugger.smart.step.inplace") && variants.stream().allMatch(v -> v.getHighlightRange() != null)) {
                try {
                    XDebuggerSmartStepIntoHandler.inplaceChoose(handler2, variants, session2, editor);
                    return;
                }
                catch (Exception e) {
                    LOG.error(e);
                    SmartStepData data2 = editor.getUserData(SMART_STEP_INPLACE_DATA);
                    if (data2 == null) break block3;
                    data2.clear();
                }
            }
        }
        XDebuggerSmartStepIntoHandler.showPopup(handler2, variants, position, session2, editor);
    }

    private static <V extends XSmartStepIntoVariant> void showPopup(final XSmartStepIntoHandler<V> handler2, List<? extends V> variants, XSourcePosition position, final XDebugSession session2, Editor editor) {
        final ScopeHighlighter highlighter = new ScopeHighlighter(editor);
        ListPopupImpl popup2 = new ListPopupImpl(session2.getProject(), new BaseListPopupStep<V>(handler2.getPopupTitle(position), variants){

            @Override
            public Icon getIconFor(V aValue) {
                return ((XSmartStepIntoVariant)aValue).getIcon();
            }

            @Override
            @NotNull
            public String getTextFor(V value2) {
                String string = ((XSmartStepIntoVariant)value2).getText();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public PopupStep onChosen(V selectedValue, boolean finalChoice) {
                session2.smartStepInto(handler2, selectedValue);
                highlighter.dropHighlight();
                return FINAL_CHOICE;
            }

            @Override
            public void canceled() {
                highlighter.dropHighlight();
                super.canceled();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler$1", "getTextFor"));
            }
        });
        DebuggerUIUtil.registerExtraHandleShortcuts(popup2, SHOW_AD, "StepInto", "SmartStepInto");
        UIUtil.maybeInstall(popup2.getList().getInputMap(0), "selectNextRow", KeyStroke.getKeyStroke(9, 0));
        popup2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object selectedValue = ObjectUtils.doIfCast(e.getSource(), JBList.class, it -> it.getSelectedValue());
                    XDebuggerSmartStepIntoHandler.highlightVariant(ObjectUtils.tryCast(selectedValue, XSmartStepIntoVariant.class), highlighter);
                }
            }
        });
        XDebuggerSmartStepIntoHandler.highlightVariant(ObjectUtils.tryCast(ContainerUtil.getFirstItem(variants), XSmartStepIntoVariant.class), highlighter);
        DebuggerUIUtil.showPopupForEditorLine(popup2, editor, position.getLine());
    }

    private static void highlightVariant(@Nullable XSmartStepIntoVariant variant, @NotNull ScopeHighlighter highlighter) {
        TextRange range2;
        if (highlighter == null) {
            XDebuggerSmartStepIntoHandler.$$$reportNull$$$0(2);
        }
        TextRange textRange = range2 = variant != null ? variant.getHighlightRange() : null;
        if (range2 != null) {
            highlighter.highlight(Pair.create(range2, Collections.singletonList(range2)));
        }
    }

    private static <V extends XSmartStepIntoVariant> void inplaceChoose(XSmartStepIntoHandler<V> handler2, List<? extends V> variants, final XDebugSession session2, final Editor editor) {
        HighlightManager highlightManager = HighlightManager.getInstance(session2.getProject());
        SmartStepData data2 = new SmartStepData(handler2, variants, session2, editor);
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.SMART_STEP_INTO_TARGET);
        EditorHyperlinkSupport hyperlinkSupport = EditorHyperlinkSupport.get(editor);
        for (SmartStepData.VariantInfo info : data2.myVariants) {
            TextRange range2 = ((XSmartStepIntoVariant)info.myVariant).getHighlightRange();
            if (range2 == null) continue;
            SmartList highlighters = new SmartList();
            highlightManager.addOccurrenceHighlight(editor, range2.getStartOffset(), range2.getEndOffset(), attributes, 5, highlighters, null);
            RangeHighlighter highlighter = (RangeHighlighter)highlighters.get(0);
            hyperlinkSupport.createHyperlink(highlighter, project2 -> data2.stepInto(info));
            data2.myHighlighters.add(highlighter);
        }
        data2.myVariants.stream().filter(v -> v.myVariant == variants.get(0)).findFirst().ifPresent(data2::select);
        LOG.assertTrue(data2.myCurrentVariant != null);
        editor.putUserData(SMART_STEP_INPLACE_DATA, data2);
        session2.updateExecutionPosition();
        IdeFocusManager.getGlobalInstance().requestFocus(editor.getContentComponent(), true);
        XDebuggerSmartStepIntoHandler.showInfoHint(editor, data2);
        session2.addSessionListener(new XDebugSessionListener(){

            void onAnyEvent() {
                session2.removeSessionListener(this);
                UIUtil.invokeLaterIfNeeded(() -> {
                    SmartStepData stepData = editor.getUserData(SMART_STEP_INPLACE_DATA);
                    if (stepData != null) {
                        stepData.clear();
                    }
                });
            }

            @Override
            public void sessionPaused() {
                this.onAnyEvent();
            }

            @Override
            public void sessionResumed() {
                this.onAnyEvent();
            }

            @Override
            public void sessionStopped() {
                this.onAnyEvent();
            }

            @Override
            public void stackFrameChanged() {
                this.onAnyEvent();
            }

            @Override
            public void settingsChanged() {
                this.onAnyEvent();
            }
        });
    }

    private static <V extends XSmartStepIntoVariant> void showInfoHint(Editor editor, SmartStepData<V> data2) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        int counter = propertiesComponent.getInt(COUNTER_PROPERTY, 0);
        if (counter < 3) {
            LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel(XDebuggerBundle.message("message.smart.step", new Object[0])));
            JComponent component2 = HintManagerImpl.getExternalComponent(editor);
            Point convertedPoint = SwingUtilities.convertPoint(editor.getContentComponent(), ((SmartStepData)data2).myCurrentVariant.myStartPoint, component2);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, convertedPoint, 40, 0, false, (short)1);
            propertiesComponent.setValue(COUNTER_PROPERTY, counter + 1, 0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightVariant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class EnterHandler
    extends SmartStepEditorActionHandler {
        EnterHandler(EditorActionHandler original) {
            super(original);
        }

        @Override
        protected void myPerform(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext, SmartStepData stepData) {
            if (editor == null) {
                EnterHandler.$$$reportNull$$$0(0);
            }
            stepData.stepInto(stepData.myCurrentVariant);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler$EnterHandler", "myPerform"));
        }
    }

    static class EscHandler
    extends SmartStepEditorActionHandler {
        EscHandler(EditorActionHandler original) {
            super(original);
        }

        @Override
        protected void myPerform(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext, SmartStepData stepData) {
            if (editor == null) {
                EscHandler.$$$reportNull$$$0(0);
            }
            editor.putUserData(SMART_STEP_INPLACE_DATA, null);
            if (this.myOriginalHandler.isEnabled(editor, caret, dataContext)) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler$EscHandler", "myPerform"));
        }
    }

    static class RightHandler
    extends SmartStepEditorActionHandler {
        RightHandler(EditorActionHandler original) {
            super(original);
        }

        @Override
        protected void myPerform(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext, SmartStepData stepData) {
            if (editor == null) {
                RightHandler.$$$reportNull$$$0(0);
            }
            stepData.selectNext(SmartStepData.Direction.RIGHT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler$RightHandler", "myPerform"));
        }
    }

    static class LeftHandler
    extends SmartStepEditorActionHandler {
        LeftHandler(EditorActionHandler original) {
            super(original);
        }

        @Override
        protected void myPerform(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext, SmartStepData stepData) {
            if (editor == null) {
                LeftHandler.$$$reportNull$$$0(0);
            }
            stepData.selectNext(SmartStepData.Direction.LEFT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler$LeftHandler", "myPerform"));
        }
    }

    static class DownHandler
    extends SmartStepEditorActionHandler {
        DownHandler(EditorActionHandler original) {
            super(original);
        }

        @Override
        protected void myPerform(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext, SmartStepData stepData) {
            if (editor == null) {
                DownHandler.$$$reportNull$$$0(0);
            }
            stepData.selectNext(SmartStepData.Direction.DOWN);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler$DownHandler", "myPerform"));
        }
    }

    static class UpHandler
    extends SmartStepEditorActionHandler {
        UpHandler(EditorActionHandler original) {
            super(original);
        }

        @Override
        protected void myPerform(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext, SmartStepData stepData) {
            if (editor == null) {
                UpHandler.$$$reportNull$$$0(0);
            }
            stepData.selectNext(SmartStepData.Direction.UP);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler$UpHandler", "myPerform"));
        }
    }

    static abstract class SmartStepEditorActionHandler
    extends EditorActionHandler {
        protected final EditorActionHandler myOriginalHandler;

        SmartStepEditorActionHandler(EditorActionHandler originalHandler) {
            this.myOriginalHandler = originalHandler;
        }

        @Override
        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            SmartStepData stepData;
            if (editor == null) {
                SmartStepEditorActionHandler.$$$reportNull$$$0(0);
            }
            if ((stepData = editor.getUserData(SMART_STEP_INPLACE_DATA)) != null) {
                this.myPerform(editor, caret, dataContext, stepData);
            } else {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
        }

        @Override
        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                SmartStepEditorActionHandler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                SmartStepEditorActionHandler.$$$reportNull$$$0(2);
            }
            return editor.getUserData(SMART_STEP_INPLACE_DATA) != null || this.myOriginalHandler.isEnabled(editor, caret, dataContext);
        }

        protected abstract void myPerform(@NotNull Editor var1, @Nullable Caret var2, DataContext var3, SmartStepData var4);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler$SmartStepEditorActionHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class SmartStepData<V extends XSmartStepIntoVariant> {
        private final XSmartStepIntoHandler<V> myHandler;
        private final List<VariantInfo> myVariants;
        private final XDebugSession mySession;
        private final Editor myEditor;
        private VariantInfo myCurrentVariant;
        private final List<RangeHighlighter> myHighlighters = new ArrayList<RangeHighlighter>();
        final Comparator<VariantInfo> DISTANCE_TO_CURRENT_COMPARATOR = Comparator.comparingInt(a -> Math.abs(a.myStartPoint.x - this.myCurrentVariant.myStartPoint.x));

        SmartStepData(XSmartStepIntoHandler<V> handler2, List<? extends V> variants, XDebugSession session2, Editor editor) {
            this.myHandler = handler2;
            this.mySession = session2;
            this.myEditor = editor;
            this.myVariants = ((StreamEx)StreamEx.of(variants).map(x$0 -> new VariantInfo(this, x$0)).sorted(Comparator.comparingInt(v -> ((XSmartStepIntoVariant)v.myVariant).getHighlightRange().getStartOffset()).thenComparingInt(v -> ((XSmartStepIntoVariant)v.myVariant).getHighlightRange().getLength()))).toList();
        }

        private VariantInfo getPreviousVariant() {
            int currentIndex = this.myVariants.indexOf(this.myCurrentVariant);
            return this.myVariants.get(currentIndex > 0 ? currentIndex - 1 : this.myVariants.size() - 1);
        }

        private VariantInfo getNextVariant() {
            int currentIndex = this.myVariants.indexOf(this.myCurrentVariant);
            return this.myVariants.get(currentIndex < this.myVariants.size() - 1 ? currentIndex + 1 : 0);
        }

        void selectNext(Direction direction) {
            int currentLineY = this.myCurrentVariant.myStartPoint.y;
            VariantInfo next = null;
            switch (direction) {
                case LEFT: {
                    next = this.getPreviousVariant();
                    break;
                }
                case RIGHT: {
                    next = this.getNextVariant();
                    break;
                }
                case UP: {
                    int previousLineY = this.myVariants.stream().mapToInt(v -> v.myStartPoint.y).filter(v -> v < currentLineY).max().orElse(-1);
                    next = this.myVariants.stream().filter(v -> v.myStartPoint.y == previousLineY).min(this.DISTANCE_TO_CURRENT_COMPARATOR).orElseGet(this::getPreviousVariant);
                    break;
                }
                case DOWN: {
                    int nextLineY = this.myVariants.stream().mapToInt(v -> v.myStartPoint.y).filter(v -> v > currentLineY).min().orElse(-1);
                    next = this.myVariants.stream().filter(v -> v.myStartPoint.y == nextLineY).min(this.DISTANCE_TO_CURRENT_COMPARATOR).orElseGet(this::getNextVariant);
                }
            }
            if (next != null) {
                this.select(next);
            }
        }

        void select(@NotNull VariantInfo variant) {
            if (variant == null) {
                SmartStepData.$$$reportNull$$$0(0);
            }
            this.setCurrentVariantHighlighterAttributes(DebuggerColors.SMART_STEP_INTO_TARGET);
            this.myCurrentVariant = variant;
            this.setCurrentVariantHighlighterAttributes(DebuggerColors.SMART_STEP_INTO_SELECTION);
        }

        private void setCurrentVariantHighlighterAttributes(TextAttributesKey attributes) {
            int index = this.myVariants.indexOf(this.myCurrentVariant);
            if (index != -1) {
                ((RangeHighlighterEx)this.myHighlighters.get(index)).setTextAttributes(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributes));
            }
        }

        void stepInto(@NotNull VariantInfo variant) {
            if (variant == null) {
                SmartStepData.$$$reportNull$$$0(1);
            }
            this.clear();
            this.mySession.smartStepInto(this.myHandler, variant.myVariant);
        }

        void clear() {
            this.myEditor.putUserData(SMART_STEP_INPLACE_DATA, null);
            HighlightManagerImpl highlightManager = (HighlightManagerImpl)HighlightManager.getInstance(this.mySession.getProject());
            highlightManager.hideHighlights(this.myEditor, 5);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "variant";
            objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler$SmartStepData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "select";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stepInto";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static class VariantInfo {
            @NotNull
            final V myVariant;
            @NotNull
            final Point myStartPoint;
            final /* synthetic */ SmartStepData this$0;

            VariantInfo(V variant) {
                if (variant == null) {
                    VariantInfo.$$$reportNull$$$0(0);
                }
                this.this$0 = this$0;
                this.myVariant = variant;
                this.myStartPoint = ((SmartStepData)this$0).myEditor.offsetToXY(((XSmartStepIntoVariant)variant).getHighlightRange().getStartOffset());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandler$SmartStepData$VariantInfo", "<init>"));
            }
        }

        static enum Direction {
            UP,
            DOWN,
            LEFT,
            RIGHT;

        }
    }
}

