/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.actions.handlers.XAddToWatchesFromEditorActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class XEvaluateInConsoleFromEditorActionHandler
extends XAddToWatchesFromEditorActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            XEvaluateInConsoleFromEditorActionHandler.$$$reportNull$$$0(0);
        }
        return super.isEnabled(session2, dataContext) && XEvaluateInConsoleFromEditorActionHandler.getConsoleExecuteAction(session2) != null;
    }

    @Nullable
    private static ConsoleExecuteAction getConsoleExecuteAction(@NotNull XDebugSession session2) {
        if (session2 == null) {
            XEvaluateInConsoleFromEditorActionHandler.$$$reportNull$$$0(1);
        }
        return XEvaluateInConsoleFromEditorActionHandler.getConsoleExecuteAction(session2.getConsoleView());
    }

    @Nullable
    public static ConsoleExecuteAction getConsoleExecuteAction(@Nullable ConsoleView consoleView) {
        if (!(consoleView instanceof LanguageConsoleView)) {
            return null;
        }
        List<AnAction> actions = ActionUtil.getActions(((LanguageConsoleView)consoleView).getConsoleEditor().getComponent());
        ConsoleExecuteAction action2 = ContainerUtil.findInstance(actions, ConsoleExecuteAction.class);
        return action2 == null || !action2.isEnabled() ? null : action2;
    }

    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        Promise<Pair> rangeAndText;
        int selectionEnd;
        Editor editor;
        if (session2 == null) {
            XEvaluateInConsoleFromEditorActionHandler.$$$reportNull$$$0(2);
        }
        if (!((editor = CommonDataKeys.EDITOR.getData(dataContext)) instanceof EditorEx)) {
            return;
        }
        int selectionStart = editor.getSelectionModel().getSelectionStart();
        if (selectionStart != (selectionEnd = editor.getSelectionModel().getSelectionEnd())) {
            TextRange textRange = new TextRange(selectionStart, selectionEnd);
            rangeAndText = Promises.resolvedPromise(Pair.create(textRange, editor.getDocument().getText(textRange)));
        } else {
            XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
            if (evaluator != null) {
                Promise<ExpressionInfo> expressionInfoPromise = evaluator.getExpressionInfoAtOffsetAsync(session2.getProject(), editor.getDocument(), selectionStart, true);
                rangeAndText = expressionInfoPromise.then(expressionInfo -> {
                    if (expressionInfo == null) {
                        return null;
                    }
                    return Pair.create(expressionInfo.getTextRange(), XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, editor.getDocument()));
                });
            } else {
                return;
            }
        }
        rangeAndText.onSuccess(textRangeStringPair -> ApplicationManager.getApplication().invokeLater(() -> {
            TextRange range2 = (TextRange)textRangeStringPair.getFirst();
            String text2 = (String)textRangeStringPair.getSecond();
            if (text2 == null) {
                return;
            }
            ConsoleExecuteAction action2 = XEvaluateInConsoleFromEditorActionHandler.getConsoleExecuteAction(session2);
            if (action2 != null) {
                action2.execute(range2, text2, (EditorEx)editor);
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "session";
        objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/XEvaluateInConsoleFromEditorActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getConsoleExecuteAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

