/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointDependencyState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionState;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="breakpoint")
public class BreakpointState<B extends XBreakpoint<P>, P extends XBreakpointProperties, T extends XBreakpointType<B, P>> {
    private String myTypeId;
    private boolean myEnabled;
    private Element myPropertiesElement;
    private SuspendPolicy mySuspendPolicy = SuspendPolicy.ALL;
    private boolean myLogMessage;
    private boolean myLogStack;
    private LogExpression myLogExpression;
    private Condition myCondition;
    private XBreakpointDependencyState myDependencyState;
    @Tag(value="group")
    private String myGroup;
    @Tag(value="description")
    private String myDescription;
    private long myTimeStamp;

    public BreakpointState() {
    }

    public BreakpointState(boolean enabled, String typeId, long timeStamp, SuspendPolicy suspendPolicy) {
        this.myEnabled = enabled;
        this.myTypeId = typeId;
        this.myTimeStamp = timeStamp;
        this.mySuspendPolicy = suspendPolicy;
    }

    @Attribute(value="enabled")
    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Attribute(value="type")
    public String getTypeId() {
        return this.myTypeId;
    }

    public void setTypeId(String typeId) {
        this.myTypeId = typeId;
    }

    @Tag(value="properties")
    public Element getPropertiesElement() {
        return this.myPropertiesElement;
    }

    public void setPropertiesElement(Element propertiesElement) {
        this.myPropertiesElement = propertiesElement;
    }

    @Attribute(value="suspend")
    public String getSuspendPolicyString() {
        return this.mySuspendPolicy.name();
    }

    public void setSuspendPolicyString(String suspendPolicy) {
        this.mySuspendPolicy = SuspendPolicy.valueOf(suspendPolicy);
    }

    @Transient
    public SuspendPolicy getSuspendPolicy() {
        return this.mySuspendPolicy;
    }

    public void setSuspendPolicy(SuspendPolicy suspendPolicy) {
        this.mySuspendPolicy = suspendPolicy;
    }

    @Attribute(value="log-message")
    public boolean isLogMessage() {
        return this.myLogMessage;
    }

    public void setLogMessage(boolean logMessage) {
        this.myLogMessage = logMessage;
    }

    @Attribute(value="log-stack")
    public boolean isLogStack() {
        return this.myLogStack;
    }

    public void setLogStack(boolean logStack) {
        this.myLogStack = logStack;
    }

    @Nullable
    public String getGroup() {
        return this.myGroup;
    }

    public void setGroup(String group) {
        this.myGroup = group;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    @Property(surroundWithTag=false)
    @Nullable
    public LogExpression getLogExpression() {
        return this.myLogExpression;
    }

    public void setLogExpression(@Nullable LogExpression logExpression) {
        if (logExpression != null) {
            logExpression.checkConverted();
        }
        this.myLogExpression = logExpression;
    }

    @Property(surroundWithTag=false)
    @Nullable
    public Condition getCondition() {
        return this.myCondition;
    }

    public void setCondition(@Nullable Condition condition2) {
        if (condition2 != null) {
            condition2.checkConverted();
        }
        this.myCondition = condition2;
    }

    public boolean isLogExpressionEnabled() {
        return this.myLogExpression == null || !this.myLogExpression.myDisabled;
    }

    public boolean isConditionEnabled() {
        return this.myCondition == null || !this.myCondition.myDisabled;
    }

    @Property(surroundWithTag=false)
    public XBreakpointDependencyState getDependencyState() {
        return this.myDependencyState;
    }

    public void setDependencyState(XBreakpointDependencyState dependencyState) {
        this.myDependencyState = dependencyState;
    }

    public XBreakpointBase<B, P, ?> createBreakpoint(@NotNull T type, @NotNull XBreakpointManagerImpl breakpointManager) {
        if (type == null) {
            BreakpointState.$$$reportNull$$$0(0);
        }
        if (breakpointManager == null) {
            BreakpointState.$$$reportNull$$$0(1);
        }
        return new XBreakpointBase(type, breakpointManager, this);
    }

    public long getTimeStamp() {
        return this.myTimeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.myTimeStamp = timeStamp;
    }

    void applyDefaults(BreakpointState state) {
        state.mySuspendPolicy = this.mySuspendPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "breakpointManager";
                break;
            }
        }
        objectArray[1] = "com/intellij/xdebugger/impl/breakpoints/BreakpointState";
        objectArray[2] = "createBreakpoint";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Tag(value="log-expression")
    public static class LogExpression
    extends XExpressionState {
        public LogExpression() {
        }

        private LogExpression(boolean disabled, XExpression expression) {
            super(disabled, expression);
        }

        @Nullable
        public static LogExpression create(boolean disabled, XExpression expression) {
            if (XDebuggerUtilImpl.isEmptyExpression(expression)) {
                return null;
            }
            return new LogExpression(disabled, expression);
        }
    }

    @Tag(value="condition")
    public static class Condition
    extends XExpressionState {
        public Condition() {
        }

        private Condition(boolean disabled, XExpression expression) {
            super(disabled, expression);
        }

        @Nullable
        public static Condition create(boolean disabled, XExpression expression) {
            if (XDebuggerUtilImpl.isEmptyExpression(expression)) {
                return null;
            }
            return new Condition(disabled, expression);
        }
    }
}

