/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.EditBreakpointAction;
import com.intellij.xdebugger.impl.breakpoints.BreakpointState;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.RemoveBreakpointGutterIconAction;
import com.intellij.xdebugger.impl.breakpoints.ToggleBreakpointGutterIconAction;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointDependencyState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointBase<Self extends XBreakpoint<P>, P extends XBreakpointProperties, S extends BreakpointState>
extends UserDataHolderBase
implements XBreakpoint<P>,
Comparable<Self> {
    @NonNls
    private static final String BR_NBSP = "<br>&nbsp;";
    private final XBreakpointType<Self, P> myType;
    @Nullable
    private final P myProperties;
    protected final S myState;
    private final XBreakpointManagerImpl myBreakpointManager;
    private Icon myIcon;
    private CustomizedBreakpointPresentation myCustomizedPresentation;
    private boolean myConditionEnabled = true;
    private XExpression myCondition;
    private boolean myLogExpressionEnabled = true;
    private XExpression myLogExpression;
    private volatile boolean myDisposed;

    public XBreakpointBase(XBreakpointType<Self, P> type, XBreakpointManagerImpl breakpointManager, @Nullable P properties, S state) {
        this.myState = state;
        this.myType = type;
        this.myProperties = properties;
        this.myBreakpointManager = breakpointManager;
        this.initExpressions();
    }

    protected XBreakpointBase(XBreakpointType<Self, P> type, XBreakpointManagerImpl breakpointManager, S breakpointState) {
        this.myState = breakpointState;
        this.myType = type;
        this.myBreakpointManager = breakpointManager;
        this.myProperties = type.createProperties();
        if (this.myProperties != null) {
            ComponentSerializationUtil.loadComponentState(this.myProperties, ((BreakpointState)this.myState).getPropertiesElement());
        }
        this.initExpressions();
    }

    private void initExpressions() {
        this.myConditionEnabled = ((BreakpointState)this.myState).isConditionEnabled();
        BreakpointState.Condition condition2 = ((BreakpointState)this.myState).getCondition();
        this.myCondition = condition2 != null ? condition2.toXExpression() : null;
        this.myLogExpressionEnabled = ((BreakpointState)this.myState).isLogExpressionEnabled();
        BreakpointState.LogExpression expression = ((BreakpointState)this.myState).getLogExpression();
        this.myLogExpression = expression != null ? expression.toXExpression() : null;
    }

    public final Project getProject() {
        return this.myBreakpointManager.getProject();
    }

    protected XBreakpointManagerImpl getBreakpointManager() {
        return this.myBreakpointManager;
    }

    public final void fireBreakpointChanged() {
        this.clearIcon();
        this.myBreakpointManager.fireBreakpointChanged(this);
    }

    @Override
    public XSourcePosition getSourcePosition() {
        return this.getType().getSourcePosition(this);
    }

    @Override
    public Navigatable getNavigatable() {
        XSourcePosition position = this.getSourcePosition();
        if (position == null) {
            return null;
        }
        return position.createNavigatable(this.getProject());
    }

    @Override
    public boolean isEnabled() {
        return ((BreakpointState)this.myState).isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            ((BreakpointState)this.myState).setEnabled(enabled);
            this.fireBreakpointChanged();
        }
    }

    @Override
    @NotNull
    public SuspendPolicy getSuspendPolicy() {
        SuspendPolicy suspendPolicy = ((BreakpointState)this.myState).getSuspendPolicy();
        if (suspendPolicy == null) {
            XBreakpointBase.$$$reportNull$$$0(0);
        }
        return suspendPolicy;
    }

    @Override
    public void setSuspendPolicy(@NotNull SuspendPolicy policy) {
        if (policy == null) {
            XBreakpointBase.$$$reportNull$$$0(1);
        }
        if (((BreakpointState)this.myState).getSuspendPolicy() != policy) {
            ((BreakpointState)this.myState).setSuspendPolicy(policy);
            this.fireBreakpointChanged();
        }
    }

    @Override
    public boolean isLogMessage() {
        return ((BreakpointState)this.myState).isLogMessage();
    }

    @Override
    public void setLogMessage(boolean logMessage) {
        if (logMessage != this.isLogMessage()) {
            ((BreakpointState)this.myState).setLogMessage(logMessage);
            this.fireBreakpointChanged();
        }
    }

    @Override
    public boolean isLogStack() {
        return ((BreakpointState)this.myState).isLogStack();
    }

    @Override
    public void setLogStack(boolean logStack) {
        if (logStack != this.isLogStack()) {
            ((BreakpointState)this.myState).setLogStack(logStack);
            this.fireBreakpointChanged();
        }
    }

    public boolean isConditionEnabled() {
        return this.myConditionEnabled;
    }

    public void setConditionEnabled(boolean conditionEnabled) {
        if (this.myConditionEnabled != conditionEnabled) {
            this.myConditionEnabled = conditionEnabled;
            this.fireBreakpointChanged();
        }
    }

    public boolean isLogExpressionEnabled() {
        return this.myLogExpressionEnabled;
    }

    public void setLogExpressionEnabled(boolean logExpressionEnabled) {
        if (this.myLogExpressionEnabled != logExpressionEnabled) {
            this.myLogExpressionEnabled = logExpressionEnabled;
            this.fireBreakpointChanged();
        }
    }

    @Override
    public String getLogExpression() {
        XExpression expression = this.getLogExpressionObject();
        return expression != null ? expression.getExpression() : null;
    }

    @Override
    public void setLogExpression(@Nullable String expression) {
        if (!Comparing.equal(this.getLogExpression(), expression)) {
            this.myLogExpression = XExpressionImpl.fromText(expression);
            this.fireBreakpointChanged();
        }
    }

    public XExpression getLogExpressionObjectInt() {
        return this.myLogExpression;
    }

    @Override
    @Nullable
    public XExpression getLogExpressionObject() {
        return this.myLogExpressionEnabled ? this.myLogExpression : null;
    }

    @Override
    public void setLogExpressionObject(@Nullable XExpression expression) {
        if (!Comparing.equal(this.myLogExpression, expression)) {
            this.myLogExpression = expression;
            this.fireBreakpointChanged();
        }
    }

    @Override
    public String getCondition() {
        XExpression expression = this.getConditionExpression();
        return expression != null ? expression.getExpression() : null;
    }

    @Override
    public void setCondition(@Nullable String condition2) {
        if (!Comparing.equal(condition2, this.getCondition())) {
            this.myCondition = XExpressionImpl.fromText(condition2);
            this.fireBreakpointChanged();
        }
    }

    public XExpression getConditionExpressionInt() {
        return this.myCondition;
    }

    @Override
    @Nullable
    public XExpression getConditionExpression() {
        return this.myConditionEnabled ? this.myCondition : null;
    }

    @Override
    public void setConditionExpression(@Nullable XExpression condition2) {
        if (!Comparing.equal(condition2, this.myCondition)) {
            this.myCondition = condition2;
            this.fireBreakpointChanged();
        }
    }

    @Override
    public long getTimeStamp() {
        return ((BreakpointState)this.myState).getTimeStamp();
    }

    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public P getProperties() {
        return this.myProperties;
    }

    @Override
    @NotNull
    public XBreakpointType<Self, P> getType() {
        XBreakpointType<Self, P> xBreakpointType = this.myType;
        if (xBreakpointType == null) {
            XBreakpointBase.$$$reportNull$$$0(2);
        }
        return xBreakpointType;
    }

    public S getState() {
        Object propertiesState = this.myProperties == null ? null : (Object)this.myProperties.getState();
        Element element2 = propertiesState == null ? null : XmlSerializer.serialize(propertiesState);
        Element propertiesElement = element2 == null ? null : JDOMUtil.internElement(element2);
        ((BreakpointState)this.myState).setCondition(BreakpointState.Condition.create(!this.myConditionEnabled, this.myCondition));
        ((BreakpointState)this.myState).setLogExpression(BreakpointState.LogExpression.create(!this.myLogExpressionEnabled, this.myLogExpression));
        ((BreakpointState)this.myState).setPropertiesElement(propertiesElement);
        return this.myState;
    }

    public XBreakpointDependencyState getDependencyState() {
        return ((BreakpointState)this.myState).getDependencyState();
    }

    public void setDependencyState(XBreakpointDependencyState state) {
        ((BreakpointState)this.myState).setDependencyState(state);
    }

    @Nullable
    public String getGroup() {
        return ((BreakpointState)this.myState).getGroup();
    }

    public void setGroup(String group) {
        ((BreakpointState)this.myState).setGroup(StringUtil.nullize(group));
    }

    public String getUserDescription() {
        return ((BreakpointState)this.myState).getDescription();
    }

    public void setUserDescription(String description) {
        ((BreakpointState)this.myState).setDescription(StringUtil.nullize(description));
    }

    public final void dispose() {
        this.myDisposed = true;
        this.doDispose();
    }

    protected void doDispose() {
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public String toString() {
        return "XBreakpointBase(type=" + this.myType + ")";
    }

    @Nullable
    protected GutterDraggableObject createBreakpointDraggableObject() {
        return null;
    }

    protected List<? extends AnAction> getAdditionalPopupMenuActions(XDebugSession session2) {
        return this.getType().getAdditionalPopupMenuActions(this, session2);
    }

    @NotNull
    public String getDescription() {
        XBreakpoint<?> masterBreakpoint;
        String logExpression;
        StringBuilder builder2 = new StringBuilder();
        builder2.append("<html>").append("<body>");
        builder2.append(XBreakpointUtil.getDisplayText(this));
        String errorMessage = this.getErrorMessage();
        if (!StringUtil.isEmpty(errorMessage)) {
            builder2.append(BR_NBSP);
            builder2.append("<font color='#").append(ColorUtil.toHex(JBColor.RED)).append("'>");
            builder2.append(errorMessage);
            builder2.append("</font>");
        }
        if (this.getSuspendPolicy() == SuspendPolicy.NONE) {
            builder2.append(BR_NBSP).append(XDebuggerBundle.message("xbreakpoint.tooltip.suspend.policy.none", new Object[0]));
        } else if (this.getType().isSuspendThreadSupported()) {
            builder2.append(BR_NBSP);
            switch (this.getSuspendPolicy()) {
                case ALL: {
                    builder2.append(XDebuggerBundle.message("xbreakpoint.tooltip.suspend.policy.all", new Object[0]));
                    break;
                }
                case THREAD: {
                    builder2.append(XDebuggerBundle.message("xbreakpoint.tooltip.suspend.policy.thread", new Object[0]));
                }
            }
        }
        String condition2 = this.getCondition();
        if (!StringUtil.isEmpty(condition2)) {
            builder2.append(BR_NBSP);
            builder2.append(XDebuggerBundle.message("xbreakpoint.tooltip.condition", new Object[0]));
            builder2.append("&nbsp;");
            builder2.append(XmlStringUtil.escapeString(condition2));
        }
        if (this.isLogMessage()) {
            builder2.append(BR_NBSP).append(XDebuggerBundle.message("xbreakpoint.tooltip.log.message", new Object[0]));
        }
        if (this.isLogStack()) {
            builder2.append(BR_NBSP).append(XDebuggerBundle.message("xbreakpoint.tooltip.log.stack", new Object[0]));
        }
        if (!StringUtil.isEmpty(logExpression = this.getLogExpression())) {
            builder2.append(BR_NBSP);
            builder2.append(XDebuggerBundle.message("xbreakpoint.tooltip.log.expression", new Object[0]));
            builder2.append("&nbsp;");
            builder2.append(XmlStringUtil.escapeString(logExpression));
        }
        if ((masterBreakpoint = this.getBreakpointManager().getDependentBreakpointManager().getMasterBreakpoint(this)) != null) {
            builder2.append(BR_NBSP);
            String str = XDebuggerBundle.message("xbreakpoint.tooltip.depends.on", new Object[0]);
            builder2.append(str);
            builder2.append("&nbsp;");
            builder2.append(XBreakpointUtil.getShortText(masterBreakpoint));
        }
        builder2.append("</body>").append("</html>");
        String string = builder2.toString();
        if (string == null) {
            XBreakpointBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void updateIcon() {
        Icon icon2 = this.calculateSpecialIcon();
        this.setIcon(icon2 != null ? icon2 : this.getType().getEnabledIcon());
    }

    protected void setIcon(Icon icon2) {
        if (!XDebuggerUtilImpl.isEmptyExpression(this.getConditionExpression())) {
            LayeredIcon newIcon = new LayeredIcon(2);
            newIcon.setIcon(icon2, 0);
            newIcon.setIcon(AllIcons.Debugger.Question_badge, 1, 10, 6);
            this.myIcon = JBUI.scale(newIcon);
        } else {
            this.myIcon = icon2;
        }
    }

    @Nullable
    protected final Icon calculateSpecialIcon() {
        Icon icon2;
        XDebugSessionImpl session2 = this.getBreakpointManager().getDebuggerManager().getCurrentSession();
        if (!this.isEnabled()) {
            if (session2 == null || !session2.areBreakpointsMuted()) {
                return this.getType().getDisabledIcon();
            }
            return this.getType().getMutedDisabledIcon();
        }
        if (session2 == null) {
            if (this.getBreakpointManager().getDependentBreakpointManager().getMasterBreakpoint(this) != null) {
                return this.getType().getInactiveDependentIcon();
            }
        } else {
            Icon icon3;
            if (session2.areBreakpointsMuted()) {
                return this.getType().getMutedEnabledIcon();
            }
            if (session2.isInactiveSlaveBreakpoint(this)) {
                return this.getType().getInactiveDependentIcon();
            }
            CustomizedBreakpointPresentation presentation = session2.getBreakpointPresentation(this);
            if (presentation != null && (icon3 = presentation.getIcon()) != null) {
                return icon3;
            }
        }
        if (this.getSuspendPolicy() == SuspendPolicy.NONE) {
            return this.getType().getSuspendNoneIcon();
        }
        if (this.myCustomizedPresentation != null && (icon2 = this.myCustomizedPresentation.getIcon()) != null) {
            return icon2;
        }
        return null;
    }

    public Icon getIcon() {
        if (this.myIcon == null) {
            this.updateIcon();
        }
        return this.myIcon;
    }

    @Nullable
    public String getErrorMessage() {
        String message;
        CustomizedBreakpointPresentation presentation;
        XDebugSessionImpl currentSession = this.getBreakpointManager().getDebuggerManager().getCurrentSession();
        if (currentSession != null && (presentation = currentSession.getBreakpointPresentation(this)) != null && (message = presentation.getErrorMessage()) != null) {
            return message;
        }
        return this.myCustomizedPresentation != null ? this.myCustomizedPresentation.getErrorMessage() : null;
    }

    CustomizedBreakpointPresentation getCustomizedPresentation() {
        return this.myCustomizedPresentation;
    }

    public void setCustomizedPresentation(CustomizedBreakpointPresentation presentation) {
        this.myCustomizedPresentation = presentation;
    }

    @NotNull
    public GutterIconRenderer createGutterIconRenderer() {
        return new BreakpointGutterIconRenderer();
    }

    public void clearIcon() {
        this.myIcon = null;
    }

    @Override
    public int compareTo(@NotNull Self self) {
        if (self == null) {
            XBreakpointBase.$$$reportNull$$$0(4);
        }
        return this.myType.getBreakpointComparator().compare(this, self);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendPolicy";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSuspendPolicy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class BreakpointGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        protected BreakpointGutterIconRenderer() {
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon2 = XBreakpointBase.this.getIcon();
            if (icon2 == null) {
                BreakpointGutterIconRenderer.$$$reportNull$$$0(0);
            }
            return icon2;
        }

        @Override
        @NotNull
        public String getAccessibleName() {
            String string = "icon: " + XBreakpointBase.this.getType().getTitle() + (XBreakpointBase.this.getCondition() != null ? " conditional" : "") + (!XBreakpointBase.this.isEnabled() ? " disabled" : "");
            if (string == null) {
                BreakpointGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public AnAction getClickAction() {
            if (Registry.is("debugger.click.disable.breakpoints")) {
                return new ToggleBreakpointGutterIconAction(XBreakpointBase.this);
            }
            return new RemoveBreakpointGutterIconAction(XBreakpointBase.this);
        }

        @Override
        @Nullable
        public AnAction getMiddleButtonClickAction() {
            if (!Registry.is("debugger.click.disable.breakpoints")) {
                return new ToggleBreakpointGutterIconAction(XBreakpointBase.this);
            }
            return new RemoveBreakpointGutterIconAction(XBreakpointBase.this);
        }

        @Override
        @Nullable
        public AnAction getRightButtonClickAction() {
            return new EditBreakpointAction.ContextAction(this, XBreakpointBase.this, DebuggerSupport.getDebuggerSupport(XDebuggerSupport.class));
        }

        @Override
        @Nullable
        public ActionGroup getPopupMenuActions() {
            return new DefaultActionGroup(XBreakpointBase.this.getAdditionalPopupMenuActions(XBreakpointBase.this.getBreakpointManager().getDebuggerManager().getCurrentSession()));
        }

        @Override
        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.RIGHT;
            if (alignment == null) {
                BreakpointGutterIconRenderer.$$$reportNull$$$0(2);
            }
            return alignment;
        }

        @Override
        @Nullable
        public String getTooltipText() {
            return XBreakpointBase.this.getDescription();
        }

        @Override
        public GutterDraggableObject getDraggableObject() {
            return XBreakpointBase.this.createBreakpointDraggableObject();
        }

        private XBreakpointBase<?, ?, ?> getBreakpoint() {
            return XBreakpointBase.this;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof BreakpointGutterIconRenderer && this.getBreakpoint() == ((BreakpointGutterIconRenderer)obj).getBreakpoint() && Comparing.equal(this.getIcon(), ((BreakpointGutterIconRenderer)obj).getIcon());
        }

        @Override
        public int hashCode() {
            return this.getBreakpoint().hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase$BreakpointGutterIconRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAccessibleName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlignment";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

