/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.XLightBreakpointPropertiesPanel;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

class XBreakpointItem
extends BreakpointItem {
    private final XBreakpoint<?> myBreakpoint;
    private XLightBreakpointPropertiesPanel myPropertiesPanel;

    XBreakpointItem(XBreakpoint<?> breakpoint) {
        this.myBreakpoint = breakpoint;
    }

    @Override
    public void setupRenderer(ColoredListCellRenderer renderer, Project project2, boolean selected2) {
        this.setupGenericRenderer(renderer, true);
    }

    @Override
    public void setupRenderer(ColoredTreeCellRenderer renderer, Project project2, boolean selected2) {
        this.setupGenericRenderer(renderer, false);
    }

    @Override
    public void setupGenericRenderer(SimpleColoredComponent renderer, boolean plainView) {
        renderer.setIcon(this.getIcon());
        SimpleTextAttributes attributes = this.myBreakpoint.isEnabled() ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
        renderer.append(StringUtil.notNullize(this.getDisplayText()), attributes);
        String description = this.getUserDescription();
        if (!StringUtil.isEmpty(description)) {
            renderer.append(" (" + description + ")", SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
        }
    }

    @Override
    public String getDisplayText() {
        return XBreakpointUtil.getShortText(this.myBreakpoint);
    }

    @Nullable
    private String getUserDescription() {
        return ((XBreakpointBase)this.myBreakpoint).getUserDescription();
    }

    @Override
    public Icon getIcon() {
        return ((XBreakpointBase)this.myBreakpoint).getIcon();
    }

    @Override
    public String speedSearchText() {
        return this.getDisplayText() + " " + StringUtil.notNullize(this.getUserDescription());
    }

    @Override
    public String footerText() {
        return XBreakpointUtil.getDisplayText(this.myBreakpoint);
    }

    @Override
    public void saveState() {
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.saveProperties();
        }
    }

    @Override
    public void doUpdateDetailView(DetailView panel2, boolean editorOnly) {
        XSourcePosition sourcePosition;
        XBreakpointBase breakpoint = (XBreakpointBase)this.myBreakpoint;
        Project project2 = breakpoint.getProject();
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.dispose();
            this.myPropertiesPanel = null;
        }
        if (!editorOnly) {
            this.myPropertiesPanel = new XLightBreakpointPropertiesPanel(project2, this.getManager(), breakpoint, true);
            panel2.setPropertiesPanel(this.myPropertiesPanel.getMainPanel());
        }
        if ((sourcePosition = this.myBreakpoint.getSourcePosition()) != null && sourcePosition.getFile().isValid()) {
            XBreakpointItem.showInEditor(panel2, sourcePosition.getFile(), sourcePosition.getLine());
        } else {
            panel2.clearEditor();
        }
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.setDetailView(panel2);
            this.myPropertiesPanel.loadProperties();
            this.myPropertiesPanel.getMainPanel().revalidate();
        }
    }

    @Override
    public void navigate(boolean requestFocus) {
        Navigatable navigatable = this.myBreakpoint.getNavigatable();
        if (navigatable != null && navigatable.canNavigate()) {
            navigatable.navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        Navigatable navigatable = this.myBreakpoint.getNavigatable();
        return navigatable != null && navigatable.canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        Navigatable navigatable = this.myBreakpoint.getNavigatable();
        return navigatable != null && navigatable.canNavigateToSource();
    }

    private XBreakpointManagerImpl getManager() {
        return ((XBreakpointBase)this.myBreakpoint).getBreakpointManager();
    }

    @Override
    public boolean allowedToRemove() {
        return !this.getManager().isDefaultBreakpoint(this.myBreakpoint);
    }

    @Override
    public void removed(Project project2) {
        XDebuggerUtil.getInstance().removeBreakpoint(project2, this.myBreakpoint);
    }

    @Override
    public Object getBreakpoint() {
        return this.myBreakpoint;
    }

    @Override
    public boolean isEnabled() {
        return this.myBreakpoint.isEnabled();
    }

    @Override
    public void setEnabled(boolean state) {
        this.myBreakpoint.setEnabled(state);
    }

    @Override
    public boolean isDefaultBreakpoint() {
        return this.getManager().isDefaultBreakpoint(this.myBreakpoint);
    }

    @Override
    public int compareTo(BreakpointItem breakpointItem) {
        if (breakpointItem.getBreakpoint() instanceof XBreakpointBase) {
            return ((XBreakpointBase)this.myBreakpoint).compareTo((XBreakpoint)breakpointItem.getBreakpoint());
        }
        return 0;
    }

    @Override
    public void dispose() {
        if (this.myPropertiesPanel != null) {
            this.myPropertiesPanel.dispose();
            this.myPropertiesPanel = null;
        }
    }
}

