/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointCustomGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointFileGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointGroupingByTypeRule;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointPanelProvider
extends BreakpointPanelProvider<XBreakpoint> {
    @Override
    public void createBreakpointsGroupingRules(Collection<XBreakpointGroupingRule> rules) {
        rules.add(new XBreakpointGroupingByTypeRule());
        rules.add(new XBreakpointFileGroupingRule());
        rules.add(new XBreakpointCustomGroupingRule());
    }

    @Override
    public void addListener(BreakpointPanelProvider.BreakpointsListener listener2, Project project2, Disposable disposable2) {
        project2.getMessageBus().connect(disposable2).subscribe(XBreakpointListener.TOPIC, new MyXBreakpointListener(listener2, XDebuggerManager.getInstance(project2).getBreakpointManager()));
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    @Nullable
    public XBreakpoint<?> findBreakpoint(@NotNull Project project2, @NotNull Document document, int offset) {
        if (project2 == null) {
            XBreakpointPanelProvider.$$$reportNull$$$0(0);
        }
        if (document == null) {
            XBreakpointPanelProvider.$$$reportNull$$$0(1);
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance(project2).getBreakpointManager();
        int line = document.getLineNumber(offset);
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null) {
            return null;
        }
        for (XLineBreakpointType<?> type : XDebuggerUtil.getInstance().getLineBreakpointTypes()) {
            XLineBreakpoint<?> breakpoint = breakpointManager.findBreakpointAtLine(type, file2, line);
            if (breakpoint == null) continue;
            return breakpoint;
        }
        return null;
    }

    @Override
    public GutterIconRenderer getBreakpointGutterIconRenderer(Object breakpoint) {
        RangeHighlighter highlighter;
        if (breakpoint instanceof XLineBreakpointImpl && (highlighter = ((XLineBreakpointImpl)breakpoint).getHighlighter()) != null) {
            return highlighter.getGutterIconRenderer();
        }
        return null;
    }

    @Override
    public void onDialogClosed(Project project2) {
    }

    @Override
    public void provideBreakpointItems(Project project2, Collection<BreakpointItem> items) {
        Arrays.stream(XDebuggerManager.getInstance(project2).getBreakpointManager().getAllBreakpoints()).map(XBreakpointItem::new).forEach(items::add);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
        }
        objectArray[1] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointPanelProvider";
        objectArray[2] = "findBreakpoint";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyXBreakpointListener
    implements XBreakpointListener<XBreakpoint<?>> {
        public final BreakpointPanelProvider.BreakpointsListener myListener;
        public final XBreakpointManager myBreakpointManager;

        MyXBreakpointListener(BreakpointPanelProvider.BreakpointsListener listener2, XBreakpointManager breakpointManager) {
            this.myListener = listener2;
            this.myBreakpointManager = breakpointManager;
        }

        @Override
        public void breakpointAdded(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                MyXBreakpointListener.$$$reportNull$$$0(0);
            }
            this.myListener.breakpointsChanged();
        }

        @Override
        public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                MyXBreakpointListener.$$$reportNull$$$0(1);
            }
            this.myListener.breakpointsChanged();
        }

        @Override
        public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
            if (breakpoint == null) {
                MyXBreakpointListener.$$$reportNull$$$0(2);
            }
            this.myListener.breakpointsChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "breakpoint";
            objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointPanelProvider$MyXBreakpointListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "breakpointAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "breakpointRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "breakpointChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

