/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XExpressionState {
    @Attribute(value="disabled")
    public boolean myDisabled;
    @Attribute(value="expression")
    public String myExpression;
    @Attribute(value="language")
    public String myLanguage;
    @Attribute(value="custom")
    public String myCustomInfo;
    @Attribute(value="mode")
    public EvaluationMode myMode;
    @Text
    public String myOldExpression;

    public XExpressionState() {
        this.myMode = EvaluationMode.EXPRESSION;
    }

    public XExpressionState(boolean disabled, @NotNull String expression, String language2, String customInfo, EvaluationMode mode) {
        if (expression == null) {
            XExpressionState.$$$reportNull$$$0(0);
        }
        this.myMode = EvaluationMode.EXPRESSION;
        this.myDisabled = disabled;
        this.myExpression = expression;
        this.myLanguage = language2;
        this.myCustomInfo = customInfo;
        this.myMode = mode;
    }

    public XExpressionState(boolean disabled, XExpression expression) {
        this(disabled, expression.getExpression(), expression.getLanguage() != null ? expression.getLanguage().getID() : null, expression.getCustomInfo(), expression.getMode());
    }

    public XExpressionState(XExpression expression) {
        this(false, expression);
    }

    void checkConverted() {
        if (this.myOldExpression != null) {
            this.myExpression = this.myOldExpression;
            this.myOldExpression = null;
        }
    }

    @Nullable
    public XExpression toXExpression() {
        this.checkConverted();
        if (StringUtil.isEmptyOrSpaces(this.myExpression)) {
            return null;
        }
        return new XExpressionImpl(this.myExpression, Language.findLanguageByID(this.myLanguage), this.myCustomInfo, this.myMode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/impl/breakpoints/XExpressionState", "<init>"));
    }
}

