/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.popup.util.DetailController;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.ui.popup.util.ItemWrapperListRenderer;
import com.intellij.ui.popup.util.MasterController;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakpointChooser {
    private DetailView myDetailViewDelegate;
    private final Delegate myDelegate;
    private final ComboBox<BreakpointItem> myComboBox;
    private final DetailController myDetailController;
    private final List<BreakpointItem> myBreakpointItems;
    private MyDetailView myDetailView;

    public void setDetailView(DetailView detailView) {
        this.myDetailViewDelegate = detailView;
        this.myDetailView = new MyDetailView(this.myDetailViewDelegate.getEditorState());
        this.myDetailController.setDetailView(this.myDetailView);
    }

    public Object getSelectedBreakpoint() {
        return ((BreakpointItem)this.myComboBox.getSelectedItem()).getBreakpoint();
    }

    private void pop(DetailView.PreviewEditorState pushed) {
        if (pushed.getFile() != null) {
            this.myDetailViewDelegate.navigateInPreviewEditor(new DetailView.PreviewEditorState(pushed.getFile(), pushed.getNavigate(), pushed.getAttributes()));
        } else {
            this.myDetailViewDelegate.clearEditor();
        }
    }

    public void setSelectedBreakpoint(Object breakpoint) {
        this.myComboBox.setSelectedItem(BreakpointChooser.findItem(breakpoint, this.myBreakpointItems));
    }

    public BreakpointChooser(final Project project2, Delegate delegate, Object baseBreakpoint, List<BreakpointItem> breakpointItems) {
        this.myDelegate = delegate;
        this.myBreakpointItems = breakpointItems;
        BreakpointItem breakpointItem = BreakpointChooser.findItem(baseBreakpoint, this.myBreakpointItems);
        final Ref hackedSelection = Ref.create();
        this.myDetailController = new DetailController(new MasterController(){
            final JLabel fake = new JLabel();

            @Override
            public ItemWrapper[] getSelectedItems() {
                if (hackedSelection.get() == null) {
                    return new ItemWrapper[0];
                }
                return new ItemWrapper[]{(BreakpointItem)hackedSelection.get()};
            }

            @Override
            public JLabel getPathLabel() {
                return this.fake;
            }
        });
        CollectionComboBoxModel<BreakpointItem> model = new CollectionComboBoxModel<BreakpointItem>(this.myBreakpointItems, breakpointItem);
        this.myComboBox = new ComboBox<BreakpointItem>(model);
        this.myComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (BreakpointChooser.this.myDetailView != null) {
                    BreakpointChooser.this.myDetailView.clearEditor();
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                if (BreakpointChooser.this.myDetailView != null) {
                    BreakpointChooser.this.myDetailView.clearEditor();
                }
            }
        });
        this.myComboBox.setRenderer(new ItemWrapperListRenderer(project2, null){

            @Override
            protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.customizeCellRenderer(list2, value2, index, selected2, hasFocus);
                if (selected2 && hackedSelection.get() != value2) {
                    hackedSelection.set(value2);
                    BreakpointChooser.this.myDetailController.updateDetailView();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointChooser$3", "customizeCellRenderer"));
            }
        });
        this.myComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                BreakpointChooser.this.myDelegate.breakpointChosen(project2, (BreakpointItem)BreakpointChooser.this.myComboBox.getSelectedItem());
            }
        });
    }

    @Nullable
    private static BreakpointItem findItem(Object baseBreakpoint, List<? extends BreakpointItem> breakpointItems) {
        BreakpointItem breakpointItem = null;
        for (BreakpointItem breakpointItem2 : breakpointItems) {
            if (breakpointItem2.getBreakpoint() != baseBreakpoint) continue;
            breakpointItem = breakpointItem2;
            break;
        }
        return breakpointItem;
    }

    public JComponent getComponent() {
        return this.myComboBox;
    }

    private class MyDetailView
    implements DetailView {
        private final DetailView.PreviewEditorState myPushed;
        private ItemWrapper myCurrentItem;
        final UserDataHolderBase myDataHolderBase = new UserDataHolderBase();

        MyDetailView(DetailView.PreviewEditorState pushed) {
            this.myPushed = pushed;
            this.putUserData(BreakpointItem.EDITOR_ONLY, Boolean.TRUE);
        }

        @Override
        public Editor getEditor() {
            return BreakpointChooser.this.myDetailViewDelegate.getEditor();
        }

        @Override
        public void navigateInPreviewEditor(DetailView.PreviewEditorState editorState) {
            if (BreakpointChooser.this.myDetailViewDelegate != null) {
                BreakpointChooser.this.myDetailViewDelegate.navigateInPreviewEditor(editorState);
            }
        }

        @Override
        public JPanel getPropertiesPanel() {
            return null;
        }

        @Override
        public void setPropertiesPanel(@Nullable JPanel panel2) {
        }

        @Override
        public void clearEditor() {
            BreakpointChooser.this.pop(this.myPushed);
        }

        @Override
        public DetailView.PreviewEditorState getEditorState() {
            return BreakpointChooser.this.myDetailViewDelegate.getEditorState();
        }

        @Override
        public void setCurrentItem(ItemWrapper currentItem) {
            this.myCurrentItem = currentItem;
        }

        @Override
        public ItemWrapper getCurrentItem() {
            return this.myCurrentItem;
        }

        @Override
        public boolean hasEditorOnly() {
            return true;
        }

        @Override
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                MyDetailView.$$$reportNull$$$0(0);
            }
            return this.myDataHolderBase.getUserData(key);
        }

        @Override
        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (key == null) {
                MyDetailView.$$$reportNull$$$0(1);
            }
            this.myDataHolderBase.putUserData(key, value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "key";
            objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/ui/BreakpointChooser$MyDetailView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Delegate {
        public void breakpointChosen(Project var1, BreakpointItem var2);
    }
}

