/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroup;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemsTreeController;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsGroupNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsTreeCellRenderer;

public class BreakpointsCheckboxTree
extends CheckboxTree {
    private Delegate myDelegate = null;

    @Override
    protected void nodeStateWillChange(CheckedTreeNode node) {
        super.nodeStateWillChange(node);
        if (this.myDelegate != null) {
            this.myDelegate.nodeStateWillChange(node);
        }
    }

    @Override
    protected void onNodeStateChanged(CheckedTreeNode node) {
        super.onNodeStateChanged(node);
        if (this.myDelegate != null) {
            this.myDelegate.nodeStateDidChange(node);
        }
    }

    public void setDelegate(Delegate delegate) {
        this.myDelegate = delegate;
    }

    public BreakpointsCheckboxTree(Project project2, BreakpointItemsTreeController model) {
        super(new BreakpointsTreeCellRenderer.BreakpointsCheckboxTreeCellRenderer(project2), model.getRoot());
    }

    @Override
    protected void installSpeedSearch() {
        new TreeSpeedSearch(this, path2 -> {
            Object node = path2.getLastPathComponent();
            if (node instanceof BreakpointItemNode) {
                return ((BreakpointItemNode)node).getBreakpointItem().speedSearchText();
            }
            if (node instanceof BreakpointsGroupNode) {
                return ((XBreakpointGroup)((BreakpointsGroupNode)node).getGroup()).getName();
            }
            return "";
        }, true);
    }

    @Override
    public String convertValueToText(Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value2 instanceof BreakpointItemNode) {
            String displayText;
            BreakpointItem breakpointItem = ((BreakpointItemNode)value2).getBreakpointItem();
            String string = displayText = breakpointItem != null ? breakpointItem.getDisplayText() : null;
            if (!StringUtil.isEmptyOrSpaces(displayText)) {
                return displayText;
            }
        }
        return super.convertValueToText(value2, selected2, expanded, leaf, row, hasFocus);
    }

    static interface Delegate {
        public void nodeStateDidChange(CheckedTreeNode var1);

        public void nodeStateWillChange(CheckedTreeNode var1);
    }
}

