/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroup;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointCustomGroup;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsGroupNode;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

class BreakpointsTreeCellRenderer {
    private static final SimpleTextAttributes SIMPLE_CELL_ATTRIBUTES_BOLD = SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES.derive(1, null, null, null);

    BreakpointsTreeCellRenderer() {
    }

    private static void customizeRenderer(Project project2, Object value2, boolean selected2, boolean expanded, ColoredTreeCellRenderer renderer) {
        if (value2 instanceof BreakpointItemNode) {
            BreakpointItemNode node = (BreakpointItemNode)value2;
            BreakpointItem breakpoint = node.getBreakpointItem();
            breakpoint.setupRenderer(renderer, project2, selected2);
        } else if (value2 instanceof BreakpointsGroupNode) {
            Object group = ((BreakpointsGroupNode)value2).getGroup();
            renderer.setIcon(((XBreakpointGroup)group).getIcon(expanded));
            if (group instanceof XBreakpointCustomGroup && ((XBreakpointCustomGroup)group).isDefault()) {
                renderer.append(((XBreakpointGroup)group).getName(), SIMPLE_CELL_ATTRIBUTES_BOLD);
            } else {
                renderer.append(((XBreakpointGroup)group).getName(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
            }
        }
    }

    public static class BreakpointsSimpleTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final Project myProject;

        public BreakpointsSimpleTreeCellRenderer(Project project2) {
            this.myProject = project2;
        }

        @Override
        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                BreakpointsSimpleTreeCellRenderer.$$$reportNull$$$0(0);
            }
            BreakpointsTreeCellRenderer.customizeRenderer(this.myProject, value2, selected2, expanded, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/breakpoints/ui/tree/BreakpointsTreeCellRenderer$BreakpointsSimpleTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    public static class BreakpointsCheckboxTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private final Project myProject;

        public BreakpointsCheckboxTreeCellRenderer(Project project2) {
            this.myProject = project2;
        }

        @Override
        public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            BreakpointsTreeCellRenderer.customizeRenderer(this.myProject, value2, selected2, expanded, this.getTextRenderer());
        }
    }
}

