/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.CodeFragmentInputComponent;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.evaluate.ExpressionInputComponent;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.nodes.EvaluatingExpressionRootNode;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerEvaluationDialog
extends DialogWrapper {
    public static final DataKey<XDebuggerEvaluationDialog> KEY = DataKey.create("DEBUGGER_EVALUATION_DIALOG");
    private static final int ADD_WATCH_MODIFIERS = (SystemInfo.isMac ? 4 : 2) | 1;
    static KeyStroke ADD_WATCH_KEYSTROKE = KeyStroke.getKeyStroke(10, ADD_WATCH_MODIFIERS);
    private final JPanel myMainPanel;
    private final JPanel myResultPanel;
    private final XDebuggerTreePanel myTreePanel;
    private EvaluationInputComponent myInputComponent;
    private final XDebugSession mySession;
    private final Supplier<? extends XDebuggerEvaluator> myEvaluatorSupplier;
    private final Project myProject;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private EvaluationMode myMode;
    private XSourcePosition mySourcePosition;
    private final SwitchModeAction mySwitchModeAction;
    private final boolean myIsCodeFragmentEvaluationSupported;

    public XDebuggerEvaluationDialog(@NotNull XDebugSession session2, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull XExpression text2, @Nullable XSourcePosition sourcePosition, boolean isCodeFragmentEvaluationSupported) {
        if (session2 == null) {
            XDebuggerEvaluationDialog.$$$reportNull$$$0(0);
        }
        if (editorsProvider == null) {
            XDebuggerEvaluationDialog.$$$reportNull$$$0(1);
        }
        if (text2 == null) {
            XDebuggerEvaluationDialog.$$$reportNull$$$0(2);
        }
        this(session2, null, session2.getProject(), editorsProvider, text2, sourcePosition, isCodeFragmentEvaluationSupported);
    }

    public XDebuggerEvaluationDialog(@NotNull XDebuggerEvaluator evaluator, @NotNull Project project2, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull XExpression text2, @Nullable XSourcePosition sourcePosition, boolean isCodeFragmentEvaluationSupported) {
        if (evaluator == null) {
            XDebuggerEvaluationDialog.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            XDebuggerEvaluationDialog.$$$reportNull$$$0(4);
        }
        if (editorsProvider == null) {
            XDebuggerEvaluationDialog.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            XDebuggerEvaluationDialog.$$$reportNull$$$0(6);
        }
        this(null, () -> evaluator, project2, editorsProvider, text2, sourcePosition, isCodeFragmentEvaluationSupported);
    }

    private XDebuggerEvaluationDialog(final @Nullable XDebugSession session2, @Nullable Supplier<? extends XDebuggerEvaluator> evaluatorSupplier, final @NotNull Project project2, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull XExpression text2, @Nullable XSourcePosition sourcePosition, boolean isCodeFragmentEvaluationSupported) {
        if (project2 == null) {
            XDebuggerEvaluationDialog.$$$reportNull$$$0(7);
        }
        if (editorsProvider == null) {
            XDebuggerEvaluationDialog.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            XDebuggerEvaluationDialog.$$$reportNull$$$0(9);
        }
        super(project2, true);
        this.mySession = session2;
        this.myEvaluatorSupplier = evaluatorSupplier;
        this.myProject = project2;
        this.myEditorsProvider = editorsProvider;
        this.mySourcePosition = sourcePosition;
        this.myIsCodeFragmentEvaluationSupported = isCodeFragmentEvaluationSupported;
        this.setModal(false);
        this.setOKButtonText(XDebuggerBundle.message("xdebugger.button.evaluate", new Object[0]));
        this.setCancelButtonText(XDebuggerBundle.message("xdebugger.evaluate.dialog.close", new Object[0]));
        this.myTreePanel = new XDebuggerTreePanel(project2, editorsProvider, this.myDisposable, sourcePosition, "XDebugger.Evaluation.Dialog.Tree.Popup", session2 == null ? null : ((XDebugSessionImpl)session2).getValueMarkers());
        this.myResultPanel = JBUI.Panels.simplePanel().addToTop(new JLabel(XDebuggerBundle.message("xdebugger.evaluate.label.result", new Object[0]))).addToCenter(this.myTreePanel.getMainPanel());
        this.myMainPanel = new EvaluationMainPanel();
        this.mySwitchModeAction = new SwitchModeAction();
        DumbAwareAction.create(e -> this.mySwitchModeAction.actionPerformed(null)).registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(77, 512)), this.getRootPane(), this.myDisposable);
        new AnAction(){

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                Project project2 = e.getProject();
                e.getPresentation().setEnabled(session2 != null && project2 != null && LookupManager.getInstance(project2).getActiveLookup() == null);
            }

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                XDebuggerEvaluationDialog.this.addToWatches();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(ADD_WATCH_KEYSTROKE), this.getRootPane(), this.myDisposable);
        new AnAction(){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                IdeFocusManager.getInstance(project2).requestFocus(XDebuggerEvaluationDialog.this.myTreePanel.getTree(), true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog$2", "actionPerformed"));
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(82, 512)), this.getRootPane(), this.myDisposable);
        this.myTreePanel.getTree().expandNodesOnLoad(XDebuggerEvaluationDialog::isFirstChild);
        EvaluationMode mode = XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().getEvaluationDialogMode();
        if (mode == EvaluationMode.CODE_FRAGMENT && !this.myIsCodeFragmentEvaluationSupported) {
            mode = EvaluationMode.EXPRESSION;
        }
        if (mode == EvaluationMode.EXPRESSION && text2.getMode() == EvaluationMode.CODE_FRAGMENT && this.myIsCodeFragmentEvaluationSupported) {
            mode = EvaluationMode.CODE_FRAGMENT;
        }
        this.setTitle(XDebuggerBundle.message("xdebugger.evaluate.dialog.title", new Object[0]));
        this.switchToMode(mode, text2);
        FUCounterUsageLogger.getInstance().logEvent("debugger.evaluate.usage", "dialog.open", new FeatureUsageData().addData("mode", mode.name()));
        if (mode == EvaluationMode.EXPRESSION) {
            this.myInputComponent.getInputEditor().selectAll();
        }
        this.init();
        if (this.mySession != null) {
            this.mySession.addSessionListener(new XDebugSessionListener(){

                @Override
                public void sessionStopped() {
                    ApplicationManager.getApplication().invokeLater(() -> XDebuggerEvaluationDialog.this.close(1));
                }

                @Override
                public void stackFrameChanged() {
                    XDebuggerEvaluationDialog.this.updateSourcePosition();
                }

                @Override
                public void sessionPaused() {
                    XDebuggerEvaluationDialog.this.updateSourcePosition();
                }
            }, this.myDisposable);
        }
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.myMainPanel.removeAll();
    }

    private void updateSourcePosition() {
        if (this.mySession == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            this.mySourcePosition = this.mySession.getCurrentPosition();
            this.getInputEditor().setSourcePosition(this.mySourcePosition);
        });
    }

    @Override
    protected void doOKAction() {
        FUCounterUsageLogger.getInstance().logEvent("debugger.evaluate.usage", "evaluate", new FeatureUsageData().addData("mode", this.myMode.name()));
        this.evaluate();
    }

    @Override
    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction = new DialogWrapper.OkAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                if (XDebuggerEvaluationDialog.this.mySession != null && (e.getModifiers() & ADD_WATCH_MODIFIERS) == ADD_WATCH_MODIFIERS) {
                    XDebuggerEvaluationDialog.this.addToWatches();
                }
            }
        };
    }

    private void addToWatches() {
        XDebugSessionTab tab;
        XExpression expression;
        if (this.myMode == EvaluationMode.EXPRESSION && !XDebuggerUtilImpl.isEmptyExpression(expression = this.getInputEditor().getExpression()) && (tab = ((XDebugSessionImpl)this.mySession).getSessionTab()) != null) {
            tab.getWatchesView().addWatchExpression(expression, -1, true);
            this.getInputEditor().requestFocusInEditor();
        }
    }

    @Override
    protected String getHelpId() {
        return "debugging.debugMenu.evaluate";
    }

    @Override
    protected JButton createJButtonForAction(Action action2) {
        JButton button2 = super.createJButtonForAction(action2);
        if (action2 == this.mySwitchModeAction) {
            int width1 = new JButton((String)XDebuggerEvaluationDialog.getSwitchButtonText((EvaluationMode)EvaluationMode.EXPRESSION)).getPreferredSize().width;
            int width2 = new JButton((String)XDebuggerEvaluationDialog.getSwitchButtonText((EvaluationMode)EvaluationMode.CODE_FRAGMENT)).getPreferredSize().width;
            Dimension size = new Dimension(Math.max(width1, width2), button2.getPreferredSize().height);
            button2.setMinimumSize(size);
            button2.setPreferredSize(size);
        }
        return button2;
    }

    public XExpression getExpression() {
        return this.getInputEditor().getExpression();
    }

    private static String getSwitchButtonText(EvaluationMode mode) {
        return mode != EvaluationMode.EXPRESSION ? XDebuggerBundle.message("button.text.expression.mode", new Object[0]) : XDebuggerBundle.message("button.text.code.fragment.mode", new Object[0]);
    }

    private void switchToMode(EvaluationMode mode, XExpression text2) {
        if (this.myMode == mode) {
            return;
        }
        this.myMode = mode;
        Editor oldEditor = this.myInputComponent != null ? this.myInputComponent.getInputEditor().getEditor() : null;
        this.myInputComponent = this.createInputComponent(mode, text2);
        this.myMainPanel.removeAll();
        this.myInputComponent.addComponent(this.myMainPanel, this.myResultPanel);
        XDebuggerEditorBase.copyCaretPosition(oldEditor, this.myInputComponent.getInputEditor().getEditor());
        this.mySwitchModeAction.putValue("Name", XDebuggerEvaluationDialog.getSwitchButtonText(mode));
        this.getInputEditor().requestFocusInEditor();
    }

    private XDebuggerEditorBase getInputEditor() {
        return this.myInputComponent.getInputEditor();
    }

    private EvaluationInputComponent createInputComponent(EvaluationMode mode, XExpression text2) {
        text2 = XExpressionImpl.changeMode(text2, mode);
        if (mode == EvaluationMode.EXPRESSION) {
            ExpressionInputComponent component2 = new ExpressionInputComponent(this.myProject, this.myEditorsProvider, "evaluateExpression", this.mySourcePosition, text2, this.myDisposable, this.mySession != null);
            component2.getInputEditor().setExpandHandler(() -> this.mySwitchModeAction.actionPerformed(null));
            return component2;
        }
        CodeFragmentInputComponent component3 = new CodeFragmentInputComponent(this.myProject, this.myEditorsProvider, this.mySourcePosition, text2, this.getDimensionServiceKey() + ".splitter", this.myDisposable);
        component3.getInputEditor().addCollapseButton(() -> this.mySwitchModeAction.actionPerformed(null));
        return component3;
    }

    private void evaluate() {
        XDebuggerEditorBase inputEditor = this.getInputEditor();
        int offset = -1;
        Editor editor = inputEditor.getEditor();
        if (editor != null) {
            offset = editor.getCaretModel().getOffset();
        }
        XDebuggerTree tree = this.myTreePanel.getTree();
        tree.markNodesObsolete();
        tree.setRoot(new EvaluatingExpressionRootNode(this, tree), false);
        tree.selectNodeOnLoad(XDebuggerEvaluationDialog::isFirstChild, Conditions.alwaysFalse());
        this.myResultPanel.invalidate();
        editor = inputEditor.getEditor();
        inputEditor.requestFocusInEditor();
        if (offset >= 0 && editor != null) {
            offset = Math.min(editor.getDocument().getTextLength(), offset);
            editor.getCaretModel().moveToOffset(offset);
            editor.getSelectionModel().setSelection(offset, offset);
        }
    }

    private static boolean isFirstChild(TreeNode node) {
        return node.getParent() instanceof EvaluatingExpressionRootNode;
    }

    @Override
    public void doCancelAction() {
        this.getInputEditor().saveTextInHistory();
        super.doCancelAction();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "#xdebugger.evaluate";
    }

    @Override
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public void startEvaluation(@NotNull XDebuggerEvaluator.XEvaluationCallback evaluationCallback) {
        XDebuggerEvaluator evaluator;
        if (evaluationCallback == null) {
            XDebuggerEvaluationDialog.$$$reportNull$$$0(10);
        }
        XDebuggerEditorBase inputEditor = this.getInputEditor();
        inputEditor.saveTextInHistory();
        XExpression expression = inputEditor.getExpression();
        XDebuggerEvaluator xDebuggerEvaluator = evaluator = this.mySession == null ? this.myEvaluatorSupplier.get() : this.mySession.getDebugProcess().getEvaluator();
        if (evaluator == null) {
            evaluationCallback.errorOccurred(XDebuggerBundle.message("xdebugger.evaluate.stack.frame.has.not.evaluator", new Object[0]));
        } else {
            evaluator.evaluate(expression, evaluationCallback, null);
        }
    }

    public void evaluationDone() {
        if (this.mySession != null) {
            this.mySession.rebuildViews();
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.getInputEditor().getPreferredFocusedComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorsProvider";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationCallback";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "startEvaluation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class EvaluationMainPanel
    extends BorderLayoutPanel
    implements DataProvider {
        private EvaluationMainPanel() {
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                EvaluationMainPanel.$$$reportNull$$$0(0);
            }
            if (KEY.is(dataId)) {
                return XDebuggerEvaluationDialog.this;
            }
            return null;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            d.width = Math.max(d.width, JBUI.scale(450));
            return d;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog$EvaluationMainPanel", "getData"));
        }
    }

    private class SwitchModeAction
    extends AbstractAction {
        private SwitchModeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XExpression text2 = XDebuggerEvaluationDialog.this.getInputEditor().getExpression();
            EvaluationMode newMode = XDebuggerEvaluationDialog.this.myMode == EvaluationMode.EXPRESSION ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION;
            XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().setEvaluationDialogMode(newMode);
            FUCounterUsageLogger.getInstance().logEvent("debugger.evaluate.usage", "mode.switch", new FeatureUsageData().addData("mode", newMode.name()));
            XDebuggerEvaluationDialog.this.switchToMode(newMode, text2);
        }
    }
}

