/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.OccurenceNavigator;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.xdebugger.XDebuggerBundle;
import java.awt.Point;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;
import org.jetbrains.annotations.NotNull;

public abstract class DebuggerFramesList
extends JBList
implements OccurenceNavigator {
    public DebuggerFramesList() {
        super(new CollectionListModel<Object>(new Object[0]));
    }

    protected void doInit() {
        this.getSelectionModel().setSelectionMode(0);
        this.setCellRenderer(this.createListRenderer());
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DebuggerFramesList.this.onFrameChanged(DebuggerFramesList.this.getSelectedValue());
                }
            }
        });
        this.getEmptyText().setText(XDebuggerBundle.message("debugger.frames.not.available", new Object[0]));
    }

    @Override
    public void setModel(ListModel model) {
    }

    public CollectionListModel getModel() {
        return (CollectionListModel)super.getModel();
    }

    public void clear() {
        this.getModel().removeAll();
    }

    public int getElementCount() {
        return this.getModel().getSize();
    }

    @Override
    @NotNull
    public String getNextOccurenceActionName() {
        String string = XDebuggerBundle.message("action.next.frame.text", new Object[0]);
        if (string == null) {
            DebuggerFramesList.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = XDebuggerBundle.message("action.previous.frame.text", new Object[0]);
        if (string == null) {
            DebuggerFramesList.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        this.setSelectedIndex(this.getSelectedIndex() + 1);
        return this.createInfo();
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        this.setSelectedIndex(this.getSelectedIndex() - 1);
        return this.createInfo();
    }

    private OccurenceNavigator.OccurenceInfo createInfo() {
        return OccurenceNavigator.OccurenceInfo.position(this.getSelectedIndex(), this.getElementCount());
    }

    @Override
    public boolean hasNextOccurence() {
        return this.getSelectedIndex() < this.getElementCount() - 1;
    }

    @Override
    public boolean hasPreviousOccurence() {
        return this.getSelectedIndex() > 0;
    }

    protected abstract ListCellRenderer createListRenderer();

    protected abstract void onFrameChanged(Object var1);

    @Override
    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        return -1;
    }

    @Override
    public int locationToIndex(Point location2) {
        if (location2.y <= this.getPreferredSize().height) {
            return super.locationToIndex(location2);
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/xdebugger/impl/frame/DebuggerFramesList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

