/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.openapi.CompositeDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.DebuggerSessionTabBase;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XWatchTransferable;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XWatchesViewImpl
extends XVariablesView
implements DnDNativeTarget,
XWatchesView {
    private WatchesRootNode myRootNode;
    private final CompositeDisposable myDisposables;
    private final boolean myWatchesInVariables;

    public XWatchesViewImpl(@NotNull XDebugSessionImpl session2, boolean watchesInVariables) {
        if (session2 == null) {
            XWatchesViewImpl.$$$reportNull$$$0(0);
        }
        this(session2, watchesInVariables, watchesInVariables);
    }

    public XWatchesViewImpl(@NotNull XDebugSessionImpl session2, boolean watchesInVariables, boolean vertical) {
        if (session2 == null) {
            XWatchesViewImpl.$$$reportNull$$$0(1);
        }
        super(session2);
        this.myDisposables = new CompositeDisposable();
        this.myWatchesInVariables = watchesInVariables;
        XDebuggerTree tree = this.getTree();
        this.createNewRootNode(null);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.NewWatch", tree, this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.RemoveWatch", tree, this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.CopyWatch", tree, this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.EditWatch", tree, this.myDisposables);
        EmptyAction.registerWithShortcutSet("XDebugger.NewWatch", CommonShortcuts.getNew(), tree);
        EmptyAction.registerWithShortcutSet("XDebugger.RemoveWatch", CommonShortcuts.getDelete(), tree);
        DnDManager.getInstance().registerTarget(this, tree);
        new AnAction(){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                Object contents;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((contents = CopyPasteManager.getInstance().getContents(XWatchTransferable.EXPRESSIONS_FLAVOR)) instanceof List) {
                    for (Object item : (List)contents) {
                        if (!(item instanceof XExpression)) continue;
                        XWatchesViewImpl.this.addWatchExpression((XExpression)item, -1, true);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$1", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.getPaste(), tree, this.myDisposables);
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("DebuggerToolbar", DebuggerSessionTabBase.getCustomizedActionGroup("XDebugger.Watches.Tree.Toolbar"), !vertical);
        toolbar.setBorder(new CustomLineBorder(CaptionPanel.CNT_ACTIVE_BORDER_COLOR, 0, 0, vertical ? 0 : 1, vertical ? 1 : 0));
        toolbar.setTargetComponent(tree);
        if (!this.myWatchesInVariables) {
            this.getTree().getEmptyText().setText(XDebuggerBundle.message("debugger.no.watches", new Object[0]));
        }
        this.getPanel().add((Component)toolbar.getComponent(), vertical ? "West" : "North");
        this.installEditListeners();
    }

    private void installEditListeners() {
        final XDebuggerTree watchTree = this.getTree();
        final Alarm quitePeriod = new Alarm();
        final Alarm editAlarm = new Alarm();
        final ClickListener mouseListener = new ClickListener(){

            @Override
            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!SwingUtilities.isLeftMouseButton(event) || (event.getModifiers() & 0xF) != 0) {
                    return false;
                }
                boolean sameRow = XWatchesViewImpl.isAboveSelectedItem(event, watchTree, false);
                if (!sameRow || clickCount > 1) {
                    editAlarm.cancelAllRequests();
                    return false;
                }
                AnAction editWatchAction = ActionManager.getInstance().getAction("XDebugger.EditWatch");
                Presentation presentation = editWatchAction.getTemplatePresentation().clone();
                DataContext context = DataManager.getInstance().getDataContext(watchTree);
                AnActionEvent actionEvent = new AnActionEvent(null, context, "WATCH_TREE", presentation, ActionManager.getInstance(), 0);
                Runnable runnable2 = () -> editWatchAction.actionPerformed(actionEvent);
                if (editAlarm.isEmpty() && quitePeriod.isEmpty()) {
                    editAlarm.addRequest(runnable2, UIUtil.getMultiClickInterval());
                } else {
                    editAlarm.cancelAllRequests();
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$2", "onClick"));
            }
        };
        final DoubleClickListener mouseEmptySpaceListener = new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(MouseEvent event) {
                if (!XWatchesViewImpl.isAboveSelectedItem(event, watchTree, true)) {
                    XWatchesViewImpl.this.myRootNode.addNewWatch();
                    return true;
                }
                return false;
            }
        };
        ListenerUtil.addClickListener(watchTree, mouseListener);
        ListenerUtil.addClickListener(watchTree, mouseEmptySpaceListener);
        final FocusListener focusListener2 = new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                quitePeriod.addRequest(EmptyRunnable.getInstance(), UIUtil.getMultiClickInterval());
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                editAlarm.cancelAllRequests();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ListenerUtil.addFocusListener(watchTree, focusListener2);
        final TreeSelectionListener selectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                quitePeriod.addRequest(EmptyRunnable.getInstance(), UIUtil.getMultiClickInterval());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$5", "valueChanged"));
            }
        };
        watchTree.addTreeSelectionListener(selectionListener);
        this.myDisposables.add(new Disposable(){

            @Override
            public void dispose() {
                ListenerUtil.removeClickListener(watchTree, mouseListener);
                ListenerUtil.removeClickListener(watchTree, mouseEmptySpaceListener);
                ListenerUtil.removeFocusListener(watchTree, focusListener2);
                watchTree.removeTreeSelectionListener(selectionListener);
            }
        });
    }

    @Override
    public void dispose() {
        Disposer.dispose(this.myDisposables);
        DnDManager.getInstance().unregisterTarget(this, this.getTree());
        super.dispose();
    }

    private static boolean isAboveSelectedItem(MouseEvent event, XDebuggerTree watchTree, boolean fullWidth) {
        Rectangle bounds2 = watchTree.getRowBounds(watchTree.getLeadSelectionRow());
        if (bounds2 != null) {
            if (fullWidth) {
                bounds2.x = 0;
            }
            bounds2.width = watchTree.getWidth();
            if (bounds2.contains(event.getPoint())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addWatchExpression(@NotNull XExpression expression, int index, boolean navigateToWatchNode) {
        if (expression == null) {
            XWatchesViewImpl.$$$reportNull$$$0(2);
        }
        this.addWatchExpression(expression, index, navigateToWatchNode, false);
    }

    public void addWatchExpression(@NotNull XExpression expression, int index, boolean navigateToWatchNode, boolean noDuplicates) {
        if (expression == null) {
            XWatchesViewImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        XDebugSession session2 = XWatchesViewImpl.getSession(this.getTree());
        boolean found2 = false;
        if (noDuplicates) {
            for (WatchNode watchNode : this.myRootNode.getWatchChildren()) {
                if (!watchNode.getExpression().equals(expression)) continue;
                TreeUtil.selectNode(this.getTree(), watchNode);
                found2 = true;
            }
        }
        if (!found2) {
            this.myRootNode.addWatchExpression(session2 != null ? session2.getCurrentStackFrame() : null, expression, index, navigateToWatchNode);
            this.updateSessionData();
        }
        if (navigateToWatchNode && session2 != null) {
            XDebugSessionTab.showWatchesView((XDebugSessionImpl)session2);
        }
    }

    public void computeWatches() {
        this.myRootNode.computeWatches();
    }

    @Override
    protected XValueContainerNode doCreateNewRootNode(@Nullable XStackFrame stackFrame) {
        WatchesRootNode node;
        this.myRootNode = node = new WatchesRootNode(this.getTree(), this, this.getExpressions(), stackFrame, this.myWatchesInVariables);
        return node;
    }

    @Override
    protected void addEmptyMessage(XValueContainerNode root) {
        if (this.myWatchesInVariables) {
            super.addEmptyMessage(root);
        }
    }

    @NotNull
    private List<XExpression> getExpressions() {
        List<XExpression> expressions;
        XDebuggerTree tree = this.getTree();
        XDebugSession session2 = XWatchesViewImpl.getSession(tree);
        if (session2 != null) {
            expressions = ((XDebugSessionImpl)session2).getSessionData().getWatchExpressions();
        } else {
            XDebuggerTreeNode root = tree.getRoot();
            List<WatchNode> current2 = root instanceof WatchesRootNode ? ((WatchesRootNode)tree.getRoot()).getWatchChildren() : Collections.emptyList();
            SmartList<XExpression> list2 = new SmartList<XExpression>();
            for (WatchNode child2 : current2) {
                list2.add(child2.getExpression());
            }
            expressions = list2;
        }
        List<XExpression> list2 = expressions;
        if (list2 == null) {
            XWatchesViewImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            XWatchesViewImpl.$$$reportNull$$$0(5);
        }
        if (XWatchesView.DATA_KEY.is(dataId)) {
            return this;
        }
        return super.getData(dataId);
    }

    @Override
    public void removeWatches(List<? extends XDebuggerTreeNode> nodes) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<? extends WatchNode> children2 = this.myRootNode.getWatchChildren();
        int minIndex = Integer.MAX_VALUE;
        ArrayList<XDebuggerTreeNode> toRemove2 = new ArrayList<XDebuggerTreeNode>();
        for (XDebuggerTreeNode xDebuggerTreeNode : nodes) {
            int index = children2.indexOf(xDebuggerTreeNode);
            if (index == -1) continue;
            toRemove2.add(xDebuggerTreeNode);
            minIndex = Math.min(minIndex, index);
        }
        this.myRootNode.removeChildren(toRemove2);
        List<? extends WatchNode> newChildren = this.myRootNode.getWatchChildren();
        if (!newChildren.isEmpty()) {
            WatchNode watchNode = newChildren.get(Math.min(minIndex, newChildren.size() - 1));
            TreeUtil.selectNode(this.getTree(), watchNode);
        }
        this.updateSessionData();
    }

    @Override
    public void removeAllWatches() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myRootNode.removeAllChildren();
        this.updateSessionData();
    }

    public void moveWatchUp(WatchNode node) {
        this.myRootNode.moveUp(node);
        this.updateSessionData();
    }

    public void moveWatchDown(WatchNode node) {
        this.myRootNode.moveDown(node);
        this.updateSessionData();
    }

    public void updateSessionData() {
        SmartList<XExpression> expressions = new SmartList<XExpression>();
        List<? extends WatchNode> children2 = this.myRootNode.getWatchChildren();
        for (WatchNode watchNode : children2) {
            expressions.add(watchNode.getExpression());
        }
        XDebugSession session2 = XWatchesViewImpl.getSession(this.getTree());
        if (session2 != null) {
            ((XDebugSessionImpl)session2).setWatchExpressions(expressions);
        } else {
            XDebugSessionData xDebugSessionData = XWatchesViewImpl.getData(XDebugSessionData.DATA_KEY, this.getTree());
            if (xDebugSessionData != null) {
                xDebugSessionData.setWatchExpressions(expressions);
            }
        }
    }

    @Override
    public boolean update(DnDEvent aEvent) {
        Object object = aEvent.getAttachedObject();
        boolean possible = false;
        if (object instanceof XValueNodeImpl[]) {
            possible = true;
            if (((XValueNodeImpl[])object).length == 1) {
                Point point = aEvent.getPoint();
                XDebuggerTree tree = this.getTree();
                TreePath path2 = tree.getClosestPathForLocation(point.x, point.y);
                if (path2 != null && path2.getLastPathComponent() == ((XValueNodeImpl[])object)[0]) {
                    Rectangle pathBounds = tree.getPathBounds(path2);
                    possible = pathBounds != null && pathBounds.y + pathBounds.height < point.y;
                }
            }
        } else if (object instanceof DnDNativeTarget.EventInfo) {
            possible = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor) != null;
        }
        aEvent.setDropPossible(possible, XDebuggerBundle.message("xdebugger.drop.text.add.to.watches", new Object[0]));
        return true;
    }

    @Override
    public void drop(DnDEvent aEvent) {
        String text2;
        Object object = aEvent.getAttachedObject();
        if (object instanceof XValueNodeImpl[]) {
            for (XValueNodeImpl node : (XValueNodeImpl[])object) {
                DebuggerUIUtil.addToWatches(this, node);
            }
        } else if (object instanceof DnDNativeTarget.EventInfo && (text2 = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor)) != null) {
            this.addWatchExpression(XExpressionImpl.fromText(text2), -1, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addWatchExpression";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

