/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MergedCompositeConfigurable
extends CompositeConfigurable<Configurable>
implements SearchableConfigurable {
    static final EmptyBorder BOTTOM_INSETS = new EmptyBorder(0, 0, 10, 0);
    private static final Insets FIRST_COMPONENT_INSETS = new Insets(0, 0, 10, 0);
    private static final Insets N_COMPONENT_INSETS = new Insets(7, 0, 10, 0);
    protected final Configurable[] children;
    protected JComponent rootComponent;
    private final String id;
    private final String displayName;
    private final String helpTopic;

    MergedCompositeConfigurable(@NotNull String id2, @NotNull String displayName, @Nullable String helpTopic, Configurable @NotNull [] children2) {
        if (id2 == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(1);
        }
        if (children2 == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(2);
        }
        this.children = children2;
        this.id = id2;
        this.displayName = displayName;
        this.helpTopic = helpTopic;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nls
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Nullable
    public String getHelpTopic() {
        if (this.helpTopic != null) {
            return this.helpTopic;
        }
        return this.children.length == 1 ? this.children[0].getHelpTopic() : null;
    }

    protected boolean isUseTargetedProductPolicyIfSeveralChildren() {
        return false;
    }

    @Override
    @Nullable
    public JComponent createComponent() {
        if (this.rootComponent == null) {
            Configurable firstConfigurable = this.children[0];
            if (this.children.length == 1) {
                JComponent component2 = firstConfigurable.createComponent();
                String rootComponentDisplayName = firstConfigurable.getDisplayName();
                if (!StringUtil.isEmpty(rootComponentDisplayName) && !MergedCompositeConfigurable.isTargetedToProduct(firstConfigurable)) {
                    component2.setBorder(IdeBorderFactory.createTitledBorder(rootComponentDisplayName, false, FIRST_COMPONENT_INSETS));
                }
                this.rootComponent = MergedCompositeConfigurable.createPanel(true);
                this.rootComponent.add(component2);
            } else {
                boolean isFirstNamed = true;
                JPanel panel2 = MergedCompositeConfigurable.createPanel(true);
                for (Configurable configurable2 : this.children) {
                    JComponent component3 = configurable2.createComponent();
                    assert (component3 != null);
                    String displayName = configurable2.getDisplayName();
                    if (StringUtil.isEmpty(displayName)) {
                        component3.setBorder(BOTTOM_INSETS);
                    } else {
                        boolean addBorder = true;
                        if (this.isUseTargetedProductPolicyIfSeveralChildren() && isFirstNamed) {
                            isFirstNamed = false;
                            if (MergedCompositeConfigurable.isTargetedToProduct(configurable2)) {
                                addBorder = false;
                            }
                        }
                        if (addBorder) {
                            component3.setBorder(IdeBorderFactory.createTitledBorder(displayName, false, firstConfigurable == configurable2 ? FIRST_COMPONENT_INSETS : N_COMPONENT_INSETS));
                        }
                    }
                    panel2.add(component3);
                }
                this.rootComponent = panel2;
            }
        }
        return this.rootComponent;
    }

    static boolean isTargetedToProduct(@NotNull Configurable configurable2) {
        if (configurable2 == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(4);
        }
        return DebuggerConfigurableProvider.EXTENSION_POINT.extensions().anyMatch(provider -> provider.isTargetedToProduct(configurable2));
    }

    @NotNull
    static JPanel createPanel(boolean isUseTitledBorder) {
        int verticalGap = 7;
        JPanel panel2 = new JPanel(new VerticalFlowLayout(0, 0, isUseTitledBorder ? 0 : verticalGap, true, true));
        if (!isUseTitledBorder) {
            panel2.setBorder(new EmptyBorder(-verticalGap, 0, 0, 0));
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @Override
    public void disposeUIResources() {
        this.rootComponent = null;
        super.disposeUIResources();
    }

    @Override
    @NotNull
    protected List<Configurable> createConfigurables() {
        List<Configurable> list2 = Arrays.asList(this.children);
        if (list2 == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/settings/MergedCompositeConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/settings/MergedCompositeConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTargetedToProduct";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

