/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.XDebuggerBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class BreakpointEditor {
    private JPanel myMainPanel;
    private JButton myDoneButton;
    private JPanel myPropertiesPlaceholder;
    private LinkLabel myShowMoreOptionsLink;
    private Delegate myDelegate;

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        AnAction action2 = ActionManager.getInstance().getAction("ViewBreakpoints");
        String shortcutText = action2 != null ? KeymapUtil.getFirstKeyboardShortcutText(action2) : null;
        String text2 = XDebuggerBundle.message("xbreakpoints.popup.more.label", new Object[0]);
        if (shortcutText != null) {
            text2 = text2 + " (" + shortcutText + ")";
        }
        this.myShowMoreOptionsLink = LinkLabel.create(text2, () -> {
            if (this.myDelegate != null) {
                this.myDelegate.more();
            }
        });
    }

    public void setShowMoreOptionsLink(boolean b) {
        this.myShowMoreOptionsLink.setVisible(b);
    }

    public BreakpointEditor() {
        this.$$$setupUI$$$();
        this.myDoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointEditor.this.done();
            }
        });
        DumbAwareAction doneAction = new DumbAwareAction(){

            @Override
            public void update(@NotNull AnActionEvent e) {
                JComboBox comboBox2;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.update(e);
                Project project2 = 2.getEventProject(e);
                Editor editor = e.getData(CommonDataKeys.EDITOR);
                boolean disabled = project2 != null && (LookupManager.getInstance(project2).getActiveLookup() != null || editor != null && TemplateManager.getInstance(project2).getActiveTemplate(editor) != null);
                Component owner = IdeFocusManager.findInstance().getFocusOwner();
                if (owner != null && (comboBox2 = ComponentUtil.getParentOfType(JComboBox.class, owner)) != null && comboBox2.isPopupVisible()) {
                    disabled = true;
                }
                e.getPresentation().setEnabled(!disabled && (editor == null || StringUtil.isEmpty(editor.getSelectionModel().getSelectedText())));
            }

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                BreakpointEditor.this.done();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/BreakpointEditor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        doneAction.registerCustomShortcutSet(new CompositeShortcutSet(CommonShortcuts.ESCAPE, CommonShortcuts.ENTER, CommonShortcuts.CTRL_ENTER), this.myMainPanel);
    }

    private void done() {
        if (this.myDelegate != null) {
            this.myDelegate.done();
        }
    }

    public void setPropertiesPanel(JComponent p) {
        this.myPropertiesPlaceholder.removeAll();
        this.myPropertiesPlaceholder.add((Component)p, "Center");
    }

    public void setDelegate(Delegate d) {
        this.myDelegate = d;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        this.myPropertiesPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDoneButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle("messages/XDebuggerBundle", BreakpointEditor.class).getString("done.action.text"));
        jPanel3.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        LinkLabel linkLabel = this.myShowMoreOptionsLink;
        jPanel3.add((Component)linkLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface Delegate {
        public void done();

        public void more();
    }
}

