/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.LayoutStateDefaults;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebuggerBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerSessionTabBase
extends RunTab {
    protected ExecutionConsole myConsole;

    public DebuggerSessionTabBase(@NotNull Project project2, @NotNull String runnerId, @NotNull String sessionName, @NotNull GlobalSearchScope searchScope, boolean shouldInitTabDefaults) {
        if (project2 == null) {
            DebuggerSessionTabBase.$$$reportNull$$$0(0);
        }
        if (runnerId == null) {
            DebuggerSessionTabBase.$$$reportNull$$$0(1);
        }
        if (sessionName == null) {
            DebuggerSessionTabBase.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            DebuggerSessionTabBase.$$$reportNull$$$0(3);
        }
        super(project2, searchScope, runnerId, XDebuggerBundle.message("xdebugger.default.content.title", new Object[0]), sessionName);
        LayoutStateDefaults defaults = this.myUi.getDefaults();
        if (shouldInitTabDefaults) {
            defaults.initTabDefaults(0, XDebuggerBundle.message("xdebugger.debugger.tab.title", new Object[0]), null);
        }
        defaults.initContentAttraction("FrameContent", "breakpoint").initContentAttraction("ConsoleContent", "startup", new LayoutAttractionPolicy.FocusOnce(false));
    }

    public static ActionGroup getCustomizedActionGroup(String id2) {
        return (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(id2);
    }

    protected void attachNotificationTo(Content content2) {
        if (this.myConsole instanceof ObservableConsoleView) {
            ObservableConsoleView observable2 = (ObservableConsoleView)((Object)this.myConsole);
            observable2.addChangeListener(types -> {
                if (types.contains(ConsoleViewContentType.ERROR_OUTPUT) || types.contains(ConsoleViewContentType.NORMAL_OUTPUT)) {
                    content2.fireAlert();
                }
            }, content2);
            RunProfile profile = this.getRunProfile();
            if (profile instanceof RunConfigurationBase && !ApplicationManager.getApplication().isUnitTestMode()) {
                observable2.addChangeListener(new RunContentBuilder.ConsoleToFrontListener((RunConfigurationBase)profile, this.myProject, DefaultDebugExecutor.getDebugExecutorInstance(), this.myRunContentDescriptor, this.myUi), content2);
            }
        }
    }

    @Nullable
    protected RunProfile getRunProfile() {
        return this.myEnvironment != null ? this.myEnvironment.getRunProfile() : null;
    }

    public void select() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (this.myRunContentDescriptor != null) {
                RunContentManager manager = RunContentManager.getInstance(this.myProject);
                ToolWindow toolWindow = manager.getToolWindowByDescriptor(this.myRunContentDescriptor);
                Content content2 = this.myRunContentDescriptor.getAttachedContent();
                if (toolWindow == null || content2 == null) {
                    return;
                }
                manager.selectRunContent(this.myRunContentDescriptor);
            }
        }, ModalityState.defaultModalityState());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "runnerId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "sessionName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "searchScope";
                break;
            }
        }
        objectArray[1] = "com/intellij/xdebugger/impl/ui/DebuggerSessionTabBase";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

