/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Font;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeadlessValueEvaluationCallback
implements XFullValueEvaluator.XFullValueEvaluationCallback {
    private final XValueNodeImpl myNode;
    private volatile boolean myEvaluated;
    private volatile boolean myCanceled;
    private final Semaphore mySemaphore;

    public HeadlessValueEvaluationCallback(@NotNull XValueNodeImpl node) {
        if (node == null) {
            HeadlessValueEvaluationCallback.$$$reportNull$$$0(0);
        }
        this.myNode = node;
        this.mySemaphore = new Semaphore();
        this.mySemaphore.down();
    }

    public void startFetchingValue(@NotNull XFullValueEvaluator fullValueEvaluator) {
        if (fullValueEvaluator == null) {
            HeadlessValueEvaluationCallback.$$$reportNull$$$0(1);
        }
        fullValueEvaluator.startEvaluation(this);
        new Alarm().addRequest(() -> this.showProgress(), 500);
    }

    @Override
    public void evaluated(@NotNull String fullValue) {
        if (fullValue == null) {
            HeadlessValueEvaluationCallback.$$$reportNull$$$0(2);
        }
        this.evaluationComplete(fullValue);
    }

    @Override
    public void evaluated(@NotNull String fullValue, @Nullable Font font) {
        if (fullValue == null) {
            HeadlessValueEvaluationCallback.$$$reportNull$$$0(3);
        }
        this.evaluated(fullValue);
    }

    @Override
    public void errorOccurred(@NotNull String errorMessage) {
        if (errorMessage == null) {
            HeadlessValueEvaluationCallback.$$$reportNull$$$0(4);
        }
        try {
            String message = XDebuggerBundle.message("load.value.task.error", errorMessage);
            XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(message, NotificationType.ERROR).notify(this.myNode.getTree().getProject());
        }
        finally {
            this.evaluationComplete(errorMessage);
        }
    }

    private void evaluationComplete(@NotNull String value2) {
        if (value2 == null) {
            HeadlessValueEvaluationCallback.$$$reportNull$$$0(5);
        }
        try {
            this.myEvaluated = true;
            this.mySemaphore.up();
        }
        finally {
            this.evaluationComplete(value2, this.myNode.getTree().getProject());
        }
    }

    public XValueNodeImpl getNode() {
        return this.myNode;
    }

    protected void evaluationComplete(@NotNull String value2, @NotNull Project project2) {
        if (value2 == null) {
            HeadlessValueEvaluationCallback.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            HeadlessValueEvaluationCallback.$$$reportNull$$$0(7);
        }
    }

    @Override
    public boolean isObsolete() {
        return this.myCanceled;
    }

    public void showProgress() {
        if (this.myEvaluated || this.myNode.isObsolete()) {
            return;
        }
        new Task.Backgroundable(this.myNode.getTree().getProject(), XDebuggerBundle.message("load.value.task.text", new Object[0])){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                int i = 0;
                while (!HeadlessValueEvaluationCallback.this.myCanceled && !HeadlessValueEvaluationCallback.this.myEvaluated) {
                    indicator.checkCanceled();
                    indicator.setFraction((double)(i++ % 100) * 0.01);
                    HeadlessValueEvaluationCallback.this.mySemaphore.waitFor(300L);
                }
            }

            @Override
            public boolean shouldStartInBackground() {
                return false;
            }

            @Override
            public void onCancel() {
                HeadlessValueEvaluationCallback.this.myCanceled = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/xdebugger/impl/ui/tree/nodes/HeadlessValueEvaluationCallback$1", "run"));
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullValueEvaluator";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/HeadlessValueEvaluationCallback";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "startFetchingValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluated";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "errorOccurred";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluationComplete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

