/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.WatchInplaceEditor;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchesRootNode
extends XValueContainerNode<XValueContainer> {
    private final XWatchesView myWatchesView;
    private final List<WatchNodeImpl> myChildren;

    public WatchesRootNode(@NotNull XDebuggerTree tree, @NotNull XWatchesView watchesView, XExpression @NotNull [] expressions) {
        if (tree == null) {
            WatchesRootNode.$$$reportNull$$$0(0);
        }
        if (watchesView == null) {
            WatchesRootNode.$$$reportNull$$$0(1);
        }
        if (expressions == null) {
            WatchesRootNode.$$$reportNull$$$0(2);
        }
        this(tree, watchesView, Arrays.asList(expressions), null, false);
    }

    public WatchesRootNode(@NotNull XDebuggerTree tree, @NotNull XWatchesView watchesView, @NotNull List<? extends XExpression> expressions, final @Nullable XStackFrame stackFrame, final boolean watchesInVariables) {
        if (tree == null) {
            WatchesRootNode.$$$reportNull$$$0(3);
        }
        if (watchesView == null) {
            WatchesRootNode.$$$reportNull$$$0(4);
        }
        if (expressions == null) {
            WatchesRootNode.$$$reportNull$$$0(5);
        }
        super(tree, null, false, new XValueContainer(){

            @Override
            public void computeChildren(@NotNull XCompositeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (stackFrame != null && watchesInVariables) {
                    stackFrame.computeChildren(node);
                } else {
                    node.addChildren(XValueChildrenList.EMPTY, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode$1", "computeChildren"));
            }
        });
        this.myWatchesView = watchesView;
        this.myChildren = new ArrayList<WatchNodeImpl>();
        for (XExpression xExpression : expressions) {
            this.myChildren.add(new WatchNodeImpl(this.myTree, this, xExpression, stackFrame));
        }
    }

    @Override
    @NotNull
    public List<? extends XValueContainerNode<?>> getLoadedChildren() {
        List<XValueContainerNode<?>> list2 = ContainerUtil.concat(this.myChildren, super.getLoadedChildren());
        if (list2 == null) {
            WatchesRootNode.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<? extends TreeNode> getChildren() {
        List<TreeNode> children2 = super.getChildren();
        List<TreeNode> list2 = ContainerUtil.concat(this.myChildren, children2);
        if (list2 == null) {
            WatchesRootNode.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Deprecated
    @NotNull
    public List<? extends WatchNode> getAllChildren() {
        List<? extends WatchNode> list2 = this.getWatchChildren();
        if (list2 == null) {
            WatchesRootNode.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public List<? extends WatchNode> getWatchChildren() {
        List<WatchNodeImpl> list2 = this.myChildren;
        if (list2 == null) {
            WatchesRootNode.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        this.myChildren.clear();
    }

    public void computeWatches() {
        this.myChildren.forEach(WatchNodeImpl::computePresentationIfNeeded);
    }

    @Deprecated
    public void addWatchExpression(@Nullable XDebuggerEvaluator evaluator, @NotNull XExpression expression, int index, boolean navigateToWatchNode) {
        if (expression == null) {
            WatchesRootNode.$$$reportNull$$$0(10);
        }
        this.addWatchExpression((XStackFrame)null, expression, index, navigateToWatchNode);
    }

    public void addWatchExpression(@Nullable XStackFrame stackFrame, @NotNull XExpression expression, int index, boolean navigateToWatchNode) {
        if (expression == null) {
            WatchesRootNode.$$$reportNull$$$0(11);
        }
        WatchNodeImpl message = new WatchNodeImpl(this.myTree, this, expression, stackFrame);
        if (index == -1) {
            this.myChildren.add(message);
            index = this.myChildren.size() - 1;
        } else {
            this.myChildren.add(index, message);
        }
        this.fireNodeInserted(index);
        TreeUtil.selectNode(this.myTree, message);
        if (navigateToWatchNode) {
            this.myTree.scrollPathToVisible(message.getPath());
        }
    }

    private void fireNodeInserted(int index) {
        this.myTree.getTreeModel().nodesWereInserted(this, new int[]{index});
    }

    public int removeChildNode(XDebuggerTreeNode node) {
        return this.removeChildNode(this.myChildren, node);
    }

    public void removeChildren(Collection<? extends XDebuggerTreeNode> nodes) {
        int[] indices = this.getNodesIndices(nodes);
        TreeNode[] removed = this.getChildNodes(indices);
        this.myChildren.removeAll(nodes);
        this.fireNodesRemoved(indices, removed);
    }

    public void removeAllChildren() {
        this.myChildren.clear();
        this.fireNodeStructureChanged();
    }

    public void moveUp(WatchNode node) {
        int index = this.getIndex(node);
        if (index > 0) {
            ContainerUtil.swapElements(this.myChildren, index, index - 1);
        }
        this.fireNodeStructureChanged();
        this.getTree().setSelectionRow(index - 1);
    }

    public void moveDown(WatchNode node) {
        int index = this.getIndex(node);
        if (index < this.myChildren.size() - 1) {
            ContainerUtil.swapElements(this.myChildren, index, index + 1);
        }
        this.fireNodeStructureChanged();
        this.getTree().setSelectionRow(index + 1);
    }

    public void addNewWatch() {
        this.editWatch(null);
    }

    public void editWatch(@Nullable WatchNodeImpl node) {
        WatchNodeImpl messageNode;
        int index;
        int n = index = node != null ? this.myChildren.indexOf(node) : -1;
        if (index == -1) {
            int selectedIndex = this.myChildren.indexOf(ArrayUtil.getFirstElement(this.myTree.getSelectedNodes(WatchNodeImpl.class, null)));
            int targetIndex = selectedIndex == -1 ? this.myChildren.size() : selectedIndex + 1;
            messageNode = new WatchNodeImpl(this.myTree, this, XExpressionImpl.EMPTY_EXPRESSION, null);
            this.myChildren.add(targetIndex, messageNode);
            this.fireNodeInserted(targetIndex);
            this.getTree().setSelectionRows(ArrayUtilRt.EMPTY_INT_ARRAY);
        } else {
            messageNode = node;
        }
        new WatchInplaceEditor(this, this.myWatchesView, messageNode, node).show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchesView";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChildren";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addWatchExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

