/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueGroupNodeImpl
extends XValueContainerNode<XValueGroup>
implements RestorableStateNode {
    public XValueGroupNodeImpl(XDebuggerTree tree, XDebuggerTreeNode parent, @NotNull XValueGroup group) {
        if (group == null) {
            XValueGroupNodeImpl.$$$reportNull$$$0(0);
        }
        super(tree, parent, false, group);
        this.setIcon(group.getIcon());
        this.myText.append(group.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String comment = group.getComment();
        if (comment != null) {
            XValuePresentationUtil.appendSeparator((ColoredTextContainer)this.myText, group.getSeparator());
            this.myText.append(comment, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (this.isExpand(group)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.isObsolete()) {
                    this.myTree.expandPath(this.getPath());
                }
            });
        }
        this.myTree.nodeLoaded(this, group.getName());
    }

    private boolean isExpand(@NotNull XValueGroup group) {
        String name;
        if (group == null) {
            XValueGroupNodeImpl.$$$reportNull$$$0(1);
        }
        if (group.isRestoreExpansion() && StringUtil.isNotEmpty(name = group.getName()) && PropertiesComponent.getInstance(this.getTree().getProject()).isValueSet(group.getName())) {
            return PropertiesComponent.getInstance(this.getTree().getProject()).getBoolean(name);
        }
        return group.isAutoExpand();
    }

    public void onExpansion(boolean expanded) {
        String name;
        XValueGroup group = (XValueGroup)this.getValueContainer();
        if (group.isRestoreExpansion() && StringUtil.isNotEmpty(name = group.getName())) {
            PropertiesComponent.getInstance(this.getTree().getProject()).setValue(group.getName(), String.valueOf(expanded), null);
        }
    }

    @Override
    public String toString() {
        return "Group:" + ((XValueGroup)this.myValueContainer).getName();
    }

    @Override
    @Nullable
    public String getName() {
        return ((XValueGroup)this.myValueContainer).getName();
    }

    @Override
    @Nullable
    public String getRawValue() {
        return null;
    }

    @Override
    public boolean isComputed() {
        return true;
    }

    @Override
    public void markChanged() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "group";
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValueGroupNodeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isExpand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

