/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerInlayUtil;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.frame.XValueWithInlinePresentation;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.pinned.items.PinToTopMemberValue;
import com.intellij.xdebugger.impl.pinned.items.PinToTopParentValue;
import com.intellij.xdebugger.impl.pinned.items.actions.XDebuggerPinToTopAction;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallback;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueNodeImpl
extends XValueContainerNode<XValue>
implements XValueNode,
XCompositeNode,
XValueNodePresentationConfigurator.ConfigurableXValueNode,
RestorableStateNode {
    public static final Comparator<XValueNodeImpl> COMPARATOR = (o1, o2) -> StringUtil.naturalCompare(o1.getName(), o2.getName());
    private static final int MAX_NAME_LENGTH = 100;
    private final String myName;
    @Nullable
    private String myRawValue;
    private XFullValueEvaluator myFullValueEvaluator;
    private boolean myChanged;
    private XValuePresentation myValuePresentation;

    public XValueNodeImpl(XDebuggerTree tree, @Nullable XDebuggerTreeNode parent, String name, @NotNull XValue value2) {
        if (value2 == null) {
            XValueNodeImpl.$$$reportNull$$$0(0);
        }
        super(tree, parent, true, value2);
        this.myName = name;
        value2.computePresentation(this, XValuePlace.TREE);
        if (!this.isComputed()) {
            if (this.myName != null) {
                this.myText.append(this.myName, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                this.myText.append(" = ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            this.myText.append(XDebuggerUIConstants.getCollectingDataMessage(), XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
        }
    }

    @Override
    public void setPresentation(@Nullable Icon icon2, @NonNls @Nullable String type, @NonNls @NotNull String value2, boolean hasChildren) {
        if (value2 == null) {
            XValueNodeImpl.$$$reportNull$$$0(1);
        }
        XValueNodePresentationConfigurator.setPresentation(icon2, type, value2, hasChildren, this);
    }

    @Override
    public void setPresentation(@Nullable Icon icon2, @NonNls @Nullable String type, @NonNls @NotNull String separator, @NonNls @Nullable String value2, boolean hasChildren) {
        if (separator == null) {
            XValueNodeImpl.$$$reportNull$$$0(2);
        }
        XValueNodePresentationConfigurator.setPresentation(icon2, type, separator, value2, hasChildren, (XValueNodePresentationConfigurator.ConfigurableXValueNode)this);
    }

    @Override
    public void setPresentation(@Nullable Icon icon2, @NotNull XValuePresentation presentation, boolean hasChildren) {
        if (presentation == null) {
            XValueNodeImpl.$$$reportNull$$$0(3);
        }
        XValueNodePresentationConfigurator.setPresentation(icon2, presentation, hasChildren, this);
    }

    @Override
    public void applyPresentation(@Nullable Icon icon2, @NotNull XValuePresentation valuePresentation, boolean hasChildren) {
        if (valuePresentation == null) {
            XValueNodeImpl.$$$reportNull$$$0(4);
        }
        if (this.isObsolete()) {
            return;
        }
        this.setIcon(icon2);
        boolean refresh2 = this.myValuePresentation != null;
        this.myValuePresentation = valuePresentation;
        this.myRawValue = XValuePresentationUtil.computeValueText(valuePresentation);
        if (XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowValuesInline()) {
            this.updateInlineDebuggerData(refresh2);
        }
        this.updateText();
        this.setLeaf(!hasChildren);
        this.fireNodeChanged();
        this.myTree.nodeLoaded(this, this.myName);
    }

    public void updateInlineDebuggerData(boolean refresh2) {
        try {
            XSourcePosition debuggerPosition;
            final XDebugSession session2 = XDebugView.getSession(this.getTree());
            XSourcePosition xSourcePosition = debuggerPosition = session2 == null ? null : session2.getCurrentPosition();
            if (debuggerPosition == null) {
                return;
            }
            if (refresh2) {
                this.myTree.updateEditor();
            } else {
                XInlineDebuggerDataCallback callback2 = new XInlineDebuggerDataCallback(){

                    @Override
                    public void computed(XSourcePosition position) {
                        if (XValueNodeImpl.this.isObsolete() || position == null) {
                            return;
                        }
                        VirtualFile file2 = position.getFile();
                        if (!Comparing.equal(debuggerPosition.getFile(), file2)) {
                            return;
                        }
                        Document document = FileDocumentManager.getInstance().getDocument(file2);
                        if (document == null) {
                            return;
                        }
                        XVariablesView.InlineVariablesInfo data2 = XVariablesView.InlineVariablesInfo.get(session2);
                        if (data2 == null) {
                            return;
                        }
                        if (!XValueNodeImpl.this.showAsInlay(session2, position, debuggerPosition)) {
                            data2.put(file2, position, XValueNodeImpl.this, document.getModificationStamp());
                            XValueNodeImpl.this.myTree.updateEditor();
                        }
                    }
                };
                if (((XValue)this.getValueContainer()).computeInlineDebuggerData(callback2) == ThreeState.UNSURE) {
                    ((XValue)this.getValueContainer()).computeSourcePosition(callback2::computed);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean showAsInlay(XDebugSession session2, XSourcePosition position, XSourcePosition debuggerPosition) {
        if (!Registry.is("debugger.show.values.between.lines") && !Registry.is("debugger.show.values.inplace")) {
            return false;
        }
        if (Registry.is("debugger.show.values.between.lines") && session2 instanceof XDebugSessionImpl && XDebuggerInlayUtil.showValueInBlockInlay((XDebugSessionImpl)session2, this, position)) {
            return true;
        }
        if (Registry.is("debugger.show.values.inplace")) {
            String presentation;
            XValue container2 = (XValue)this.getValueContainer();
            if (debuggerPosition.getLine() == position.getLine() && container2 instanceof XValueWithInlinePresentation && (presentation = ((XValueWithInlinePresentation)((Object)container2)).computeInlinePresentation()) != null) {
                XDebuggerInlayUtil.createInlay(this.myTree.getProject(), position.getFile(), position.getOffset(), presentation);
                return true;
            }
        }
        return false;
    }

    @Override
    public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
        if (fullValueEvaluator == null) {
            XValueNodeImpl.$$$reportNull$$$0(5);
        }
        this.invokeNodeUpdate(() -> {
            this.myFullValueEvaluator = fullValueEvaluator;
            this.fireNodeChanged();
        });
    }

    public void clearFullValueEvaluator() {
        this.myFullValueEvaluator = null;
    }

    private void updateText() {
        ValueMarkup markup;
        this.myText.clear();
        XValueMarkers<?, ?> markers = this.myTree.getValueMarkers();
        if (markers != null && (markup = markers.getMarkup((XValue)this.getValueContainer())) != null) {
            this.myText.append("[" + markup.getText() + "] ", new SimpleTextAttributes(1, markup.getColor()));
        }
        if (this.myValuePresentation.isShowName()) {
            this.appendName();
        }
        XValueNodeImpl.buildText(this.myValuePresentation, (ColoredTextContainer)this.myText);
    }

    private void appendName() {
        if (!StringUtil.isEmpty(this.myName)) {
            SimpleTextAttributes attributes = this.myChanged ? XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES : XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES;
            XValuePresentationUtil.renderValue(this.myName, (ColoredTextContainer)this.myText, attributes, 100, null);
        }
    }

    public static void buildText(@NotNull XValuePresentation valuePresenter, @NotNull ColoredTextContainer text2) {
        if (valuePresenter == null) {
            XValueNodeImpl.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            XValueNodeImpl.$$$reportNull$$$0(7);
        }
        XValueNodeImpl.buildText(valuePresenter, text2, true);
    }

    public static void buildText(@NotNull XValuePresentation valuePresenter, @NotNull ColoredTextContainer text2, boolean appendSeparator) {
        String type;
        if (valuePresenter == null) {
            XValueNodeImpl.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            XValueNodeImpl.$$$reportNull$$$0(9);
        }
        if (appendSeparator) {
            XValuePresentationUtil.appendSeparator(text2, valuePresenter.getSeparator());
        }
        if ((type = valuePresenter.getType()) != null) {
            text2.append("{" + type + "} ", XDebuggerUIConstants.TYPE_ATTRIBUTES);
        }
        valuePresenter.renderValue(new XValueTextRendererImpl(text2));
    }

    @Override
    public void markChanged() {
        if (this.myChanged) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myChanged = true;
        if (this.myName != null && this.myValuePresentation != null) {
            this.updateText();
            this.fireNodeChanged();
        }
    }

    @Nullable
    public XFullValueEvaluator getFullValueEvaluator() {
        return this.myFullValueEvaluator;
    }

    @Override
    @Nullable
    public XDebuggerTreeNodeHyperlink getLink() {
        if (this.myFullValueEvaluator != null) {
            return new XDebuggerTreeNodeHyperlink(this.myFullValueEvaluator.getLinkText()){

                @Override
                public boolean alwaysOnScreen() {
                    return true;
                }

                @Override
                public void onClick(MouseEvent event) {
                    if (XValueNodeImpl.this.myFullValueEvaluator.isShowValuePopup()) {
                        DebuggerUIUtil.showValuePopup(XValueNodeImpl.this.myFullValueEvaluator, event, XValueNodeImpl.this.myTree.getProject(), null);
                    } else {
                        new HeadlessValueEvaluationCallback(XValueNodeImpl.this).startFetchingValue(XValueNodeImpl.this.myFullValueEvaluator);
                    }
                    event.consume();
                }
            };
        }
        return null;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public XValuePresentation getValuePresentation() {
        return this.myValuePresentation;
    }

    @Override
    @Nullable
    public String getRawValue() {
        return this.myRawValue;
    }

    @Override
    public boolean isComputed() {
        return this.myValuePresentation != null;
    }

    public void setValueModificationStarted() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myRawValue = null;
        this.myText.clear();
        this.appendName();
        XValuePresentationUtil.appendSeparator((ColoredTextContainer)this.myText, this.myValuePresentation.getSeparator());
        this.myText.append(XDebuggerUIConstants.getModifyingValueMessage(), XDebuggerUIConstants.MODIFYING_VALUE_HIGHLIGHT_ATTRIBUTES);
        this.setLeaf(true);
        this.fireNodeStructureChanged();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    @Nullable
    public Object getIconTag() {
        if (!this.getTree().getPinToTopManager().isEnabled()) {
            return null;
        }
        if (!(this.myValueContainer instanceof PinToTopMemberValue)) {
            return null;
        }
        PinToTopMemberValue pinToTopMemberValue = (PinToTopMemberValue)((Object)this.myValueContainer);
        if (!pinToTopMemberValue.canBePinned()) {
            return null;
        }
        if (!(this.myParent instanceof XValueNodeImpl)) {
            return null;
        }
        if (!(((XValueNodeImpl)this.myParent).myValueContainer instanceof PinToTopParentValue)) {
            return null;
        }
        return new XDebuggerTreeNodeHyperlink(XDebuggerBundle.message("xdebugger.pin.to.top.action", new Object[0])){

            @Override
            public void onClick(MouseEvent event) {
                XDebuggerPinToTopAction.Companion.pinToTopField(event, XValueNodeImpl.this);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuePresentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullValueEvaluator";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuePresenter";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applyPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setFullValueEvaluator";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "buildText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

