/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.component;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.EventDispatcher;
import com.intellij.xdebugger.memory.component.MemoryViewManagerState;
import com.intellij.xdebugger.memory.event.MemoryViewManagerListener;
import org.jetbrains.annotations.NotNull;

@State(name="MemoryViewSettings", storages={@Storage(value="memory.view.xml")})
public class MemoryViewManager
implements PersistentStateComponent<MemoryViewManagerState> {
    public static final String MEMORY_VIEW_CONTENT = "MemoryView";
    private final EventDispatcher<MemoryViewManagerListener> myDispatcher = EventDispatcher.create(MemoryViewManagerListener.class);
    private MemoryViewManagerState myState = new MemoryViewManagerState();

    public static MemoryViewManager getInstance() {
        return ServiceManager.getService(MemoryViewManager.class);
    }

    @Override
    @NotNull
    public MemoryViewManagerState getState() {
        return new MemoryViewManagerState(this.myState);
    }

    @Override
    public void loadState(@NotNull MemoryViewManagerState state) {
        if (state == null) {
            MemoryViewManager.$$$reportNull$$$0(0);
        }
        this.myState = state;
        this.fireStateChanged();
    }

    public void setShowDiffOnly(boolean value2) {
        if (this.myState.isShowWithDiffOnly != value2) {
            this.myState.isShowWithDiffOnly = value2;
            this.fireStateChanged();
        }
    }

    public void setShowWithInstancesOnly(boolean value2) {
        if (this.myState.isShowWithInstancesOnly != value2) {
            this.myState.isShowWithInstancesOnly = value2;
            this.fireStateChanged();
        }
    }

    public void setShowTrackedOnly(boolean value2) {
        if (this.myState.isShowTrackedOnly != value2) {
            this.myState.isShowTrackedOnly = value2;
            this.fireStateChanged();
        }
    }

    public void setAutoUpdate(boolean value2) {
        if (this.myState.isAutoUpdateModeOn != value2) {
            this.myState.isAutoUpdateModeOn = value2;
            this.fireStateChanged();
        }
    }

    public boolean isNeedShowDiffOnly() {
        return this.myState.isShowWithDiffOnly;
    }

    public boolean isNeedShowInstancesOnly() {
        return this.myState.isShowWithInstancesOnly;
    }

    public boolean isNeedShowTrackedOnly() {
        return this.myState.isShowTrackedOnly;
    }

    public boolean isAutoUpdateModeEnabled() {
        return this.myState.isAutoUpdateModeOn;
    }

    public void addMemoryViewManagerListener(MemoryViewManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MemoryViewManager.$$$reportNull$$$0(1);
        }
        this.myDispatcher.addListener(listener2, parentDisposable);
    }

    private void fireStateChanged() {
        this.myDispatcher.getMulticaster().stateChanged(new MemoryViewManagerState(this.myState));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/memory/component/MemoryViewManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addMemoryViewManagerListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

