/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSchemaProvider {
    public static final ExtensionPointName<XmlSchemaProvider> EP_NAME = new ExtensionPointName("com.intellij.xml.schemaProvider");

    @Nullable
    public static XmlFile findSchema(@NotNull @NonNls String namespace, @Nullable Module module2, @NotNull PsiFile file2) {
        if (namespace == null) {
            XmlSchemaProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            XmlSchemaProvider.$$$reportNull$$$0(1);
        }
        if (file2.getProject().isDefault()) {
            return null;
        }
        boolean dumb = DumbService.getInstance(file2.getProject()).isDumb();
        for (XmlSchemaProvider provider : EP_NAME.getExtensionList()) {
            XmlFile schema;
            if (dumb && !DumbService.isDumbAware(provider) || file2 instanceof XmlFile && !provider.isAvailable((XmlFile)file2) || (schema = provider.getSchema(namespace, module2, file2)) == null) continue;
            return schema;
        }
        return null;
    }

    @Nullable
    public static XmlFile findSchema(@NotNull @NonNls String namespace, @NotNull PsiFile baseFile) {
        PsiDirectory directory;
        if (namespace == null) {
            XmlSchemaProvider.$$$reportNull$$$0(2);
        }
        if (baseFile == null) {
            XmlSchemaProvider.$$$reportNull$$$0(3);
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((directory = baseFile.getParent()) == null ? baseFile : directory);
        return XmlSchemaProvider.findSchema(namespace, module2, baseFile);
    }

    public static List<XmlSchemaProvider> getAvailableProviders(@NotNull XmlFile file2) {
        if (file2 == null) {
            XmlSchemaProvider.$$$reportNull$$$0(4);
        }
        return ContainerUtil.findAll(EP_NAME.getExtensionList(), xmlSchemaProvider -> xmlSchemaProvider.isAvailable(file2));
    }

    @Nullable
    public abstract XmlFile getSchema(@NotNull @NonNls String var1, @Nullable Module var2, @NotNull PsiFile var3);

    public boolean isAvailable(@NotNull XmlFile file2) {
        if (file2 == null) {
            XmlSchemaProvider.$$$reportNull$$$0(5);
        }
        return false;
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file2, @Nullable String tagName) {
        if (file2 == null) {
            XmlSchemaProvider.$$$reportNull$$$0(6);
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            XmlSchemaProvider.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Nullable
    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            XmlSchemaProvider.$$$reportNull$$$0(8);
        }
        if (context == null) {
            XmlSchemaProvider.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Nullable
    public Set<String> getLocations(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            XmlSchemaProvider.$$$reportNull$$$0(10);
        }
        if (context == null) {
            XmlSchemaProvider.$$$reportNull$$$0(11);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/XmlSchemaProvider";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/XmlSchemaProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSchema";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableProviders";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableNamespaces";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPrefix";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLocations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

