/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.breadcrumbs.BreadcrumbsXmlWrapper;
import org.jetbrains.annotations.NotNull;

final class BreadcrumbsInitializingActivity
implements StartupActivity.DumbAware {
    BreadcrumbsInitializingActivity() {
    }

    @Override
    public void runActivity(final @NotNull Project project2) {
        if (project2 == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(0);
        }
        if (project2.isDefault() || ApplicationManager.getApplication().isUnitTestMode() || project2.isDisposed()) {
            return;
        }
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, new MyFileEditorManagerListener());
        connection.subscribe(FileTypeManager.TOPIC, new FileTypeListener(){

            @Override
            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                BreadcrumbsInitializingActivity.reinitBreadcrumbsInAllEditors(project2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity$1", "fileTypesChanged"));
            }
        });
        VirtualFileManager.getInstance().addVirtualFileListener(new MyVirtualFileListener(project2), project2);
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> BreadcrumbsInitializingActivity.reinitBreadcrumbsInAllEditors(project2));
        UIUtil.invokeLaterIfNeeded(() -> BreadcrumbsInitializingActivity.reinitBreadcrumbsInAllEditors(project2));
    }

    private static void reinitBreadcrumbsInAllEditors(@NotNull Project project2) {
        if (project2 == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(1);
        }
        if (project2.isDisposed()) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance(project2);
        for (VirtualFile virtualFile2 : fileEditorManager.getOpenFiles()) {
            BreadcrumbsInitializingActivity.reinitBreadcrumbsComponent(fileEditorManager, virtualFile2);
        }
    }

    private static void reinitBreadcrumbsComponent(@NotNull FileEditorManager fileEditorManager, @NotNull VirtualFile file2) {
        if (fileEditorManager == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(3);
        }
        boolean above = EditorSettingsExternalizable.getInstance().isBreadcrumbsAbove();
        for (FileEditor fileEditor : fileEditorManager.getAllEditors(file2)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            TextEditor textEditor = (TextEditor)fileEditor;
            Editor editor = textEditor.getEditor();
            BreadcrumbsXmlWrapper wrapper2 = BreadcrumbsXmlWrapper.getBreadcrumbsWrapper(editor);
            if (BreadcrumbsInitializingActivity.isSuitable(textEditor, file2)) {
                if (wrapper2 != null) {
                    if (wrapper2.breadcrumbs.above != above) {
                        BreadcrumbsInitializingActivity.remove(fileEditorManager, fileEditor, wrapper2);
                        wrapper2.breadcrumbs.above = above;
                        BreadcrumbsInitializingActivity.add(fileEditorManager, fileEditor, wrapper2);
                    }
                    wrapper2.queueUpdate();
                    continue;
                }
                BreadcrumbsInitializingActivity.registerWrapper(fileEditorManager, fileEditor, new BreadcrumbsXmlWrapper(editor));
                continue;
            }
            if (wrapper2 == null) continue;
            BreadcrumbsInitializingActivity.disposeWrapper(fileEditorManager, fileEditor, wrapper2);
        }
    }

    private static boolean isSuitable(@NotNull TextEditor editor, @NotNull VirtualFile file2) {
        if (editor == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(5);
        }
        if (file2 instanceof HttpVirtualFile || !editor.isValid()) {
            return false;
        }
        for (FileBreadcrumbsCollector collector : FileBreadcrumbsCollector.EP_NAME.getExtensions(editor.getEditor().getProject())) {
            if (!collector.handlesFile(file2) || !collector.isShownForFile(editor.getEditor(), file2)) continue;
            return true;
        }
        return false;
    }

    private static void add(@NotNull FileEditorManager manager, @NotNull FileEditor editor, @NotNull BreadcrumbsXmlWrapper wrapper2) {
        if (manager == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(7);
        }
        if (wrapper2 == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(8);
        }
        if (wrapper2.breadcrumbs.above) {
            manager.addTopComponent(editor, wrapper2);
        } else {
            manager.addBottomComponent(editor, wrapper2);
        }
    }

    private static void remove(@NotNull FileEditorManager manager, @NotNull FileEditor editor, @NotNull BreadcrumbsXmlWrapper wrapper2) {
        if (manager == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(10);
        }
        if (wrapper2 == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(11);
        }
        if (wrapper2.breadcrumbs.above) {
            manager.removeTopComponent(editor, wrapper2);
        } else {
            manager.removeBottomComponent(editor, wrapper2);
        }
    }

    private static void registerWrapper(@NotNull FileEditorManager fileEditorManager, @NotNull FileEditor fileEditor, @NotNull BreadcrumbsXmlWrapper wrapper2) {
        if (fileEditorManager == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(12);
        }
        if (fileEditor == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(13);
        }
        if (wrapper2 == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(14);
        }
        BreadcrumbsInitializingActivity.add(fileEditorManager, fileEditor, wrapper2);
        Disposer.register(fileEditor, () -> BreadcrumbsInitializingActivity.disposeWrapper(fileEditorManager, fileEditor, wrapper2));
    }

    private static void disposeWrapper(@NotNull FileEditorManager fileEditorManager, @NotNull FileEditor fileEditor, @NotNull BreadcrumbsXmlWrapper wrapper2) {
        if (fileEditorManager == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(15);
        }
        if (fileEditor == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(16);
        }
        if (wrapper2 == null) {
            BreadcrumbsInitializingActivity.$$$reportNull$$$0(17);
        }
        BreadcrumbsInitializingActivity.remove(fileEditorManager, fileEditor, wrapper2);
        Disposer.dispose(wrapper2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reinitBreadcrumbsInAllEditors";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reinitBreadcrumbsComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "registerWrapper";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "disposeWrapper";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyVirtualFileListener
    implements VirtualFileListener {
        private final Project myProject;

        MyVirtualFileListener(@NotNull Project project2) {
            if (project2 == null) {
                MyVirtualFileListener.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        @Override
        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile file2;
            FileEditorManager fileEditorManager;
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(1);
            }
            if ("name".equals(event.getPropertyName()) && !this.myProject.isDisposed() && (fileEditorManager = FileEditorManager.getInstance(this.myProject)).isFileOpen(file2 = event.getFile())) {
                BreadcrumbsInitializingActivity.reinitBreadcrumbsComponent(fileEditorManager, file2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity$MyVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        @Override
        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(1);
            }
            BreadcrumbsInitializingActivity.reinitBreadcrumbsComponent(source, file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity$MyFileEditorManagerListener";
            objectArray[2] = "fileOpened";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

