/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.util.XmlTagUtilBase;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagUtil
extends XmlTagUtilBase {
    private static final TObjectIntHashMap<String> ourCharacterEntities = new TObjectIntHashMap();

    public static String getCDATAQuote(String text2) {
        if (text2 == null) {
            return null;
        }
        String offensiveChars = "<>&\n";
        int textLength = text2.length();
        if (textLength > 0 && (Character.isWhitespace(text2.charAt(0)) || Character.isWhitespace(text2.charAt(textLength - 1)))) {
            return "<![CDATA[" + text2 + "]]>";
        }
        for (int i = 0; i < offensiveChars.length(); ++i) {
            char c = offensiveChars.charAt(i);
            if (text2.indexOf(c) == -1) continue;
            return "<![CDATA[" + text2 + "]]>";
        }
        return text2;
    }

    public static String getInlineQuote(String text2) {
        if (text2 == null) {
            return null;
        }
        String offensiveChars = "<>&";
        for (int i = 0; i < offensiveChars.length(); ++i) {
            char c = offensiveChars.charAt(i);
            if (text2.indexOf(c) == -1) continue;
            return "<![CDATA[" + text2 + "]]>";
        }
        return text2;
    }

    public static CharSequence composeTagText(@NonNls String tagName, @NonNls String tagValue) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append('<').append(tagName);
        if (StringUtil.isEmpty(tagValue)) {
            builder2.append("/>");
        } else {
            builder2.append('>').append(XmlTagUtil.getCDATAQuote(tagValue)).append("</").append(tagName).append('>');
        }
        return builder2;
    }

    public static String[] getCharacterEntityNames() {
        ArrayList<String> list2 = new ArrayList<String>();
        ourCharacterEntities.forEachKey(list2::add);
        return ArrayUtilRt.toStringArray(list2);
    }

    public static char getCharacterByEntityName(String entityName2) {
        return (char)ourCharacterEntities.get(entityName2);
    }

    @Nullable
    public static XmlToken getStartTagNameElement(@NotNull XmlTag tag2) {
        IElementType elementType;
        ASTNode current2;
        ASTNode node;
        if (tag2 == null) {
            XmlTagUtil.$$$reportNull$$$0(0);
        }
        if ((node = tag2.getNode()) == null) {
            return null;
        }
        for (current2 = node.getFirstChildNode(); current2 != null && (elementType = current2.getElementType()) != XmlTokenType.XML_NAME && elementType != XmlTokenType.XML_TAG_NAME; current2 = current2.getTreeNext()) {
        }
        return current2 == null ? null : (XmlToken)current2.getPsi();
    }

    @Nullable
    public static XmlToken getEndTagNameElement(@NotNull XmlTag tag2) {
        ASTNode current2;
        ASTNode node;
        if (tag2 == null) {
            XmlTagUtil.$$$reportNull$$$0(1);
        }
        if ((node = tag2.getNode()) == null) {
            return null;
        }
        ASTNode prev = current2 = node.getLastChildNode();
        while (current2 != null) {
            IElementType elementType = prev.getElementType();
            if ((elementType == XmlTokenType.XML_NAME || elementType == XmlTokenType.XML_TAG_NAME) && current2.getElementType() == XmlTokenType.XML_END_TAG_START) {
                return (XmlToken)prev.getPsi();
            }
            prev = current2;
            current2 = TemplateLanguageUtil.getSameLanguageTreePrev(current2);
        }
        return null;
    }

    @NotNull
    public static TextRange getTrimmedValueRange(@NotNull XmlTag tag2) {
        if (tag2 == null) {
            XmlTagUtil.$$$reportNull$$$0(2);
        }
        XmlTagValue tagValue = tag2.getValue();
        String text2 = tagValue.getText();
        String trimmed = text2.trim();
        int index = text2.indexOf(trimmed);
        int startOffset = tagValue.getTextRange().getStartOffset() - tag2.getTextRange().getStartOffset() + index;
        return new TextRange(startOffset, startOffset + trimmed.length());
    }

    @Nullable
    public static TextRange getStartTagRange(@NotNull XmlTag tag2) {
        if (tag2 == null) {
            XmlTagUtil.$$$reportNull$$$0(3);
        }
        XmlToken tagName = XmlTagUtil.getStartTagNameElement(tag2);
        return XmlTagUtil.getTagRange(tagName, XmlTokenType.XML_START_TAG_START);
    }

    @Nullable
    public static TextRange getEndTagRange(@NotNull XmlTag tag2) {
        if (tag2 == null) {
            XmlTagUtil.$$$reportNull$$$0(4);
        }
        XmlToken tagName = XmlTagUtil.getEndTagNameElement(tag2);
        return XmlTagUtil.getTagRange(tagName, XmlTokenType.XML_END_TAG_START);
    }

    @Nullable
    private static TextRange getTagRange(@Nullable XmlToken tagName, IElementType tagStart) {
        PsiElement f;
        PsiElement s;
        if (tagName == null) {
            return null;
        }
        for (s = tagName.getPrevSibling(); s != null && s.getNode().getElementType() != tagStart; s = s.getPrevSibling()) {
        }
        for (f = tagName.getNextSibling(); f != null && f.getNode().getElementType() != XmlTokenType.XML_TAG_END && f.getNode().getElementType() != XmlTokenType.XML_EMPTY_ELEMENT_END; f = f.getNextSibling()) {
        }
        if (s != null && f != null) {
            return new TextRange(s.getTextRange().getStartOffset(), f.getTextRange().getEndOffset());
        }
        return null;
    }

    static {
        ourCharacterEntities.put("lt", 60);
        ourCharacterEntities.put("gt", 62);
        ourCharacterEntities.put("apos", 39);
        ourCharacterEntities.put("quot", 34);
        ourCharacterEntities.put("nbsp", 160);
        ourCharacterEntities.put("amp", 38);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "tag";
        objectArray2[1] = "com/intellij/xml/util/XmlTagUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStartTagNameElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getEndTagNameElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTrimmedValueRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStartTagRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getEndTagRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

