/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.Datatypes;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class SpecialOperations {
    private SpecialOperations() {
    }

    public static Set<State> reverse(Automaton a) {
        HashMap m = new HashMap();
        Set<State> states = a.getStates();
        Set<State> accept2 = a.getAcceptStates();
        for (State r : states) {
            m.put(r, new HashSet());
            r.accept = false;
        }
        for (State r : states) {
            for (Transition t : r.getTransitions()) {
                ((HashSet)m.get(t.to)).add(new Transition(t.min, t.max, r));
            }
        }
        for (State r : states) {
            r.transitions = (Set)m.get(r);
        }
        a.initial.accept = true;
        a.initial = new State();
        for (State r : accept2) {
            a.initial.addEpsilon(r);
        }
        a.deterministic = false;
        return accept2;
    }

    public static Automaton overlap(Automaton a1, Automaton a2) {
        Automaton b1 = a1.cloneExpanded();
        b1.determinize();
        SpecialOperations.acceptToAccept(b1);
        Automaton b2 = a2.cloneExpanded();
        SpecialOperations.reverse(b2);
        b2.determinize();
        SpecialOperations.acceptToAccept(b2);
        SpecialOperations.reverse(b2);
        b2.determinize();
        return b1.intersection(b2).minus(BasicAutomata.makeEmptyString());
    }

    private static void acceptToAccept(Automaton a) {
        State s = new State();
        for (State r : a.getAcceptStates()) {
            s.addEpsilon(r);
        }
        a.initial = s;
        a.deterministic = false;
    }

    public static Automaton singleChars(Automaton a) {
        State s;
        Automaton b = new Automaton();
        b.initial = s = new State();
        State q = new State();
        q.accept = true;
        if (a.isSingleton()) {
            for (int i = 0; i < a.singleton.length(); ++i) {
                s.transitions.add(new Transition(a.singleton.charAt(i), q));
            }
        } else {
            for (State p : a.getStates()) {
                for (Transition t : p.transitions) {
                    s.transitions.add(new Transition(t.min, t.max, q));
                }
            }
        }
        b.deterministic = true;
        b.removeDeadTransitions();
        return b;
    }

    public static Automaton trim(Automaton a, String set, char c) {
        a = a.cloneExpandedIfRequired();
        State f = new State();
        SpecialOperations.addSetTransitions(f, set, f);
        f.accept = true;
        for (State s : a.getStates()) {
            State r = s.step(c);
            if (r != null) {
                State q = new State();
                SpecialOperations.addSetTransitions(q, set, q);
                SpecialOperations.addSetTransitions(s, set, q);
                q.addEpsilon(r);
            }
            if (!s.accept) continue;
            s.addEpsilon(f);
        }
        State p = new State();
        SpecialOperations.addSetTransitions(p, set, p);
        p.addEpsilon(a.initial);
        a.initial = p;
        a.deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    private static void addSetTransitions(State s, String set, State p) {
        for (int n = 0; n < set.length(); ++n) {
            s.transitions.add(new Transition(set.charAt(n), p));
        }
    }

    public static Automaton compress(Automaton a, String set, char c) {
        a = a.cloneExpandedIfRequired();
        for (State s : a.getStates()) {
            State r = s.step(c);
            if (r == null) continue;
            State q = new State();
            SpecialOperations.addSetTransitions(q, set, q);
            SpecialOperations.addSetTransitions(s, set, q);
            q.addEpsilon(r);
        }
        a.deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    public static Automaton subst(Automaton a, Map<Character, Set<Character>> map2) {
        if (map2.isEmpty()) {
            return a.cloneIfRequired();
        }
        TreeSet<Character> ckeys = new TreeSet<Character>(map2.keySet());
        char[] keys2 = new char[ckeys.size()];
        int j = 0;
        for (Character c : ckeys) {
            keys2[j++] = c.charValue();
        }
        a = a.cloneExpandedIfRequired();
        for (State s : a.getStates()) {
            Set<Transition> st = s.transitions;
            s.resetTransitions();
            block2: for (Transition t : st) {
                int index = SpecialOperations.findIndex(t.min, keys2);
                while (t.min <= t.max) {
                    if (keys2[index] > t.min) {
                        char m = (char)(keys2[index] - '\u0001');
                        if (t.max < m) {
                            m = t.max;
                        }
                        s.transitions.add(new Transition(t.min, m, t.to));
                        if (m + '\u0001' > 65535) continue block2;
                        t.min = (char)(m + '\u0001');
                        continue;
                    }
                    if (keys2[index] < t.min) {
                        char m = index + 1 < keys2.length ? (char)(keys2[++index] - '\u0001') : (char)'\uffff';
                        if (t.max < m) {
                            m = t.max;
                        }
                        s.transitions.add(new Transition(t.min, m, t.to));
                        if (m + '\u0001' > 65535) continue block2;
                        t.min = (char)(m + '\u0001');
                        continue;
                    }
                    for (Character c : map2.get(Character.valueOf(t.min))) {
                        s.transitions.add(new Transition(c.charValue(), t.to));
                    }
                    if (t.min + '\u0001' > 65535) continue block2;
                    t.min = (char)(t.min + '\u0001');
                    if (index + 1 >= keys2.length || keys2[index + 1] != t.min) continue;
                    ++index;
                }
            }
        }
        a.deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    static int findIndex(char c, char[] points) {
        int a = 0;
        int b = points.length;
        while (b - a > 1) {
            int d = a + b >>> 1;
            if (points[d] > c) {
                b = d;
                continue;
            }
            if (points[d] < c) {
                a = d;
                continue;
            }
            return d;
        }
        return a;
    }

    public static Automaton subst(Automaton a, char c, String s) {
        a = a.cloneExpandedIfRequired();
        HashSet<StatePair> epsilons = new HashSet<StatePair>();
        for (State p : a.getStates()) {
            Set<Transition> st = p.transitions;
            p.resetTransitions();
            for (Transition t : st) {
                if (t.max < c || t.min > c) {
                    p.transitions.add(t);
                    continue;
                }
                if (t.min < c) {
                    p.transitions.add(new Transition(t.min, (char)(c - '\u0001'), t.to));
                }
                if (t.max > c) {
                    p.transitions.add(new Transition((char)(c + '\u0001'), t.max, t.to));
                }
                if (s.length() == 0) {
                    epsilons.add(new StatePair(p, t.to));
                    continue;
                }
                State q = p;
                for (int i = 0; i < s.length(); ++i) {
                    State r = i + 1 == s.length() ? t.to : new State();
                    q.transitions.add(new Transition(s.charAt(i), r));
                    q = r;
                }
            }
        }
        a.addEpsilons(epsilons);
        a.deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    public static Automaton homomorph(Automaton a, char[] source, char[] dest) {
        a = a.cloneExpandedIfRequired();
        for (State s : a.getStates()) {
            Set<Transition> st = s.transitions;
            s.resetTransitions();
            for (Transition t : st) {
                int length;
                for (int min = t.min; min <= t.max; min += length) {
                    int n = SpecialOperations.findIndex((char)min, source);
                    char nmin = (char)(dest[n] + min - source[n]);
                    int end = n + 1 == source.length ? 65535 : source[n + 1] - '\u0001';
                    length = end < t.max ? end + 1 - min : t.max + '\u0001' - min;
                    s.transitions.add(new Transition(nmin, (char)(nmin + length - 1), t.to));
                }
            }
        }
        a.deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    public static Automaton projectChars(Automaton a, Set<Character> chars) {
        int i;
        Character[] c = chars.toArray(new Character[chars.size()]);
        char[] cc = new char[c.length];
        boolean normalchars = false;
        for (i = 0; i < c.length; ++i) {
            if (c[i] == null) {
                normalchars = true;
                continue;
            }
            cc[i] = c[i].charValue();
        }
        Arrays.sort(cc);
        if (a.isSingleton()) {
            for (i = 0; i < a.singleton.length(); ++i) {
                char sc = a.singleton.charAt(i);
                if (normalchars && (sc <= '\udfff' || sc >= '\uf900') || Arrays.binarySearch(cc, sc) >= 0) continue;
                return BasicAutomata.makeEmpty();
            }
            return a.cloneIfRequired();
        }
        HashSet<StatePair> epsilons = new HashSet<StatePair>();
        a = a.cloneExpandedIfRequired();
        for (State s : a.getStates()) {
            HashSet<Transition> new_transitions = new HashSet<Transition>();
            for (Transition t : s.transitions) {
                boolean addepsilon = false;
                if (t.min < '\uf900' && t.max > '\udfff') {
                    int w2;
                    int w1 = Arrays.binarySearch(cc, t.min > '\ue000' ? (char)t.min : (char)'\ue000');
                    if (w1 < 0) {
                        w1 = -w1 - 1;
                        addepsilon = true;
                    }
                    if ((w2 = Arrays.binarySearch(cc, t.max < '\uf8ff' ? (char)t.max : (char)'\uf8ff')) < 0) {
                        w2 = -w2 - 2;
                        addepsilon = true;
                    }
                    for (int w = w1; w <= w2; ++w) {
                        new_transitions.add(new Transition(cc[w], t.to));
                        if (w <= w1 || cc[w - 1] + '\u0001' == cc[w]) continue;
                        addepsilon = true;
                    }
                }
                if (normalchars) {
                    if (t.min <= '\udfff') {
                        new_transitions.add(new Transition(t.min, t.max < '\udfff' ? (char)t.max : (char)'\udfff', t.to));
                    }
                    if (t.max >= '\uf900') {
                        new_transitions.add(new Transition(t.min > '\uf900' ? (char)t.min : (char)'\uf900', t.max, t.to));
                    }
                } else if (t.min <= '\udfff' || t.max >= '\uf900') {
                    addepsilon = true;
                }
                if (!addepsilon) continue;
                epsilons.add(new StatePair(s, t.to));
            }
            s.transitions = new_transitions;
        }
        a.reduce();
        a.addEpsilons(epsilons);
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    public static boolean isFinite(Automaton a) {
        if (a.isSingleton()) {
            return true;
        }
        return SpecialOperations.isFinite(a.initial, new HashSet<State>(), new HashSet<State>());
    }

    private static boolean isFinite(State s, HashSet<State> path2, HashSet<State> visited) {
        path2.add(s);
        for (Transition t : s.transitions) {
            if (!path2.contains(t.to) && (visited.contains(t.to) || SpecialOperations.isFinite(t.to, path2, visited))) continue;
            return false;
        }
        path2.remove(s);
        visited.add(s);
        return true;
    }

    public static Set<String> getStrings(Automaton a, int length) {
        HashSet<String> strings = new HashSet<String>();
        if (a.isSingleton() && a.singleton.length() == length) {
            strings.add(a.singleton);
        } else if (length >= 0) {
            SpecialOperations.getStrings(a.initial, strings, new StringBuilder(), length);
        }
        return strings;
    }

    private static void getStrings(State s, Set<String> strings, StringBuilder path2, int length) {
        if (length == 0) {
            if (s.accept) {
                strings.add(path2.toString());
            }
        } else {
            for (Transition t : s.transitions) {
                for (int n = t.min; n <= t.max; ++n) {
                    path2.append((char)n);
                    SpecialOperations.getStrings(t.to, strings, path2, length - 1);
                    path2.deleteCharAt(path2.length() - 1);
                }
            }
        }
    }

    public static Set<String> getFiniteStrings(Automaton a) {
        HashSet<String> strings = new HashSet<String>();
        if (a.isSingleton()) {
            strings.add(a.singleton);
        } else if (!SpecialOperations.getFiniteStrings(a.initial, new HashSet<State>(), strings, new StringBuilder(), -1)) {
            return null;
        }
        return strings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> getFiniteStrings(Automaton a, int limit) {
        HashSet<String> strings = new HashSet<String>();
        if (a.isSingleton()) {
            if (limit <= 0) return null;
            strings.add(a.singleton);
            return strings;
        } else {
            if (SpecialOperations.getFiniteStrings(a.initial, new HashSet<State>(), strings, new StringBuilder(), limit)) return strings;
            return null;
        }
    }

    private static boolean getFiniteStrings(State s, HashSet<State> pathstates, HashSet<String> strings, StringBuilder path2, int limit) {
        pathstates.add(s);
        for (Transition t : s.transitions) {
            if (pathstates.contains(t.to)) {
                return false;
            }
            for (int n = t.min; n <= t.max; ++n) {
                path2.append((char)n);
                if (t.to.accept) {
                    strings.add(path2.toString());
                    if (limit >= 0 && strings.size() > limit) {
                        return false;
                    }
                }
                if (!SpecialOperations.getFiniteStrings(t.to, pathstates, strings, path2, limit)) {
                    return false;
                }
                path2.deleteCharAt(path2.length() - 1);
            }
        }
        pathstates.remove(s);
        return true;
    }

    public static String getCommonPrefix(Automaton a) {
        boolean done;
        if (a.isSingleton()) {
            return a.singleton;
        }
        StringBuilder b = new StringBuilder();
        HashSet<State> visited = new HashSet<State>();
        State s = a.initial;
        do {
            done = true;
            visited.add(s);
            if (s.accept || s.transitions.size() != 1) continue;
            Transition t = s.transitions.iterator().next();
            if (t.min != t.max || visited.contains(t.to)) continue;
            b.append(t.min);
            s = t.to;
            done = false;
        } while (!done);
        return b.toString();
    }

    public static void prefixClose(Automaton a) {
        for (State s : a.getStates()) {
            s.setAccept(true);
        }
        a.clearHashCode();
        a.checkMinimizeAlways();
    }

    public static Automaton hexCases(Automaton a) {
        HashMap<Character, Set<Character>> map2 = new HashMap<Character, Set<Character>>();
        char c1 = 'a';
        char c2 = 'A';
        while (c1 <= 'f') {
            HashSet<Character> ws = new HashSet<Character>();
            ws.add(Character.valueOf(c1));
            ws.add(Character.valueOf(c2));
            map2.put(Character.valueOf(c1), ws);
            map2.put(Character.valueOf(c2), ws);
            c1 = (char)(c1 + '\u0001');
            c2 = (char)(c2 + '\u0001');
        }
        Automaton ws = Datatypes.getWhitespaceAutomaton();
        return ws.concatenate(a.subst(map2)).concatenate(ws);
    }

    public static Automaton replaceWhitespace(Automaton a) {
        HashMap<Character, Set<Character>> map2 = new HashMap<Character, Set<Character>>();
        HashSet<Character> ws = new HashSet<Character>();
        ws.add(Character.valueOf(' '));
        ws.add(Character.valueOf('\t'));
        ws.add(Character.valueOf('\n'));
        ws.add(Character.valueOf('\r'));
        map2.put(Character.valueOf(' '), ws);
        return a.subst(map2);
    }
}

