/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Transition;
import dk.brics.automaton.TransitionComparator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class State
implements Serializable,
Comparable<State> {
    static final long serialVersionUID = 30001L;
    boolean accept;
    Set<Transition> transitions;
    int number;
    int id;
    static int next_id;

    public State() {
        this.resetTransitions();
        this.id = next_id++;
    }

    final void resetTransitions() {
        this.transitions = new HashSet<Transition>();
    }

    public Set<Transition> getTransitions() {
        return this.transitions;
    }

    public void addTransition(Transition t) {
        this.transitions.add(t);
    }

    public void setAccept(boolean accept2) {
        this.accept = accept2;
    }

    public boolean isAccept() {
        return this.accept;
    }

    public State step(char c) {
        for (Transition t : this.transitions) {
            if (t.min > c || c > t.max) continue;
            return t.to;
        }
        return null;
    }

    public void step(char c, Collection<State> dest) {
        for (Transition t : this.transitions) {
            if (t.min > c || c > t.max) continue;
            dest.add(t.to);
        }
    }

    void addEpsilon(State to) {
        if (to.accept) {
            this.accept = true;
        }
        this.transitions.addAll(to.transitions);
    }

    Transition[] getSortedTransitionArray(boolean to_first) {
        Transition[] e = this.transitions.toArray(new Transition[this.transitions.size()]);
        Arrays.sort(e, new TransitionComparator(to_first));
        return e;
    }

    public List<Transition> getSortedTransitions(boolean to_first) {
        return Arrays.asList(this.getSortedTransitionArray(to_first));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("state ").append(this.number);
        if (this.accept) {
            b.append(" [accept]");
        } else {
            b.append(" [reject]");
        }
        b.append(":\n");
        for (Transition t : this.transitions) {
            b.append("  ").append(t.toString()).append("\n");
        }
        return b.toString();
    }

    @Override
    public int compareTo(State s) {
        return s.id - this.id;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

