/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatIntIterator;
import gnu.trove.TFloatIntProcedure;
import gnu.trove.TFloatProcedure;
import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TFloatIntHashMap
extends TFloatHash {
    protected transient int[] _values;

    public TFloatIntHashMap() {
    }

    public TFloatIntHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TFloatIntHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TFloatIntHashMap(TFloatHashingStrategy strategy) {
        super(strategy);
    }

    public TFloatIntHashMap(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TFloatIntHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TFloatIntHashMap m = (TFloatIntHashMap)super.clone();
        m._values = this._values == null ? null : (int[])this._values.clone();
        return m;
    }

    public TFloatIntIterator iterator() {
        return new TFloatIntIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new int[capacity];
        return capacity;
    }

    public int put(float key, int value2) {
        int previous = 0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value2;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        float[] oldKeys = this._set;
        int[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new float[newCapacity];
        this._values = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            float o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public int get(float key) {
        int index = this.index(key);
        return index < 0 ? 0 : this._values[index];
    }

    public void clear() {
        super.clear();
        float[] keys2 = this._set;
        int[] vals = this._values;
        if (vals == null) {
            return;
        }
        byte[] states = this._states;
        int i = keys2.length;
        while (i-- > 0) {
            keys2[i] = 0.0f;
            vals[i] = 0;
            states[i] = 0;
        }
    }

    public int remove(float key) {
        int prev = 0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatIntHashMap)) {
            return false;
        }
        TFloatIntHashMap that = (TFloatIntHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    protected void removeAt(int index) {
        this._values[index] = 0;
        super.removeAt(index);
    }

    public int[] getValues() {
        int[] vals = new int[this.size()];
        int[] v = this._values;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                vals[j++] = v[i];
            }
        }
        return vals;
    }

    public float[] keys() {
        float[] keys2 = new float[this.size()];
        float[] k = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                keys2[j++] = k[i];
            }
        }
        return keys2;
    }

    public boolean containsValue(int val) {
        byte[] states = this._states;
        int[] vals = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(float key) {
        return this.contains(key);
    }

    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(values2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean forEachEntry(TFloatIntProcedure procedure) {
        byte[] states = this._states;
        float[] keys2 = this._set;
        int[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean retainEntries(TFloatIntProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        float[] keys2 = this._set;
        int[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        return modified;
    }

    public void transformValues(TIntFunction function) {
        byte[] states = this._states;
        int[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                values2[i] = function.execute(values2[i]);
            }
        }
    }

    public boolean increment(float key) {
        return this.adjustValue(key, 1);
    }

    public boolean adjustValue(float key, int amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            float key = stream.readFloat();
            int val = stream.readInt();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TFloatIntProcedure(){

            public boolean execute(float key, int value2) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append(value2);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure
    implements TFloatIntProcedure {
        private final TFloatIntHashMap _otherMap;

        EqProcedure(TFloatIntHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(float key, int value2) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value2, this._otherMap.get(key));
        }

        private static boolean eq(int v1, int v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TFloatIntProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float key, int value2) {
            this.h += TFloatIntHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value2);
            return true;
        }
    }
}

